<?php

// Librairies php
require($_SERVER['DOCUMENT_ROOT'].'/site/config/php/lib.inc.php');
require($_SERVER['DOCUMENT_ROOT'].'/site/config/php/var.inc.php');
//require($_SERVER['DOCUMENT_ROOT'].'/espace/php/var.php');

// session
require($_SERVER['DOCUMENT_ROOT'].'/espace/inc/session-p.php');

// head
require($_SERVER['DOCUMENT_ROOT'].'/espace/inc/head-p.php');

// menu
require($_SERVER['DOCUMENT_ROOT'].'/espace/inc/menu-p.php');

// Contenu
?>

<style>
</style>

	<div id="wrapper">

		<div id="header">
			<div class="grid-container">
				<h1>Bibliothèque</h1>
				<h6>Consultez les ouvrages mis à votre disposition</h6>
			</div>
		</div>

		<section class="bg-white">
			<div class="grid-container">
				<h3 class="dark">À savoir</h3>
				<p>
				Vous pouvez consulter en ligne les références de notre fonds documentaire disponible aux centres du Port et de St Louis. Vous pouvez consulter sur place les ouvrages pendant nos horaires d'ouverture au public. Vous pourrez emprunter 2 ouvrages maximum par personne avec une durée d'emprunt d'un mois pour permettre une rotation optimale du fonds. Un chèque de caution de 50€ par ouvrage emprunté vous sera demandé (non encaissé) et restitué lors du retour de l'ouvrage en bon état. Pour les cours d'anglais, il vous sera demandé un ouvrage d’exercices et de préparation au test Bulats. Vous devrez vous acquitter de 10€ pour la location de l'ouvrage (par semestre) et d'un chèque de 50€ non encaissé restitué lors du retour de l'ouvrage en bon état.
				</p>
			
				<form id="search-form" method="post" action="index.php">
					<div class="grid-50">
						<label for="keyword">Rechercher par mot clé : </label>
						<input type="text" name="keyword" id="keyword">
					</div>
					<div class="grid-50">
						<label for="auteur">Rechercher par auteur : </label>
						<input type="text" name="auteur" id="auteur">
					</div>
					<div class="grid-100">
						<input type="submit" value="Rechercher" class="bloc bloc-small bg-red"/>
					</div>
				</form>
			</div>
		</section>

		<section class="bg-light arrow" id="results">
					
			<div class="arrow-white"></div>
			<div class="grid-container" id="results-table">
		
			</div>
		</section>
<?php

// Footer
require($_SERVER['DOCUMENT_ROOT'].'/espace/inc/footer-p.php');

// Scripts js
require($_SERVER['DOCUMENT_ROOT'].'/espace/inc/script-p.php');

// Scripts JS specifiques
?>
	<script>
	
		function search(){
			$.ajax({
				type:		"GET",
				url:		"search.php",
				data:		$('#search-form').serialize(),
				success:	function(response){
								$("#results-table").html(response);
								$('.ajax-popup-link').magnificPopup({type: 'ajax',cursor: 'mfp-ajax-cur',closeBtnInside: true});
							}
			});
		}

		$('#search-form').submit(function(e){
			e.preventDefault();
			search();
			$('body').animate({scrollTop:$('#results').offset().top}, 1200);
		});
		
		$(window).load(search());

	</script>

</body>
</html>