<!DOCTYPE html>
<html>
<head>
	<meta charset="utf8"/>
	<meta http-equiv="X-UA-Compatible" content="IE=edge"/>
  <link rel="shortcut icon" href="<?php echo get_stylesheet_directory_uri(); ?>/img/items/favicon.png" />
	<meta name="viewport" content="width=device-width, initial-scale=1"/>
	<meta name="mobile-web-app-capable" content="yes"/>
	<meta name="apple-mobile-web-app-capable" content="yes"/>
	<meta name="apple-mobile-web-app-title" content="<?php bloginfo( 'name' ); ?> - <?php bloginfo( 'description' ); ?>"/>
	<link rel="profile" href="http://gmpg.org/xfn/11"/>
	<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>"/>
  <meta name="format-detection" content="telephone=no" />
  <link rel="preconnect" href="https://fonts.gstatic.com">
  <link href="https://fonts.googleapis.com/css2?family=Roboto:ital,wght@0,300;1,400&display=swap" rel="stylesheet"> 
  <link href='https://fonts.googleapis.com/css?family=Varela+Round' rel='stylesheet' type='text/css'>
  <link href='https://fonts.googleapis.com/css?family=Open+Sans:400,700,700italic,400italic' rel='stylesheet' type='text/css'>
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;500;600&display=swap" rel="stylesheet">
  <link rel="preconnect" href="https://cdnjs.cloudflare.com">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.11.2/css/all.css" integrity="sha256-46qynGAkLSFpVbEBog43gvNhfrOj+BmwXdxFgVK/Kvc=" crossorigin="anonymous" />
	<?php wp_head(); ?>
</head>

<body <?php body_class();?>>
  <header id="main-header">
    <div class="header-top bg-white">
      <div class="container">
        <div class="row">
          <div class="flex-container">
            <div class="flex-item header-top-contact"><a class="varela" href="tel:+262262422837">Nous contacter: <span>0262.42.28.37</span></a></div>
            <div class="header-top-acces">
              <button class="varela bg-red acces-rapides-trigger">Accès rapides</button>
              <div class="acces-rapides">
                <?php 
                  echo get_post_field('post_content', 888);
                ?>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
    <div class="header-nav bg-red">
      <div class="container">
        <div class="row">
          <div class="col-xs-12 col-md-3">
            <a href="<?php echo get_home_url()?>/" class="site-logo">
              <img src="<?php echo get_stylesheet_directory_uri().'/img/cnam-reunion-logo.png' ?>" alt="Logo Cnam Réunion" title="Logo Cnam Réunion">
            </a>
          </div>
          <div class="col-xs-12 col-md-9">
            <div class="flex-container">
              <ul class="menu-list">
                <li class="menu-item">
                  <a href="<?php echo get_home_url()?>/">Le Cnam</a>
                  <ul class="sub-menu">
                    <li id="menu-item-446" class="menu-item menu-item-type-post_type menu-item-object-page menu-item-has-children menu-item-28">
                      <a href="<?php echo get_permalink(28) ?>">L'établissement national</a>
                    </li>
                    <li id="menu-item-455" class="menu-item menu-item-type-post_type menu-item-object-page menu-item-30">
                      <a href="<?php echo get_permalink(30) ?>">Le centre régionl de La Réunion</a>
                    </li>
                  </ul>
                </li>
                <li class="menu-item">
                  <a href="<?php echo get_permalink(57) ?>" class="mega-menu-trigger">Nos unités</a>
                  <div class="mega-menu">
                    <div class="mega-menu-container">
                      <div class="mega-menu-col-control">
                        <ul>
                          <?php 
                            $ue_classe_1 = get_ue_class_1();
                            $i = 0;
                            foreach ($ue_classe_1 as $key => $value) {
                              $ue_active = ( $i==0 ) ? 'active' : '';
                              echo '<li><a class="'.$ue_active.'" data-control="'.$key.'">'.$value.'</a></li>';
                              $i++;
                            }
                          ?>
                        </ul>
                      </div>
                      <div class="mega-menu-col-content">
                        <?php 
                          $ue_classe_1 = get_ue_class_1();
                          $i = 0;
                          foreach ($ue_classe_1 as $key => $value) {
                            $active = ( $i==0 ) ? 'active' : '';
                            $ue_classe_2 = get_ue_class_2_by_class_1($value);
                            echo '<div class="mega-menu-col-tab mega-menu-col-tab-'.$key.' '.$active.'">';
                            foreach ($ue_classe_2 as $key2 => $value2) {
                              echo '<div class="mega-menu-col-container">';
                              echo '<h5>'.$value2.'</h5>';

                              $ue = get_ue_by_class_2($value2);
                              foreach ($ue as $key_ue => $value_ue) {
                                echo '<span href="'.$ue[$key_ue]['id'].'">'.ucfirst($ue[$key_ue]['intitule']).'</span>';
                              }
                              echo '</div>';
                            }
                            $i++;
                            echo '</div>';
                          }
                        ?>
                      </div>
                    </div>
                  </div>
                </li>
                <li class="menu-item">
                  <a href="<?php echo get_permalink(59) ?>" class="mega-menu-trigger">Nos diplômes</a>
                  <div class="mega-menu">
                    <div class="mega-menu-container">
                      
                      <div class="mega-menu-col-control">
                        <ul>
                          <?php 
                            $poles = get_poles();
                            $i = 0;
                            foreach ($poles as $key => $value) {
                              $p_active = ( $i==0 ) ? 'active' : '';
                              echo '<li><a class="'.$p_active.'" data-control="'.$poles[$key]['id'].'">'.$poles[$key]['nom'].'</a></li>';
                              $i++;
                            }
                          ?>
                        </ul>
                      </div>
                      <div class="mega-menu-col-content">
                        
                          <?php 
                            $poles = get_poles(); 
                            $i=0;
                            foreach ($poles as $key_p => $value_p) {
                              $f_active = ( $i==0 ) ? 'active' : '';
                              $filieres = get_filieres_by_pole($poles[$key_p]['id']);
                              echo '<div class="mega-menu-col-tab mega-menu-col-tab-'.$poles[$key_p]['id'].' '.$f_active.'">';
                              foreach ($filieres as $key_f => $value_f) {
                                $diplomes = get_diplomes_by_filiere($filieres[$key_f]['id']);
                                if($diplomes){

                                  echo '<div class="mega-menu-col-container">';
                                  echo '<h5>'.$filieres[$key_f]['intitule'].'</h5>';
                                  foreach ($diplomes as $key_d => $value_d) {
                                    echo '<span href="'.$diplomes[$key_d]['id'].'">'.ucfirst($diplomes[$key_d]['titre']).' '.$diplomes[$key_d]['specialite'].'</span>';
                                    //echo '<span href="'.$diplomes[$key_d]['id'].'">'.$diplomes[$key_d]['specialite'].'</span>';
                                  }
                                  echo '</div>';              
                                }
                              }
                              echo '</div>';
                              $i++;
                            }
                          ?>
                        </div>
                      </div>
                    </div>
                  
                </li>
              </ul>
              <?php 
                wp_nav_menu ( array (
                 'theme_location' => 'main-menu' ,
                 'menu' => 'Main',
                 'menu_class' => 'menu-list', 
                 'menu_id' => 'main-menu',
                 'container' => 'ul'
                ) );
              ?>
              <div class="search-form-trigger">
                <i class="fa-search"></i>
              </div>
              <div class="search-form-wrapper">
                <?php get_search_form() ?>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </header>