<?php
$filename = '../../../../../../logs/apache_error.log';

if (file_exists($filename) == false)	error("Le fichier $filename n'existe pas");

$string = file_get_contents($filename, "r");

$tab = explode("\n",$string);

// Creer un tableau qui contient la liste
// des dates des erreurs PHP
// exemple :
// Array
//(
//    [0] => 2008-02-15
//    [1] => 2008-02-16
//    [2] => 2008-02-17
//    [3] => 2008-02-18
//) 


$liste_erreur = array();
foreach($tab as $value)
{
	if (substr($value,0,1) == "[")
	{
		$date = new DateTime(substr($value,1,19));
		$erreur	= substr($value,33);

		$liste_erreur[$date->format("Y-m-d H:i:s")][] = "Erreur";
	}
}

$id = 0;

$data = [];

foreach($liste_erreur as $key => $value)
{						
	$data[] = [	'id'		=> $id++,
				'title'		=> "Erreur",
				'start'		=> $key,
				'end'		=> $key,
				'allDay'	=>  false];
}

 // jQuery wants JSON data
echo json_encode($data);