<?php
session_start();

require($_SERVER['DOCUMENT_ROOT']."/tourisme/base/config/dbconfig.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/tourisme/base/lib/lib.db.inc.php");

$filename = '../../../../../../../logs/php_error.log';

if (file_exists($filename) == false)
	echo("Le fichier $filename n'existe pas");

$string = file_get_contents($filename, "r");

$tab = explode("\n",$string);

$tab_error = [];

$compteur = 0;
foreach($tab as $current_line)
{
	// Exemple : [19-Dec-2016 11:04:59 Indian/Reunion] PHP Warning:  filesize(): stat failed for files/CA20160819_2124.slk in C:\wamp64\www\cabinet\comptes_bancaires\index.php on line 306

	$matches = array();
	preg_match('~^\[(.*)\](.*)~', $current_line, $matches);

	try
	{
		if (array_key_exists(1, $matches))
		{
			$date = new DateTime($matches[1]);

			if (!strpos($matches[2], "PHP Warning") && !strpos($matches[2], "PHP Notice") && !strpos($matches[2], "PHP Fatal error") && !strpos($matches[2], "PHP Parse error") && !strpos($matches[2], "PHP Deprecated"))
			{
				$tab_error[$compteur]['ligne']		.= $matches[2]."\n";
			}
			else
			{
				$compteur++;
					
				$tab_error[$compteur]['datetime']	= $matches[1];
				$tab_error[$compteur]['ligne']		= $matches[2];
			}
		}
		
	}
	catch (Exception $e)
	{
		echo "Format date incorrect : <pre>".$e."</pre>";
	}
}


foreach($tab_error as $current_line)
{
	if(strpos($current_line['ligne'], "PHP Warning"))
		$type_error = "PHP Warning";
	elseif(strpos($current_line['ligne'], "PHP Notice"))
		$type_error = "PHP Notice";
	elseif(strpos($current_line['ligne'], "PHP Fatal error"))
		$type_error = "PHP Fatal error";
	elseif(strpos($current_line['ligne'], "PHP Parse error"))
		$type_error = "PHP Parse error";
	elseif(strpos($current_line['ligne'], "PHP Deprecated"))
		$type_error = "PHP Deprecated";
	else
		$type_error = "";

	$date = new DateTime($current_line['datetime']);


	dbquery("INSERT INTO log_php_error
		VALUES (NULL,
				'".$date->format("Y-m-d H:i:s")."',
				'".addslashes($type_error)."',
				'".addslashes($current_line['ligne'])."'
					)");

}

// Efface le fichier de log
$fp = fopen($filename, 'w+');
fwrite($fp, '');
fclose($fp);

echo "ok";