<?php
// ============
// STATISTIQUES
// ============

require($_SERVER['DOCUMENT_ROOT']."/tourisme/base/config/config.global.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/tourisme/base/config/dbconfig.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/tourisme/base/lib/lib.main.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/tourisme/base/lib/lib.db.inc.php");

// Header
require($_SERVER['DOCUMENT_ROOT']."/tourisme/base/config/header.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/lib/Net_GeoIP/1.0.0RC1/GeoIP.php");

libraries(array('Chart.js'));
?>

<script type="text/javascript">
<!--
function init_pie_3d_os_json()
{
	data_1 = [];
	
	// Chargement initial
	$.getJSON('pie_3d_os_json.php', function(data){

		data_1.push(parseInt(data.Windows));
		data_1.push(parseInt(data.MacOS));
		data_1.push(parseInt(data.Linux));
		data_1.push(parseInt(data.Mobile));
	})
	.done(function(){

		$("#pie-chart-os-wrapper").html("").html("<canvas id='pie-chart-os'></canvas>");
	
		const myLineChart = new Chart(document.getElementById("pie-chart-os"), {
			type: 'pie',
			data: {
			  labels: ["Windows", "MacOS","Linux", "Mobile"],
			  datasets: [{
				label: "Hommes / Femmes",
				backgroundColor: ["#63aaf7", "#f782bd", "#00cc99", "#99ff99"],
				data: data_1
			  }]
			},
			options: {
			  title: {
				display: true,
				text: 'Hommes / Femmes'
			  }
			}
		});

	})
	.fail(function(e){
		alert("Une erreur s'est produite :"+Object.values(e))
	})
	.always(function(){
	});
}

function init_pie_3d_robot_json()
{
	data_2 = [];
	
	// Chargement initial
	$.getJSON('pie_3d_robot_json.php', function(data){

		data_2.push(parseInt(data.BingBot));
		data_2.push(parseInt(data.Googlebot));
		data_2.push(parseInt(data.YandexBot));
		data_2.push(parseInt(data.msnbot));
		data_2.push(parseInt(data.Autre));
	})
	.done(function(){

		$("#pie-chart-robot-wrapper").html("").html("<canvas id='pie-chart-robot'></canvas>");
	
		const myLineChart = new Chart(document.getElementById("pie-chart-robot"), {
			type: 'pie',
			data: {
			  labels: ["BingBot", "Googlebot","YandexBot", "msnbot", "Autre"],
			  datasets: [{
				label: "Robot",
				backgroundColor: ["#63aaf7", "#f782bd", "#00cc99", "#99ff99", "#ff9900"],
				data: data_2
			  }]
			},
			options: {
			  title: {
				display: true,
				text: 'Robot'
			  }
			}
		});

	})
	.fail(function(e){
		alert("Une erreur s'est produite :"+Object.values(e))
	})
	.always(function(){
	});
}

function init_pie_3d_browser_json()
{
	data_3 = [];
	
	// Chargement initial
	$.getJSON('pie_3d_browser_json.php', function(data){

		data_3.push(parseInt(data['Default Browser']));
		data_3.push(parseInt(data.IE));
		data_3.push(parseInt(data.Chrome));
		data_3.push(parseInt(data.Firefox));
		data_3.push(parseInt(data.Autre));

	})
	.done(function(){
		$("#pie-chart-browser-wrapper").html("").html("<canvas id='pie-chart-browser'></canvas>");
	
		const myLineChart = new Chart(document.getElementById("pie-chart-browser"), {
			type: 'pie',
			data: {
			  labels: ["Default Browser","IE", "Chrome","Firefox", "Autre"],
			  datasets: [{
				label: "Robot",
				backgroundColor: ["#63aaf7", "#f782bd", "#00cc99", "#99ff99", "#ff9900"],
				data: data_3
			  }]
			},
			options: {
			  title: {
				display: true,
				text: 'Robot'
			  }
			}
		});

	})
	.fail(function(e){
		alert("Une erreur s'est produite :"+Object.values(e))
	})
	.always(function(){
	});

}

$(document).ready(function()
{		
	init_pie_3d_os_json();
	init_pie_3d_robot_json();
	init_pie_3d_browser_json();

	
	$( "#tabs" ).tabs({ active: 0 });

	
	$("#table_famille_os").tablesorter({ sortList:[[0,1]], widgets: ['zebra']});
	$("#table_robot_indexation").tablesorter({ sortList:[[1,1]], widgets: ['zebra']});
	$("#table_navigateur").tablesorter({ widgets: ['zebra']});

	$("#table_referer").tablesorter({ widgets: ['zebra']});
	$("#table_page").tablesorter({ widgets: ['zebra']});
});	
//-->
</script>


<div class='title'>Statistiques user agent</div>


<div style='position:relative;top:0px; left:10px;width:800px;z-index:1;' id="tabs">
	<ul>
		<li><a href="#tabs-1">OS</a></li>
		<li><a href="#tabs-2">Robot</a></li>
		<li><a href="#tabs-3">Browser</a></li>
	</ul>
	<div id="tabs-1">
		
		<!--
		// ==
		// OS
		// ==
		-->
		
		<div id="pie-chart-os-wrapper" style="position: relative; top:0px;left:200px;height:220px; width:220px">
	<canvas id="pie-chart-os"></canvas></div>

		
		<table id='table_famille_os' class='table table-striped'>
		<thead>
		<tr>
			<th width='250'>Os</th>
			<th>Nb</th>
		</tr>
		</thead>
		<tbody>

		<?php
		$sql_http_user_agent_os = dbquery("SELECT DISTINCT(platform)
			FROM log_user_agent 
			ORDER BY platform");
		for ($i=0;$i<dbnumrows($sql_http_user_agent_os);$i++)
		{
			$platform			= dbresult($sql_http_user_agent_os,$i,"platform");

			$sql_nb_http_user_agent_os = dbquery("SELECT SUM(nb) AS nb_access FROM log_user_agent WHERE  
				platform ='".$platform."'");

			$nb_access	= dbresult($sql_nb_http_user_agent_os,0,"nb_access");

			if ($nb_access > 0)
			{	
				echo "<tr><td>".$platform."</td>";
				echo "<td style='text-align:right'>".number_format($nb_access, 0, ',', ' ')."</td></tr>";
			}
		}
		?>

		</tr>
		</tbody>
		</table>
	</div>

	
	<div id="tabs-2">
		
		<!--
		// =====
		// Robot
		// =====
		-->
		
		
		<div id="pie-chart-robot-wrapper" style="position: relative; top:0px;left:200px;height:220px; width:220px">
	<canvas id="pie-chart-robot"></canvas></div>


		<table id='table_robot_indexation' class='table table-striped'>
		<thead>
			<tr><th width='250'>Robot</th>
			<th>Nb</th>
		</tr>
		</thead>
		<tbody>

		<?php
		$sql_http_user_agent_robot = dbquery("SELECT DISTINCT(browser)
			FROM log_user_agent
			WHERE browser LIKE '%bot%'
				OR browser LIKE '%slurp%'
			ORDER BY platform");

		for ($i=0;$i<dbnumrows($sql_http_user_agent_robot);$i++)
		{
			$browser = dbresult($sql_http_user_agent_robot,$i,"browser");

			$sql_nb_http_user_agent_robot = dbquery("SELECT SUM(nb) AS nb_access FROM log_user_agent WHERE  
				browser = '".$browser."'");

			$nb_access	= dbresult($sql_nb_http_user_agent_robot,0,"nb_access");

			if ($nb_access > 0)
			{	
				echo "<tr><td>".$browser."</td>";
				echo "<td style='text-align:right'>".number_format($nb_access, 0, ',', ' ')."</td></tr>";
			}
		}
		?>

		</tr>
		</tbody>
		</table>

	</div>

	<div id="tabs-3">

		<!--
		// =======
		// Browser
		// =======
		-->
				
		<div id="pie-chart-browser-wrapper" style="position: relative; top:0px;left:200px;height:220px; width:220px">
	<canvas id="pie-chart-browser"></canvas></div>


		<table id='table_navigateur' class='table table-striped'>
		<thead>
			<tr><th width='250'>Navigateur</th>
			<th>Nb</th>
		</tr>
		</thead>
		<tbody>

		<?php
		$sql_http_user_agent_browser = dbquery("SELECT browser,SUM(nb) AS nb_access
			FROM log_user_agent 
			WHERE browser NOT LIKE '%bot%'
				AND browser NOT LIKE '%slurp%'
			GROUP BY browser
			ORDER BY nb_access DESC");

		for ($i=0;$i<dbnumrows($sql_http_user_agent_browser);$i++)
		{
			echo "<tr><td>".dbresult($sql_http_user_agent_browser,$i,"browser")."</td>";
			echo "<td style='text-align:right'>".number_format(dbresult($sql_http_user_agent_browser,$i,"nb_access"), 0, ',', ' ')."</td></tr>";
		}
		?>

		</tr>
		</tbody>
		</table>

	</div>
</div>


<?php
// Footer
require($_SERVER['DOCUMENT_ROOT']."/tourisme/base/config/footer.inc.php");
?>