<?php
// =====================================
// BIBLIOTHEQUE
// =====================================

require($_SERVER['DOCUMENT_ROOT']."/tourisme/base/config/config.global.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/tourisme/base/config/dbconfig.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/tourisme/base/lib/lib.main.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/tourisme/base/lib/lib.db.inc.php");

function get_url($src)
{
	// ----------------------------------------------------------------------------------------------
	// 1. Local :  -- > preg_match('/^\//',$src) == true  -- Commence par /
	// --> http://192.168.2.103/lib/jquery/3.5.0/jquery.min.js
	// ---------------------------------------------------------------------------------------------- 
	if (preg_match('/^\//',$src))
	{
		$protocol = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on')? "https://":"http://";   
		
		$url = $protocol.$_SERVER['HTTP_HOST'].$src;
	}
	// -----------------------------------------------------------------------------
	//  2. Local : https://cdnjs.cloudflare.com/ajax/libs/jquery/3.5.0/jquery.min.js
	// -----------------------------------------------------------------------------
	else
		$url = $src;

	return $url;
}
?>

<script type="text/javascript"> 
$(document).ready(function()
{		
	// ----------------------
	// Initialize tablesorter
	// ----------------------
	$("table").tablesorter({
		headers : { 0 : { sorter: false } },
		theme : "bootstrap",
		widthFixed: true,
	    headerTemplate : '{content} {icon}', // new in v2.7. Needed to add the bootstrap icon!
		widgets : [ "uitheme", "zebra" ],
		widgetOptions : {
		}
	})

	$(".checkbox").click(function(){

		$.ajax({
			type:		"GET",
			url:		"version/active.php",
			data:		"id_library_version="+$(this).val()+"&checked="+$(this).prop( "checked" ),
			beforeSend:	function(){
			},
			complete:	function(){	
			},
			success:	function(response){
				if (response != "ok")
					alert("Erreur : "+response);
			}
		});
	});


	$("#ajout").click(function(){

		$.ajax({
			type:		"GET",
			url:		"version/add.php",
			data:		$('#form_checkbox').serialize(),
			beforeSend:	function(){
			},
			complete:	function(){	
			},
			success:	function(response){
				if (response == "ok")
					$('#form_checkbox').html("Ajout <i style='color:green' class='bi bi-check-lg' aria-hidden='true'></i>");
				else
					$('#form_checkbox').html("Erreur : "+response);
			}
		});
	});

	$(".upd").click(function(){

		$("#container").load("version/update_form.php?id_library_version="+$(this).attr('id'));

	});


});	
</script> 

<form id='form_checkbox' form='form_checkbox' style='width:900px;height:300px'>
	<input type="hidden" name="id_library_file" value="<?php echo $_GET['id_library_file'] ?>">
	
	<?php
	$sql_libraries = dbquery("SELECT *
		FROM libraries
		WHERE id_library IN (
			SELECT id_library
			FROM libraries_files
			WHERE id_library_file = '".$_GET['id_library_file']."'
		)
		ORDER BY id_library ASC");
	
	if (dbnumrows($sql_libraries) == 0)
		die("Le fichier n'existe pas");

	$id_library	= dbresult($sql_libraries,0,"libraries.id_library");
	$name		= dbresult($sql_libraries,0,"libraries.name");

	$sql_libraries_files = dbquery("SELECT *
		FROM libraries_files
		WHERE id_library_file = '".$_GET['id_library_file']."'");
	if (dbnumrows($sql_libraries_files)>0)
	{
		$id_library_file= dbresult($sql_libraries_files,0,"id_library_file");
		$description	= dbresult($sql_libraries_files,0,"description");
		$type			= dbresult($sql_libraries_files,0,"type");

		// Affichage du type
		if ($type == "")
			$type = "PHP";
		?>

		<div class='title'><?php echo $name." ".$description." (".$type.")" ?></div>

		<!-- Réponses -->
		<div id="container" style="position:absolute; top: 100px; left: 10px">
		
			<table class="tablesorter" > 
			<thead> 
			</thead>
			<tbody>

			<?php	
			$sql_libraries_files_js = dbquery("SELECT *
				FROM libraries_files,libraries_version
				WHERE libraries_files.id_library_file = libraries_version.id_library_file
					AND libraries_files.id_library_file = '".$id_library_file."'");

			for ($j=0;$j<dbnumrows($sql_libraries_files_js);$j++)
			{
				$id_library_version	= dbresult($sql_libraries_files_js,$j,"libraries_version.id_library_version");
				$src				= dbresult($sql_libraries_files_js,$j,"libraries_version.src");
				$version			= dbresult($sql_libraries_files_js,$j,"libraries_version.version");
				$active				= dbresult($sql_libraries_files_js,$j,"libraries_version.active");
				$description		= dbresult($sql_libraries_files_js,$j,"libraries_files.description");
				$integrity			= dbresult($sql_libraries_files_js,$j,"libraries_version.integrity");

				/*
				function parse_url()
				Array
				(
					[scheme] => https
					[host] => cdnjs.cloudflare.com
					[path] => /ajax/libs/jqueryui/1.12.1/jquery-ui.min.js
				)
				*/
				$parse = parse_url(get_url($src));

				if ($parse['scheme'] == "https")
					$https = "<span style='font-weight:bold;color:green'>HTTPS</span>";
				else
					$https = "<span style='font-weight:bold;color:red'>HTTP</span>";
				?>

				<tr>
				<td style='text-align:center'><i id='<?php echo $id_library_version ?>' style='color:orange' class='upd bi bi-pencil-fill fa-lg'></i></td>
				<td style='text-align:center'><input type="radio" name='library_version' class="checkbox" value="<?php echo $id_library_version ?>" <?php if ($active== 1) echo " checked"?>></td>
					<td><?php echo $https ?></td>
					<td><?php echo $parse['host'] ?></td>
					<td>
						<?php echo $version;
						if ($description <> "")
							echo "(".$description.")";
						?>
					</td>
					<td><?php echo $parse['path'] ?></td>
					<td style='width:50px'>
						<?php
						if ($integrity <>"")
							echo "<span style='font-weight:bold;color:#9900cc'>HASHCODE</span>";
						else
							echo "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
						?>
					</td>
				<td><a target='_new' href='<?php echo get_url($src) ?>'><i class='bi bi-box-arrow-up-right fa-2x' aria-hidden='true'></i></td>
					</tr>
				<?php
			}
			?>
			<tr>
				<td></td>
				<td></td>
				<td></td>
				<td></td>
				<td><input class='form-control' type='text' name='version'	placeholder='Version'		style='width:60px'></td>
				<td><input class='form-control' type='text' name='src'		placeholder='URL complete'	style='width:300px'></td>
				<td><input class='form-control' type='text' name='integrity'	placeholder='Hashcode'		style='width:300px'></td>
				<td><button class='btn btn-primary' type='button' id='ajout'>Ajout</button></td>
			</tr>
			</tbody>
			</table>

		</div>
		<?php
	}
	else
	{
		echo "<div style='left: 10px; color:green'><b>Aucun résultat</b> trouvé ...</div>";
	}
	?>
</form>