<?php
// ============
// BIBLIOTHEQUE
// ============

require($_SERVER['DOCUMENT_ROOT']."/tourisme/base/config/config.global.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/tourisme/base/config/dbconfig.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/tourisme/base/lib/lib.main.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/tourisme/base/lib/lib.db.inc.php");

function get_url($src):array
{
	$return = [];
	
	// ----------
	// 1. Local :
	// LOCAL : /lib/jwplayer/7.1.4/jwplayer.js
	// ----------
	if (!preg_match('/http/',$src))
	{
		$return = [	'HTTP_HOST'			=>	$_SERVER['HTTP_HOST'],
					'SERVER_PROTOCOL'	=>	$_SERVER['SERVER_PROTOCOL']];
	}
	// -----------------------------------------------------------------------------
	//  2. Distant : https://cdnjs.cloudflare.com/ajax/libs/jquery/3.5.0/jquery.min.js
	// DISTANT : https://cdnjs.cloudflare.com/ajax/libs/videojs-contrib-dash/5.1.1/videojs-dash.min.js
	// -----------------------------------------------------------------------------
	else
	{
		$parse_ = parse_url($src);

		/*
		function parse_url()
		Array
		(
			[scheme] => https
			[host] => cdnjs.cloudflare.com
			[path] => /ajax/libs/jqueryui/1.12.1/jquery-ui.min.js
		)
		*/

		$return = [	'HTTP_HOST'			=>	$parse_['host'],
					'SERVER_PROTOCOL'	=>	$parse_['scheme']];
	}
	
	return $return;
}

$json = [];

$sql_libraries = dbquery("SELECT * FROM libraries
	WHERE type = '".$_GET['type']."'
	 ORDER BY id_library ASC");

for ($i=0;$i<dbnumrows($sql_libraries);$i++)
{
	$id_library		= dbresult($sql_libraries,$i,"id_library");
	$name_library	= dbresult($sql_libraries,$i,"libraries.name");
	
	$sql_libraries_js_css = dbquery("SELECT *
		FROM libraries_files,libraries_version
		WHERE libraries_files.id_library_file = libraries_version.id_library_file
			AND libraries_files.id_library = '".$id_library."'
			AND libraries_version.active='1'");

	$files = [];
	
	for ($j=0;$j<dbnumrows($sql_libraries_js_css);$j++)
	{
		$id_library_file		= dbresult($sql_libraries_js_css,$j,"libraries_files.id_library_file");
		$src					= dbresult($sql_libraries_js_css,$j,"libraries_version.src");
		$version				= dbresult($sql_libraries_js_css,$j,"libraries_version.version");
		$description			= dbresult($sql_libraries_js_css,$j,"libraries_files.description");
		$integrity				= dbresult($sql_libraries_js_css,$j,"libraries_version.integrity");
		$id_library_version		= dbresult($sql_libraries_js_css,$j,"libraries_version.id_library_version");
		$libraries_files_type	= dbresult($sql_libraries_js_css,$j,"libraries_files.type");
		

		/*
		function parse_url()
		Array
		(
			[scheme] => https
			[host] => cdnjs.cloudflare.com
			[path] => /ajax/libs/jqueryui/1.12.1/jquery-ui.min.js
		)
		*/

		$files[] = [
			'id_library_file'		=> $id_library_file,
			'libraries_files_type'	=> $libraries_files_type,
			'parse_url'				=> get_url($src),
			'version'				=> ($description == "")?	$version:$version."(".$description.")",
			'path'					=> basename($src),
			'src'					=> $src,
			'hascode'				=> ($integrity <> ""),
			'id_library_version'	=> $id_library_version];
	}

	$json[] = [	'id_library'	=> $id_library,
				'name_library'	=> $name_library,
				'files'			=> $files];
}

echo json_encode($json);