<?php
// ==========================
// Bibliotheques de fonctions
// ==========================

function libraries(array $tab_libraries)
{
	// --------
	// JS + css
	// --------
	
	$in_libraires = "";
	foreach ($tab_libraries as $name_library)
	{
		$in_libraires .= "'".$name_library."',";
	}
	$in_libraires = substr($in_libraires,0,-1);

	$sql_libraries = dbquery("SELECT *
		FROM libraries,libraries_files,libraries_version
		WHERE libraries.id_library = libraries_files.id_library
			AND libraries_files.id_library_file = libraries_version.id_library_file
			AND libraries.name IN (".$in_libraires.")
			AND libraries_version.active='1'
		ORDER BY libraries_files.id_library_file ASC");

	for ($i=0;$i<dbnumrows($sql_libraries);$i++)
	{
		$name			= dbresult($sql_libraries,$i,"libraries.name");
		$type_library	= dbresult($sql_libraries,$i,"libraries.type");
		$description	= dbresult($sql_libraries,$i,"libraries_files.description");
		$type			= dbresult($sql_libraries,$i,"libraries_files.type");
		$src			= dbresult($sql_libraries,$i,"libraries_version.src");
		$version		= dbresult($sql_libraries,$i,"libraries_version.version");
		$integrity		= dbresult($sql_libraries,$i,"libraries_version.integrity");

		if ($type_library == "JS+CSS")
		{
			if ($type == "js")
			{
				?>
				<!-- <?php echo $name." ".$description ?> (JS) -->
				<script src="<?php echo $src ?>" <?php if ($integrity <> "") echo "integrity='".$integrity."'" ?> crossorigin="anonymous"></script>
				<?php
			}
			else if ($type == "css")
			{
				?>
				<!-- <?php echo $name." ".$description ?> (CSS) -->
				<link rel="stylesheet" href="<?php echo $src ?>" <?php if ($integrity <> "") echo "integrity='".$integrity."'" ?> crossorigin="anonymous">
				<?php
			}
		}
		else
		{
			// Bibliotheque PHP
			// Exemple : /lib/tcpdf/6.2.13/tcpdf.php
			require($_SERVER['DOCUMENT_ROOT'].$src);
		}
	}
}





// -----------------------------------
// Format date ISO --> Format francais
// --> Ex : 2007-12-25 --> 25/12/2007
// -----------------------------------
function date_iso_fr($date) 
{
	$date_fr = "";
	
	if ($date <> "" && $date <> "0000-00-00")
	{
		$date_tab = array();
		$date_tab = explode("-",$date);
		
		// Pour éviter la Notice: Undefined offset:
		if (count($date_tab) == 3)
			$date_fr = $date_tab[2]."/".$date_tab[1]."/".$date_tab[0];
	}	

	return $date_fr;
}


// -------------------------------------------------
// Format ISO --> Format francais
// --> Ex : 2007-12-25 --> Mercredi 25 décembre 2007
// -------------------------------------------------
function date_iso_fr_complete($date) 
{
	global $dico;
	
	if ($date <> "")
	{
		$date = new datetime($date);

		$year		= $date->format("Y");
		$mois		= $dico[$date->format("F")];
		$day		= $date->format("j");
		$day_week	= $dico[$date->format("l")];

		$date_fr_complete = $day_week." ".$day." ".$mois." ".$year;
	}	

	return $date_fr_complete;
}



// ----------------------------------
// Format SQL --> Format francais
// --> Ex : 25/12/2007 --> 2007-12-25
// ----------------------------------
function date_fr_iso($date) 
{
	if ($date <> "")
	{
		$date_tab = explode("/",$date);
		$date = $date_tab[2]."-".$date_tab[1]."-".$date_tab[0];
	}
	return $date;
}