<?php
// ==============================
// BIBLIOTHEQUE pour file cabinet
// ==============================

function ddISO($date)
{
	return date("Y-m-d H:i:s",$date);
}


function id_file_parent($id_file)
{
	$files_parent = dbquery("SELECT id_file_parent FROM files WHERE id_file = '".$id_file."'");

	$id_file_parent = "";
	if (dbnumrows($files_parent) > 0)
		$id_file_parent =  dbresult($files_parent,0,"id_file_parent");
	
	
	if ($id_file_parent <> "")
		return $id_file_parent;
	else
		return "NULL";
}

// ---------------------------------------
// 4382
// -> 4377 -> 4366 -> 4366 -> 4015 -> NULL
// ---------------------------------------
function tab_id_file_parent($id_file)
{
	$tab = array($id_file);

	while ($id_file <> "NULL")
	{
		$tab[] = id_file_parent($id_file);
		$id_file = id_file_parent($id_file);
	}
	
	return $tab;
}


// ----------------------------------------
// Nom du fichier
// --> Peut etre utilisé pour un répertoire
// ----------------------------------------
function file_name($id_file)
{
	$sql_files = dbquery("SELECT file_name FROM files
						WHERE id_file = '".$id_file."'");

	if (dbnumrows($sql_files) > 0)
		return dbresult($sql_files,0,"file_name");
}



// ====================
// Repertoire au dessus
// ====================
function get_from_parent($id_file,$id_usage)
{
	$display = array();

	if ($id_file == "NULL")
		$where_rep = "id_file_parent IS NULL";
	else
		$where_rep = "id_file_parent = '".$id_file."'";

	$sql_list_files = dbquery("SELECT * FROM files
						WHERE id_usage = '".$id_usage."'
							AND ".$where_rep."
						ORDER BY folder_file ASC,file_name ASC");

	for ($i=0;$i<dbnumrows($sql_list_files);$i++)
	{
		$display[$i]['id_file']			= dbresult($sql_list_files,$i,"id_file");
		$display[$i]['directory']		= dbresult($sql_list_files,$i,"directory");
		$display[$i]['file_name']		= dbresult($sql_list_files,$i,"file_name");
		$display[$i]['folder_file']		= dbresult($sql_list_files,$i,"folder_file");
		$display[$i]['extension']		= dbresult($sql_list_files,$i,"extension");
		$display[$i]['size']			= dbresult($sql_list_files,$i,"size");
		$display[$i]['date']			= new DateTime(dbresult($sql_list_files,$i,"date"));
		$display[$i]['id_file_parent']	= dbresult($sql_list_files,$i,"id_file_parent");

		$display[$i]['icon']			= icone_bootstrap_icon($display[$i]['folder_file'],$display[$i]['extension']);
		$display[$i]['type']			= file_type($display[$i]['folder_file'],$display[$i]['extension']);
	}

	return $display;
}



function id_file_child($id_file)
{
	$file_child = dbquery("SELECT * FROM files WHERE id_file_parent = '".$id_file."' ORDER BY folder_file ASC, file_name ASC");

	$id_file_parent = "";

	$tab = [];
	for ($i=0;$i<dbnumrows($file_child);$i++)
	{
		$id_file		= dbresult($file_child,$i,"id_file");
		$file_name		= dbresult($file_child,$i,"file_name");
		$folder_file	= dbresult($file_child,$i,"folder_file");

		$tab[$i]['id_file']			= dbresult($file_child,$i,"id_file");
		$tab[$i]['file_name']		= dbresult($file_child,$i,"file_name");
		$tab[$i]['folder_file']		= dbresult($file_child,$i,"folder_file");
	}

	return $tab;
}



function get_from_folder_examen_bis($rep,$liste_ue_centre_enseignement)
{
	if (isset($_GET['id_centre_enseignement']))
	{
		$id_centre_enseignement = "id_centre_enseignement=".$_GET['id_centre_enseignement'];
		$where_pays_centre_enseignement = "auditeurs.id_centre_enseignement='".$_GET['id_centre_enseignement']."'";
		$pays_centre_enseignement = pays_centre_enseignement($_GET['id_centre_enseignement'])."/".ville_centre_enseignement($_GET['id_centre_enseignement']);
	}
	else
		$where_pays_centre_enseignement = "1=1";


	
	foreach ($liste_ue_centre_enseignement as $key => $id_ue)
	{
		$sql_nb_auditeur_ue = dbquery("SELECT COUNT(DISTINCT(auditeurs_ue.id_auditeur)) AS nb_auditeurs
			FROM auditeurs_ue,auditeurs_diplomes,auditeurs,centres_enseignement
			WHERE auditeurs_ue.annee_universitaire='".param('annee_universitaire_examen')."'
				AND auditeurs_ue.id_auditeur=auditeurs_diplomes.id_auditeur
				AND auditeurs_diplomes.id=auditeurs.id
				AND auditeurs.id_centre_enseignement=centres_enseignement.id_centre_enseignement
				AND ".$where_pays_centre_enseignement."
				AND auditeurs_ue.id_ue = '".$id_ue."'");


		$nb_auditeur[$id_ue] = dbresult($sql_nb_auditeur_ue,0,"nb_auditeurs");
	}

	// UE autorisées
	$ue_authorized = array();

	$sql_ue_authorized = dbquery("SELECT id_centre_enseignement,id_ue
		FROM centres_enseignement_examen");

	for ($i=0;$i<dbnumrows($sql_ue_authorized);$i++)
	{
		$id_centre_enseignement = dbresult($sql_ue_authorized,$i,"id_centre_enseignement");
		$id_ue					= dbresult($sql_ue_authorized,$i,"id_ue");

		$ue_authorized[$id_centre_enseignement][$id_ue] = true;
	}




	$rep_base = "../service_scolaire/examen/sujets_examens/".param('annee_universitaire_examen');

	if (is_dir($rep_base.$rep))
		$dir = opendir($rep_base.$rep);
	else
		error("Attention: le repertoire ".param('annee_universitaire_examen')." specifié n'existe pas");



	$i = 0;
	while ($f = readdir($dir))
	{
		
		// Répertoire
		if(is_dir($rep_base.$rep."/".$f))
		{
			
			if ($f <> "." && $f <> "..")
			{	
				// Si on es dans le répertoire racine : Affiche les dossiers dont le nom est dans la liste des UE
				if ($rep <> "/" || in_array ($f, $liste_ue_centre_enseignement))
				{		
					// Plus d'un auditeur (un seul /) ou plus de 2 slash (/)
					if ( $ue_authorized[$_GET['id_centre_enseignement']][$f] || $nb_auditeur[$f] > 0 || substr_count($rep, '/') >= 2)
					{
						$display[$i]['file_name']     = $f;
						$display[$i]['modified_date'] = new DateTime(ddISO(filemtime($rep_base.$rep."/".$f)));
						$display[$i]['rep'] 		  = $rep.$f;
						$display[$i]['folder_file']   = "folder";
						$display[$i]['filesize']      = "";

						$display[$i]['autorized']     = true;
						$display[$i]['link']          = "";
						
						$display[$i]['icon']          = "<i style='background-color:white;color:#F9D56F' class='bi bi-folder-fill fa-2x'></i>";
						$display[$i++]['type']		  =	"Dossier de fichier";
					}
					else
					{
						$display[$i]['file_name']     = $f;
						$display[$i]['modified_date'] = new DateTime(ddISO(filemtime($rep_base.$rep."/".$f)));
						$display[$i]['folder_file']   = "folder";
						$display[$i]['filesize']      = "";

						$display[$i]['autorized']     = false;
						$display[$i]['link']          = "";
						
						$display[$i]['icon']          = "<i style='background-color:white;color:#CCCCCC' class='bi bi-folder-fill fa-2x'></i>";
						$display[$i++]['type']		  =	"Dossier de fichier";
					}
				}
			}
		}
	}

	if (is_dir($rep_base.$rep))
		$dir = opendir($rep_base.$rep);

	while ($f = readdir($dir))
	{		
		// Fichier
		if(is_file($rep_base.$rep."/".$f) && $f <> "desktop.ini")
		{
			$file_type = "Fichier ".extension($f);
			$sql_icon = dbquery("SELECT type,color,bootstrap_icon
					FROM file
					WHERE file_extension ='".extension($f)."'");
				if (dbnumrows($sql_icon)>0)
				{
					$file_type		= dbresult($sql_icon,0,"type");
					$color			= dbresult($sql_icon,0,"color");
					$bootstrap_icon	= dbresult($sql_icon,0,"bootstrap_icon");
					$bootstrap_icon_html = "<i style='color:".$color."' class='".$bootstrap_icon." fa-2x' aria-hidden='true'></i>";
				}
				else
					$bootstrap_icon_html = "<i style='color:black' class='bi bi-file-earmark fa-2x' aria-hidden='true'></i>";


			$display[$i]['file_name'] 	  = $f;
			$display[$i]['modified_date'] = new DateTime(ddISO(filemtime($rep_base.$rep."/".$f)));
			$display[$i]['folder_file']   = "file";
			$display[$i]['filesize']      = filesize($rep_base.$rep."/".$f)+1000;

			$display[$i]['autorized']     = true;
			$display[$i]['link'] 		  = 'download.php?f='.urlencode($f);

			$display[$i]['icon'] 		  = $bootstrap_icon_html;
			$display[$i++]['type']		  =	$file_type;
		}
	}

	return $display;
}

function get_from_folder_examen($rep,$liste_ue_centre_enseignement)
{
	if (isset($_GET['id_centre_enseignement']))
	{
		$id_centre_enseignement = "id_centre_enseignement=".$_GET['id_centre_enseignement'];
		$where_pays_centre_enseignement = "auditeurs.id_centre_enseignement='".$_GET['id_centre_enseignement']."'";
		$pays_centre_enseignement = pays_centre_enseignement($_GET['id_centre_enseignement'])."/".ville_centre_enseignement($_GET['id_centre_enseignement']);
	}
	else
		$where_pays_centre_enseignement = "1=1";


	
	foreach ($liste_ue_centre_enseignement as $key => $id_ue)
	{
		$sql_nb_auditeur_ue = dbquery("SELECT COUNT(DISTINCT(auditeurs_ue.id_auditeur)) AS nb_auditeurs
			FROM auditeurs_ue,auditeurs_diplomes,auditeurs,centres_enseignement
			WHERE auditeurs_ue.annee_universitaire='".param('annee_universitaire_examen')."'
				AND auditeurs_ue.id_auditeur=auditeurs_diplomes.id_auditeur
				AND auditeurs_diplomes.id=auditeurs.id
				AND auditeurs.id_centre_enseignement=centres_enseignement.id_centre_enseignement
				AND ".$where_pays_centre_enseignement."
				AND auditeurs_ue.id_ue = '".$id_ue."'");


		$nb_auditeur[$id_ue] = dbresult($sql_nb_auditeur_ue,0,"nb_auditeurs");
	}

	// UE autorisées
	$ue_authorized = array();

	$sql_ue_authorized = dbquery("SELECT id_centre_enseignement,id_ue
		FROM centres_enseignement_examen");

	for ($i=0;$i<dbnumrows($sql_ue_authorized);$i++)
	{
		$id_centre_enseignement = dbresult($sql_ue_authorized,$i,"id_centre_enseignement");
		$id_ue					= dbresult($sql_ue_authorized,$i,"id_ue");

		$ue_authorized[$id_centre_enseignement][$id_ue] = true;
	}




	$rep_base = "../service_scolaire/examen/sujets_examens/".param('annee_universitaire_examen')."/";

	if (is_dir($rep_base.$rep))
		$dir = opendir($rep_base.$rep);
	else
		error("Attention: le repertoire ".param('annee_universitaire_examen')." specifié n'existe pas");



	$i = 0;
	while ($f = readdir($dir))
	{
		// Répertoire
		if(is_dir($rep_base.$rep.$f))
		{
			if ($f <> "." && $f <> "..")
			{	
				// Si on es dans le répertoire racine : Affiche les dossiers dont le nom est dans la liste des UE
				if ($rep <> "/" || in_array ($f, $liste_ue_centre_enseignement))
				{		
					// Plus d'un auditeur (un seul /) ou plus de 2 slash (/)
					if ( $ue_authorized[$_GET['id_centre_enseignement']][$f] || $nb_auditeur[$f] > 0 || substr_count($rep, '/') >= 2)
					{
						$display[$i]['file_name']     = $f;
						$display[$i]['modified_date'] = new DateTime(ddISO(filemtime($rep_base.$rep.$f)));
						$display[$i]['rep'] 		  = $rep.$f;
						$display[$i]['folder_file']   = "folder";
						$display[$i]['folder_up']	  = $rep_base.$rep;
						$display[$i]['filesize']      = "";

						$display[$i]['autorized']     = true;
						$display[$i]['link']          = "";
						
						$display[$i]['icon']          = "<i style='background-color:white;color:#F9D56F' class='bi bi-folder-fill fa-2x'></i>";
						$display[$i++]['type']		  =	"Dossier de fichier";
					}
					else
					{
						$display[$i]['file_name']     = $f;
						$display[$i]['modified_date'] = new DateTime(ddISO(filemtime($rep_base.$rep.$f)));
						$display[$i]['folder_file']   = "folder";
						$display[$i]['folder_up']	  = "??";
						$display[$i]['filesize']      = "";

						$display[$i]['autorized']     = false;
						$display[$i]['link']          = "";
						
						$display[$i]['icon']          = "<i style='background-color:white;color:#CCCCCC' class='bi bi-folder-fill fa-2x'></i>";
						$display[$i++]['type']		  =	"Dossier de fichier";
					}
				}
			}
		}
	}

	if (is_dir($rep_base.$rep))
		$dir = opendir($rep_base.$rep);

	while ($f = readdir($dir))
	{
		// Fichier
		if(is_file($rep_base.$rep.$f) && $f <> "desktop.ini")
		{
			$file_type = "Fichier ".extension($f);
			$sql_icon = dbquery("SELECT type,color,bootstrap_icon
					FROM file
					WHERE file_extension ='".extension($f)."'");
				if (dbnumrows($sql_icon)>0)
				{
					$file_type		= dbresult($sql_icon,0,"type");
					$color			= dbresult($sql_icon,0,"color");
					$bootstrap_icon	= dbresult($sql_icon,0,"bootstrap_icon");
					$bootstrap_icon_html = "<i style='color:".$color."' class='".$bootstrap_icon." fa-2x' aria-hidden='true'></i>";
				}
				else
					$bootstrap_icon_html = "<i style='color:black' class='bi bi-file-earmark fa-2x' aria-hidden='true'></i>";


			$display[$i]['file_name'] 	  = $f;
			$display[$i]['modified_date'] = new DateTime(ddISO(filemtime($rep_base.$rep.$f)));
			$display[$i]['folder_file']   = "file";
			$display[$i]['filesize']      = filesize($rep_base.$rep.$f);

			$display[$i]['autorized']     = true;
			$display[$i]['link'] 		  = 'download.php?f='.urlencode($f);

			$display[$i]['icon'] 		  = $bootstrap_icon_html;
			$display[$i++]['type']		  =	$file_type;
		}
	}

	return $display;
}

function get_data_folder($rep,$rep_base)
{
	if (is_dir($rep_base.$rep))
		$dir = opendir($rep_base.$rep);
	else
		die("Attention: le repertoire specifié [$rep,$rep_base] n'existe pas");

	$i = 0;
	
	$display = array();
	while ($f = readdir($dir))
	{
		// Répertoire
		if(is_dir($rep_base.$rep.$f))
		{
			if ($f <> "." && $f <> "..")
			{	
				$display[$i]['file_name']     = $f;
				$display[$i]['modified_date'] = new DateTime(ddISO(filemtime($rep_base.$rep.$f)));
				$display[$i]['rep'] 		  = $rep.$f;
				$display[$i]['folder_file']   = "folder";
				$display[$i]['filesize']    = "";

				$display[$i]['icon']          = "<i style='color:#F9D56F' class='bi bi-folder-fill fa-2x'></i>";
				$display[$i++]['type']		  =	"Dossier";
			}
		}
	}
		
	if (is_dir($rep_base.$rep))
		$dir = opendir($rep_base.$rep);

	while ($f = readdir($dir))
	{
		// Fichier
		if(is_file($rep_base.$rep.$f) && $f <> "desktop.ini")
		{
			$display[$i]['file_name'] 	  = $f;
			$display[$i]['modified_date'] = new DateTime(ddISO(filemtime($rep_base.$rep.$f)));
			$display[$i]['folder_file']   = "file";
			$display[$i]['filesize']	  = filesize($rep_base.$rep.$f);

			$display[$i]['icon'] 		  = icone_bootstrap_icon("file",extension($f));
			$display[$i++]['type']		  =	"Fichier ".extension($f);
		}
	}

	return $display;
}