<?php
function adjustParam($url, $s) {            
	if (preg_match('/(.*?)\?/', $url, $matches)) $urlWithoutParams = $matches[1];
	else $urlWithoutParams = $url;  

	parse_str(parse_url($url, PHP_URL_QUERY), $params);

	if (strpos($s, '=') !== false) {
			list($var, $value) = explode('=', $s);
			$params[$var] = urldecode($value);
			return $urlWithoutParams . '?' . http_build_query($params);      
	} else {
			unset($params[$s]);
			$newQueryString = http_build_query($params);
			if ($newQueryString) return $urlWithoutParams . '?' . $newQueryString;      
			else return $urlWithoutParams;
	}
}
?>

<!-- Accueil Scolaire Compta Super Courrier Cdi  -->
<script>
function init_nav_services()
{
	// Chargement initial
	$.getJSON("/tourisme/base/config/navigation/nav_services_json.php", function(data){
		
		$("#navbar_service_ul").html("");

		$(data).each(function(i, data_from_json){
			
			if (data_from_json.type == "nav-link")
			{
				$("#navbar_service_ul").append($("<li class='nav-item'>").append("<a class='nav-link "+data_from_json.class+"' href='/tourisme/base/config/navigation/link_service.php?id_service="+data_from_json.id_service+"'>"+data_from_json.intitule+"</a>"))
			}
			else if (data_from_json.type == "button")
			{
				$("#navbar_service_ul").append($("<li class='nav-item'>").append("<button data-fancybox data-type='ajax' class='btn btn-info' href='/tourisme/base/config/regroupement_chat_webconf/index.php'>"+data_from_json.html+"</button>"))
			}
			
		});

	})
	.done(function(){


	})
	.fail(function(e){
		alert("Une erreur s'est produite :"+Object.values(e))
	})
	.always(function(){
	});
}

function init_nav_menu()
{
	// Chargement initial
	$.getJSON("/tourisme/base/config/navigation/nav_menu_json.php?<?php echo $_SERVER['QUERY_STRING'] ?>", function(data){
		
		$("#navbar_menu_ul").html("");

		$(data).each(function(i, data_from_json){
			
			$("#navbar_menu_ul").append($("<li class='nav-item'>").append("<a class='nav-link "+data_from_json.class+"' href='"+data_from_json.href+"'>"+data_from_json.intitule+"</a>"))
			
		});

	})
	.done(function(){


	})
	.fail(function(e){
		alert("Une erreur s'est produite :"+Object.values(e))
	})
	.always(function(){
	});
}


function init_nav_ss_menu()
{
	// Chargement initial
	$.getJSON("/tourisme/base/config/navigation/nav_ss_menu_json.php?<?php echo $_SERVER['QUERY_STRING'] ?>", function(data){
		
		$("#ss_menu_add").html("");

		if (data.length > 0)
		{
			$("#nav_ss_menu").show();
			$("#data").removeClass("data_without_menu")
			$("#data").addClass("data")
		}
		else
		{
			$("#data").addClass("data_without_menu")
			$("#data").removeClass("data")
		}


		$(data).each(function(i, data_from_json){

			if (data_from_json.type == 'categorie')
			{
				$("#ss_menu_add").append($("<li>").append($("<div style='position:relative;top:7px;background-color:#6699cc;font-weight:bold;text-align:center;margin-bottom:10px'>").append(data_from_json.intitule)));
			}
			else
			{
				$("#ss_menu_add").append($("<li class='"+data_from_json.class+"'>").append("<a href='/tourisme/base/config/navigation/link_ss_menu.php?id_ss_menu="+data_from_json.id_ss_menu+"' target='"+data_from_json.target+"'>"+data_from_json.intitule+"</a>"))
			}
			
		});

	})
	.done(function(){


	})
	.fail(function(e){
		alert("Une erreur s'est produite :"+Object.values(e))
	})
	.always(function(){
	});
}


$(document).ready(function()
{		
	init_nav_services();
	init_nav_menu();
	init_nav_ss_menu();
	
	$("#session").buttonset();
	
	$("#session_1").click(function() {

		$.ajax({
			type: "GET",
			url: "/base_adm/service_scolaire/examen/change_session.php",
			data: "session=1",
			success: function(msg){
				document.location="<?php echo adjustParam($_SERVER['REQUEST_URI'],'session=1'); ?>";
			}
		});
	});
		
	$("#session_2").click(function() {

		$.ajax({
			type: "GET",
			url: "/base_adm/service_scolaire/examen/change_session.php",
			data: "session=2",
			success: function(msg){
				document.location="<?php echo adjustParam($_SERVER['REQUEST_URI'],'session=2'); ?>";
			}
		});
	});


	$(".multi_annee").click(function() {

		$.fancybox.open({
			src  : '/tourisme/base/config/multi_annee_form.php',
			type : 'ajax',
			opts : {
				afterClose : function() {
				
					document.location.reload(true);
				}
			}
		});

	});


});
</script>


<!-- SERVICES -->
<nav id="nav_services" style='position:relative;top:32px;left:0px;padding:0px;min-height:68px' class="navbar navbar-expand-lg navbar-dark bg-dark">
	<div class="container-fluid">
	
		<button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
		<span class="navbar-toggler-icon"></span>
		</button>
		
		<div class="collapse navbar-collapse" id="navbarSupportedContent">
		
			<ul class="navbar-nav me-auto mb-2 mb-lg-0 scrollbar" style='min-width:200px;max-width:calc(100vw - 340px);overflow-x:auto' id="navbar_service_ul">
			</ul>

			<form class="form-inline">

				<input class="form-control" type="search" name='search_field' id='search_field' placeholder="Recherche" style='width:200px;display:inline'>
				
			</form>

		</div>
	</div>
</nav>

<!-- MENU -->
<nav id="navbar_menu" style='position:relative;top:32px;left:0px;padding:0px' class="navbar navbar-expand-lg navbar-dark bg-primary">
	<div class="container-fluid">
	
		<button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarSupportedContent2" aria-controls="navbarSupportedContent2" aria-expanded="false" aria-label="Toggle navigation">
		<span class="navbar-toggler-icon"></span>
		</button>
		
		<div class="collapse navbar-collapse" id="navbarSupportedContent2">
		
			<ul class="navbar-nav me-auto mb-2 mb-lg-0 scrollbar" style='min-width:200px;max-width:calc(100vw - 340px);overflow-x:auto' id="navbar_menu_ul">
			</ul>

		</div>
	</div>
</nav>


<!-- SOUS-MENU -->
<div style='position:relative;top:-84px;left:-10px'>
	
	<nav id='nav_ss_menu' style='display:none'>
		<ul class='navbar_ss_menu_ul' id='navbar_ss_menu_ul'>
		</ul>
	</nav>
</div>

<div id='data'>