<?php
session_start();

require($_SERVER['DOCUMENT_ROOT']."/tourisme/base/config/config.global.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/tourisme/base/config/dbconfig.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/tourisme/base/lib/lib.main.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/tourisme/base/lib/lib.db.inc.php");
libraries(array('PhpSpreadsheet'));
require($_SERVER['DOCUMENT_ROOT']."/tourisme/base/config/excel/xls_style_spreadsheet.inc.php");

require($_SERVER['DOCUMENT_ROOT']."/tourisme/base/config/crud/global.inc.php");


use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;


function num2alpha($n)
{
	return \PhpOffice\PhpSpreadsheet\Cell\Coordinate::stringFromColumnIndex($n);
}

// -------------------------------------
// Annnee universitaires
// --> Selection
// --> Ex: 2009-2010 2010-2011 2011-2012
// -------------------------------------

$xls_file_without_extension = $_GET['title'];



// Create new PHPExcel object
$spreadsheet = new Spreadsheet();


// ---------------------
// Name of the worksheet
// ---------------------
$spreadsheet->setActiveSheetIndex(0);






// ----------------------------------------------
// Affiche le fichier excel sous la forme de tabs
// oui / non
// ----------------------------------------------


$id_for_tab_column = "";

if (isset($bd_data_table[$_GET['table_name']]['keys']) && is_array($bd_data_table[$_GET['table_name']]['keys']))
{
	foreach($bd_data_table[$_GET['table_name']]['keys'] as $key => $value)
	{
		if (isset($value['tabs']))
		{
			$id_for_tab_column = $key;
		}
	}
}


// ------------------
// Plusieurs feuilles
// ------------------

if ($id_for_tab_column <> "")
{
	$relation = array();
	if (isset($bd_data_table[$_GET['table_name']]['keys'][$id_for_tab_column]['relation']))
		$relation = $bd_data_table[$_GET['table_name']]['keys'][$id_for_tab_column];
	
		// $relation['display_field']		array("immobilier_biens.adresse_1","immobilier_biens.adresse_2");


	// SELECT DISTINCT(id_bien) FROM immobilier_travaux		
	$sql_table_tab = dbquery("SELECT DISTINCT(".$id_for_tab_column.") FROM ".$_GET['table_name']);

	for ($ii=0;$ii<dbnumrows($sql_table_tab);$ii++)
	{
		$id_for_tab = dbresult($sql_table_tab,$ii,$id_for_tab_column);

		if ($relation <> "")
		{
			$sql_displayed_field = "";
			
			foreach($relation['display_field'] as $displayed_field)
			{
				$sql_displayed_field .= $displayed_field.",";
			}

			$table_name = explode(".",$relation['relation']);

			// SELECT immobilier_biens.adresse_1,immobilier_biens.adresse_2 FROM immobilier_biens WHERE immobilier_biens.id_bien='2'
			$sql_field_name = dbquery("SELECT ".substr($sql_displayed_field,0,-1)." FROM ".$table_name[0]." WHERE ".$relation['relation']."='".$id_for_tab."'");
			if (dbnumrows($sql_field_name) > 0)
			{
				$value_tab = "";
				foreach($relation['display_field'] as $displayed_field)
				{
					$value_tab .= dbresult($sql_field_name,0,$displayed_field)." ";
				}
			}
		}


		// A partir de la 2e sheet
		if ($ii > 0)
			$spreadsheet->createSheet();

		// Add some data
		$spreadsheet->setActiveSheetIndex($ii);

		// Nom de la feuille excel
		$spreadsheet->getActiveSheet()->setTitle($value_tab);




		// ------
		// ENTETE
		// ------
		$spreadsheet->getActiveSheet()->setCellValue('B1',$_GET['title']." ".$value_tab );
		$spreadsheet->getActiveSheet()->mergeCells('B1:D2');
		$spreadsheet->getActiveSheet()->getStyle('B1:D2')->applyFromArray($styleCenter);
		$spreadsheet->getActiveSheet()->getStyle('B1:D2')->applyFromArray($styleDoubleBorder);
		$spreadsheet->getActiveSheet()->getStyle('B1:D2')->applyFromArray($styleBold);
		$spreadsheet->getActiveSheet()->getStyle('B1:D2')->applyFromArray($styleYellow);




		// ------
		// Header
		// ------
		$col = 0;

		if (is_array($bd_data_table[$_GET['table_name']]['keys']))
		{
			foreach($bd_data_table[$_GET['table_name']]['keys'] as $key => $value)
			{
				if (isset($value['display']) && $value['display'] == "none")
					continue;
				
				if (isset($value['label']))
					$column_name = $value['label'];
				else
					$column_name =  ucfirst(str_replace("_"," ",$key));
				
				$spreadsheet->getActiveSheet()->setCellValueByColumnAndRow($col++, $row=4, $column_name);
			}
		}


		// ----
		// DATA
		// ----
		$sql_table = dbquery("SELECT * FROM ".$_GET['table_name']." WHERE `".$id_for_tab_column."`='".$id_for_tab."'");

		$row = 5;
		for ($i=0;$i<dbnumrows($sql_table);$i++)
		{
			$col = 0;
			foreach($bd_data_table[$_GET['table_name']]['keys'] as $key => $value)
			{
				if (isset($value['display']) && $value['display'] == "none")
					continue;

				$display = "";
						
				if (isset($value['relation']) && $value['relation'] <> '' && dbresult($sql_table,$i,$key) <> '')
				{
					list($table,$field) = explode(".",$value['relation']);
							
					$sql_relation = dbquery("SELECT * FROM ".$table." WHERE ".$field."='".dbresult($sql_table,$i,$key)."'");

					$display = "";
					foreach($value['display_field'] as $value)
					{
						if (dbnumrows($sql_relation) > 0)
						{
							$display .= dbresult($sql_relation,0,$value)." ";
						}
					}
				}
				// Date
				elseif (isset($value['type']) && $value['type']=='date' && dbresult($sql_table,$i,$key) <> "")
				{
					$date_value = new DateTime(dbresult($sql_table,$i,$key));
					$display = $date_value->format('d/m/Y');
				}
				else
					$display = dbresult($sql_table,$i,$key);

				$spreadsheet->getActiveSheet()->setCellValueByColumnAndRow($col++, $row, $display);
			}
			$row++;
		}



		// ---------
		// Formatage
		// ---------

		for ($i=0;$i<$col;$i++)
			$spreadsheet->getActiveSheet()->getColumnDimension(num2alpha($i))->setWidth('16');


		// -> Header
		$spreadsheet->getActiveSheet()->getStyle('A4:'.num2alpha($col-1).'4')->applyFromArray($styleLeft);
		$spreadsheet->getActiveSheet()->getStyle('A4:'.num2alpha($col-1).'4')->applyFromArray($styleCenterVertical);
		$spreadsheet->getActiveSheet()->getStyle('A4:'.num2alpha($col-1).'4')->applyFromArray($styleBold);
		$spreadsheet->getActiveSheet()->getStyle('A4:'.num2alpha($col-1).'4')->applyFromArray($styleWhiteRed);
		$spreadsheet->getActiveSheet()->getStyle('A4:'.num2alpha($col-1).'4')->applyFromArray($styleDoubleBorder);
		$spreadsheet->getActiveSheet()->getStyle('A4:'.num2alpha($col-1).'4')->applyFromArray($styleInsideBorder);
		$spreadsheet->getActiveSheet()->getStyle('A4:'.num2alpha($col-1).'4')->getAlignment()->setWrapText(true);


		// -> Body
		$spreadsheet->getActiveSheet()->getStyle('A5:'.num2alpha($col-1).($row-1))->applyFromArray($styleLeft);
		$spreadsheet->getActiveSheet()->getStyle('A5:'.num2alpha($col-1).($row-1))->applyFromArray($styleCenterVertical);
		$spreadsheet->getActiveSheet()->getStyle('A5:'.num2alpha($col-1).($row-1))->applyFromArray($styleDoubleBorder);
		$spreadsheet->getActiveSheet()->getStyle('A5:'.num2alpha($col-1).($row-1))->applyFromArray($styleInsideBorder);
		$spreadsheet->getActiveSheet()->getStyle('A5:'.num2alpha($col-1).($row-1))->getAlignment()->setWrapText(true);
	}


	$spreadsheet->setActiveSheetIndex(0);
}
else
{
	$spreadsheet->getActiveSheet()->setTitle($_GET['title']);
	
	// ------
	// ENTETE
	// ------
	$spreadsheet->getActiveSheet()->setCellValue('B1',$_GET['title'] );
	$spreadsheet->getActiveSheet()->mergeCells('B1:D2');
	$spreadsheet->getActiveSheet()->getStyle('B1:D2')->applyFromArray($styleCenter);
	$spreadsheet->getActiveSheet()->getStyle('B1:D2')->applyFromArray($styleDoubleBorder);
	$spreadsheet->getActiveSheet()->getStyle('B1:D2')->applyFromArray($styleBold);
	$spreadsheet->getActiveSheet()->getStyle('B1:D2')->applyFromArray($styleYellow);


	// ------
	// Header
	// ------
	$col = 1;

	if (is_array($bd_data_table[$_GET['table_name']]['keys']))
	{
		foreach($bd_data_table[$_GET['table_name']]['keys'] as $key => $value)
		{
			if (isset($value['display']) && $value['display'] == "none")
				continue;
			
			if (isset($value['label']))
				$column_name = $value['label'];
			else
				$column_name =  ucfirst(str_replace("_"," ",$key));
			
			$spreadsheet->getActiveSheet()->setCellValueByColumnAndRow($col++, $row=4, $column_name);
		}
	}


	// ----
	// DATA
	// ----
	$sql_table = dbquery("SELECT * FROM ".$_GET['table_name']);

	$row = 5;
	for ($i=0;$i<dbnumrows($sql_table);$i++)
	{
		$col = 1;
		foreach($bd_data_table[$_GET['table_name']]['keys'] as $key => $value)
		{
			if (isset($value['display']) && $value['display'] == "none")
				continue;

			$display = "";
					
			if (isset($value['relation']) && $value['relation'] <> '' && dbresult($sql_table,$i,$key) <> '')
			{
				list($table,$field) = explode(".",$value['relation']);
						
				$sql_relation = dbquery("SELECT * FROM ".$table." WHERE ".$field."='".dbresult($sql_table,$i,$key)."'");

				$display = "";
				foreach($value['display_field'] as $value)
				{
					if (dbnumrows($sql_relation) > 0)
					{
						$display .= dbresult($sql_relation,0,$value)." ";
					}
				}
			}
			// Date
			elseif (isset($value['type']) && $value['type']=='date' && dbresult($sql_table,$i,$key) <> "")
			{
				$date_value = new DateTime(dbresult($sql_table,$i,$key));
				$display = $date_value->format('d/m/Y');
			}
			else
				$display = dbresult($sql_table,$i,$key);

			$spreadsheet->getActiveSheet()->setCellValueByColumnAndRow($col++, $row, $display);
		}
		$row++;
	}



	// ---------
	// Formatage
	// ---------

	for ($i=0;$i<$col;$i++)
		$spreadsheet->getActiveSheet()->getColumnDimension(num2alpha($i))->setWidth('16');


	// -> Header
	$spreadsheet->getActiveSheet()->getStyle('A4:'.num2alpha($col-1).'4')->applyFromArray($styleLeft);
	$spreadsheet->getActiveSheet()->getStyle('A4:'.num2alpha($col-1).'4')->applyFromArray($styleCenterVertical);
	$spreadsheet->getActiveSheet()->getStyle('A4:'.num2alpha($col-1).'4')->applyFromArray($styleBold);
	$spreadsheet->getActiveSheet()->getStyle('A4:'.num2alpha($col-1).'4')->applyFromArray($styleWhiteRed);
	$spreadsheet->getActiveSheet()->getStyle('A4:'.num2alpha($col-1).'4')->applyFromArray($styleDoubleBorder);
	$spreadsheet->getActiveSheet()->getStyle('A4:'.num2alpha($col-1).'4')->applyFromArray($styleInsideBorder);
	$spreadsheet->getActiveSheet()->getStyle('A4:'.num2alpha($col-1).'4')->getAlignment()->setWrapText(true);


	// -> Body
	$spreadsheet->getActiveSheet()->getStyle('A5:'.num2alpha($col-1).($row-1))->applyFromArray($styleLeft);
	$spreadsheet->getActiveSheet()->getStyle('A5:'.num2alpha($col-1).($row-1))->applyFromArray($styleCenterVertical);
	$spreadsheet->getActiveSheet()->getStyle('A5:'.num2alpha($col-1).($row-1))->applyFromArray($styleDoubleBorder);
	$spreadsheet->getActiveSheet()->getStyle('A5:'.num2alpha($col-1).($row-1))->applyFromArray($styleInsideBorder);
	$spreadsheet->getActiveSheet()->getStyle('A5:'.num2alpha($col-1).($row-1))->getAlignment()->setWrapText(true);
}


$spreadsheet->getActiveSheet()->getPageMargins()->setTop(0.5);
$spreadsheet->getActiveSheet()->getPageMargins()->setRight(0.5);
$spreadsheet->getActiveSheet()->getPageMargins()->setLeft(0.5);
$spreadsheet->getActiveSheet()->getPageMargins()->setBottom(0.5);

// -------------------------------------------------------
// Set page orientation, size, Print Area and Fit To Pages
// -------------------------------------------------------
$objPageSetup = new \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup();
$objPageSetup->setPaperSize(\PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4);
$objPageSetup->setOrientation(\PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_LANDSCAPE);
$objPageSetup->setPrintArea("A1:E".$row);
$objPageSetup->setFitToWidth(1);
$spreadsheet->getActiveSheet()->setPageSetup($objPageSetup);



$spreadsheet->setActiveSheetIndex(0);


// -------------------
// Format : Excel 2007
// -------------------
header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment;filename="'.$xls_file_without_extension.'.xlsx"');
header('Cache-Control: max-age=0');

$objWriter = \PhpOffice\PhpSpreadsheet\IOFactory::createWriter($spreadsheet, 'Xlsx');
$objWriter->save('php://output');