<?php
// =======================
// CRUD version 2021-05-16
// --> Liste
// =======================



// ------------------
// personnel_services 
// ------------------

$bd_data_table['personnel_services']['keys'] = [	
	'id_personnel'	=> ['relation'		=> 'personnel.id_personnel',
						'label'			=> 'Personnel',
						'display_field'	=> ['personnel.nom','personnel.prenom'],
						'width'			=> '200px',
						'required'		=> true],
	'id_service'	=> ['relation'		=> 'services.id_service',
						'label'			=> 'Modèles',
						'display_field'	=> ['services.service'],
						'type'			=> 'text',
						'width'			=> '200px',
						'required'		=> true]
];

// ------
// hotels 
// ------

$bd_data_table['gh_hotels']['keys'] = [	
	'id_hotel'		=> ['index'=> 'primary','display'=>'none'],
	'nom_hotel'		=> ['type' => 'text',	'width' => '400px'],
	'adresse'		=> ['type' => 'text',	'width' => '400px'],
	'code_postal'	=> ['type' => 'text',	'width' => '400px'],
	'ville'			=> ['type' => 'text',	'width' => '400px']
];

// -------
// clients 
// -------

$bd_data_table['gh_clients']['keys'] = [	
	'id_client'	=> ['index'=> 'primary','display'=>'none'],
	'nom'		=> ['type' => 'text',	'width' => '400px'],
	'prenom'	=> ['type' => 'text',	'width' => '400px'],
	'email'		=> ['type' => 'email',	'width' => '400px']	
];

// ----
// vols
// ----

$bd_data_table['ta_vols']['keys'] = array(
	'id_vol'		=> array(	'index'		=> 'primary',
								'display'	=> 'none'),
	'type_avion'	=> array(	'type'		=> 'text',
								'width'		=> '100px',
								'required'	=> true),
	'id_compagnie'	=> array(	'required'		=> true,
								'relation'		=> 'ta_compagnies.id_compagnie',
								'label'			=> 'Compagnie',
								'display_field'	=> array('ta_compagnies.nom'), 'required'		=> true,
								'tabs'			=> true),
	'numero_vol'	=> array(	'type'			=> 'text',
								'width'			=> '100px'),
	'de_vers'		=> array(	'required'		=> true,
								'relation'		=> 'ta_aeroports.id_aeroport',
								'label'			=> 'De / Vers',
								'display_field'	=> array('ta_aeroports.nom')),
	'arrivee_depart'=> array(	'type'		=> 'text',
								'width'		=> '140px',
								'required'	=> true,
								'enum'		=> array(
									'Arrivée'	=> 'Arrivée',
									'Départ'	=> 'Départ')),
	'horaire'		=> array(	'type'		=> 'datetime',
								'required'	=> true,
								'order_by'	=> true),
	'observation'	=> array(	'type'		=> 'text',
								'width'		=> '200px')
);


// ----------
// compagnies
// ----------

$bd_data_table['ta_compagnies']['keys'] = array(
	'id_compagnie'	=> array(	'index'		=> 'primary',
								'display'	=> 'none'),
	'nom'			=> array(	'type'		=> 'text',
								'width'		=> '200px',
								'required'	=> true),
	'pdg'			=> array(	'type'		=> 'text',
								'width'		=> '200px'),
	'nb_appareil'	=> array(	'type'		=> 'text',
								'width'		=> '100px',
								'required'	=> true),
	'pays'			=> array(	'type'		=> 'text',
								'width'		=> '200px',
								'required'	=> true),
	'remarque'		=> array(	'type'		=> 'text',
								'width'		=> '200px'),
	'logo'			=> array(	'type'		=> 'text',
								'width'		=> '200px',
								'required'	=> true),
	'url'			=> array(	'type'		=> 'text',
								'width'		=> '400px',
								'required'	=> true)
);


	

// ----------
// aeroports
// ----------

$bd_data_table['ta_aeroports']['keys'] = array(
	'id_aeroport'	=> array(	'index'		=> 'primary',
								'display'	=> 'none'),
	'nom'			=> array(	'type'		=> 'text',
								'width'		=> '200px',
								'required'	=> true),
	'iata_code'		=> array(	'type'		=> 'text',
								'width'		=> '60px',
								'label'		=> 'IATA Code',
								'maxlength'	=> 3,
								'required'	=> true)
);