-- phpMyAdmin SQL Dump
-- version 5.2.1
-- https://www.phpmyadmin.net/
--
-- Host: pneumoprevil.mysql.db
-- Generation Time: Aug 15, 2023 at 02:34 PM
-- Server version: 5.7.42-log
-- PHP Version: 8.1.22

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
START TRANSACTION;
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;

--
-- Database: `pneumoprevil`
--
CREATE DATABASE IF NOT EXISTS `pneumoprevil` DEFAULT CHARACTER SET latin1 COLLATE latin1_swedish_ci;
USE `pneumoprevil`;

-- --------------------------------------------------------

--
-- Table structure for table `banque_clients`
--

CREATE TABLE `banque_clients` (
  `id_client` int(11) NOT NULL,
  `nom` varchar(50) NOT NULL,
  `prenom` varchar(50) NOT NULL,
  `abreviation` varchar(10) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `banque_clients`
--

INSERT INTO `banque_clients` (`id_client`, `nom`, `prenom`, `abreviation`) VALUES
(1, 'TANGUY', 'Bernard', 'B'),
(2, 'TANGUY', 'Dominique', 'Dom'),
(3, 'TANGUY', 'Maurice', 'M'),
(4, 'TANGUY', 'David', 'D'),
(5, 'TANGUY', 'Pierre', 'P'),
(6, 'TANGUY', 'Bernard J.', 'BJ');

-- --------------------------------------------------------

--
-- Table structure for table `banque_comptes`
--

CREATE TABLE `banque_comptes` (
  `id_compte` int(11) NOT NULL,
  `intitule` varchar(100) DEFAULT NULL,
  `number` varchar(20) DEFAULT NULL,
  `id_banque` int(11) NOT NULL,
  `id_type` int(11) NOT NULL,
  `id_client` int(11) NOT NULL,
  `disponible` tinyint(1) DEFAULT NULL,
  `montant` decimal(10,2) DEFAULT NULL,
  `taux` decimal(4,2) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `banque_comptes`
--

INSERT INTO `banque_comptes` (`id_compte`, `intitule`, `number`, `id_banque`, `id_type`, `id_client`, `disponible`, `montant`, `taux`) VALUES
(1, 'DAV (B&Dom)', '7583 073 60 31', 1, 0, 1, 1, 8856.29, 0.00),
(2, 'DAV (M)', '8000 248 00 01', 1, 0, 3, 1, 52280.44, 0.00),
(3, 'DAV (D)', '8000 247 10 01', 1, 0, 4, 1, 3714.89, 0.00),
(4, 'DAV (P)', '8000 249 80 01', 1, 0, 5, 1, 1239.02, 0.00),
(5, 'DAV (BJ)', '9000 744 03 58', 1, 0, 6, 1, 3461.78, 0.00),
(6, 'CEL (B)', '8000 240 43 02', 1, 1, 1, 1, 305.55, 0.25),
(7, 'CEL (Dom)', '8000 239 03 01', 1, 1, 2, 1, 305.55, 0.25),
(8, 'CEL (M)', '8000 248 03 01', 1, 1, 3, 1, 15381.48, 0.25),
(9, 'CEL (D)', '8000 247 13 01', 1, 1, 4, 1, 301.95, 0.25),
(10, 'CEL (P)', '8000 249 83 01', 1, 1, 5, 1, 309.97, 0.25),
(11, 'CEL (BJ)', '8001 785 13 01', 1, 1, 6, 1, 302.71, 0.25),
(12, 'Livret A (B)', '9002 289 05 16', 1, 3, 1, 1, 19199.17, 0.50),
(13, 'Livret A (Dom)', '9002 847 50 23', 1, 3, 2, 1, 18109.63, 0.50),
(14, 'Livret A (M)', NULL, 1, 3, 3, 1, 0.00, 0.50),
(15, 'Livret A (D)', '9002 847 48 21', 1, 3, 4, 1, 0.00, 0.50),
(16, 'Livret A (P)', '9001 953 74 40', 1, 3, 5, 1, 23050.49, 0.50),
(17, 'Livret A (BJ)', '9001 953 71 36', 1, 3, 6, 1, 18273.84, 0.50),
(18, 'Compte societaire CA (M)', '30009625697', 1, 2, 3, 1, 53762.55, 0.50),
(19, 'Compte sur livret', '7583 073 62 01', 1, 4, 1, 1, 75087.96, 0.05),
(20, 'Compte societaire CA (B)', '3000 085 57 20', 1, 2, 1, 1, 88384.48, 0.50),
(21, 'Compte societaire CA (D)', '3000 086 68 02', 1, 2, 4, 1, 10.01, 0.50),
(22, 'Compte societaire CA (P)', '3000 086 67 30', 1, 2, 5, 1, 83135.93, 0.50),
(23, 'Compte societaire CA (BJ)', '3000 086 62 76', 1, 2, 6, 1, 66128.29, 0.50),
(24, 'Compte Chèque CE', NULL, 2, 0, 1, 1, 237.00, NULL),
(25, 'PEL (B)', '7659 941 83 34', 1, 6, 1, 0, 95854.58, 1.50),
(26, 'PEL (Dom)', '7659 942 63 34', 1, 6, 2, 0, 93138.95, 1.50),
(27, 'PEL (M)', '8000 248 03 34', 1, 6, 3, 0, 97003.32, 1.50),
(28, 'PEL (D)', '7659 941 03 34', 1, 6, 4, 0, 97956.08, 1.50),
(29, 'PEL (P)', '7659 939 63 34', 1, 6, 5, 0, 95227.71, 1.50),
(30, 'PEL (BJ)', '9001 447 60 92', 1, 6, 6, 0, 111246.69, 1.50),
(31, 'Compte Titres (B+Dom)', '9001 768 09 39', 1, 15, 1, 0, 564.57, 2.00),
(32, 'Compte Titres (M)', '8000 248 06 00', 1, 15, 3, 0, 113922.92, 2.00),
(33, 'Compte Titres (D)', '8000 247 16 00', 1, 15, 4, 0, 95675.47, 2.00),
(34, 'Compte Titres (P)', '8000 249 86 00', 1, 15, 5, 0, 94755.67, 2.00),
(35, 'Compte Titres (BJ)', '9002 013 16 61', 1, 15, 6, 0, 159809.72, 2.00),
(36, 'Espace Gestion PEP (B)', '9002 000 04 54', 1, 14, 1, 0, 178720.67, 1.00),
(37, 'Espace Gestion PEP (Dom)', '9002 000 04 63', 1, 14, 2, 0, 149209.53, 1.00),
(38, 'Confluence', '8000 240 47 50', 1, 7, 1, 0, 63486.18, 0.65),
(39, 'Espace Gestion (B)', '9001 998 50 64', 1, 8, 1, 0, 143416.37, 0.83),
(40, 'Espace Gestion (Dom)', '9001 998 51 17', 1, 8, 2, 0, 161903.39, 0.83),
(41, 'Espace Gestion (M)', '9001 998 51 35', 1, 8, 3, 0, 265709.85, 0.83),
(42, 'Espace Gestion (D)', '9001 998 50 91', 1, 8, 4, 0, 306288.70, 0.83),
(43, 'Espace Gestion (P)', '9001 998 51 26', 1, 8, 5, 0, 282793.77, 0.83),
(44, 'Espace Gestion (BJ)', '9001 998 52 70', 1, 8, 6, 0, 237432.99, 0.83),
(45, 'Espace Liberté 2 (M)', '3000 152 57 66', 1, 9, 3, 0, 228647.21, 1.90),
(46, 'Espace Liberté 2 (D)', '3000 147 39 10', 1, 9, 4, 0, 179420.21, 1.90),
(47, 'Espace Liberté 2 (P)', '3000 147 41 42', 1, 9, 5, 0, 259387.78, 1.90),
(48, 'Espace Liberté 2 (BJ)', '3000 147 40 53', 1, 9, 6, 0, 199229.45, 1.90),
(49, 'Espace Liberté 3 (Dom)', '2019 15 20 06 9178', 1, 10, 2, 0, 100000.00, 1.80),
(50, 'Predissime (M)', '9001 67 29 365', 1, 11, 3, 0, 24889.02, 1.00),
(51, 'Predissime (D)', '9001 27 08 760', 1, 11, 4, 0, 25407.31, 1.00),
(52, 'Predissime (P)', '9001 72 31 567', 1, 11, 5, 0, 24889.02, 1.00),
(53, 'Predissime (BJ)', '9001 27 08 554', 1, 11, 6, 0, 25407.31, 1.00),
(54, 'DAV (D)', '69 22 51039', 3, 0, 4, 1, 14200.00, 0.00);

-- --------------------------------------------------------

--
-- Table structure for table `banque_documents`
--

CREATE TABLE `banque_documents` (
  `id_document` int(11) NOT NULL,
  `id_compte` int(11) DEFAULT NULL,
  `id_client` int(11) DEFAULT NULL,
  `type_document` enum('','Relevé mensuel','Relevé trimestriel','Relevé annuel','Versement','Arbitrage','Bilan') NOT NULL,
  `date` date NOT NULL,
  `document` varchar(255) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `banque_documents`
--

INSERT INTO `banque_documents` (`id_document`, `id_compte`, `id_client`, `type_document`, `date`, `document`) VALUES
(1, 28, NULL, 'Relevé annuel', '2020-01-03', 'E_Releves_PEL_Annuel_(03_01_2020)_104536768_DzObVXDT.pdf'),
(2, 51, NULL, 'Relevé annuel', '2020-01-22', 'RELEVE_ANNUEL_ASSURANCE_VIE_CONTRATS_EN_UC_A1972699304_emcqNZ2f.pdf'),
(3, 46, NULL, 'Relevé trimestriel', '2020-09-30', 'RELEVE_TRIMESTRIEL_ASSURANCE_VIE_CONTRATS_EN_UC_A2072143085_lZXXWZwS.pdf'),
(4, 33, NULL, 'Relevé trimestriel', '2020-09-30', 'E_Releves_comptes_TITRES_(30_09_2020)_113659534_aGfsuWLT.pdf'),
(5, 51, NULL, 'Arbitrage', '2019-04-03', 'CONFIRMATION_D_OPERATION_D_ARBITRAGE_A1871955380_tQggaIul.pdf'),
(6, 46, NULL, 'Versement', '2019-04-03', 'Demande_de_versement_libre_Assurance_Vie_20190403_96194238_d6wu5FuB.pdf'),
(7, NULL, 4, 'Bilan', '2019-04-03', 'Bilan_Conseil_(20190403)_Reference_03_04_2019_96183598_j4uHnUP0.pdf'),
(8, 38, NULL, 'Relevé annuel', '2020-01-16', 'RELEVE_ANNUEL_ASSURANCE_VIE_CONTRATS_EN_EUROS_A1972797317_C64Pplmt.pdf'),
(9, 31, NULL, 'Relevé annuel', '2019-12-31', 'E_Releves_comptes_TITRES_(31_12_2019)_105576271_g8QPxWlE.pdf'),
(10, 25, NULL, 'Relevé annuel', '2019-12-31', 'E_Releves_PEL_Annuel_(03_01_2020)_104536769_liX82fMI.pdf'),
(11, 36, NULL, 'Relevé mensuel', '2020-11-25', 'ESPACE_GESTION_PEP_90020000454.pdf'),
(13, 42, NULL, 'Relevé annuel', '2020-11-25', 'ESPACE_GESTION_90019985091.pdf'),
(14, 45, NULL, 'Relevé trimestriel', '2020-09-20', 'RELEVE_TRIMESTRIEL_ASSURANCE_VIE_CONTRATS_EN_UC_A2072143107_mAidUC49.pdf'),
(15, 50, NULL, 'Relevé annuel', '2020-01-22', 'RELEVE_ANNUEL_ASSURANCE_VIE_CONTRATS_EN_UC_A1972699986_BZz3S98D.pdf'),
(16, 32, NULL, 'Relevé trimestriel', '2020-09-30', 'E_Releves_comptes_TITRES_(30_09_2020)_113659535_xQD4Z4hz.pdf'),
(17, 27, NULL, 'Relevé annuel', '2019-12-31', 'E_Releves_PEL_Annuel_(03_01_2020)_104536772_HHfaTJjj.pdf'),
(18, 41, NULL, 'Relevé mensuel', '2020-11-25', 'ESPACE_GESTION_90019985135.pdf'),
(19, 47, NULL, 'Relevé trimestriel', '2020-09-30', 'RELEVE_TRIMESTRIEL_ASSURANCE_VIE_CONTRATS_EN_UC_A2072143087_yvJji6lC.pdf'),
(20, 34, NULL, 'Relevé trimestriel', '2020-09-30', 'E_Releves_comptes_TITRES_(30_09_2020)_113659536_84foy9oJ.pdf'),
(21, NULL, 5, 'Bilan', '2019-04-03', 'Bilan_Conseil_(20190403)_Reference_03_04_2019_96183531_6SXafp2S.pdf'),
(22, 47, NULL, 'Versement', '2019-04-03', 'Demande_de_versement_libre_Assurance_Vie_20190403_96194424_Lay6GQNg.pdf'),
(23, 52, NULL, 'Relevé mensuel', '2020-11-29', 'PREDISSIME_9_90017231567.pdf'),
(24, 43, NULL, 'Relevé mensuel', '2020-11-25', 'ESPACE_GESTION_90019985126.pdf'),
(25, 48, NULL, 'Relevé trimestriel', '2020-10-30', 'RELEVE_TRIMESTRIEL_ASSURANCE_VIE_CONTRATS_EN_UC_A2072143086_eIBhCmty.pdf'),
(26, 30, NULL, 'Relevé annuel', '2019-12-31', 'E_Releves_PEL_Annuel_(03_01_2020)_104537471_zcMXVF5j.pdf'),
(27, 35, NULL, 'Relevé trimestriel', '2020-09-30', 'E_Releves_comptes_TITRES_(30_09_2020)_113660234_wDQlvpH9.pdf'),
(28, NULL, 6, 'Bilan', '2019-04-03', 'Bilan_Conseil_(20190403)_Reference_03_04_2019_96183601_QaiyR9Hd.pdf'),
(29, 53, NULL, 'Arbitrage', '2018-09-25', 'CONFIRMATION_D_OPERATION_D_ARBITRAGE_A1871955379_s2WpnJRP.pdf'),
(30, 39, NULL, 'Relevé mensuel', '2020-11-25', 'ESPACE_GESTION_90019985064.pdf'),
(31, 48, NULL, 'Versement', '2019-04-03', 'Demande_de_versement_libre_Assurance_Vie_20190403_96194415_X5bzd7H6.pdf'),
(32, 53, NULL, 'Relevé mensuel', '2020-11-29', 'PREDISSIME_9_90012708554.pdf'),
(33, 44, NULL, 'Relevé mensuel', '2020-11-25', 'ESPACE_GESTION_90019985270.pdf');

-- --------------------------------------------------------

--
-- Table structure for table `banque_etablissement`
--

CREATE TABLE `banque_etablissement` (
  `id_banque` int(11) NOT NULL,
  `nom` varchar(50) NOT NULL,
  `abreviation` varchar(10) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `banque_etablissement`
--

INSERT INTO `banque_etablissement` (`id_banque`, `nom`, `abreviation`) VALUES
(1, 'Crédit Agricole', 'CA'),
(2, 'Caisse d\'Épargne', 'CE'),
(3, 'Révolut', 'RE');

-- --------------------------------------------------------

--
-- Table structure for table `banque_type`
--

CREATE TABLE `banque_type` (
  `id_type` int(11) NOT NULL,
  `nom` varchar(50) NOT NULL,
  `detaille` varchar(100) NOT NULL,
  `id_typologie` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `banque_type`
--

INSERT INTO `banque_type` (`id_type`, `nom`, `detaille`, `id_typologie`) VALUES
(0, 'CCHQ', 'Compte Chèque', 1),
(1, 'CEL', 'Compte Épargne Logement', 2),
(2, 'CSL SOCIETAIRES', 'Comptes sociétaire', 2),
(3, 'LIVRET A', 'Livret A', 2),
(4, 'CSL', 'Compte Sur Livret', 2),
(5, 'LEP', 'Livret d\'Épargne Populaire', 2),
(6, 'PEL', 'Plan Épargne Logement ', 3),
(7, 'CONFLUENCE', 'Confluence', 4),
(8, 'ESPGESTION', 'Espace Gestion', 4),
(9, 'ESP LIB 2', 'Espace Liberté 2', 4),
(10, 'ESP LIB 3', 'Espace Liberté 3', 4),
(11, 'PRED', 'Predissime', 4),
(14, 'ESPGESTPEP', 'Espace Gestion PEP', 4),
(15, 'TITR', 'Compte Titre', 5);

-- --------------------------------------------------------

--
-- Table structure for table `banque_typologies`
--

CREATE TABLE `banque_typologies` (
  `id_typologie` int(11) NOT NULL,
  `nom` varchar(100) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `banque_typologies`
--

INSERT INTO `banque_typologies` (`id_typologie`, `nom`) VALUES
(1, 'Comptes courants'),
(2, 'Épargne disponible'),
(3, 'Épargne à terme'),
(4, 'Assurance vie et Capitalisation'),
(5, 'Épargne boursière');

-- --------------------------------------------------------

--
-- Table structure for table `car_jaune_arrets`
--

CREATE TABLE `car_jaune_arrets` (
  `id_arret` int(11) NOT NULL,
  `nom` varchar(255) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `car_jaune_arrets`
--

INSERT INTO `car_jaune_arrets` (`id_arret`, `nom`) VALUES
(1, 'Gare de St-Pierre'),
(2, 'Gare de St-Louis'),
(3, 'RDT Etang-Salé'),
(4, 'RDT Portail'),
(5, 'RDT Colimaçons'),
(6, 'RDT L’Eperon'),
(7, 'RDT Plateau Caillou'),
(8, 'Cambaie'),
(9, 'Clinique Flamboyants'),
(10, 'Les Vilebrequins'),
(11, 'Mairie de la Possession'),
(12, 'Roland Garros'),
(13, 'Gare de St-Denis');

-- --------------------------------------------------------

--
-- Table structure for table `car_jaune_lignes`
--

CREATE TABLE `car_jaune_lignes` (
  `id_ligne` char(2) NOT NULL,
  `nom` varchar(255) NOT NULL,
  `color` char(6) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `car_jaune_lignes`
--

INSERT INTO `car_jaune_lignes` (`id_ligne`, `nom`, `color`) VALUES
('O1', 'St-Pierre <-> StDenis', '6FCAF3'),
('O2', 'St-Pierre <-> St-Denis', '00ADBA');

-- --------------------------------------------------------

--
-- Table structure for table `car_jaune_lignes_arrets`
--

CREATE TABLE `car_jaune_lignes_arrets` (
  `id_ligne` char(2) NOT NULL,
  `sens` enum('1','2') NOT NULL,
  `id_arret` int(11) NOT NULL,
  `order` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `car_jaune_lignes_arrets`
--

INSERT INTO `car_jaune_lignes_arrets` (`id_ligne`, `sens`, `id_arret`, `order`) VALUES
('O1', '1', 1, 1),
('O1', '1', 2, 2),
('O1', '1', 3, 3),
('O1', '1', 4, 4),
('O1', '1', 5, 5),
('O1', '1', 6, 6),
('O1', '1', 7, 7),
('O1', '1', 8, 8),
('O1', '1', 9, 9),
('O1', '1', 10, 10),
('O1', '1', 11, 11),
('O1', '1', 12, 12),
('O1', '1', 13, 13),
('O1', '2', 1, 13),
('O1', '2', 2, 12),
('O1', '2', 3, 11),
('O1', '2', 4, 10),
('O1', '2', 5, 9),
('O1', '2', 6, 8),
('O1', '2', 7, 7),
('O1', '2', 8, 6),
('O1', '2', 9, 5),
('O1', '2', 10, 4),
('O1', '2', 11, 3),
('O1', '2', 12, 2),
('O1', '2', 13, 1);

-- --------------------------------------------------------

--
-- Table structure for table `car_jaune_trajet`
--

CREATE TABLE `car_jaune_trajet` (
  `id_ligne` char(2) NOT NULL,
  `sens` tinyint(1) NOT NULL,
  `week_weekend` enum('week','weekend') NOT NULL,
  `id_trajet` int(11) NOT NULL,
  `id_arret` int(11) NOT NULL,
  `horaire` time NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `car_jaune_trajet`
--

INSERT INTO `car_jaune_trajet` (`id_ligne`, `sens`, `week_weekend`, `id_trajet`, `id_arret`, `horaire`) VALUES
('O1', 1, 'week', 1, 1, '05:15:00'),
('O1', 1, 'week', 1, 2, '05:25:00'),
('O1', 1, 'week', 1, 3, '05:34:00'),
('O1', 1, 'week', 1, 4, '05:40:00'),
('O1', 1, 'week', 1, 5, '05:49:00'),
('O1', 1, 'week', 1, 6, '06:01:00'),
('O1', 1, 'week', 1, 7, '06:05:00'),
('O1', 1, 'week', 1, 8, '06:19:00'),
('O1', 1, 'week', 1, 9, '06:22:00'),
('O1', 1, 'week', 1, 10, '06:25:00'),
('O1', 1, 'week', 1, 11, '06:30:00'),
('O1', 1, 'week', 1, 12, '06:55:00'),
('O1', 1, 'week', 1, 13, '06:58:00'),
('O1', 1, 'week', 2, 1, '06:15:00'),
('O1', 1, 'week', 2, 2, '06:25:00'),
('O1', 1, 'week', 2, 3, '06:34:00'),
('O1', 1, 'week', 2, 4, '06:40:00'),
('O1', 1, 'week', 2, 5, '06:49:00'),
('O1', 1, 'week', 2, 6, '07:01:00'),
('O1', 1, 'week', 2, 7, '07:05:00'),
('O1', 1, 'week', 2, 8, '07:19:00'),
('O1', 1, 'week', 2, 9, '07:22:00'),
('O1', 1, 'week', 2, 10, '07:25:00'),
('O1', 1, 'week', 2, 11, '07:30:00'),
('O1', 1, 'week', 2, 12, '07:55:00'),
('O1', 1, 'week', 2, 13, '07:58:00'),
('O1', 1, 'week', 3, 1, '07:15:00'),
('O1', 1, 'week', 3, 2, '07:25:00'),
('O1', 1, 'week', 3, 3, '07:34:00'),
('O1', 1, 'week', 3, 4, '07:41:00'),
('O1', 1, 'week', 3, 5, '07:50:00'),
('O1', 1, 'week', 3, 6, '08:02:00'),
('O1', 1, 'week', 3, 7, '08:06:00'),
('O1', 1, 'week', 3, 8, '08:23:00'),
('O1', 1, 'week', 3, 9, '08:26:00'),
('O1', 1, 'week', 3, 10, '08:30:00'),
('O1', 1, 'week', 3, 11, '08:36:00'),
('O1', 1, 'week', 3, 12, '08:55:00'),
('O1', 1, 'week', 3, 13, '08:58:00'),
('O1', 1, 'week', 4, 1, '08:15:00'),
('O1', 1, 'week', 4, 2, '08:26:00'),
('O1', 1, 'week', 4, 3, '08:35:00'),
('O1', 1, 'week', 4, 4, '08:42:00'),
('O1', 1, 'week', 4, 5, '08:51:00'),
('O1', 1, 'week', 4, 6, '09:03:00'),
('O1', 1, 'week', 4, 7, '09:07:00'),
('O1', 1, 'week', 4, 8, '09:18:00'),
('O1', 1, 'week', 4, 9, '09:21:00'),
('O1', 1, 'week', 4, 10, '09:25:00'),
('O1', 1, 'week', 4, 11, '09:31:00'),
('O1', 1, 'week', 4, 12, '09:56:00'),
('O1', 1, 'week', 4, 13, '09:59:00'),
('O1', 1, 'week', 5, 1, '10:45:00'),
('O1', 1, 'week', 5, 2, '10:56:00'),
('O1', 1, 'week', 5, 3, '11:05:00'),
('O1', 1, 'week', 5, 4, '11:11:00'),
('O1', 1, 'week', 5, 5, '11:20:00'),
('O1', 1, 'week', 5, 6, '11:32:00'),
('O1', 1, 'week', 5, 7, '11:36:00'),
('O1', 1, 'week', 5, 8, '11:46:00'),
('O1', 1, 'week', 5, 9, '11:49:00'),
('O1', 1, 'week', 5, 10, '11:52:00'),
('O1', 1, 'week', 5, 11, '11:58:00'),
('O1', 1, 'week', 5, 12, '12:17:00'),
('O1', 1, 'week', 5, 13, '12:19:00'),
('O1', 1, 'week', 6, 1, '13:25:00'),
('O1', 1, 'week', 6, 2, '13:36:00'),
('O1', 1, 'week', 6, 3, '13:45:00'),
('O1', 1, 'week', 6, 4, '13:52:00'),
('O1', 1, 'week', 6, 5, '14:01:00'),
('O1', 1, 'week', 6, 6, '14:13:00'),
('O1', 1, 'week', 6, 7, '14:17:00'),
('O1', 1, 'week', 6, 8, '14:27:00'),
('O1', 1, 'week', 6, 9, '14:30:00'),
('O1', 1, 'week', 6, 10, '14:33:00'),
('O1', 1, 'week', 6, 11, '14:39:00'),
('O1', 1, 'week', 6, 12, '15:05:00'),
('O1', 1, 'week', 6, 13, '15:07:00'),
('O1', 1, 'week', 7, 1, '15:45:00'),
('O1', 1, 'week', 7, 2, '15:57:00'),
('O1', 1, 'week', 7, 3, '16:06:00'),
('O1', 1, 'week', 7, 4, '16:13:00'),
('O1', 1, 'week', 7, 5, '16:22:00'),
('O1', 1, 'week', 7, 6, '16:34:00'),
('O1', 1, 'week', 7, 7, '16:38:00'),
('O1', 1, 'week', 7, 8, '16:48:00'),
('O1', 1, 'week', 7, 9, '16:51:00'),
('O1', 1, 'week', 7, 10, '16:54:00'),
('O1', 1, 'week', 7, 11, '17:00:00'),
('O1', 1, 'week', 7, 12, '17:20:00'),
('O1', 1, 'week', 7, 13, '17:22:00'),
('O1', 1, 'week', 8, 1, '16:45:00'),
('O1', 1, 'week', 8, 2, '16:58:00'),
('O1', 1, 'week', 8, 3, '17:07:00'),
('O1', 1, 'week', 8, 4, '17:14:00'),
('O1', 1, 'week', 8, 5, '17:23:00'),
('O1', 1, 'week', 8, 6, '17:35:00'),
('O1', 1, 'week', 8, 7, '17:39:00'),
('O1', 1, 'week', 8, 8, '17:49:00'),
('O1', 1, 'week', 8, 9, '17:52:00'),
('O1', 1, 'week', 8, 10, '17:55:00'),
('O1', 1, 'week', 8, 11, '18:00:00'),
('O1', 1, 'week', 8, 12, '18:20:00'),
('O1', 1, 'week', 8, 13, '18:22:00'),
('O1', 1, 'week', 9, 1, '17:45:00'),
('O1', 1, 'week', 9, 2, '17:57:00'),
('O1', 1, 'week', 9, 3, '18:05:00'),
('O1', 1, 'week', 9, 4, '18:12:00'),
('O1', 1, 'week', 9, 5, '18:21:00'),
('O1', 1, 'week', 9, 6, '18:32:00'),
('O1', 1, 'week', 9, 7, '18:36:00'),
('O1', 1, 'week', 9, 8, '18:45:00'),
('O1', 1, 'week', 9, 9, '18:48:00'),
('O1', 1, 'week', 9, 10, '18:51:00'),
('O1', 1, 'week', 9, 11, '18:56:00'),
('O1', 1, 'week', 9, 12, '19:11:00'),
('O1', 1, 'week', 9, 13, '19:13:00'),
('O1', 1, 'week', 10, 1, '18:45:00'),
('O1', 1, 'week', 10, 2, '18:55:00'),
('O1', 1, 'week', 10, 3, '19:03:00'),
('O1', 1, 'week', 10, 4, '19:10:00'),
('O1', 1, 'week', 10, 5, '19:19:00'),
('O1', 1, 'week', 10, 6, '19:30:00'),
('O1', 1, 'week', 10, 7, '19:34:00'),
('O1', 1, 'week', 10, 8, '19:43:00'),
('O1', 1, 'week', 10, 9, '19:45:00'),
('O1', 1, 'week', 10, 10, '19:48:00'),
('O1', 1, 'week', 10, 11, '19:53:00'),
('O1', 1, 'week', 10, 12, '20:08:00'),
('O1', 1, 'week', 10, 13, '20:10:00'),
('O1', 1, 'weekend', 11, 1, '05:45:00'),
('O1', 1, 'weekend', 11, 2, '05:55:00'),
('O1', 1, 'weekend', 11, 3, '06:03:00'),
('O1', 1, 'weekend', 11, 4, '06:10:00'),
('O1', 1, 'weekend', 11, 5, '06:19:00'),
('O1', 1, 'weekend', 11, 6, '06:30:00'),
('O1', 1, 'weekend', 11, 7, '06:34:00'),
('O1', 1, 'weekend', 11, 8, '06:43:00'),
('O1', 1, 'weekend', 11, 9, '06:45:00'),
('O1', 1, 'weekend', 11, 10, '06:48:00'),
('O1', 1, 'weekend', 11, 11, '06:52:00'),
('O1', 1, 'weekend', 11, 12, '07:06:00'),
('O1', 1, 'weekend', 11, 13, '07:07:00'),
('O1', 1, 'weekend', 12, 1, '07:45:00'),
('O1', 1, 'weekend', 12, 2, '07:55:00'),
('O1', 1, 'weekend', 12, 3, '08:04:00'),
('O1', 1, 'weekend', 12, 4, '08:10:00'),
('O1', 1, 'weekend', 12, 5, '08:19:00'),
('O1', 1, 'weekend', 12, 6, '08:31:00'),
('O1', 1, 'weekend', 12, 7, '08:35:00'),
('O1', 1, 'weekend', 12, 8, '08:44:00'),
('O1', 1, 'weekend', 12, 9, '08:46:00'),
('O1', 1, 'weekend', 12, 10, '08:49:00'),
('O1', 1, 'weekend', 12, 11, '08:54:00'),
('O1', 1, 'weekend', 12, 12, '09:09:00'),
('O1', 1, 'weekend', 12, 13, '09:11:00'),
('O1', 1, 'weekend', 13, 1, '09:45:00'),
('O1', 1, 'weekend', 13, 2, '09:55:00'),
('O1', 1, 'weekend', 13, 3, '10:04:00'),
('O1', 1, 'weekend', 13, 4, '10:10:00'),
('O1', 1, 'weekend', 13, 5, '10:19:00'),
('O1', 1, 'weekend', 13, 6, '10:31:00'),
('O1', 1, 'weekend', 13, 7, '10:35:00'),
('O1', 1, 'weekend', 13, 8, '10:44:00'),
('O1', 1, 'weekend', 13, 9, '10:46:00'),
('O1', 1, 'weekend', 13, 10, '10:49:00'),
('O1', 1, 'weekend', 13, 11, '10:54:00'),
('O1', 1, 'weekend', 13, 12, '11:09:00'),
('O1', 1, 'weekend', 13, 13, '11:11:00'),
('O1', 1, 'weekend', 14, 1, '11:45:00'),
('O1', 1, 'weekend', 14, 2, '11:55:00'),
('O1', 1, 'weekend', 14, 3, '12:04:00'),
('O1', 1, 'weekend', 14, 4, '12:10:00'),
('O1', 1, 'weekend', 14, 5, '12:19:00'),
('O1', 1, 'weekend', 14, 6, '12:31:00'),
('O1', 1, 'weekend', 14, 7, '12:35:00'),
('O1', 1, 'weekend', 14, 8, '12:44:00'),
('O1', 1, 'weekend', 14, 9, '12:46:00'),
('O1', 1, 'weekend', 14, 10, '12:49:00'),
('O1', 1, 'weekend', 14, 11, '12:54:00'),
('O1', 1, 'weekend', 14, 12, '13:09:00'),
('O1', 1, 'weekend', 14, 13, '13:11:00'),
('O1', 1, 'weekend', 15, 1, '13:45:00'),
('O1', 1, 'weekend', 15, 2, '13:54:00'),
('O1', 1, 'weekend', 15, 3, '14:02:00'),
('O1', 1, 'weekend', 15, 4, '14:09:00'),
('O1', 1, 'weekend', 15, 5, '14:18:00'),
('O1', 1, 'weekend', 15, 6, '14:29:00'),
('O1', 1, 'weekend', 15, 7, '14:33:00'),
('O1', 1, 'weekend', 15, 8, '14:42:00'),
('O1', 1, 'weekend', 15, 9, '14:44:00'),
('O1', 1, 'weekend', 15, 10, '14:47:00'),
('O1', 1, 'weekend', 15, 11, '14:52:00'),
('O1', 1, 'weekend', 15, 12, '15:08:00'),
('O1', 1, 'weekend', 15, 13, '15:10:00'),
('O1', 1, 'weekend', 16, 1, '15:45:00'),
('O1', 1, 'weekend', 16, 2, '15:55:00'),
('O1', 1, 'weekend', 16, 3, '16:03:00'),
('O1', 1, 'weekend', 16, 4, '16:10:00'),
('O1', 1, 'weekend', 16, 5, '16:19:00'),
('O1', 1, 'weekend', 16, 6, '16:30:00'),
('O1', 1, 'weekend', 16, 7, '16:34:00'),
('O1', 1, 'weekend', 16, 8, '16:43:00'),
('O1', 1, 'weekend', 16, 9, '16:45:00'),
('O1', 1, 'weekend', 16, 10, '16:48:00'),
('O1', 1, 'weekend', 16, 11, '16:53:00'),
('O1', 1, 'weekend', 16, 12, '17:15:00'),
('O1', 1, 'weekend', 16, 13, '17:17:00'),
('O1', 1, 'weekend', 17, 1, '17:45:00'),
('O1', 1, 'weekend', 17, 2, '17:55:00'),
('O1', 1, 'weekend', 17, 3, '18:04:00'),
('O1', 1, 'weekend', 17, 4, '18:10:00'),
('O1', 1, 'weekend', 17, 5, '18:19:00'),
('O1', 1, 'weekend', 17, 6, '18:31:00'),
('O1', 1, 'weekend', 17, 7, '18:35:00'),
('O1', 1, 'weekend', 17, 8, '18:44:00'),
('O1', 1, 'weekend', 17, 9, '18:46:00'),
('O1', 1, 'weekend', 17, 10, '18:49:00'),
('O1', 1, 'weekend', 17, 11, '18:54:00'),
('O1', 1, 'weekend', 17, 12, '19:18:00'),
('O1', 1, 'weekend', 17, 13, '19:20:00'),
('O1', 1, 'weekend', 18, 1, '19:45:00'),
('O1', 1, 'weekend', 18, 2, '19:55:00'),
('O1', 1, 'weekend', 18, 3, '20:03:00'),
('O1', 1, 'weekend', 18, 4, '20:10:00'),
('O1', 1, 'weekend', 18, 5, '20:19:00'),
('O1', 1, 'weekend', 18, 6, '20:30:00'),
('O1', 1, 'weekend', 18, 7, '20:34:00'),
('O1', 1, 'weekend', 18, 8, '20:43:00'),
('O1', 1, 'weekend', 18, 9, '20:45:00'),
('O1', 1, 'weekend', 18, 10, '20:48:00'),
('O1', 1, 'weekend', 18, 11, '20:52:00'),
('O1', 1, 'weekend', 18, 12, '21:06:00'),
('O1', 1, 'weekend', 18, 13, '21:07:00'),
('O1', 2, 'week', 19, 1, '06:25:00'),
('O1', 2, 'week', 19, 2, '06:14:00'),
('O1', 2, 'week', 19, 3, '06:04:00'),
('O1', 2, 'week', 19, 4, '05:58:00'),
('O1', 2, 'week', 19, 5, '05:51:00'),
('O1', 2, 'week', 19, 6, '05:38:00'),
('O1', 2, 'week', 19, 7, '05:35:00'),
('O1', 2, 'week', 19, 8, '05:26:00'),
('O1', 2, 'week', 19, 9, '05:22:00'),
('O1', 2, 'week', 19, 10, '05:19:00'),
('O1', 2, 'week', 19, 11, '05:15:00'),
('O1', 2, 'week', 19, 12, '05:01:00'),
('O1', 2, 'week', 19, 13, '05:00:00'),
('O1', 2, 'week', 20, 1, '07:35:00'),
('O1', 2, 'week', 20, 2, '07:20:00'),
('O1', 2, 'week', 20, 3, '07:10:00'),
('O1', 2, 'week', 20, 4, '07:04:00'),
('O1', 2, 'week', 20, 5, '06:55:00'),
('O1', 2, 'week', 20, 6, '06:42:00'),
('O1', 2, 'week', 20, 7, '06:39:00'),
('O1', 2, 'week', 20, 8, '06:30:00'),
('O1', 2, 'week', 20, 9, '06:25:00'),
('O1', 2, 'week', 20, 10, '06:22:00'),
('O1', 2, 'week', 20, 11, '06:17:00'),
('O1', 2, 'week', 20, 12, '06:02:00'),
('O1', 2, 'week', 20, 13, '06:00:00'),
('O1', 2, 'week', 21, 1, '09:01:00'),
('O1', 2, 'week', 21, 2, '08:47:00'),
('O1', 2, 'week', 21, 3, '08:37:00'),
('O1', 2, 'week', 21, 4, '08:31:00'),
('O1', 2, 'week', 21, 5, '08:23:00'),
('O1', 2, 'week', 21, 6, '08:10:00'),
('O1', 2, 'week', 21, 7, '08:07:00'),
('O1', 2, 'week', 21, 8, '07:58:00'),
('O1', 2, 'week', 21, 9, '07:53:00'),
('O1', 2, 'week', 21, 10, '07:50:00'),
('O1', 2, 'week', 21, 11, '07:45:00'),
('O1', 2, 'week', 21, 12, '07:31:00'),
('O1', 2, 'week', 21, 13, '07:30:00'),
('O1', 2, 'week', 22, 1, '09:44:00'),
('O1', 2, 'week', 22, 2, '09:30:00'),
('O1', 2, 'week', 22, 3, '09:20:00'),
('O1', 2, 'week', 22, 4, '09:14:00'),
('O1', 2, 'week', 22, 5, '09:06:00'),
('O1', 2, 'week', 22, 6, '08:53:00'),
('O1', 2, 'week', 22, 7, '08:50:00'),
('O1', 2, 'week', 22, 8, '08:41:00'),
('O1', 2, 'week', 22, 9, '08:37:00'),
('O1', 2, 'week', 22, 10, '08:34:00'),
('O1', 2, 'week', 22, 11, '08:30:00'),
('O1', 2, 'week', 22, 12, '08:16:00'),
('O1', 2, 'week', 22, 13, '08:15:00'),
('O1', 2, 'week', 23, 1, '12:32:00'),
('O1', 2, 'week', 23, 2, '12:20:00'),
('O1', 2, 'week', 23, 3, '12:10:00'),
('O1', 2, 'week', 23, 4, '12:04:00'),
('O1', 2, 'week', 23, 5, '11:56:00'),
('O1', 2, 'week', 23, 6, '11:43:00'),
('O1', 2, 'week', 23, 7, '11:40:00'),
('O1', 2, 'week', 23, 8, '11:29:00'),
('O1', 2, 'week', 23, 9, '11:25:00'),
('O1', 2, 'week', 23, 10, '11:22:00'),
('O1', 2, 'week', 23, 11, '11:17:00'),
('O1', 2, 'week', 23, 12, '11:02:00'),
('O1', 2, 'week', 23, 13, '11:00:00'),
('O1', 2, 'week', 24, 1, '14:31:00'),
('O1', 2, 'week', 24, 2, '14:19:00'),
('O1', 2, 'week', 24, 3, '14:09:00'),
('O1', 2, 'week', 24, 4, '14:03:00'),
('O1', 2, 'week', 24, 5, '13:55:00'),
('O1', 2, 'week', 24, 6, '13:42:00'),
('O1', 2, 'week', 24, 7, '13:39:00'),
('O1', 2, 'week', 24, 8, '13:30:00'),
('O1', 2, 'week', 24, 9, '13:26:00'),
('O1', 2, 'week', 24, 10, '13:23:00'),
('O1', 2, 'week', 24, 11, '13:19:00'),
('O1', 2, 'week', 24, 12, '13:02:00'),
('O1', 2, 'week', 24, 13, '13:00:00'),
('O1', 2, 'week', 25, 1, '17:05:00'),
('O1', 2, 'week', 25, 2, '16:52:00'),
('O1', 2, 'week', 25, 3, '16:42:00'),
('O1', 2, 'week', 25, 4, '16:36:00'),
('O1', 2, 'week', 25, 5, '16:27:00'),
('O1', 2, 'week', 25, 6, '16:14:00'),
('O1', 2, 'week', 25, 7, '16:11:00'),
('O1', 2, 'week', 25, 8, '16:01:00'),
('O1', 2, 'week', 25, 9, '15:57:00'),
('O1', 2, 'week', 25, 10, '15:54:00'),
('O1', 2, 'week', 25, 11, '15:49:00'),
('O1', 2, 'week', 25, 12, '15:32:00'),
('O1', 2, 'week', 25, 13, '15:30:00'),
('O1', 2, 'week', 26, 1, '18:05:00'),
('O1', 2, 'week', 26, 2, '17:53:00'),
('O1', 2, 'week', 26, 3, '17:43:00'),
('O1', 2, 'week', 26, 4, '17:37:00'),
('O1', 2, 'week', 26, 5, '17:29:00'),
('O1', 2, 'week', 26, 6, '17:16:00'),
('O1', 2, 'week', 26, 7, '17:13:00'),
('O1', 2, 'week', 26, 8, '17:03:00'),
('O1', 2, 'week', 26, 9, '16:59:00'),
('O1', 2, 'week', 26, 10, '16:56:00'),
('O1', 2, 'week', 26, 11, '16:51:00'),
('O1', 2, 'week', 26, 12, '16:32:00'),
('O1', 2, 'week', 26, 13, '16:30:00'),
('O1', 2, 'week', 27, 1, '19:14:00'),
('O1', 2, 'week', 27, 2, '19:03:00'),
('O1', 2, 'week', 27, 3, '18:54:00'),
('O1', 2, 'week', 27, 4, '18:48:00'),
('O1', 2, 'week', 27, 5, '18:40:00'),
('O1', 2, 'week', 27, 6, '18:28:00'),
('O1', 2, 'week', 27, 7, '18:25:00'),
('O1', 2, 'week', 27, 8, '18:16:00'),
('O1', 2, 'week', 27, 9, '18:12:00'),
('O1', 2, 'week', 27, 10, '18:10:00'),
('O1', 2, 'week', 27, 11, '18:06:00'),
('O1', 2, 'week', 27, 12, '17:47:00'),
('O1', 2, 'week', 27, 13, '17:45:00'),
('O1', 2, 'week', 28, 1, '20:11:00'),
('O1', 2, 'week', 28, 2, '20:00:00'),
('O1', 2, 'week', 28, 3, '19:51:00'),
('O1', 2, 'week', 28, 4, '19:45:00'),
('O1', 2, 'week', 28, 5, '19:37:00'),
('O1', 2, 'week', 28, 6, '19:25:00'),
('O1', 2, 'week', 28, 7, '19:22:00'),
('O1', 2, 'week', 28, 8, '19:13:00'),
('O1', 2, 'week', 28, 9, '19:09:00'),
('O1', 2, 'week', 28, 10, '19:07:00'),
('O1', 2, 'week', 28, 11, '19:03:00'),
('O1', 2, 'week', 28, 12, '18:47:00'),
('O1', 2, 'week', 28, 13, '18:45:00'),
('O1', 2, 'weekend', 29, 1, '07:12:00'),
('O1', 2, 'weekend', 29, 2, '07:02:00'),
('O1', 2, 'weekend', 29, 3, '06:52:00'),
('O1', 2, 'weekend', 29, 4, '06:46:00'),
('O1', 2, 'weekend', 29, 5, '06:38:00'),
('O1', 2, 'weekend', 29, 6, '06:25:00'),
('O1', 2, 'weekend', 29, 7, '06:22:00'),
('O1', 2, 'weekend', 29, 8, '06:13:00'),
('O1', 2, 'weekend', 29, 9, '06:08:00'),
('O1', 2, 'weekend', 29, 10, '06:05:00'),
('O1', 2, 'weekend', 29, 11, '06:00:00'),
('O1', 2, 'weekend', 29, 12, '05:46:00'),
('O1', 2, 'weekend', 29, 13, '05:45:00'),
('O1', 2, 'weekend', 30, 1, '09:11:00'),
('O1', 2, 'weekend', 30, 2, '09:00:00'),
('O1', 2, 'weekend', 30, 3, '08:50:00'),
('O1', 2, 'weekend', 30, 4, '08:44:00'),
('O1', 2, 'weekend', 30, 5, '08:36:00'),
('O1', 2, 'weekend', 30, 6, '08:23:00'),
('O1', 2, 'weekend', 30, 7, '08:20:00'),
('O1', 2, 'weekend', 30, 8, '08:11:00'),
('O1', 2, 'weekend', 30, 9, '08:07:00'),
('O1', 2, 'weekend', 30, 10, '08:04:00'),
('O1', 2, 'weekend', 30, 11, '07:59:00'),
('O1', 2, 'weekend', 30, 12, '07:46:00'),
('O1', 2, 'weekend', 30, 13, '07:45:00'),
('O1', 2, 'weekend', 31, 1, '11:14:00'),
('O1', 2, 'weekend', 31, 2, '11:03:00'),
('O1', 2, 'weekend', 31, 3, '10:53:00'),
('O1', 2, 'weekend', 31, 4, '10:46:00'),
('O1', 2, 'weekend', 31, 5, '10:38:00'),
('O1', 2, 'weekend', 31, 6, '10:25:00'),
('O1', 2, 'weekend', 31, 7, '10:21:00'),
('O1', 2, 'weekend', 31, 8, '10:12:00'),
('O1', 2, 'weekend', 31, 9, '10:08:00'),
('O1', 2, 'weekend', 31, 10, '10:05:00'),
('O1', 2, 'weekend', 31, 11, '10:00:00'),
('O1', 2, 'weekend', 31, 12, '09:46:00'),
('O1', 2, 'weekend', 31, 13, '09:45:00'),
('O1', 2, 'weekend', 32, 1, '13:08:00'),
('O1', 2, 'weekend', 32, 2, '12:58:00'),
('O1', 2, 'weekend', 32, 3, '12:48:00'),
('O1', 2, 'weekend', 32, 4, '12:42:00'),
('O1', 2, 'weekend', 32, 5, '12:35:00'),
('O1', 2, 'weekend', 32, 6, '12:22:00'),
('O1', 2, 'weekend', 32, 7, '12:19:00'),
('O1', 2, 'weekend', 32, 8, '12:10:00'),
('O1', 2, 'weekend', 32, 9, '12:06:00'),
('O1', 2, 'weekend', 32, 10, '12:04:00'),
('O1', 2, 'weekend', 32, 11, '12:00:00'),
('O1', 2, 'weekend', 32, 12, '11:46:00'),
('O1', 2, 'weekend', 32, 13, '11:45:00'),
('O1', 2, 'weekend', 33, 1, '15:10:00'),
('O1', 2, 'weekend', 33, 2, '15:00:00'),
('O1', 2, 'weekend', 33, 3, '14:50:00'),
('O1', 2, 'weekend', 33, 4, '14:44:00'),
('O1', 2, 'weekend', 33, 5, '14:37:00'),
('O1', 2, 'weekend', 33, 6, '14:24:00'),
('O1', 2, 'weekend', 33, 7, '14:21:00'),
('O1', 2, 'weekend', 33, 8, '14:12:00'),
('O1', 2, 'weekend', 33, 9, '14:08:00'),
('O1', 2, 'weekend', 33, 10, '14:05:00'),
('O1', 2, 'weekend', 33, 11, '14:00:00'),
('O1', 2, 'weekend', 33, 12, '13:46:00'),
('O1', 2, 'weekend', 33, 13, '13:45:00'),
('O1', 2, 'weekend', 34, 1, '17:10:00'),
('O1', 2, 'weekend', 34, 2, '16:59:00'),
('O1', 2, 'weekend', 34, 3, '16:50:00'),
('O1', 2, 'weekend', 34, 4, '16:44:00'),
('O1', 2, 'weekend', 34, 5, '16:36:00'),
('O1', 2, 'weekend', 34, 6, '16:24:00'),
('O1', 2, 'weekend', 34, 7, '16:21:00'),
('O1', 2, 'weekend', 34, 8, '16:12:00'),
('O1', 2, 'weekend', 34, 9, '16:08:00'),
('O1', 2, 'weekend', 34, 10, '16:05:00'),
('O1', 2, 'weekend', 34, 11, '16:00:00'),
('O1', 2, 'weekend', 34, 12, '15:46:00'),
('O1', 2, 'weekend', 34, 13, '15:45:00'),
('O1', 2, 'weekend', 35, 1, '19:14:00'),
('O1', 2, 'weekend', 35, 2, '19:03:00'),
('O1', 2, 'weekend', 35, 3, '18:53:00'),
('O1', 2, 'weekend', 35, 4, '18:47:00'),
('O1', 2, 'weekend', 35, 5, '18:38:00'),
('O1', 2, 'weekend', 35, 6, '18:25:00'),
('O1', 2, 'weekend', 35, 7, '18:22:00'),
('O1', 2, 'weekend', 35, 8, '18:13:00'),
('O1', 2, 'weekend', 35, 9, '18:09:00'),
('O1', 2, 'weekend', 35, 10, '18:06:00'),
('O1', 2, 'weekend', 35, 11, '18:01:00'),
('O1', 2, 'weekend', 35, 12, '17:47:00'),
('O1', 2, 'weekend', 35, 13, '17:45:00'),
('O1', 2, 'weekend', 36, 1, '20:47:00'),
('O1', 2, 'weekend', 36, 2, '20:38:00'),
('O1', 2, 'weekend', 36, 3, '20:29:00'),
('O1', 2, 'weekend', 36, 4, '20:23:00'),
('O1', 2, 'weekend', 36, 5, '20:16:00'),
('O1', 2, 'weekend', 36, 6, '20:04:00'),
('O1', 2, 'weekend', 36, 7, '20:01:00'),
('O1', 2, 'weekend', 36, 8, '19:53:00'),
('O1', 2, 'weekend', 36, 9, '19:50:00'),
('O1', 2, 'weekend', 36, 10, '19:47:00'),
('O1', 2, 'weekend', 36, 11, '19:44:00'),
('O1', 2, 'weekend', 36, 12, '19:31:00'),
('O1', 2, 'weekend', 36, 13, '19:30:00');

-- --------------------------------------------------------

--
-- Table structure for table `comptes_gestion`
--

CREATE TABLE `comptes_gestion` (
  `annee` year(4) NOT NULL,
  `date_from` date NOT NULL,
  `date_to` date NOT NULL,
  `observations` text NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `comptes_gestion`
--

INSERT INTO `comptes_gestion` (`annee`, `date_from`, `date_to`, `observations`) VALUES
('2017', '2017-01-01', '2017-12-31', 'Déclaration initiale modifiée : \r\nIntérêt financier CA : TR=13818€ correspond a Bernard + Dominique + Pierre Tanguy sur la même déclaration. Pierre Tanguy à TR=7648€\r\nFacture des billets de voyages non retrouvé donc non mentionné. Taxe et impôt : 2005 € =  20 844 € (cumul imposable 2017 P. Tanguy) x 9,62% (=pourcentage de la feuille d’impôts des parents.)'),
('2018', '2018-01-01', '2018-12-31', 'Il y a moins de prélèvements sur le compte de Pierre Tanguy cette année de la part des curateurs.\r\nImpôts et taxe de Bernard + Dominique + Pierre Tanguy = 0€  sur 2019 (année de transition). Donc pas de déclaration d\'impôts et taxe pour Pierre Tanguy.\r\nPrudence créole m\'a transmit seulement les justificatifs 2017 et pas 2018 pour les dépenses de santé.'),
('2019', '2019-01-01', '2019-02-19', 'Déclaration sur 1 mois et demi sur 2019.\r\nÉvolution seulement du compte bancaire DAV sur 1 mois et demi.');

-- --------------------------------------------------------

--
-- Table structure for table `comptes_gestion_montant`
--

CREATE TABLE `comptes_gestion_montant` (
  `id_compte` int(11) NOT NULL,
  `fin_annee` year(4) NOT NULL,
  `montant` decimal(10,2) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `comptes_gestion_montant`
--

INSERT INTO `comptes_gestion_montant` (`id_compte`, `fin_annee`, `montant`) VALUES
(4, '2016', 288.79),
(4, '2017', 7583.96),
(4, '2018', 35929.60),
(4, '2019', 39696.16),
(10, '2016', 305.39),
(10, '2017', 305.39),
(10, '2018', 306.70),
(10, '2019', 306.70),
(16, '2016', 111.25),
(16, '2017', 111.25),
(16, '2018', 112.08),
(16, '2019', 112.08),
(22, '2016', 10.17),
(22, '2017', 10.17),
(22, '2018', 10.21),
(22, '2019', 10.21),
(47, '2016', 180672.35),
(47, '2017', 183855.49),
(47, '2018', 186895.87),
(47, '2019', 186895.87),
(52, '2016', 23882.06),
(52, '2017', 24432.54),
(52, '2018', 24583.67),
(52, '2019', 24583.67);

-- --------------------------------------------------------

--
-- Table structure for table `comptes_gestion_operations`
--

CREATE TABLE `comptes_gestion_operations` (
  `id_operation` int(11) NOT NULL,
  `id_type` int(11) NOT NULL,
  `date` date NOT NULL,
  `montant` decimal(6,2) NOT NULL,
  `explication` text NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `comptes_gestion_operations`
--

INSERT INTO `comptes_gestion_operations` (`id_operation`, `id_type`, `date`, `montant`, `explication`) VALUES
(1, 9, '2017-01-01', 480.00, 'Janvier 2017'),
(2, 9, '2017-02-01', 480.00, 'Février 2017'),
(3, 9, '2017-03-01', 480.00, 'Mars 2017'),
(4, 9, '2017-04-01', 480.00, 'Avril 2017'),
(5, 9, '2017-05-01', 480.00, 'Mai 2017'),
(6, 9, '2017-06-01', 480.00, 'Juin 2017'),
(7, 9, '2017-07-01', 480.00, 'Juillet 2017'),
(8, 9, '2017-08-01', 480.00, 'Août 2017'),
(9, 9, '2017-09-01', 480.00, 'Septembre 2017'),
(10, 9, '2017-10-01', 480.00, 'Octobre 2017'),
(11, 9, '2017-11-01', 480.00, 'Novembre 2017'),
(12, 9, '2017-12-01', 480.00, 'Décembre 2017'),
(13, 9, '2018-01-01', 480.00, 'Janvier 2018'),
(14, 9, '2018-02-01', 480.00, 'Février 2018'),
(15, 9, '2018-03-01', 480.00, 'Mars 2018'),
(16, 9, '2018-04-01', 480.00, 'Avril 2018'),
(17, 9, '2018-05-01', 480.00, 'Mai 2018'),
(18, 9, '2018-06-01', 480.00, 'Juin 2018'),
(19, 9, '2018-07-01', 480.00, 'Juillet 2018'),
(20, 9, '2018-08-01', 480.00, 'Août 2018'),
(21, 9, '2018-09-01', 480.00, 'Septembre 2018'),
(22, 9, '2018-10-01', 480.00, 'Octobre 2018'),
(23, 9, '2018-11-01', 480.00, 'Novembre 2018'),
(24, 9, '2018-12-01', 480.00, 'Décembre 2018'),
(25, 9, '2019-01-01', 480.00, 'Janvier 2019'),
(26, 1, '2017-01-01', 1781.06, 'Janvier 2017'),
(27, 1, '2017-02-01', 1781.06, 'Février 2017'),
(28, 1, '2017-03-01', 1781.06, 'Mars 2017'),
(29, 1, '2017-04-01', 1777.45, 'Avril 2017'),
(30, 1, '2017-05-01', 1777.45, 'Mai 2017'),
(31, 1, '2017-06-01', 1777.45, 'Juin 2017'),
(32, 1, '2017-07-01', 1777.45, 'Juillet 2017'),
(33, 1, '2017-08-01', 1777.45, 'Août 2017'),
(34, 1, '2017-09-01', 1777.45, 'Septembre 2017'),
(35, 1, '2017-10-01', 1777.45, 'Octobre 2017'),
(36, 1, '2017-11-01', 1777.45, 'Novembre 2017'),
(37, 1, '2017-12-01', 1777.45, 'Décembre 2017'),
(38, 1, '2018-01-01', 1787.83, 'Janvier 2018'),
(39, 1, '2018-02-01', 1787.83, 'Février 2018'),
(40, 1, '2018-03-01', 1787.83, 'Mars 2018'),
(41, 1, '2018-04-01', 1787.83, 'Avril 2018'),
(42, 1, '2018-05-01', 1787.83, 'Mai 2018'),
(43, 1, '2018-06-01', 1787.83, 'Juin 2018'),
(44, 1, '2018-07-01', 1787.83, 'Juillet 2018'),
(45, 1, '2018-08-01', 1787.83, 'Août 2018'),
(46, 1, '2018-09-01', 1787.83, 'Septembre 2018'),
(47, 1, '2018-10-01', 1807.92, 'Octobre 2018'),
(48, 1, '2018-11-01', 2350.26, 'Novembre 2018'),
(49, 1, '2018-12-01', 2350.26, 'Décembre 2018'),
(50, 1, '2019-01-01', 2347.03, 'Janvier 2019'),
(51, 11, '2018-12-31', 4000.00, 'Dépenses annuelles de nourriture'),
(52, 11, '2017-12-31', 4000.00, 'Dépenses annuelles de nourriture'),
(53, 12, '2017-12-31', 1000.00, 'Dépenses annuelles habillement'),
(54, 12, '2018-12-31', 1000.00, 'Dépenses annuelles habillement'),
(55, 7, '2019-01-16', 1000.00, 'Prime Macron de 1000 €'),
(56, 11, '2019-02-19', 400.00, 'Dépenses sur 1 mois 1/2 de nourriture'),
(57, 12, '2019-02-19', 100.00, 'Dépenses sur 1 mois 1/2 habillement'),
(58, 8, '2017-12-31', 7648.00, 'Intérêts financiers 2017'),
(59, 13, '2017-12-31', 2005.00, '14931 € / 155118 € = 9,62%  (revenu de P. Tanguy imposable = 20 844 € x 9,62%)'),
(60, 10, '2017-12-31', 1360.00, 'Participation eau, Electricité, Citalis, Car Jaune'),
(61, 15, '2017-12-31', 1000.00, 'Dépenses inférieures à 500 € l\'unité'),
(62, 16, '2017-12-31', 1000.00, 'Dépenses inférieures à 500 € l\'unité'),
(63, 14, '2017-03-31', 135.33, 'Mutuelle Prudence créole 01/01/2017 au 31/03/2017'),
(64, 10, '2018-12-31', 1360.00, 'Participation eau, Electricité, Citalis, Car Jaune'),
(65, 10, '2020-02-19', 150.00, 'Participation eau, Electricité, Citalis, Car Jaune 1 mois 1/2'),
(66, 8, '2018-12-31', 8056.00, 'Intérêts financiers 2018'),
(67, 16, '2018-12-31', 1000.00, 'Dépenses inférieures à 500 € l\'unité'),
(68, 14, '2017-06-30', 135.33, 'Mutuelle Prudence créole 01/04/2017 au 30/06/2017'),
(69, 14, '2017-09-30', 135.33, 'Mutuelle Prudence créole 01/07/2017 au 30/09/2017'),
(70, 14, '2017-12-31', 135.33, 'Mutuelle Prudence créole 01/10/2017 au 31/12/2017');

-- --------------------------------------------------------

--
-- Table structure for table `comptes_gestion_types`
--

CREATE TABLE `comptes_gestion_types` (
  `id_type` int(11) NOT NULL,
  `nature` varchar(255) NOT NULL,
  `revenu_depense` enum('revenus','depenses') NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `comptes_gestion_types`
--

INSERT INTO `comptes_gestion_types` (`id_type`, `nature`, `revenu_depense`) VALUES
(1, 'Salaires, retraites', 'revenus'),
(2, 'Pensions', 'revenus'),
(3, 'Prestations, allocations', 'revenus'),
(4, 'Loyers', 'revenus'),
(5, 'Produits de vente immobilières', 'revenus'),
(6, 'Remboursements', 'revenus'),
(7, 'Revenus exceptionnels', 'revenus'),
(8, 'Autres', 'revenus'),
(9, 'Frais d\'hébergement', 'depenses'),
(10, 'Charges transports (EDF, eau...)', 'depenses'),
(11, 'Nourriture', 'depenses'),
(12, 'Habillement', 'depenses'),
(13, 'Impôts, taxes', 'depenses'),
(14, 'Santé', 'depenses'),
(15, 'Achats divers (réparation, équipements...)', 'depenses'),
(16, 'Loisirs, voyages, argent de poche', 'depenses'),
(17, 'Remboursement de dettes', 'depenses'),
(18, 'Placements (ex : virement sur compte épargne)', 'depenses'),
(19, 'Autres', 'depenses');

-- --------------------------------------------------------

--
-- Table structure for table `courrier`
--

CREATE TABLE `courrier` (
  `id_courrier` int(11) NOT NULL,
  `date` date NOT NULL,
  `destinataires` mediumtext NOT NULL,
  `corps` mediumtext NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `courrier`
--

INSERT INTO `courrier` (`id_courrier`, `date`, `destinataires`, `corps`) VALUES
(1, '2020-04-25', 'Assurances Le port', '<p>Objet : Contrat No H135270.001K</p>\r\n<p>Bonjour ....</p>'),
(2, '2020-06-01', 'Monsieur le Directeur', '<p>Monsieur le Directeur,</p>\r\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. In rutrum ante magna, sed maximus tortor aliquet eu. Vivamus mattis malesuada nulla in consequat. Proin consequat mi sed tristique pulvinar. Suspendisse vulputate id magna vitae interdum. Pellentesque egestas placerat lorem, ac ornare erat semper in. Nullam euismod nulla in neque gravida, non fringilla erat lacinia. Curabitur porta est risus, ut tristique urna rhoncus ac. Curabitur ac leo in turpis scelerisque volutpat.</p>\r\n<p>Maecenas mattis lectus non sollicitudin lacinia. Suspendisse consequat tincidunt nisl eu ullamcorper. Etiam vehicula mi eget dignissim dictum. Maecenas eu tellus tempor lectus volutpat ornare. Ut fermentum accumsan nulla, maximus tincidunt magna vestibulum quis. Maecenas id ipsum in leo ornare feugiat. Sed id dignissim sapien. Suspendisse quis ultricies lacus. Proin tortor leo, tempor at ultricies ac, facilisis et nisi. Nunc volutpat lorem tempor, mattis lectus sed, porttitor felis. Maecenas in sem at lorem laoreet venenatis sed et odio. Quisque nibh massa, commodo in ligula in, accumsan congue elit. Vestibulum molestie tincidunt est, eu fringilla nulla. Vivamus nulla nunc, fermentum eget libero eu, facilisis finibus ante. Phasellus sed nisi tortor. Proin imperdiet consequat ligula.</p>\r\n<p>Nam aliquam est quis turpis vestibulum euismod. Aenean gravida gravida iaculis. Ut commodo, lorem ut convallis pharetra, orci tellus euismod sem, et dapibus purus eros vulputate magna. Fusce at diam non nibh sodales vestibulum. Duis est leo, finibus at est et, ullamcorper porttitor leo. Aenean vel scelerisque magna, sit amet scelerisque nibh. Curabitur sit amet risus erat. Cras felis lacus, euismod ac pulvinar ut, posuere sit amet erat. Etiam auctor blandit odio aliquet placerat. Nam lacinia lacus vitae finibus vehicula. Sed tempus eros sed commodo ornare. Curabitur lectus diam, scelerisque eget nulla eu, laoreet bibendum tortor. Maecenas et orci a justo maximus elementum. Fusce leo orci, iaculis at dictum ac, aliquet eu purus. Nam et urna pretium, malesuada magna vel, aliquet quam. Donec varius, sapien sed dictum pulvinar, ante urna vestibulum elit, id sodales lorem tellus feugiat leo.</p>\r\n<p style=\"text-align: right;\">Isabelle Claite.</p>'),
(3, '2021-03-20', '', '');

-- --------------------------------------------------------

--
-- Table structure for table `creche_contrat`
--

CREATE TABLE `creche_contrat` (
  `id_contrat` int(11) NOT NULL,
  `titre` varchar(255) NOT NULL,
  `contenu` text NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `creche_contrat`
--

INSERT INTO `creche_contrat` (`id_contrat`, `titre`, `contenu`) VALUES
(1, 'Heures d’ouverture, de fermeture et congé annuel.', '<p>La cr&egrave;che est ouverte du lundi au vendredi de 7h&nbsp;&agrave;&nbsp;18h.</p>\r\n<p>Elle est ferm&eacute;e les week-ends, le lundi de P&acirc;ques et les jours f&eacute;ri&eacute;s l&eacute;gaux Mauriciens.</p>\r\n<p>Notre cong&eacute; annuel est fix&eacute; &agrave; partir du 03 jusqu&rsquo;au 15 janvier. Nous profitons de ce cong&eacute; pour la r&eacute;novation de l&rsquo;&eacute;tablissement.</p>'),
(2, 'Adaptation', '<p>La p&eacute;riode d&rsquo;adaptation est indispensable pour chaque nouvel enfant. Cette p&eacute;riode permet &agrave; l&rsquo;enfant de s&rsquo;habituer &agrave; un nouvel encadrement, aux nouveaux visages et ainsi que le rythme de la vie collective.</p>\r\n<p>Dans ce souci, nous proposons aux parents une p&eacute;riode d&rsquo;adaptation de cinq jours maximum qui se d&eacute;roule durant la derni&egrave;re semaine qui pr&eacute;c&egrave;de la date d&rsquo;entr&eacute;e de l&rsquo;enfant. Ceci se fait de mani&egrave;re suivante&nbsp;:</p>\r\n<p>Le 1<sup>er</sup>&nbsp;jour&nbsp;: une heure le matin avec un ou/et des parents. Il s&rsquo;agit surtout de la premi&egrave;re rencontre. Discussion approfondie avec notre personnel &agrave; propos de l&rsquo;enfant, compl&eacute;ter les derniers documents si n&eacute;cessaires, etc.</p>\r\n<p>Le 2<sup>&egrave;me</sup>&nbsp;jour&nbsp;: une heure l&rsquo;apr&egrave;s-midi avec un ou/et des parents.</p>\r\n<p>Le 3<sup>&egrave;me</sup>&nbsp;jour&nbsp;: les parents laissent l&rsquo;enfant seul une matin&eacute;e.</p>\r\n<p>Le 4<sup>&egrave;me</sup>&nbsp;jour&nbsp;: les parents laissent l&rsquo;enfant seul une apr&egrave;s-midi.</p>\r\n<p>Le 5<sup>&egrave;me</sup>&nbsp;jour&nbsp;: les parents laissent l&rsquo;enfant seul toute la journ&eacute;e.</p>\r\n<p>Cette p&eacute;riode d&rsquo;adaptation est enti&egrave;rement gratuite.</p>'),
(3, 'Frais de garderie et d’inscription.', '<p><strong>Frais de cr&egrave;che</strong></p>\r\n<p>Le montant des frais de garderie est un forfait mensuel et toujours payable par anticipation. Il doit donc imp&eacute;rativement &ecirc;tre effectu&eacute; par virement bancaire au compte de la cr&egrave;che avec le nom et pr&eacute;nom de l\'enfant en communication le premier jour ouvrable de chaque mois (nous encourageons cependant que les paiements soient effectu&eacute;s &agrave; partir du 28 de chaque mois et au plus tard le 2).</p>\r\n<p>Afin d&rsquo;&eacute;viter tout retard de paiement, nous vous invitons &agrave; introduire un ordre permanent aupr&egrave;s de votre banque.</p>\r\n<p>Le montant des frais sera augment&eacute; automatiquement <u>au mois de janvier de chaque ann&eacute;e de 5%.</u></p>\r\n<p>La contribution financi&egrave;re couvre la totalit&eacute; des frais de s&eacute;jour,&nbsp;<u>&agrave; l\'exclusion du lait en poudre, des couches, des m&eacute;dicaments, des aliments de r&eacute;gime et des v&ecirc;tements de rechange</u>.</p>\r\n<p><strong>L\'absence de l\'enfant, quelque que soit la cause (maladie, voyage, etc, est sans incidence sur la garderie et ne pourra donner lieu &agrave; aucun report ni cr&eacute;dit.</strong></p>\r\n<p><strong>Frais d&rsquo;inscription, garantie</strong></p>\r\n<p>Afin de garantir la bonne ex&eacute;cution du contrat conclu entre les parents et la cr&egrave;che ainsi que du pr&eacute;sent r&egrave;glement d\'ordre int&eacute;rieur, le frais d&rsquo;inscription sera r&eacute;clam&eacute; aux parents ainsi que la somme de 1 mois de frais de garderie est demand&eacute;e et &agrave; verser au compte de la cr&egrave;che avec le nom et pr&eacute;nom de l\'enfant en communication, &agrave; titre de &laquo;&nbsp;garantie&nbsp;&raquo; lors de l\'inscription de l\'enfant. <strong>Le montant des inscriptions</strong> <strong>n\'est en aucun cas remboursable</strong>.</p>\r\n<p>En cas de probl&egrave;mes m&eacute;dicaux annulant l&rsquo;entr&eacute;e de l&rsquo;enfant en cr&egrave;che, ce montant sera rembours&eacute; &agrave; la date pr&eacute;vue de l&rsquo;entr&eacute;e de l&rsquo;enfant sous pr&eacute;sentation d&rsquo;un certificat m&eacute;dical du m&eacute;decin.</p>\r\n<p><strong><u>13<sup>&egrave;me</sup> Mois </u></strong></p>\r\n<p>Le 13<sup>&egrave;me</sup> mois repr&eacute;sentant le montant d&rsquo;une mensualit&eacute; est payable chaque ann&eacute;e avant le <strong>20 d&eacute;cembre.</strong> Nous vous demandons de respecter ce d&eacute;lai de paiement afin de ne pas perturber le bon fonctionnement de la cr&egrave;che.</p>'),
(4, 'Arrivée et départ, modalités de préavis et résiliation', '<p>L&rsquo;enfant arrivera &agrave; partir de 7h00 le matin&nbsp;et entre&nbsp;12h30&nbsp;et&nbsp;14h00 l&rsquo;apr&egrave;s-midi&nbsp;quand il s&rsquo;agit des mi-temps apr&egrave;s-midi.</p>\r\n<p>L&rsquo;enfant partira au plus tard &agrave; 13h00 si c&rsquo;est une &frac12; journ&eacute;e et &agrave; 18h le soir.</p>\r\n<p>Par respect pour notre personnel, nous vous remercions de&nbsp;<u>respecter strictement ces horaires</u>.</p>\r\n<p>Le non-respect&nbsp;r&eacute;p&eacute;titif&nbsp;de ces heures met fin automatiquement &agrave; l&rsquo;inscription de l&rsquo;enfant &agrave; la cr&egrave;che sans aucun pr&eacute;avis et ni indemnit&eacute;.</p>\r\n<p>Les parents peuvent mettre fin &agrave; la garde de l\'enfant moyennant le respect d\'un pr&eacute;avis de 2 mois prenant cours le mois qui suit. Le pr&eacute;avis par lettre recommand&eacute;e doit parvenir &agrave; la direction avant le 1<sup>er</sup>&nbsp;jour ouvrable du mois de pr&eacute;avis.</p>\r\n<p>Cr&egrave;che Attitude conserve le droit de r&eacute;silier ce pr&eacute;sent contrat sans pr&eacute;avis, ni indemnit&eacute; dans des cas suivants&nbsp;:</p>\r\n<ul>\r\n<li>En cas de retard de paiement. La r&eacute;siliation aura effet &agrave; la fin du mois en cours par simple lettre de la direction.</li>\r\n<li>En cas de retard pour plus de trois fois sur le mois dans la reprise de l&rsquo;enfant. La r&eacute;siliation aura &eacute;galement &agrave; la fin du mois en cours par simple lettre de la direction.</li>\r\n</ul>'),
(5, 'Garderie en cas de maladie.', '<p>Lorsqu\'un enfant est malade ou ne vient pas, les parents sont pri&eacute;s de nous avertir.</p>\r\n<p>En cas de maladie contagieuse ou de fi&egrave;vre sup&eacute;rieure &agrave; 38,5&deg;c, votre enfant ne sera plus accept&eacute; dans la cr&egrave;che par souci du respect de la sant&eacute; des autres enfants. Dans ce cas, les parents seront pr&eacute;venus imm&eacute;diatement et l&rsquo;enfant sera r&eacute;cup&eacute;r&eacute; par les parents au plus vite.</p>\r\n<p>Un enfant malade peut &ecirc;tre accept&eacute; &agrave; condition qu&rsquo;un certificat m&eacute;dical du m&eacute;decin, atteste qu&rsquo;il n&rsquo;est pas source de danger pour les autres enfants gard&eacute;s.</p>\r\n<p>Toute prise de m&eacute;dicaments (sans exception) se fera exclusivement par les parents.</p>\r\n<p>En cas d&rsquo;urgence, votre enfant sera transport&eacute; soit par nos responsables ou soit par l&rsquo;ambulance (&agrave; la charge des parents) &agrave; la clinique / h&ocirc;pital le plus proche.</p>'),
(6, 'Sécurité', '<p>Pour des raisons &eacute;videntes de s&eacute;curit&eacute;, l&rsquo;ouverture des portes de nos locaux ne peut se faire que par notre personnel.</p>\r\n<p>Nous prions les parents de bien vouloir patienter devant la porte. Les pu&eacute;ricultrices vous ouvriront la porte d&egrave;s qu&rsquo;elles terminent le travail en cours.</p>\r\n<p>Votre enfant sera remis &agrave; la pr&eacute;sence d&rsquo;un des deux parents.</p>\r\n<p>Cr&egrave;che Attitude ne sera en aucun cas tenue pour responsable des &eacute;ventuels conflits concernant la garde de l&rsquo;enfant des cas de divorce, de s&eacute;paration ou autres probl&egrave;mes.</p>\r\n<p>Si une tierce personne que les parents doit venir chercher l&rsquo;enfant. Les parents doivent nous avertir au plus tard le matin du jour m&ecirc;me et nous fournir une photocopie de la pi&egrave;ce d&rsquo;identit&eacute; de cette personne. S&rsquo;il s&rsquo;agit toujours de la m&ecirc;me personne, les parents peuvent nous fournir une autorisation g&eacute;n&eacute;rale accompagn&eacute;e d&rsquo;une photocopie d&rsquo;une pi&egrave;ce d&rsquo;identit&eacute; de cette personne. Au moment venu, les parents doivent simplement signaler lors qu&rsquo;ils viennent d&eacute;poser l&rsquo;enfant le matin.</p>'),
(7, 'Obligation et responsabilité civile de la crèche.', '<p>En cas d&rsquo;accident &agrave; la cr&egrave;che, celle-ci est couverte par une assurance accident couvrant les heures pass&eacute;es &agrave; la cr&egrave;che.</p>\r\n<p>La direction s&rsquo;engage &agrave; mettre les parents au courant du d&eacute;veloppement de l&rsquo;enfant.</p>\r\n<p>Les parents ont acc&egrave;s &agrave; toutes les pi&egrave;ces du local et peuvent les visiter &agrave; tout moment durant la pr&eacute;sence de leur enfant &agrave; la cr&egrave;che. Mais ceci ne peut se faire dans le respect de la tranquillit&eacute; des autres enfants. Les parents s&rsquo;engagent &eacute;galement &agrave; respecter l&rsquo;hygi&egrave;ne de la cr&egrave;che.</p>'),
(8, 'Réclamations', '<p>Toute plainte ou r&eacute;clamation doit &ecirc;tre introduite aupr&egrave;s de la direction de la Cr&egrave;che Attitude, Mademoiselle Isabelle CLAITE.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</p>'),
(9, 'Inscription', '<p>La premi&egrave;re visite se fait uniquement sur rendez-vous.</p>\r\n<p>Apr&egrave;s avoir visit&eacute; la cr&egrave;che et ayant pris connaissance concernant le fonctionnement de la cr&egrave;che, tout parent qui d&eacute;sire inscrire son enfant dans notre cr&egrave;che doit remplir et signer la fiche d&rsquo;inscription et le pr&eacute;sent contrat. Lors de l&rsquo;inscription, les parents doivent nous remettre un rapport m&eacute;dical par le p&eacute;diatre traitant certifiant l&rsquo;&eacute;tat de sant&eacute; de l&rsquo;enfant. Afin de finaliser l&rsquo;inscription, les parents doivent &eacute;galement verser la garantie mentionn&eacute;e dans l&rsquo;article 3 cit&eacute; plus haut ainsi que le premier mois.</p>\r\n<p>D&egrave;s r&eacute;ception du contrat sign&eacute; et le versement, nous enverrons la confirmation de l&rsquo;inscription de l&rsquo;enfant par mail ou courrier aux parents.</p>\r\n<p>La signature d&rsquo;un des deux parents rend ce contrat valable.</p>\r\n<p>La date d&rsquo;entr&eacute;e de l&rsquo;enfant ne peut &ecirc;tre report&eacute;e qu&rsquo;une seule fois.</p>');

-- --------------------------------------------------------

--
-- Table structure for table `creche_documents`
--

CREATE TABLE `creche_documents` (
  `id_creche_document` int(11) NOT NULL,
  `nom` varchar(100) NOT NULL,
  `file` varchar(100) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `creche_documents`
--

INSERT INTO `creche_documents` (`id_creche_document`, `nom`, `file`) VALUES
(1, 'SCHOOL CALENDAR 2020', 'SCHOOL CALENDAR 2020.docx');

-- --------------------------------------------------------

--
-- Table structure for table `creche_enfants`
--

CREATE TABLE `creche_enfants` (
  `id_enfant` int(11) NOT NULL,
  `nom` varchar(50) NOT NULL,
  `prenom` varchar(50) DEFAULT NULL,
  `prenom_usuel` varchar(50) DEFAULT NULL,
  `nationalite` varchar(50) DEFAULT NULL,
  `sexe` enum('M','F') DEFAULT NULL,
  `dob` date DEFAULT NULL,
  `age` varchar(5) DEFAULT NULL,
  `religion` varchar(50) DEFAULT NULL,
  `autorisation_publication_photos` tinyint(1) NOT NULL,
  `date_in` date DEFAULT NULL,
  `date_out` date DEFAULT NULL,
  `vaccination` enum('OUI','NON') DEFAULT NULL,
  `allergie` enum('OUI','NON') DEFAULT NULL,
  `nom_du_pediatre` varchar(50) DEFAULT NULL,
  `id_parent` int(11) DEFAULT NULL,
  `remarques` varchar(255) DEFAULT NULL,
  `frais_inscription` int(11) DEFAULT NULL,
  `mensualites` int(11) DEFAULT NULL,
  `jours` varchar(50) DEFAULT NULL,
  `horaires` varchar(50) DEFAULT NULL,
  `type` enum('Creche','After School') DEFAULT NULL,
  `documents` varchar(255) DEFAULT NULL,
  `remarques_de_la_direction` varchar(255) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `creche_enfants`
--

INSERT INTO `creche_enfants` (`id_enfant`, `nom`, `prenom`, `prenom_usuel`, `nationalite`, `sexe`, `dob`, `age`, `religion`, `autorisation_publication_photos`, `date_in`, `date_out`, `vaccination`, `allergie`, `nom_du_pediatre`, `id_parent`, `remarques`, `frais_inscription`, `mensualites`, `jours`, `horaires`, `type`, `documents`, `remarques_de_la_direction`) VALUES
(1, 'AMI', 'Grisha Grigory', 'Grisha', 'Mauricienne . Russe', 'M', '2017-04-25', '2 ANS', 'Orthodox', 0, '2019-05-02', '2019-12-31', 'OUI', 'OUI', 'Dr Jutton', 1, 'Is not allow to eat any sweets, chocolates, any sugar containing foods, biscuits, juices in packs etc..', 5000, 5200, '31', '07 à 18 hrs', 'Creche', 'OK', 'Promo pas de bonus payable la 1ere annee'),
(2, 'BOODIAH', 'Héloise Lily-Rose', 'Héloise', 'Mauricienne', 'F', '2017-10-06', '18 M', 'Catholique', 0, '2019-05-02', '2020-09-30', 'OUI', 'NON', 'Dr Jutton', 2, 'RAS', 5000, 5200, '31', '8 à 18 hrs', 'Creche', 'certificat médicale manquant', NULL),
(3, 'PIANY', 'Marie Emmanuel Justin Lee', 'Justin', 'Mauricienne', 'M', '2018-11-08', '6 M', 'Catholique', 0, '2019-05-02', NULL, 'OUI', 'NON', 'Dr Jutton', 12, 'SOUFFRE D\'ECXEMA', 6500, 5000, '31', '8 à 18 hrs', 'Creche', 'OK', NULL),
(4, 'PERMAL', 'Neil', 'Neil', 'Mauricienne', 'M', '2017-05-08', '2 ANS', 'hindou', 0, '2019-06-06', '2019-12-31', 'OUI', 'NON', 'Dr Poorun', 10, 'RAS', 5000, 2700, '21', '8 à 18 hrs', 'Creche', 'OK', 'Promo pas de bonus payable la 1ere annee'),
(5, 'JEANNE', 'Miguel', 'Miguel', 'Franco / Mauricien', 'M', '2017-04-12', '3 moi', 'Catholique', 0, '2019-07-30', NULL, 'OUI', 'NON', NULL, 5, NULL, 0, 0, '0', NULL, 'Creche', NULL, NULL),
(6, 'LAMBOURG', 'Mathias', 'Mathias', 'Franco / Mauricien', 'M', '2017-11-27', '2 ANS', 'Chrétien', 0, '2019-11-12', '2020-12-31', 'OUI', 'NON', 'Dr Toofany Oomesh', 7, 'RAS', 6000, 5500, '31', '7hr à 18 hrs', 'Creche', 'OK', NULL),
(7, 'PHOKEER', 'Keziah Shankar Charlie', 'Charlie', 'Franco / Mauricien', 'M', '2019-04-15', '9 M', 'Catholique / hindou', 0, '2019-11-13', NULL, 'OUI', 'NON', 'Dr Joomaye', 11, 'RAS', 6000, 0, '12', '08 à 15hrs 30', 'Creche', 'OK', NULL),
(8, 'PARFAIT', 'Zoé', 'Zoé', 'Mauricienne', 'F', '2019-09-26', '4 M', 'Catholique', 0, '2020-02-03', NULL, 'OUI', 'NON', 'Dr Ramdhun', 9, 'RAS', 6500, 5775, '31', '08 à 17H30', 'Creche', 'OK', 'n/a'),
(9, 'REDOUBLE', 'Yann', 'Yann', 'Franco / Mauricien', 'M', '2017-05-31', '2 ANS', 'Catholique', 0, '2019-11-15', '2020-07-31', 'OUI', 'NON', 'Dr Nekitsing', 13, 'HYPERACTIF ET TURBULENT , CRIE BEACOUP ET FRAPPE LES AUTRES', 6000, 5500, '31', '8 à 18 hrs', 'Creche', 'OK', 'n/a'),
(10, 'd\'AVOINE', 'Eva Marie Hope', 'Eva', 'Mauricienne', 'F', '2018-01-18', NULL, 'Catholique', 0, '2020-02-03', NULL, 'OUI', 'NON', 'DR Y Neetoo', 3, 'RAS', 6500, 5775, '127', '8 à 17 hrs', 'Creche', 'OK', 'n/a'),
(11, 'GOBIN', 'Micah', 'Micah', 'Mauricienne', 'F', '2018-06-24', '20 M', NULL, 0, '2020-03-02', '2020-12-31', 'OUI', 'NON', NULL, 4, NULL, 0, 0, '31', '9 à 17 hrs', 'Creche', NULL, 'Contrat pas remis encore'),
(12, 'KERNEUR', 'Amy', 'Amy', 'Francaise', 'F', '2020-01-05', '3 moi', NULL, 0, '2020-06-18', '2022-06-30', 'OUI', 'NON', NULL, 6, NULL, 6500, 3885, '126', '10 à 17 hrs', 'Creche', '3 jours / semaine', 'n/a'),
(13, 'SIBILANT', 'Mathias', 'Mathias', 'Mauricienne', 'M', '2019-02-09', '16 mo', NULL, 0, '2020-07-06', NULL, 'OUI', 'NON', NULL, NULL, NULL, 6500, NULL, '0', '11 à 17 hrs', 'Creche', '2 jours / semaine', 'n/a'),
(14, 'MARIE', 'Chloe', 'Chloe', 'Mauricienne', 'F', '2019-02-12', '12 M', 'Catholique', 0, '2020-03-02', '2020-03-31', 'OUI', 'NON', NULL, 8, 'RAS', 6500, 5775, '31', '12 à 17 hrs', 'Creche', 'Contrat pas retourner', 'Départ de la crèche, suite COVID-19'),
(15, 'MALININE', 'Noémie', 'Noémie', 'Franco / Mauricien', 'F', NULL, NULL, 'n/a', 0, NULL, NULL, NULL, 'NON', NULL, 14, NULL, NULL, NULL, '0', NULL, 'After School', NULL, NULL),
(16, 'MALININE', 'Théa', 'Théa', 'Franco / Mauricien', 'F', NULL, NULL, 'n/a', 0, NULL, NULL, NULL, 'NON', NULL, 14, NULL, NULL, NULL, '0', NULL, 'After School', NULL, NULL),
(17, 'DE SAINT PHILIPPE DESPLACE', 'Camélia', 'Camélia', 'Mauricienne', 'F', NULL, NULL, 'Catholique', 0, NULL, NULL, NULL, 'NON', NULL, 15, NULL, NULL, NULL, '0', NULL, 'After School', NULL, NULL),
(18, 'GRENADE', 'Zoey', 'Zoey', 'Mauricienne', 'F', NULL, NULL, 'Catholique', 0, NULL, NULL, NULL, 'NON', NULL, 16, NULL, NULL, NULL, '0', NULL, 'After School', NULL, NULL),
(19, 'GRENADE', 'Marie Angélique Emma', 'Emma', 'Mauricienne', 'F', NULL, NULL, 'Catholique', 0, NULL, NULL, NULL, 'NON', NULL, 16, NULL, NULL, NULL, '0', NULL, 'After School', NULL, NULL),
(20, 'ROCHECOUSTE', 'Vanille', 'Vanille', 'Mauricienne', 'F', NULL, NULL, 'Catholique', 0, NULL, NULL, NULL, 'NON', NULL, 17, NULL, NULL, NULL, '0', NULL, 'After School', NULL, NULL),
(21, 'MACKAY', 'Tristan', 'Tristan', 'Mauricienne', 'M', NULL, NULL, 'Catholique', 0, NULL, NULL, NULL, 'NON', NULL, 18, NULL, NULL, NULL, '0', NULL, 'After School', NULL, NULL),
(22, 'PARFAIT', 'Lucas', 'Lucas', 'Mauricienne', 'M', NULL, NULL, 'Catholique', 0, NULL, '2020-02-03', NULL, 'NON', NULL, 9, NULL, NULL, NULL, '0', NULL, 'After School', NULL, NULL),
(23, 'MANGROO', 'Axelle Néhémie Elishama', 'Axelle', 'Mauricienne', 'F', NULL, NULL, 'Chrétienne', 0, NULL, NULL, NULL, 'NON', NULL, 19, NULL, NULL, NULL, '0', NULL, 'After School', NULL, NULL),
(24, 'd\'AVOINE', 'Mégan', 'Mégan', 'Mauricienne', 'F', NULL, NULL, 'n/a', 0, NULL, NULL, NULL, 'NON', NULL, 3, NULL, NULL, NULL, '0', NULL, 'After School', NULL, NULL),
(25, 'CATHERINE', 'Inès', 'Inès', 'Mauricienne', 'F', NULL, NULL, 'Catholique', 0, NULL, NULL, NULL, 'NON', NULL, 20, NULL, NULL, NULL, '0', NULL, 'After School', NULL, NULL),
(26, 'CATHERINE', 'Alyssa', 'Alyssa', 'Mauricienne', 'F', NULL, NULL, 'Catholique', 0, NULL, NULL, NULL, 'NON', NULL, 20, NULL, NULL, NULL, '0', NULL, 'After School', NULL, NULL),
(27, 'CAVALOT', 'Amaury', 'Amaury', 'Mauricienne', 'M', NULL, NULL, 'n/a', 0, NULL, NULL, NULL, 'NON', NULL, 21, NULL, NULL, NULL, '0', NULL, 'After School', NULL, NULL),
(28, 'QUIRIN', 'Emilia', 'Emilia', 'Mauricienne', 'F', '2014-08-16', '5', 'Catholique', 1, NULL, NULL, 'OUI', 'NON', 'Dr Abdool', 22, NULL, NULL, NULL, '0', NULL, 'After School', 'COMPLET', NULL),
(29, 'Leung-Tack', 'Hugo', 'Hugo', 'Mauricienne', 'M', NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 2200, '31', '15 pm', 'After School', 'COMPLET', 'Présence une semaine sur deux'),
(30, 'Beerjeraz', 'Théa Maria', 'Théa', 'Mauricienne', 'F', '2018-09-07', '23 mo', 'Catholique', 0, '2020-08-03', NULL, 'OUI', 'NON', NULL, NULL, 'RAS', 6500, 5775, NULL, '09 AM ', 'Creche', 'COMPLET', NULL),
(32, 'Mooneegan', 'Ezra Jared', 'Ezra', 'Mauricienne', 'M', '2019-12-24', '9 moi', 'Chrétienne', 0, '2020-10-01', NULL, 'OUI', 'NON', 'Dr Maura Neetoo', NULL, 'RAS', 6500, 5775, '0', '09 AM ', 'Creche', 'COMPLET', NULL),
(34, 'BLESSMAILLE', 'Timéo Imael Lyam', 'Timéo', 'Mauricienne', 'M', '2020-07-27', '3 moi', 'Catholique', 0, '2020-11-03', NULL, 'OUI', 'NON', 'Dr Yasseen Neetoo', NULL, NULL, 6500, 5775, '0', NULL, 'Creche', 'COMPLET', NULL),
(36, 'Lambourg', 'Arthur', 'Arthur', 'Franco-mauricien', 'M', '2020-01-28', '8 moi', 'Chrétienne', 0, '2020-10-19', NULL, 'OUI', 'NON', 'Dr Toofanny', 7, '50 % remise sur frais d\'inscription Rs 3250, publication de photos pas autorisés', 3250, 350, '4', '07 am', 'Creche', 'COMPLET', 'petit frère de Mathias Lambourg'),
(37, 'Pougnet', 'Nathan', 'Nathan', 'Mauricienne', 'M', '2020-06-19', '3 moi', 'Catholique', 1, '2020-10-01', NULL, 'OUI', 'NON', 'Dr Steciuk', 5, 'RAS', 6500, 5775, '0', '09 AM ', 'Creche', 'COMPLET', NULL),
(38, 'Ah Ting', 'Léo-Paul Shaun Chan-Yu', 'Léo', 'Mauricienne', 'M', '2019-08-15', '17 mo', 'Catholique', 0, '2021-02-02', NULL, 'OUI', 'NON', 'Dr Fouad Abdool', 30, NULL, 6500, 6064, '62', NULL, 'Creche', 'COMPLET', NULL),
(40, 'Lebon', 'Héloise', 'Héloise', 'Franco-mauricien', 'F', '2018-09-17', '28 MO', 'Catholique', 0, '2021-02-02', NULL, 'OUI', 'NON', 'Dr Steciuk', NULL, 'Sujette aux molluscum, petit boutons blancs ou rouges', 4000, 6064, '31', '09 AM ', 'Creche', NULL, 'Enregistré jusqu\'à sept 2021'),
(41, 'VARSALLY', 'Rayan Nadeem', 'Rayan', 'Mauricienne', 'M', '2020-08-21', NULL, NULL, 0, '2021-03-01', '2023-08-31', 'OUI', 'NON', 'Dr Véronique Lam', 25, NULL, 6500, 6064, '126', NULL, 'Creche', NULL, NULL),
(42, 'Sauleck', 'Raphael Yaron', 'Raphael', 'Mauricienne', 'M', '2020-11-30', '3 moi', 'Catholique', 0, '2021-03-08', NULL, 'OUI', 'NON', 'Dr Yasseen Neetoo', 26, NULL, 6500, 6064, '0', NULL, 'Creche', 'COMPLET', NULL),
(43, 'Dacruz', 'Anne-Laure Raquel', 'Anne-Laure', 'Mauricienne', 'F', '2020-10-21', NULL, 'Catholique', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '126', NULL, 'Creche', NULL, NULL),
(44, 'Piany', 'Marie Emmanuelle Madison', 'Madison', 'Mauricienne', 'F', '2021-02-15', '4 moi', 'Catholique', 1, '2021-07-01', NULL, 'OUI', 'NON', 'Dr Juttun', NULL, 'Régurgitations fréquentes', 3250, 4000, '0', 'complet', NULL, 'COMPLET', 'Tarif spécial 2ème enfant'),
(45, 'Ernestine', 'Mia Hope Laurelai', 'Mia', 'Mauricienne', 'F', '2021-04-14', '3 moi', 'Catholique', 1, '2021-07-19', NULL, 'OUI', 'NON', 'Dr Gafoor Bholah', NULL, NULL, 6500, 6064, '0', NULL, NULL, NULL, NULL),
(46, 'Dwarika', 'Marie Nolwenn Damilola', 'Nolwenn', 'Mauricienne', 'F', '2019-04-07', '2 ans', 'Catholique', 1, '2021-07-01', NULL, 'OUI', 'NON', NULL, NULL, 'Tarif spécial employée', 0, 2000, NULL, NULL, NULL, NULL, 'Tarif spécial employée'),
(47, 'D\'Avoine', 'Naomie Zoe', 'Zoe', 'Mauricienne', 'F', '2021-07-18', '3 moi', 'Catholique', 0, '2021-10-18', NULL, NULL, 'NON', 'Dr Yasseen Neetoo', NULL, NULL, 6500, 6064, '0', 'complet', 'Creche', NULL, NULL),
(48, 'Fanny', 'Marie Gabrielle Ramsay', 'Gabrielle', 'Mauricienne', 'F', '2021-07-29', '3 moi', 'Catholique', 0, NULL, NULL, 'OUI', 'NON', 'Dr Yaseen Neetoo', NULL, NULL, 6500, 6064, '0', 'complet', 'Creche', NULL, NULL),
(49, 'Gouges', 'Macey Grace Laïa', 'Laïa', 'Mauricienne', 'F', '2020-09-22', '11 mo', 'Catholique', 0, NULL, NULL, NULL, NULL, NULL, 32, NULL, NULL, NULL, '126', NULL, 'Creche', NULL, NULL),
(50, 'Farineau', 'Anaelle', 'Anaelle', 'Française', 'F', '2021-03-02', '6 moi', NULL, 1, '2021-09-27', NULL, 'OUI', 'NON', 'Dr Maura Neetoo', 33, NULL, 6500, 6065, '0', 'Demi-journées', 'Creche', NULL, 'DME'),
(51, 'CADOUX', 'Andréas', 'Andréas', 'Mauricienne', NULL, '2020-12-25', '9 moi', 'Catholique', 0, '2021-09-27', NULL, 'OUI', 'NON', 'Dr Joomye', 35, NULL, NULL, 6064, '126', 'complet', 'Creche', NULL, 'ex little mermaid'),
(52, 'Beguinot', 'Alyssa Elizabeth', 'Alyssa', 'Mauricienne', 'F', '2020-08-22', '1 AN', 'Catholique', 0, '2021-10-01', NULL, 'OUI', 'NON', 'Dr Véronique Lam', 34, NULL, 6500, 6064, '126', NULL, 'Creche', NULL, NULL),
(53, 'Chan Chin', 'Liam Aiden', 'Aiden', 'Mauricienne', 'M', '2020-04-02', '18 mo', 'Catholique', 0, '2021-10-06', NULL, 'OUI', 'NON', 'Dr François Leung', 36, NULL, 6500, 3860, '0', 'Demi-journées', 'Creche', 'MISSING CONTRAT ET MED CERTIFICATE', NULL),
(54, 'Manikam', 'Marie Kaitleen', 'Kaitleen', 'Mauricienne', 'F', '2021-11-11', '3 moi', 'Catholique', 0, '2022-02-21', NULL, 'OUI', 'OUI', 'Dr F H Foondun', 37, 'RAS', NULL, 6368, '126', 'complet', 'Creche', 'COMPLET', NULL),
(55, 'Levasseur', 'Keila Elisabeth', 'Keila', 'Mauricienne', 'F', '2021-10-20', '3 moi', 'Catholique', 1, NULL, NULL, NULL, NULL, NULL, 38, 'PAS DE PUBLICATION PHOTOS SUR FACEBOOK', NULL, NULL, '126', NULL, 'Creche', NULL, NULL),
(56, 'Arimond', 'Sophie Faith', 'Sophie', 'Mauricienne', 'F', '2021-02-24', '11 mo', 'Chrétienne', 0, '2022-01-24', '2023-08-16', 'OUI', NULL, 'Dr Ryad Joomye', 39, 'born at 30 weeks, med cert reveived', 6500, 6368, '126', 'complet', 'Creche', 'OK', 'PREMATUREE'),
(57, 'Lavictoire', 'Célia Marie Dominique', 'Célia', 'Mauricienne', 'F', '2022-03-22', '5 moi', 'Catholique', 0, '2022-08-29', NULL, 'OUI', 'NON', 'Dr Yasseen Neetoo', NULL, NULL, 6500, 6368, '0', 'complet', 'Creche', NULL, NULL),
(58, 'Domingue', 'Raphael Louis', 'Raphael', 'Mauricienne', 'M', '2021-06-17', '12 mo', 'Catholique', 1, '2022-05-23', NULL, 'OUI', 'NON', 'Dr Maura Neetoo', 41, 'RAS', 6500, 6368, '126', NULL, 'Creche', NULL, NULL),
(59, 'Kerville', 'Nico Mateo', 'Mateo', 'Mauricienne', 'M', '2020-12-02', '18 mo', 'Catholique', 0, '2022-07-25', NULL, 'OUI', 'NON', 'Dr Soobadar', 42, NULL, 6500, 6368, '0', NULL, 'Creche', NULL, 'Adaptation sur 3 jours'),
(60, 'Mungroo', 'kiara', 'Kiara', 'Mauricienne', 'F', '2021-01-25', '15 MO', NULL, 1, '2022-05-01', NULL, 'OUI', 'NON', 'Dr Jhugroo / Dr Jutton', NULL, NULL, 6500, 6368, NULL, 'complet', 'Creche', 'COMPLET', 'A commencer 4 jours par semaine pendant 2 mois a Rs4284'),
(61, 'Fidelle', 'Gabrielle Hilona', 'Hilona', 'Mauricienne', 'F', '2022-01-23', '6 moi', 'Catholique', 1, '2022-08-16', NULL, 'OUI', 'OUI', 'Dr Ryad Joomye', 44, 'Allergie aux protéines de lait de vache', 6500, NULL, '0', 'complet', 'Creche', 'COMPLET', 'ALLERGIE AUX PROTEINES DE LAIT DE VACHE'),
(62, 'Thomas', 'Samuel', 'Samuel', 'Mauricienne de parents français', 'M', '2020-10-02', '2 ANS', 'AUCUNE', 0, '2023-01-23', NULL, 'OUI', 'NON', 'Dr Damien Steciuk', 45, NULL, 6500, 6600, '0', NULL, 'Creche', 'COMPLET', 'PAYE RS 6600 AU LIEU DE RS 6686'),
(63, 'Jeannot', 'Inès', 'Inès', 'Mauricienne', 'F', '2022-07-20', '7 moi', 'Catholique', 0, '2023-02-06', NULL, 'OUI', 'NON', 'Dr Poorun', 46, NULL, NULL, 6686, '0', 'complet', 'Creche', NULL, NULL),
(64, 'Moonesamy', 'Elsa', 'Elsa', 'Mauricienne', 'F', '2020-10-16', '2 ANS', 'Chrétienne', 0, '2023-02-02', NULL, 'OUI', 'NON', 'Dr Juggroo', 47, NULL, 7000, 6685, '0', NULL, 'Creche', NULL, NULL),
(65, 'PAUL', 'Manoe Tao', 'Manoe', 'Mauricienne', 'M', '2022-12-09', '3 moi', 'Catholique', 0, '2023-03-06', NULL, 'OUI', 'NON', 'Dr Maura Neetoo', NULL, NULL, NULL, NULL, '0', 'complet', 'Creche', NULL, NULL),
(66, 'Chervonnyi', 'Maksim Arturouich', 'Maksim', 'Mauricienne', 'M', '2022-12-26', '4 MOI', NULL, 1, '2023-05-08', NULL, 'OUI', 'NON', 'Dr Ryad Joomye', 49, 'RAS', 7000, 6685, '0', 'complet', 'Creche', NULL, NULL),
(67, 'Luppens', 'Ulysse', 'Ulysse', 'Mauricienne', 'M', '2022-12-28', '8 MOI', 'Catholique', 0, '2023-08-28', NULL, 'OUI', 'NON', 'Dr Jagatsingh', 50, 'RAS', 0, 6685, '126', 'complet', 'Creche', 'COMPLET', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `creche_etude`
--

CREATE TABLE `creche_etude` (
  `id_participant` int(11) NOT NULL,
  `nom` varchar(255) NOT NULL,
  `prenom` varchar(255) NOT NULL,
  `date_naissance` date NOT NULL,
  `email` varchar(255) NOT NULL,
  `date_reponse` date NOT NULL,
  `1` varchar(255) NOT NULL,
  `2` varchar(255) NOT NULL,
  `3` varchar(255) NOT NULL,
  `4` varchar(255) NOT NULL,
  `5` varchar(255) NOT NULL,
  `6` varchar(255) NOT NULL,
  `7` varchar(255) NOT NULL,
  `8` varchar(255) NOT NULL,
  `9` varchar(255) NOT NULL,
  `10` varchar(255) NOT NULL,
  `11` varchar(255) NOT NULL,
  `12` varchar(255) NOT NULL,
  `13` varchar(255) NOT NULL,
  `14` varchar(255) NOT NULL,
  `15` varchar(255) NOT NULL,
  `16` varchar(255) NOT NULL,
  `17` varchar(255) NOT NULL,
  `18` varchar(255) NOT NULL,
  `19` varchar(255) NOT NULL,
  `20` varchar(255) NOT NULL,
  `21` varchar(255) NOT NULL,
  `22` varchar(255) NOT NULL,
  `23` varchar(255) NOT NULL,
  `24` varchar(255) NOT NULL,
  `25` varchar(255) NOT NULL,
  `26` varchar(255) NOT NULL,
  `27` varchar(255) NOT NULL,
  `28` varchar(255) NOT NULL,
  `29` varchar(255) NOT NULL,
  `30` varchar(255) NOT NULL,
  `31` varchar(255) NOT NULL,
  `32` varchar(255) NOT NULL,
  `tout_champs_rempli` tinyint(1) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `creche_etude`
--

INSERT INTO `creche_etude` (`id_participant`, `nom`, `prenom`, `date_naissance`, `email`, `date_reponse`, `1`, `2`, `3`, `4`, `5`, `6`, `7`, `8`, `9`, `10`, `11`, `12`, `13`, `14`, `15`, `16`, `17`, `18`, `19`, `20`, `21`, `22`, `23`, `24`, `25`, `26`, `27`, `28`, `29`, `30`, `31`, `32`, `tout_champs_rempli`) VALUES
(1, 'Jola', 'Denis Gerard', '1980-02-06', 'denisgerard@gmail.com', '2017-03-19', '0', '1', '0', 'Propreter et attentions particuliere', '0', 'Ouest', '0', '0', '2', '2', '0', '2', '0', '0', '2', '0', '1', 'une garde oU le development de mon enfants serai une prioriter. pas une prison', '1', '2', '0', '0', 'albion', '1', '0', '1', '1', '4', '0', '', 'mauricienne', '0', 1),
(2, 'Mungla ', 'Karin ', '1980-10-25', 'kmungla@mauritiusunion.com', '2017-03-19', '0', '1', '0', 'Peace of mind', '1', 'Albion', '0', '1', '', '', '', '', '0', '1', '', '1', '0', 'J\'en ai déjà un', '', '', '1', '0', 'Albion', '2', '1', '0', '1', '2', '0', '', 'Mauricienne', '1', 1),
(3, 'Claite', 'jennifer', '1978-12-26', 'jennifer@claite.net', '2017-03-19', '0', '1', '0', 'la confiance', '0', 'albion', '0', '0', '2', '2', '1', '1', '0', '0', '1', '1', '0', 'Un environment propre, securisant aimant les enfants et ou les parents sont en confiance.', '0', '2', '1', '0', 'albion', '2', '0', '1', '1', '8', '0', '', 'mauricienne', '0', 1),
(4, 'Cavalot', 'Virginie', '1984-01-02', 'ginie2159@gmail.com', '2017-03-19', '0', '0', '1', ' incompetence ', '0', 'Albion', '1', '0', '2', '2', '1', '1', '0', '0', '2', '1', '0', 'Garde avec des personnes complétante ', '0', '2', '1', '0', 'Port Louis ', '2', '1', '0', '1', '4', '0', '', 'Mauricienne', '0', 1),
(5, 'test 1', 'test', '0000-00-00', 'datanguy@yahoo.fr', '2017-03-22', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', 0),
(6, 'BRUGET', 'Ana', '2016-12-20', 'Step.bruget@intnet.mu', '2017-03-24', '1', '3', '0', 'Plus de developments a mon enfant', '1', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', 0),
(7, 'TEST', 'TEST', '0000-00-00', 'yzaclaite@gmail.com', '2017-03-24', '1', '4', '1', 'PROPRE', '1', 'TAMARIN', '1', '0', '2', '2', '0', '0', '', '1', '', '1', '1', 'Propre, accueillante, personnelle qualifié', '1', '3', '1', '0', '', '', '', '', '', '0', '0', '', '', '0', 1),
(8, 'Piany', 'Emmanuelle', '1984-09-27', 'malory20@hotmail.com', '2017-03-24', '1', '', '', '', '0', 'Morcellement Raffray', '0', '0', '2', '2', '1', '0', '1', '0', '2', '1', '0', 'Un lieu où il pourrait se sentir accueilli et en sécurité. Ayant un handicap il faudrait que la structure en question puisse l\'aider a s\'epanouir au maximum.', '0', '2', '1', '0', 'Albion', '1', '0', '0', '0', '4', '0', '', 'Mauricienne', '0', 1),
(9, 'Wampfler', 'Martine', '1986-05-15', 'Martine.wampfler@gmail.com', '2017-04-03', '0', '0', '0', 'Très bonne creche', '0', 'Centre', '0', '0', '2', '1', '1', '0', '0', '0', '0', '1', '0', 'La crèche et familles ', '0', '1', '1', '0', 'Albion', '2', '1', '1', '1', '8', '0', '', 'Mauricienne ', '1', 1),
(10, 'De comarmond', 'Rebecca ', '1986-09-25', 'rebecca.b2509@gmail.com ', '2017-04-03', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', 0),
(11, 'Rivaud', 'Annick', '1979-06-18', 'annick.rivaud@swanforlife.com', '2017-04-03', '1', '4', '0', 'en effet bébé est prévu pour Octobre', '0', 'Albion', '0', '0', '2', '2', '0', '1', '1', '0', '2', '1', '0', 'garderie disponible de 06h30 am a 18h30. repas inclut', '1', '2', '1', '0', 'albion', '1', '0', '0', '0', '2', '0', '', 'mauricienne', '0', 1),
(12, 'Juliana ', 'C', '2017-07-25', 'juliana@futurebrightproperties.com', '2017-04-04', '0', '0', '0', 'They are fantastic. ', '0', 'Albion', '0', '0', '2', '2', '2', '0', '1', '0', '1', '1', '0', 'Clean, Proffesional & Open Minded - Montessori Concept preferably. ', '1', '1', '1', '0', 'albion ', '1', '1', '', '0', '0', '0', '', '', '0', 1);

-- --------------------------------------------------------

--
-- Table structure for table `creche_fournisseurs`
--

CREATE TABLE `creche_fournisseurs` (
  `id_fournisseur` int(11) NOT NULL,
  `me` varchar(100) DEFAULT NULL,
  `add_1` varchar(100) DEFAULT NULL,
  `add_2` varchar(100) DEFAULT NULL,
  `tel_1` varchar(20) DEFAULT NULL,
  `tel_2` varchar(20) DEFAULT NULL,
  `email_add` varchar(100) DEFAULT NULL,
  `contact_person` varchar(50) DEFAULT NULL,
  `bank_details_1` varchar(100) DEFAULT NULL,
  `bank_details_2` varchar(100) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `creche_fournisseurs`
--

INSERT INTO `creche_fournisseurs` (`id_fournisseur`, `me`, `add_1`, `add_2`, `tel_1`, `tel_2`, `email_add`, `contact_person`, `bank_details_1`, `bank_details_2`) VALUES
(1, 'Mr Noel Allet, Owner of building', 'Avenue des Talipots', 'Quatre Bornes', '4540217', '58296949', 'N/A', 'N/A', 'MCB', '000052008509'),
(2, 'Ministry of Gender, Equality and Family Welfare', '', '', '', '', '', 'Mrs Allam', 'n/a', ''),
(3, 'Registrar Office', '', 'Port Louis', '', '', '', '', '', ''),
(4, 'Mauritius Revenue Authority', '', 'Port Louis', '', '', '', '', '', ''),
(5, 'District Council of Black River', 'Geofroy Road', 'Bambous', '', '', '', '', '', ''),
(6, 'Odézil Ltd', '', '', '', '', '', '', 'MCB', '000410904392'),
(7, 'E.Z. L Services Ltd,  Pest Control', '5, Poinsettias', 'La Tour Koenig', '57183249', '', 'ezlservices@hotmail.com', 'Kevin Ladouceur', 'MCB', ''),
(8, 'Cernol Chemicals Ltd', '', '', '', '59417300', '', 'Yannick Turenne', '', ''),
(9, 'integhr Accountant', '15th floor, Citadelle Mall, Sir Virgil Naz ', 'Port Louis', '52582129', '', 'nrochecouste@integhr.com\nwww.integhr.com', 'Nadia Rochecouste ', 'Bank One ', '003171061450'),
(10, 'Skills for Life Ltd', '3rd Floor, 51B, Ramnath Jeetah Trust Building', 'Ebène', '4893202', '59674897', 'emarketing@gmail.com', NULL, 'MCB', '000262795027'),
(11, 'National Insurance Co Ltd', '', 'Curepipe', '6023000', '57680283', '', 'Inoos Sakauloo', 'MCB', 'LIFE INSURANCE \'0000444031917\nHEALTH INSURANCE \'000444155708'),
(12, 'Mauritius Union Assurance Co Ltd ', '', 'Port Louis', '', '', '', '', '', ''),
(13, 'Refill of fire extinguishers', '', '', '', '', '', '', '', '');

-- --------------------------------------------------------

--
-- Table structure for table `creche_garde_enfant`
--

CREATE TABLE `creche_garde_enfant` (
  `id_garde_enfant` int(11) NOT NULL,
  `id_enfant` int(11) NOT NULL,
  `id_paiement` int(11) DEFAULT NULL,
  `date_debut` date NOT NULL,
  `date_fin` date NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `creche_garde_enfant`
--

INSERT INTO `creche_garde_enfant` (`id_garde_enfant`, `id_enfant`, `id_paiement`, `date_debut`, `date_fin`) VALUES
(11, 3, 1, '2020-05-01', '2020-05-22');

-- --------------------------------------------------------

--
-- Table structure for table `creche_garde_enfant_options`
--

CREATE TABLE `creche_garde_enfant_options` (
  `id_garde_enfant` int(11) NOT NULL,
  `id_option` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `creche_garde_enfant_options`
--

INSERT INTO `creche_garde_enfant_options` (`id_garde_enfant`, `id_option`) VALUES
(11, 1),
(11, 2);

-- --------------------------------------------------------

--
-- Table structure for table `creche_grille_capacites`
--

CREATE TABLE `creche_grille_capacites` (
  `id_capacite` int(11) NOT NULL,
  `id_theme` int(11) NOT NULL,
  `nom` varchar(255) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `creche_grille_capacites`
--

INSERT INTO `creche_grille_capacites` (`id_capacite`, `id_theme`, `nom`) VALUES
(1, 1, 'Les Mouvements spontanés de ses bras sont asymétriques et anarchiques'),
(2, 1, 'Le réflexe d\'agrippement est présent'),
(3, 1, 'Met occasionnellement son poing dans sa bouche'),
(4, 1, 'Examine attentivement ses mains et ses doigts'),
(5, 1, 'Gratte la surface avec ses doigts pour saisir un objet (c\'est le début de la préhension palmaire)'),
(6, 1, 'Secoue un hochet placé dans sa main'),
(7, 1, 'Saisie un objet suspendu au-dessus de lui'),
(8, 2, 'Reconnaît la voix des personnes significatives (parents, éducatrices)'),
(9, 2, 'Est attitiré par les visages'),
(10, 2, 'Fixe son regard sur un objet éloigné d\'une vingtaine de centimètre'),
(11, 2, 'Reconnaît visuellement les personnes qui lui sont significatives'),
(12, 2, 'Bouge la tête au son de la voix'),
(13, 2, 'A de l’intérêt pour les objets ou images aux couleurs contrastées, aux couleurs vives'),
(14, 2, 'Porte son poing à sa bouche'),
(15, 2, 'Cherche à localiser l’origine des sons'),
(16, 2, 'Observe et suit les personnes des yeux'),
(17, 2, 'Lorsqu’il a un objet dans la main, l’explore visuellement et avec sa bouche'),
(18, 3, 'Couché sur le dos : Tourne la tête'),
(19, 3, 'Maintient sa tête au centre'),
(20, 3, 'S’amuse à faire des mouvements de pédalage'),
(21, 3, 'Joue avec ses pieds'),
(22, 3, 'Couché sur le ventre : Ses bras et ses jambes sont fléchis sous lui'),
(23, 3, 'Tourne sa tête sur les côtés'),
(24, 3, 'Soulève sa tête quelques instants'),
(25, 3, 'Prend appuie sur son ventre et sur ses avant bras'),
(26, 3, 'Soulève la tête, redresse le dos, s’appuie sur le ventre et ses avant-bras'),
(27, 3, 'Redresse la tête et la poitrine en prenant appui sur les mains'),
(28, 3, 'Contrôle de tête et début de position assise Contrôle bien sa tête lorsqu’il est dans nos bras'),
(29, 3, 'Se retourne du ventre au dos d’un bloc'),
(30, 3, 'Tient en position assise quelque seconde avec du soutien'),
(31, 4, 'Emet des sons indifférenciés (cris, pleurs) qui deviennent différents progressivement selon la situation : faim, inconfort, contentement'),
(32, 4, 'Porte attention à la voix, surtout celle de sa mère ou des personnes significatives comme ses éducatrices habituelles'),
(33, 4, 'S’intéresse aux expressions du visage'),
(34, 4, 'S’amuse à gazouiller : aaaaaaa…iiiiiiiii…..'),
(35, 4, 'Pousse des sons aigus lorsqu’il découvre le son de sa voix'),
(36, 5, 'S’intéresse à ce qui l’entoure'),
(37, 5, 'Reconnaît les personnes ou les objets connus'),
(38, 5, 'Distingue le jour et la nuit ( expression populaire : fait ses nuits )'),
(39, 5, 'Coordonne divers actions : Il regarde un objet, le saisit, le porte à sa bouche'),
(40, 6, 'Exprime ses besoins par des cris, des pleurs'),
(41, 6, 'Manifeste des émotions primaires : douleur, dégoût, plaisir'),
(42, 6, 'Sourit à la vue d’une personne'),
(43, 6, 'Peut manifester de la colère, de la surprise, de la tristesse'),
(44, 6, 'Premier social vers 6 semaines'),
(45, 6, 'Réagit à la présence et aux déplacements des personnes autour de lui : les suit des yeux, bouge les jambes et les bras, gazouille'),
(46, 7, 'S’alimente approximativement à toutes les 4 heures (0-3 mois)'),
(47, 7, 'Dort environ 4-5 siestes par jour (0-3 mois)'),
(48, 7, 'Prends 3 à 5 repas par jour (3 mois)'),
(49, 7, 'Dort 3 siestes (3 mois)'),
(50, 7, 'Débute l’alimentation solide ( purée assez liquide ) (4-6mois)'),
(51, 7, 'Elimine fréquemment (4-6 mois)'),
(52, 7, 'Prends trois repas et exprime lui-même sa faim (6 mois)'),
(53, 8, 'Porte des objets à sa bouche'),
(54, 8, 'Est plus habile pour saisir les objets seul'),
(55, 8, 'Adapte sa préhension aux formes des objets et à leur grosseur'),
(56, 8, 'Lâche un objet qu’il a dans la main si on lui en présente un autre'),
(57, 8, 'Saisit des objets de différentes formes : biberon, balle, cube…'),
(58, 8, 'Fait passer un objet d’une main à l’autre'),
(59, 8, 'Tient deux objets à la fois, un dans chaque main et les frappe ensemble'),
(60, 8, 'Fait bravo en tapant dans ses mains'),
(61, 8, 'Manifeste de l’intérêt pour l’une de ses mains'),
(62, 8, 'Pointe du doigt'),
(63, 8, 'Relâche volontairement des objets'),
(64, 8, 'Saisie de petits objets entre le pouce et l’index'),
(65, 9, 'Porte ses orteils à sa bouche'),
(66, 9, 'Se sert de ses mains et de sa bouche pour explorer les objets'),
(67, 9, 'Comprend l’intonation affective d’un message : Il fait la moue ou pleure quand on hausse le ton'),
(68, 9, 'Découvre la notion de profondeur ( non celle du danger ) et la notion de distance'),
(69, 9, 'Bouge la tête au son de la voix'),
(70, 9, 'Peut suivre du regard un objet qui bouge rapidement'),
(71, 9, 'Comprend le terme « dans » ou « dedans »'),
(72, 9, 'Explore les objets par la bouche'),
(73, 9, 'Porte seul la suce à sa bouche'),
(74, 9, 'Mord et mâche des jouets'),
(75, 9, 'S’apaise au son d’une musique familière ou d’une voix familière'),
(76, 9, 'Eprouve du plaisir à entendre les sons qu’il produit lui-même'),
(77, 10, 'Se retourne du dos au ventre'),
(78, 10, 'Maîtrise de mieux en mieux la position assise : se protège des chutes vers l’avant (6-7 mois) de côté (8-9 mois), vers l’arrière (10 mois)'),
(79, 10, 'Couché sur le ventre ou sur le dos, se redresse'),
(80, 10, 'Rampe sur l’abdomen'),
(81, 10, 'Soutient son corps quand on le met en position debout'),
(82, 10, 'Se déplace à quatre pattes'),
(83, 10, 'Passe de la position assise à la position à genoux'),
(84, 10, 'Se met debout'),
(85, 10, 'Se déplace de côté'),
(86, 10, 'Fait quelques pas s’il est tenu des deux mains'),
(87, 10, 'Fait quelques pas s’il est tenu d’une main'),
(88, 11, 'Localise l’origine des sons qu’il entend'),
(89, 11, 'Réagit au ton de la voix, ouvrant grands les yeux, souriant, fronçant les sourcils : Comprend la tonalité affective du message.'),
(90, 11, 'Babille : babababa, mamamamam'),
(91, 11, 'Utilise l’intonation typique de sa langue maternelle'),
(92, 11, 'Se rend compte que les mots sont porteurs de sens'),
(93, 11, 'Réagit à l’appel de son nom'),
(94, 11, 'Réagit au « non »'),
(95, 11, 'Utilise des gestes pour se faire comprendre ( pointe du doigt un objet, tend les bras )'),
(96, 11, 'Capable d’initier un échange vocal'),
(97, 11, 'Utilise différentes syllabes et des intonations variées'),
(98, 11, 'Commence à dire « papa » et « maman »'),
(99, 12, 'Manifeste une intention dans ses comportement (Il fait tel geste pour atteindre tel objet)'),
(100, 12, 'Comprend la relation de cause à effet (biberon=nourriture, tel jouet=tel bruit)'),
(101, 12, 'Aime les jeux de « coucou »'),
(102, 12, 'Regarde ou suit des yeux un objet qu’il fait tomber'),
(103, 12, 'Cherche l’objet disparu sous une couverture.'),
(104, 13, 'Décode les émotions des autres par l’expression de leur visage'),
(105, 13, 'Commence à s’attacher à une personne en particulier'),
(106, 13, 'A parfois peur des étrangers'),
(107, 13, 'Réagit parfois mal quand il est séparé de ses parents, en particularité de sa mère'),
(108, 13, 'Tend les bras pour se faire prendre'),
(109, 13, 'Ne manifeste pas de peur devant enfant inconnu'),
(110, 14, 'Prend trois repas par jour'),
(111, 14, 'Fait deux siestes'),
(112, 14, 'Mange de la nourriture solide'),
(113, 14, 'Manifeste des préférences dans la nourriture'),
(114, 14, 'Tient seul son biberon'),
(115, 14, 'Mange seul avec les doigts'),
(116, 15, 'Insère de petits objets dans un contenant à travers un trou ( tel une tirelire )'),
(117, 15, 'Tourne les pages d’un livre, mais saute plusieurs pages'),
(118, 15, 'Ses deux mains font une activité différente (l’une stabilise, l’autre manipule)'),
(119, 15, 'Construit une tour de 2-3 blocs (15 mois), de 3-4 blocs (18mois)'),
(120, 15, 'Fait des traits sur du papier avec une craie de cire'),
(121, 15, 'Emboîte des objets, les sépare, les jette.'),
(122, 16, 'Aime regarder les images d’un livre'),
(123, 16, 'Sur demande, il pointe les parties de son visage : nez, bouche, oreille etc.'),
(124, 16, 'Sur demande, il pointe quelques parties de son corps :'),
(125, 16, 'Mains, pieds, doigts, cheveux'),
(126, 16, 'Sur demande identifie quelques images dans un livre en les pointant'),
(127, 16, 'Peut rassembler deux objets de même forme'),
(128, 16, 'Place dans un encastrement des formes géométriques simples ( cercle, carré, triangle)'),
(129, 16, 'Se dandine au son d’une musique'),
(130, 16, 'Essaie de chanter'),
(131, 17, 'Fait ses premiers pas sans aide'),
(132, 17, 'Pousse ou tire un objet à roulette en marchant'),
(133, 17, 'Transporte un objet'),
(134, 17, 'Monte l’escalier à quatre pattes'),
(135, 17, 'S’accroupit pour ramasser un objet au sol'),
(136, 17, 'Monte les escaliers, sans alterner les pieds et en tenant la rampe ( marque le pas )'),
(137, 17, 'Descend l’escalier à quatre pattes à reculons'),
(138, 17, 'Court'),
(139, 17, 'lance un ballon, va le chercher'),
(140, 18, 'Apprécie et initie des jeux vocaux'),
(141, 18, 'Utilise un mot à plusieurs significations ( ex : « lo » pour tout ce qui est liquide'),
(142, 18, 'Utilise un mot ayant la valeur phrase'),
(143, 18, 'Réagit de façon appropriée à de courtes phrases familière : « Viens manger »'),
(144, 18, 'Reconnaît les objets correspondant à 40-50 mots'),
(145, 18, 'Regarde les objets et les images dont on dit le nom'),
(146, 18, 'Commence à utiliser les mots pour communiquer'),
(147, 18, 'Sait dire une vingtaine de mots'),
(148, 18, 'Répète des mots ou des bouts de phrase comme un écho pour s’exercer à les prononcer'),
(149, 19, 'Imite des actions simples'),
(150, 19, 'Comprend le concept de permanence de l’objet : une chose continue à exister même si je ne la voit plus'),
(151, 19, 'Reconnaît son image dans le miroir'),
(152, 19, 'Commence à utiliser des symboles ( joue à faire semblant )'),
(153, 19, 'Dans son jeu change la fonction des objets'),
(154, 19, 'Imite une situation qu’il a vue quelques jours plus tôt'),
(155, 19, 'Saisit le sens de avant, après'),
(156, 20, 'S’intéresse aux autres enfants'),
(157, 20, 'Est sensible à la peine d’un autre enfant'),
(158, 20, 'Aime être à côté d’autres enfants ( jeu parallèle)'),
(159, 20, 'Apprend certains comportements sociaux'),
(160, 20, '(bonjour, saluer de la main, envoyer un bisou )'),
(161, 20, 'Manifeste une préférence pour l’un des enfants qu’il côtoie'),
(162, 20, 'Quand il crie ou se fâche, on peut le distraire et attirer son attention sur autre chose'),
(163, 20, 'Se reconnaît dans le miroir'),
(164, 20, 'Tolère mieux être séparé de ses parents'),
(165, 20, 'Coopère lorsqu’on l’habille'),
(166, 20, 'Démontre quelques signes de jalousie'),
(167, 20, 'Désire participer aux activités'),
(168, 21, 'Fait une sieste par jour'),
(169, 21, 'Prend trois repas et collations'),
(170, 21, 'Boit à la tasse, bec verseur et deux poignées'),
(171, 21, 'Boit au verre en le tenant à deux mains ( sous supervision )'),
(172, 21, 'Mange avec une cuillère mais renverse souvent de la nourriture. Aime manger seul'),
(173, 21, 'Peut commencer à prendre conscience qu’il a fait dans sa couche'),
(174, 21, 'Peut commencer à indiquer qu’il désire aller à la toilette'),
(175, 22, 'Visse et dévisse un couvercle'),
(176, 22, 'Tient les ciseaux d’une main et fait des franges'),
(177, 22, 'Découpe une bande de papier'),
(178, 22, 'Découpe en suivant une ligne droite'),
(179, 22, 'Fait un serpentin en roulant de la pâte à modeler'),
(180, 22, 'Tient le crayon entre le pouce et l’index'),
(181, 22, 'Suit des traits pointillés (crayon) ligne, carré, rond'),
(182, 22, 'Reproduit un carré à l’aide d’un modèle (dessin)'),
(183, 22, 'Fait un bonhomme de style têtard (visage, bras, jambes)'),
(184, 22, 'Encercle un élément'),
(185, 22, 'Construit des tours de 10 cubes'),
(186, 23, 'Participe avec intérêts aux activités de type auditives (jeu des sons)'),
(187, 23, 'Suit le rythme de la musique, du tambour'),
(188, 23, 'Peut observer sans toucher'),
(189, 24, 'En tricycle, est capable de le diriger'),
(190, 24, 'Est capable de pédaler'),
(191, 24, 'Monte et descend les escaliers en alternant les pieds'),
(192, 24, 'Court et peut s’adapter à des courbes durant sa course'),
(193, 24, 'Tient en équilibre sur un pied quelques secondes'),
(194, 24, 'Lance un ballon vers une cible'),
(195, 24, 'Attrape un ballon les bras tendu'),
(196, 24, 'Donne un coup de pied sur un ballon qui roule vers lui'),
(197, 24, 'Saute en bas de deux marches d’escalier (30cm env.)'),
(198, 24, 'Reconnaît toutes les parties de son visage'),
(199, 24, 'Reconnaît davantage de parties de son corps (front, coudes, dos, les côtes, les pieds, les genoux, etc.)'),
(200, 24, 'S’oriente facilement dans un itinéraire simple'),
(201, 25, 'Fait des phrases complètes'),
(202, 25, 'Utilise des articles, des adjectifs, des prépositions, des adverbes'),
(203, 25, 'Prononce adéquatement le son « F »'),
(204, 25, 'Prononce adéquatement le son « V »'),
(205, 25, 'Prononce adéquatement le son « Z »'),
(206, 25, 'Prononce adéquatement le son « R »'),
(207, 25, 'Prononce adéquatement le son « OI »'),
(208, 25, 'Prononce adéquatement le son « UI »'),
(209, 25, 'Dit ou chante des comptines'),
(210, 25, 'Dit son nom, son âge et son sexe'),
(211, 25, 'Utilise les pronoms : je, tu, moi'),
(212, 25, 'Parle de façon intelligible'),
(213, 25, 'Montre l’objet identifié par sa fonction (avec quoi mange-t-on ?)'),
(214, 25, 'Pose des questions'),
(215, 26, 'Regroupe, classe des objets de mêmes couleurs'),
(216, 26, 'Regroupe, classe des objets par taille'),
(217, 26, 'Réussit un casse-tête de 12 pièces'),
(218, 26, 'Nomme quelques couleurs'),
(219, 26, 'Insère des objets de tailles différentes dans un contenant à encastrer'),
(220, 26, 'Comprend les termes en avant, en arrière, près, loin'),
(221, 26, 'Comprend les termes sur, sous, devant'),
(222, 26, 'Comprend les termes aujourd’hui, demain, hier, jour, nuit'),
(223, 26, 'Copie une croix ou un carré'),
(224, 26, 'Dessine seul (mais lui seul peut identifier ce que son dessin représente)'),
(225, 26, 'Compte jusqu’à 10 (mécaniquement) peut compter des objets devant lui sans se tromper entre 2 à 6 objets'),
(226, 26, 'Pointe les objets différents'),
(227, 26, 'Reconnaît les formes rondes, carrées, triangles'),
(228, 26, 'Répond à des questions fermées commençant par « Qui », « Où »'),
(229, 26, 'Répond à des questions à développement commençant par « Comment », « Qu’est-ce que »'),
(230, 27, 'Comprend les raisons d’un interdit'),
(231, 27, 'Prend des initiatives'),
(232, 27, 'Accepte de partager ses jouets'),
(233, 27, 'Initie des jeux avec d’autres enfants'),
(234, 27, 'Participe à un jeu initier par un autre enfant'),
(235, 27, 'Demande la permission pour obtenir le jouet d’un ami'),
(236, 27, 'Comprend les consignes de conduite sociales (saluer les personnes, merci, s.v.p., etc.)'),
(237, 27, 'Capable d’attendre son tour'),
(238, 27, 'Exprime son mécontentement verbalement'),
(239, 27, 'Se sépare facilement de ses parents'),
(240, 27, 'Fait parfois des cauchemars'),
(241, 27, 'Certaines situations peuvent lui faire peur'),
(242, 27, 'Aime aider, cherche à plaire et apprécie les éloges'),
(243, 27, 'Pourrait avoir un ami imaginaire'),
(244, 28, 'Se déshabille seul (a encore un peu de difficulté pour les vêtements serrés)'),
(245, 28, 'Détache complètement la fermeture éclair d’une veste'),
(246, 28, 'Pique les aliments avec sa fourchette'),
(247, 28, 'Brosse ses dents seul (avec supervision de l’adulte)'),
(248, 28, 'Se lave les mains et les essuies'),
(249, 28, 'Va à la toilette seul (a besoin d’aide pour s’essuyer)'),
(250, 28, 'Lorsqu’il se mouche a de la difficulté à souffler par le nez, s’essuie plus qu’il ne se mouche');

-- --------------------------------------------------------

--
-- Table structure for table `creche_grille_enfants`
--

CREATE TABLE `creche_grille_enfants` (
  `id_enfant` int(11) NOT NULL,
  `id_capacite` int(11) NOT NULL,
  `date` date NOT NULL,
  `observation` enum('A','PA','NA') NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `creche_grille_enfants`
--

INSERT INTO `creche_grille_enfants` (`id_enfant`, `id_capacite`, `date`, `observation`) VALUES
(1, 1, '2020-10-19', 'A'),
(1, 2, '2020-10-19', 'PA'),
(1, 3, '2020-10-19', 'PA'),
(1, 4, '2020-10-19', 'NA'),
(1, 5, '2020-10-19', 'NA'),
(1, 6, '2020-10-19', 'PA'),
(1, 7, '2020-10-19', 'A'),
(6, 175, '2020-12-30', 'A'),
(6, 176, '2020-12-30', 'A'),
(6, 177, '2020-12-30', 'A'),
(6, 178, '2020-12-30', 'PA'),
(30, 1, '2021-04-02', 'A'),
(30, 175, '2021-04-02', 'A'),
(30, 175, '2021-04-07', 'A'),
(30, 176, '2021-04-02', 'NA'),
(30, 177, '2021-04-02', 'NA'),
(30, 178, '2021-04-02', 'NA'),
(30, 179, '2021-04-02', 'A'),
(30, 180, '2021-04-02', 'NA'),
(30, 181, '2021-04-02', 'PA'),
(30, 182, '2021-04-02', 'NA'),
(30, 183, '2021-04-02', 'PA'),
(30, 184, '2021-04-02', 'PA'),
(30, 185, '2021-04-02', 'A'),
(30, 186, '2021-04-02', 'A'),
(30, 187, '2021-04-02', 'PA'),
(30, 188, '2021-04-02', 'A'),
(30, 189, '2021-04-02', 'PA'),
(30, 190, '2021-04-02', 'NA'),
(30, 191, '2021-04-02', 'NA'),
(30, 192, '2021-04-02', 'A'),
(30, 193, '2021-04-02', 'NA'),
(30, 194, '2021-04-02', 'A'),
(30, 195, '2021-04-02', 'A'),
(30, 196, '2021-04-02', 'PA'),
(30, 197, '2021-04-02', 'NA'),
(30, 198, '2021-04-02', 'A'),
(30, 199, '2021-04-02', 'A'),
(30, 200, '2021-04-02', 'A'),
(30, 201, '2021-04-02', 'NA'),
(30, 202, '2021-04-02', 'PA'),
(30, 203, '2021-04-02', 'A'),
(30, 204, '2021-04-02', 'A'),
(30, 206, '2021-04-02', 'A'),
(30, 207, '2021-04-02', 'PA'),
(30, 208, '2021-04-02', 'A'),
(30, 209, '2021-04-02', 'PA'),
(30, 210, '2021-04-02', 'PA'),
(30, 211, '2021-04-02', 'PA'),
(30, 212, '2021-04-02', 'NA'),
(30, 213, '2021-04-02', 'A'),
(30, 214, '2021-04-02', 'NA'),
(30, 215, '2021-04-02', 'A'),
(30, 216, '2021-04-02', 'PA'),
(30, 217, '2021-04-02', 'NA'),
(30, 218, '2021-04-02', 'PA'),
(30, 219, '2021-04-02', 'A'),
(30, 220, '2021-04-02', 'PA'),
(30, 221, '2021-04-02', 'NA'),
(30, 222, '2021-04-02', 'NA'),
(30, 223, '2021-04-02', 'NA'),
(30, 224, '2021-04-02', 'PA'),
(30, 225, '2021-04-02', 'NA'),
(30, 226, '2021-04-02', 'PA'),
(30, 227, '2021-04-02', 'NA'),
(30, 228, '2021-04-02', 'PA'),
(30, 229, '2021-04-02', 'PA'),
(30, 230, '2021-04-02', 'A'),
(30, 231, '2021-04-02', 'PA'),
(30, 232, '2021-04-02', 'PA'),
(30, 233, '2021-04-02', 'A'),
(30, 234, '2021-04-02', 'A'),
(30, 235, '2021-04-02', 'NA'),
(30, 236, '2021-04-02', 'A'),
(30, 237, '2021-04-02', 'A'),
(30, 238, '2021-04-02', 'PA'),
(30, 239, '2021-04-02', 'PA'),
(30, 240, '2021-04-02', 'NA'),
(30, 241, '2021-04-02', 'NA'),
(30, 242, '2021-04-02', 'A'),
(30, 243, '2021-04-02', 'NA'),
(30, 244, '2021-04-02', 'NA'),
(30, 245, '2021-04-02', 'NA'),
(30, 246, '2021-04-02', 'PA'),
(30, 248, '2021-04-02', 'A'),
(30, 249, '2021-04-02', 'NA'),
(30, 250, '2021-04-02', 'NA'),
(32, 110, '2020-12-22', 'A');

-- --------------------------------------------------------

--
-- Table structure for table `creche_grille_etapes`
--

CREATE TABLE `creche_grille_etapes` (
  `id_etape` int(11) NOT NULL,
  `nom` varchar(50) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `creche_grille_etapes`
--

INSERT INTO `creche_grille_etapes` (`id_etape`, `nom`) VALUES
(1, 'de la naissance à 6 mois'),
(2, 'de 6 à 12 mois'),
(3, 'de 1 an à 2 ans'),
(4, '2 à 3 ans');

-- --------------------------------------------------------

--
-- Table structure for table `creche_grille_etapes_themes`
--

CREATE TABLE `creche_grille_etapes_themes` (
  `id_theme` int(11) NOT NULL,
  `id_etape` int(11) NOT NULL,
  `nom` varchar(100) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `creche_grille_etapes_themes`
--

INSERT INTO `creche_grille_etapes_themes` (`id_theme`, `id_etape`, `nom`) VALUES
(1, 1, 'Développement de la motricité fine'),
(2, 1, 'Développement sensoriel et perceptif'),
(3, 1, 'Développement de la motricité globale'),
(4, 1, 'Développement du langage'),
(5, 1, 'Développement cognitif'),
(6, 1, 'Développement socio-affectif'),
(7, 1, 'Développement des fonctions végétatives'),
(8, 2, 'Développement de la motricité fine'),
(9, 2, 'Développement sensoriel et perceptif'),
(10, 2, 'Développement de la motricité globale'),
(11, 2, 'Développement du langage'),
(12, 2, 'Développement cognitif'),
(13, 2, 'Développement socio-affectif'),
(14, 2, 'Développement des activités physiologique'),
(15, 3, 'Développement de la motricité fine'),
(16, 3, 'Développement sensoriel et perceptif'),
(17, 3, 'Développement de la motricité globale'),
(18, 3, 'Développement du langage'),
(19, 3, 'Développement cognitif'),
(20, 3, 'Développement socio-affectif'),
(21, 3, 'Développement des fonctions végétatives'),
(22, 4, 'Développement de la motricité fine'),
(23, 4, 'Développement sensoriel et perceptif'),
(24, 4, 'Développement de la motricité globale'),
(25, 4, 'Développement du langage'),
(26, 4, 'Développement cognitif'),
(27, 4, 'Développement socio-affectif'),
(28, 4, 'Développement de l\'Autonomie');

-- --------------------------------------------------------

--
-- Table structure for table `creche_jours_feries`
--

CREATE TABLE `creche_jours_feries` (
  `date` date NOT NULL,
  `nom` varchar(50) NOT NULL DEFAULT ''
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `creche_jours_feries`
--

INSERT INTO `creche_jours_feries` (`date`, `nom`) VALUES
('2020-01-02', 'New Year'),
('2020-01-25', 'Chinese Spring festival'),
('2020-02-01', 'Abolition of Slavery'),
('2020-02-08', 'Thaipoosam Cavadee'),
('2020-02-21', 'Maha Shivaratree'),
('2020-03-12', 'National day'),
('2020-03-25', 'Ougadi'),
('2020-05-01', 'Labour Day'),
('2020-05-24', 'Eid-Ul-Fitr'),
('2020-08-15', 'Assumption of the Blessed Virgin Mary'),
('2020-08-23', 'Ganesh Chaturthi'),
('2020-11-02', 'Arrival of indentured laborers'),
('2020-11-14', 'Divali'),
('2020-12-25', 'Christmas');

-- --------------------------------------------------------

--
-- Table structure for table `creche_livre_caisse`
--

CREATE TABLE `creche_livre_caisse` (
  `id_livre_caisse` int(11) NOT NULL,
  `date` date NOT NULL,
  `debit` decimal(8,2) NOT NULL,
  `credit` decimal(8,2) NOT NULL,
  `details` varchar(255) NOT NULL,
  `remarques` text NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `creche_options`
--

CREATE TABLE `creche_options` (
  `id_option` int(11) NOT NULL,
  `nom` varchar(255) NOT NULL,
  `prix` decimal(6,0) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `creche_options`
--

INSERT INTO `creche_options` (`id_option`, `nom`, `prix`) VALUES
(1, 'Pack activité Atelier de vacances', 3000),
(2, 'TEMPS PLEIN Option bien être (produits inclus), collation offert', 6400),
(3, 'TEMPS PLEIN Option petits repas frais (déjeuner) collation offerte', 6800),
(4, 'TEMPS PLEIN Option Basic (Soin, serviettes propres, collation offerte)', 5300),
(5, 'TEMPS PLEIN Option complète (soin, repas frais, produits et couches) collation offerte', 7200),
(6, 'Option 3 fois la semaine Plus collation', 3600),
(7, 'Option 2 fois la semaine plus collation', 2200);

-- --------------------------------------------------------

--
-- Table structure for table `creche_paiements`
--

CREATE TABLE `creche_paiements` (
  `id_paiement` int(11) NOT NULL,
  `id_enfant` int(11) NOT NULL,
  `for_month` date NOT NULL,
  `special` enum('','bonus_dec','assurance') NOT NULL,
  `montant` decimal(6,0) NOT NULL,
  `date_paiement` date DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `creche_paiements`
--

INSERT INTO `creche_paiements` (`id_paiement`, `id_enfant`, `for_month`, `special`, `montant`, `date_paiement`) VALUES
(1, 3, '2020-07-01', '', 5460, '2020-07-01'),
(2, 2, '2020-07-01', '', 5460, '2020-07-01'),
(3, 3, '2020-11-01', '', 5460, '2020-10-26'),
(4, 3, '2020-10-01', '', 5460, '2020-09-26');

-- --------------------------------------------------------

--
-- Table structure for table `creche_params`
--

CREATE TABLE `creche_params` (
  `id_param` varchar(40) NOT NULL DEFAULT '',
  `texte` mediumtext NOT NULL,
  `commentaire` varchar(255) NOT NULL DEFAULT ''
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `creche_params`
--

INSERT INTO `creche_params` (`id_param`, `texte`, `commentaire`) VALUES
('adresse_1', '51, Avenue des Dahlias	', ''),
('adresse_2', 'Morcellement Beerjeeraz', ''),
('BRN', 'C17149867', ''),
('directrice', 'Isabelle Claite', ''),
('email', 'crecheattitudecoltee@gmail.com', ''),
('nom_entreprise', 'Crèche Attitude Co Ltée', ''),
('site_web', 'www.crecheattitude.mu', ''),
('telephone', '2371670', ''),
('ville', 'Albion', '');

-- --------------------------------------------------------

--
-- Table structure for table `creche_parents`
--

CREATE TABLE `creche_parents` (
  `id_parent` int(11) NOT NULL,
  `nom_pere` varchar(255) NOT NULL,
  `prenom_pere` varchar(255) NOT NULL,
  `date_naissance_pere` date DEFAULT NULL,
  `email_pere` varchar(255) NOT NULL,
  `adresse_pere` text NOT NULL,
  `ville_pere` varchar(50) NOT NULL,
  `telephone_fixe_pere` varchar(50) NOT NULL,
  `telephone_portable_pere` varchar(50) NOT NULL,
  `profession_pere` varchar(255) NOT NULL,
  `employeur_pere` text NOT NULL,
  `nom_mere` varchar(255) NOT NULL,
  `prenom_mere` varchar(255) NOT NULL,
  `date_naissance_mere` date DEFAULT NULL,
  `email_mere` varchar(255) NOT NULL,
  `adresse_mere` text NOT NULL,
  `ville_mere` varchar(50) NOT NULL,
  `telephone_fixe_mere` varchar(50) NOT NULL,
  `telephone_portable_mere` varchar(50) NOT NULL,
  `profession_mere` varchar(255) NOT NULL,
  `employeur_mere` text NOT NULL,
  `nom_contact_urgence` varchar(255) NOT NULL,
  `prenom_contact_urgence` varchar(255) NOT NULL,
  `relation_urgence` text NOT NULL,
  `telephone_fixe_contact_urgence` varchar(50) NOT NULL,
  `telephone_portable_contact_urgence` varchar(50) NOT NULL,
  `nom_payeur` varchar(255) NOT NULL,
  `banque_branche_payeur` varchar(255) NOT NULL,
  `numero_compte_bancaire_payeur` varchar(255) NOT NULL,
  `type_compte_payeur` varchar(255) NOT NULL,
  `date_virement` enum('1','2','3','4','5') NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `creche_parents`
--

INSERT INTO `creche_parents` (`id_parent`, `nom_pere`, `prenom_pere`, `date_naissance_pere`, `email_pere`, `adresse_pere`, `ville_pere`, `telephone_fixe_pere`, `telephone_portable_pere`, `profession_pere`, `employeur_pere`, `nom_mere`, `prenom_mere`, `date_naissance_mere`, `email_mere`, `adresse_mere`, `ville_mere`, `telephone_fixe_mere`, `telephone_portable_mere`, `profession_mere`, `employeur_mere`, `nom_contact_urgence`, `prenom_contact_urgence`, `relation_urgence`, `telephone_fixe_contact_urgence`, `telephone_portable_contact_urgence`, `nom_payeur`, `banque_branche_payeur`, `numero_compte_bancaire_payeur`, `type_compte_payeur`, `date_virement`) VALUES
(1, 'AMI', 'Jonathan', NULL, 'jonathanami@icloud.com', '159, Prairie Rose Ave\r\nSplendid View', 'Albion', '58048554', '', '', 'Splendid Sweets Ltd\r\nAlbion', 'AMI', 'Evegenia', NULL, 'kiryuse@gmail.com', '', '', '57932662', '', '', 'Splendid Sweets Ltd\r\nAlbion', 'Ami', 'Odile', 'Grand-mère', '57390711', '', '', '', '', '', '1'),
(2, 'Boodiah', 'Nicolas', NULL, 'boodiah12.nic@hotmail.com', 'Belle Vue Phare\r\nBelle Vue', 'Albion', '58017374 59608794', '', '', 'La Sentinelle Ltd\r\nBaie du Tombeau\r\n2068200', 'Boodiah', 'Christina', NULL, 'tinaboodiah@gmail.com', '', '', '54962596   59210928', '', '', 'Somatrans IBL Group\r\nRiche Terre\r\n2027140\"', '', '', '', '', '', '', '', '', '', '1'),
(3, 'd\'Avoine', 'Vincent', NULL, '', '', '', '', '', '', '', 'd\'Avoine', 'Anne Claire', NULL, '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '1'),
(4, 'Gobin', 'Lindley', NULL, '', '', '', '', '', '', '', 'Gobin', 'Joelle', NULL, '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '1'),
(5, 'Jeanne', 'Manu', NULL, '', '', '', '', '', '', '', 'Malabar', 'Valérie', NULL, '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '1'),
(6, 'Kerneur', 'Clément', NULL, '', '', '', '', '', '', '', 'Schklartschik', 'Liliane', NULL, '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '1'),
(7, 'Lambourg', 'Fabien', NULL, '', '', '', '', '', '', '', 'Lambourg', 'Mary-Jane', NULL, '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '1'),
(8, 'Marie', 'Eric', NULL, '', '', '', '', '', '', '', 'Kerville', 'Camille', NULL, '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '1'),
(9, 'Parfait', 'Marc', NULL, '', '', '', '', '', '', '', 'Oraison-Parfait', 'Alexandra', NULL, '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '1'),
(10, 'Permal', 'Daren', NULL, '', '', '', '', '', '', '', 'Permal', 'Bhavna', NULL, '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '1'),
(11, 'Phokeer', 'Amreesh Dev', NULL, '', '', '', '', '', '', '', 'Phokeer', 'Marie-Laure Ziss', NULL, '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '1'),
(12, 'Piany', 'Jean Laurent', NULL, '', '', '', '', '', '', '', 'Piany', 'Emmanuelle', NULL, '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '1'),
(13, 'Redouble', 'Michel', NULL, '', '', '', '', '', '', '', 'Redouble', 'Martine', NULL, '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '1'),
(14, 'Malinine', 'Grégory', NULL, '', '', '', '', '', '', '', 'Malinine', 'Sharon', NULL, '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '1'),
(15, 'décédé', 'x', NULL, '', '', '', '', '', '', '', 'De St Philippe Desplace', 'Karine', NULL, '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '1'),
(16, 'Grenade', 'Gino', NULL, '', '', '', '', '', '', '', 'Grenade', 'Diane', NULL, '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '1'),
(17, 'Rochecouste', 'Didier', NULL, '', '', '', '', '', '', '', 'Rochecouste', 'Valérie', NULL, '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '1'),
(18, 'Mackay', 'Frédéric', NULL, '', '', '', '', '', '', '', 'Mackay', 'Vanessa', NULL, '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '1'),
(19, 'Mungroo', 'Sunny', NULL, '', '', '', '', '', '', '', 'Mungroo', 'Alexandre', NULL, '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '1'),
(20, 'Catherine', 'Fabrice', NULL, '', '', '', '', '', '', '', 'Catherine', 'Karolyn Claite', NULL, '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '1'),
(21, 'Cavalot', 'Rudy', NULL, '', '', '', '', '', '', '', 'Cavalot', 'Virginie', NULL, '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '1'),
(22, 'x', 'x', NULL, '', '', '', '', '', '', '', 'Quirin', 'Karen', NULL, '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '1'),
(23, 'Beerjeraz', 'Cédric', NULL, 'cb.marboboisltee@gmail.com', '284, Avenue des Colombes, Morcellement Terres d\'Albion', 'Albion', '4896414', '52501427', '', 'Marbobois Ltee', 'Brosse', 'Désirella', '1976-09-09', 'desirellaj@gmail.com', '284, Avenues des Colombes, Morcellement Terre d\'Albion', 'Albion', '4896414', '52571665', 'Air Hostess', 'SSR International Airport', 'Beerjeraz', 'Marcellino ', 'Grand-Père', '-', '52541159', '', '', '', '', '1'),
(24, 'Lebon ', 'Stéphane', NULL, 'stephtvio@gmail.com', 'Avenue des Perruches, Morcellement Terre d\'Albion', 'Albion', '0', '52527065', 'Chef de projet', 'MCB', 'Lebon', 'Violaine', NULL, '', '', 'Albion', '', '52527165', 'Educateur', 'Ecole Paul et Virginie', 'Mario Lebon, Grand Pere, 57513418\r\nLysbette Lebon, Grand Mère, 57078724', '', '', '', '', '', '', '', '', '1'),
(25, 'Varsally', 'Nadeem', '2024-12-24', 'nvarsa@kinoseven.mu', 'Astrolabe Avenue Morcellment Raffray', 'Albion', '', '52592149', 'Directeur', 'Entrepreneur', 'Lesage', 'Melissa', '1980-05-07', 'lesage.melissa@gmail.com', 'Astrolabe Avenue Morc Raffray', 'Albion', '', '59414307', 'Juriste', '', 'Lesage \r\nVarsally', 'Magali Lesage\r\nAkhtar Varsally', 'grand-mère\r\ngrand-mère\r\n\r\n\r\n\r\n', '2888493', '57565035 /  ML\r\n57528915 AV\r\n', '', '', '', '', '1'),
(26, 'Sauleck', 'F Patrice', NULL, 'patrice.sauleck@mcb.mu', 'Avenue Marlins, Morcellement de Chazal', 'Albion', '2371920', '57616625', 'MCB', 'MCB PAILLES', 'Sauleck', 'Anne-Lise', NULL, 'annelise.dan@gmail.com', 'Avenue Marlins, Morcellement de Chazal', 'Albion', '2371920', '57574945', 'Tutor', 'Collège de la Confiance', 'Sauleck\r\nDaniel', 'Roselyn\r\nLise-May', 'Grand-Mère', '', '59118599\r\n58107227', '', '', '', '', '1'),
(27, 'Ernestine ', 'Jacques Chistopher Didier', NULL, 'dernestine@gmail.com', 'No 1 Avenue des Orangers, Morcellement Belle Vue', 'Albion', '2370347', '5747899', 'Banquier', 'MCB Saint Jean ', 'Delort-Ernestine', 'Marie Jessica ', '1989-11-07', 'jessdel24@gmail.com', 'No 1 Avenue des Orangers, Morcellement Belle Vue', 'Albion', '2370347', '59836327', 'Banquiere', 'MCB Curepipe', 'Mme Nathalie \r\nMme Viola', '', 'Grand-Mère Maternelle\r\nGrand-Mère paternelle', '', '54284357\r\n57015527', '', '', '', '', '1'),
(28, 'Inconnu', 'Inconnu', NULL, '', '', '', '', '', '', '', 'Dwarika', 'Kateney', '1999-03-07', 'katedwa@gmail.com', '56, Acrise Lane, Petit Verger', 'Petite Rivière', '2337122', '54756786', 'Assistante Puéricultrice', 'Crèche Attitude Co ltée', 'Grand-Père\r\nGrand-Mère', '', 'Grand-Père\r\nGrand-Mère', '', '59167249\r\n59325954', '', '', '', '', '1'),
(29, 'dAvoine', 'Cedric', NULL, '', 'Avenue des Tulipes ', 'Albion', '2384137', '54981021', '', 'CHCL', 'dAvoine', 'Elodie', NULL, '', '', '', '', '59810719', '', 'CCI Business School', 'dAvoine \r\nFinette Constantin\r\nFinette Constantin', 'Vincent\r\n;arie Line \r\nRose ;arie d\'avoine', 'Parrain\r\nGrand  ere\r\nGrand ;ere', '', '59401431\r\n59762007\r\n54960986', '', '', '', '', '1'),
(30, 'Ah Ting ', 'David', '1984-03-09', 'david.ahting@mcb.mu', '554 Morc Belle Vue Phare', 'Albion', '2385206', '57568030', 'Banquier', 'MCB Port-Louis', 'Ah Ting', 'Severine', '1987-05-18', 'severineahting@mcb.mu', '554 Morc Belle Vue Phare', 'Albion', '2385206', '57637045', 'Banquiere', 'MCB Port-Louis', 'Lisebie (GM)\r\nChristine', '', 'Grand-mère\r\nTante', '', '57131352\r\n59021140', '', '', '', '', '1'),
(31, 'Fanny', 'Ghislain', '1978-08-23', 'ghislain.fanny@gmail.com', 'Avenue Pic-Pics\r\nMorcellement Belle Vue (phare)', 'Albion', '2371750', '57915288', 'Inventory Manager', 'Natec Medical Ltd', 'Ramsay', 'Catherine', '1991-04-13', 'catheriner1@live.com', 'Avenue Pic-Pics\r\nMorc Belle Vue (Phare)\r\n', 'Albion', '2371750', '57578391 / 58563622', 'Marketing Executive', 'Linxia Ltd', 'Ramsay', 'Lisette', 'Grand-Mère', '', '57698524', '', '', '', '', '1'),
(32, 'Gouges', 'Gervais', NULL, '', 'Avenue Cutty Sark, Morcellement Raffray', 'Albion', '2384678', '59107506', '', 'In Situ Visual Merchandising Co Ltd', 'Fitzgerald Gouges', 'Fergie', NULL, 'fergie.fitzgerald@hotmail.com', 'Avenue Cutty Sark, Morcellement Raffray', 'Albion', '2385678', '54289372', '', 'IBL Brandactiv Ltd', 'Gouges\r\nFitzgerald\r\nGouges', 'Patrick\r\nFloyd\r\nGuillaume', '', '2384678\r\n', '54977608\r\n52515204', '', '', '', '', '1'),
(33, 'Farineau', 'Francois', NULL, 'ffarineau@hotmail.fr', 'Avenue Saint Géran', 'Albion', '', '57193043', '', '', 'Sabourin', 'Elsa', NULL, 'elsasabourin@hotmail.com', 'Ave Saint Géran', 'Albion', '', '52514750', '', 'Ambassade de France', 'n/a', '', '', '', '', '', '', '', '', '1'),
(34, 'Beguinot', 'Cédric', NULL, 'berguinotcedric@yahoo.co.uk', '26, Avenue Indépendence, Sunset View', 'Roche Brunes', '', '54984985 / 57136901', '', 'South Suez Capital\r\nPointe aux Canonniers', 'Leveque', 'Anne-Sophie', NULL, 'annesophie-@outlook.com', '26 Avenue Indépendence, Sunset View', 'Roche Brunes', '', '59278234', '', 'ICPS\r\nPailles', 'Beguinot', 'Jean-Claude', 'Grand-Père', '2384658', '59775484', '', '', '', '', '1'),
(35, 'Cadoux', 'Mathieu', NULL, 'mathieu.cadoux@gmail.com', 'Sugarroof, Avenue Lilas', 'Flic en Flac', '', '54835027', '', 'Pharmacie Nouvelle Ltée\r\nPailles', 'Adam', 'Alison', NULL, '', 'Lot 15, Curly Willow, Splendid View', 'Albion', '', '59189548', '', 'Pharmacie Nouvelle Ltée\r\nPailles', 'l', 'Jason\r\nMarie-Claude\r\nCyri', 'Oncle\r\nGrand-mère\r\nGrand-père', '', '58171069\r\n57917843\r\n59403645', '', '', '', '', '1'),
(36, 'Chan Chin', 'Warren', '1989-02-03', 'wcc-153@hotmail.com', 'Avenue des Perruches, morcellement Belle Vue', 'Albion', '2370141', '54959382 54908841', '', 'Axess Ltd\r\nPailles', 'Tuyan- Chan Chin', 'Laur', '1989-01-17', 'laura-capri.17@hotmail.com', 'Avenue des Perruches\r\nMorcellement Belle Vue', 'Albion', '2370141', '54292003', 'Housewife', '', 'Tuyau', 'Alain', 'Grand-Père', '', '57467939', '', '', '', '', '1'),
(37, 'Manikam', 'Marvin Thomas', '1993-08-14', 'thomasmanikam@yahoo.com', 'Cnr Le Merle, Begonia Avenue', 'Albion', '', '59389666', '', 'MSAW', 'Manikam', 'Anne Marie Celine', '1993-02-02', 'celinemilate@gmail.com', '', '', '57044029', '59301801', '', 'Mauritius Meat Authority', 'Manikam', 'Jerry', 'Oncle', '', '52512041\r\n57248782', '', '', '', '', '1'),
(38, 'Levasseur', 'Arnaud', '1987-07-27', 'arnaud.levasseur.lead@gmail.com', '43, Avenue des Bengalis, Morcellement Terre D\'Albion', 'Albion', '', '59166353', '', 'MCB', 'Levasseur', 'Kate', '1988-06-13', 'kate.levasseur13@gmail.com', '43, Avenue des Bengalis, Morcellement Terres d\'Albion', 'Albion', '', '57834393', '', 'MCB', 'Pierette ', 'Dacruz', 'Grand-Mère', '', '59875882', '', '', '', '', '1'),
(39, 'Arimond ', 'Gilles', '1982-08-28', 'gillesarimond82@gmail.com', 'Lot 83 Avenue Cateaux Vert Morc Petite Bretagne', 'Albion', '2370430', '57774094', '', 'MCB RIVIERE DES ANGUILLES', 'Danré', 'Virginie', '1992-02-27', 'vdanre@outlook.com', 'Lot 83, Avenue Cateaux Vert, Morcellement Petite Bretagne', 'Albion', '', '57717321', '', 'MCB ST JEAN', 'Danré\r\nDanré', 'Mario\r\nCheryl', 'Grand-père\r\nGrand-Mère', '', '58081877\r\n57762409', '', '', '', '', '1'),
(40, 'Lavictoire', 'Nicolas', NULL, '', 'Avenue Saint Géran, Morcellement Raffray', 'Albion', '', '57903558 / 52534625', '', 'Summertimes', 'Goder', 'Laurence', NULL, 'laurence29@hotmail.com', 'Avenue Saint Geran, Morcellement Raffray', 'Albion', '', '58084211', '', 'Anahita Estates Ltd', 'Goder ', 'Marie Claude', 'Grand Mère', '2384455', '57830962', '', '', '', '', '1'),
(41, 'Domingue', 'Olivier', '1988-11-16', 'olivier-domingue@live.co.uk', 'Lot 343 Morc De Chazal', 'Albion', '', '58498132', '', 'MCB', 'L\'Assemillante', 'Sandrine', NULL, 'sandrine-lassemillante@hotmail.com', '', '', '', '5849054', '', 'FEMME AU FOYER', 'LASSEMILLANTE\r\nLASSEMMILLANTE', 'JACQUES\r\nAUDREY', '', '', '52536048\r\n59164185', '', '', '', '', '1'),
(42, 'Kerville', 'Clovis', '1986-09-23', '', 'Belle Vue Phare', 'Albion', '', '59807887', 'Dolswim', '', 'René', 'Beatrice Desirella', '1995-09-08', 'desirela.b.rene@accenture.com', '', '', '', '54844310', 'Accenture', 'Accenture', 'René', 'Dorine', 'Grand-Mère', '', '58094133', '', '', '', '', '1'),
(43, 'Mungroo', 'Vishant', NULL, 'vishant08@gmail.com', '163, Avenue des Dahlias Morc Raffray', 'Albion', '2371570', '57491246', '', 'LUCRIN MTIUS LTD MOKA BUSINESS PARK', 'Mungroo', 'Janysha', NULL, 'janysha10@gmail.com', '', '', '', '59899937', 'Housewife', '', 'Lutchmee Muddapah', 'Lutchmee', 'Grand-mère', '', '57215994', '', '', '', '', '1'),
(44, 'Fidelle', 'Mathieu Donovan', '1992-06-12', '', 'Morcellement Petite Bretagne', 'Albion', '', '57903929', '', 'Alu Gates\r\nJin Fei', 'Hermans Fidelle', 'Deborah Kelly', '1994-07-04', 'deborahhermans@hotmail.com', '', '', '', '57803207', 'Banquiere', 'MCB \r\nSaint Jean', 'Hermans', 'Johan', 'Parrain', '', '58079164', '', '', '', '', '1'),
(45, 'Thomas', 'Romain', '1987-02-13', 'rt0047@gmail.com', 'Avenue Ouragan', 'Albion', '', '57021417', 'Prof de maths', 'Lycée des Mascareignes ', 'Vykopalova', 'Zusana', '1988-05-31', 'zuzanavykopalova@gmail.com', 'Avenue Ouragan', 'Albion', '', '57021428', 'Femme au foyet', '', '', 'Clévio', 'Ami', '', '52597822', '', '', '', '', '1'),
(46, 'Jeannot', 'Alexandre', '1993-12-04', 'ajeannot93@gmail.com', '10 Avenue des noisettes, Morc Rey', 'Pointe aux Sables', '', '57150805', 'Medecin', 'Medecin à domicile', 'Jeannot', 'Laeticia', '2000-12-19', 'laeticiaalexj@gmail.com', '', '', '', '58192927', 'Etudiante', '', '', '', 'Grand-père', '', '52598854', '', '', '', '', '1'),
(47, 'Moonesamy ', 'Christophe', '1991-09-17', 'christophe.arius@gmail.com', 'Morcellement Raffray, Avenue Victory', 'Albion', '2371831', '57587932', 'Gout SA ', 'SELF EMPLOYED', 'Moonesamy', 'Heena', '1990-10-12', 'heena.moonesamy@safyrmu.com', '', '', '', '57805601', '', 'Safyr Capital Partners Ltd', 'Gopaul\r\nMoonesamy', 'Nitish Gopaul\r\nBrandon Moonesamy', 'Oncle\r\nOncle', '', '59861011\r\n58005659\r\n', '', '', '', '', '1'),
(48, 'Paul', 'Pierre-Yves', NULL, 'pierreyves.paul@outlook.com', 'Avenue Saint Geran', 'Albion', '', '52535230', 'Entrepreneur', '', 'Chung-Kai-To', 'Rachel', NULL, 'r.chungkaito@gmail.com', '', '', '', '52569577', 'N:A', '', 'Gérard et Ariane Paul\r\nMarie-Noelle Chung-Kai-To', '', 'grand-parents\r\n', '', '52534533 / 59392086\r\n59279881', '', '', '', '', '1'),
(49, 'Chervonnyi', 'Arthur', NULL, 'arturhervonnyi@gmail.com', 'Ave des Tourtereaux', 'Flic en Flac', '', '', '', 'Abinber\r\nUnicity / Medine', 'Chervonnyi', 'Joanita', NULL, 'joanita.quirin@gmail.com', '', '', '', '52529720', '', 'Abinber\r\nUnicity / Medine', 'Curtis Quirin - Grand-Père\r\nJonathan Quirin - Oncle', '', '', '', '54987574\r\n57219466', '', '', '', '', '1'),
(50, 'Luppens', 'Arnaud', '1986-05-28', 'aluppens@gmail.com', '348 Avenue des Cygnes, Terre d\'Albion', 'Albion', '', '59858871', '', 'Aquarelle Group, Boundary Rd Q Bornes', 'Labour', 'Odile', '1986-05-26', 'aoluppens@gmail.com', '', '', '', '57980901', '', 'Dauerflora Ave Victory Albion', 'Marilyn Labour\r\nRichard Labour', '', 'Grand-mère\r\nGrand-père\r\n', '', '57874334\r\n59776507', '', '', '', '', '1');

-- --------------------------------------------------------

--
-- Table structure for table `creche_paye`
--

CREATE TABLE `creche_paye` (
  `id_creche_paye` int(11) NOT NULL,
  `id_personnel` int(11) NOT NULL,
  `month` date NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `creche_paye`
--

INSERT INTO `creche_paye` (`id_creche_paye`, `id_personnel`, `month`) VALUES
(1, 4, '2020-05-01'),
(2, 4, '2020-04-01'),
(3, 5, '2020-05-01'),
(4, 7, '2020-05-01'),
(5, 8, '2020-05-01'),
(6, 6, '2020-05-01'),
(7, 4, '2020-06-01'),
(8, 3, '2020-05-01'),
(9, 3, '2020-09-01'),
(10, 3, '2019-09-01'),
(11, 5, '2020-06-01'),
(12, 5, '2020-06-01'),
(13, 10, '2020-06-01'),
(14, 10, '2020-06-01'),
(16, 6, '2020-06-01'),
(17, 5, '2020-07-01'),
(21, 4, '2020-07-01'),
(23, 10, '2020-07-01'),
(24, 11, '2020-07-01'),
(28, 7, '2020-07-01'),
(29, 4, '2020-08-01'),
(30, 10, '2020-08-01'),
(31, 5, '2020-04-01'),
(36, 11, '2020-08-01'),
(37, 5, '2020-08-01'),
(38, 4, '2020-09-01'),
(39, 4, '2020-09-01'),
(40, 4, '2020-09-01'),
(41, 5, '2020-09-01'),
(42, 10, '2020-09-01'),
(43, 12, '2020-09-01'),
(44, 11, '2020-09-01'),
(45, 11, '2020-10-01'),
(46, 4, '2020-10-01'),
(47, 5, '2020-10-01'),
(48, 5, '2020-10-01'),
(49, 12, '2020-10-01'),
(50, 12, '2020-10-01'),
(51, 13, '2020-10-01'),
(52, 4, '2020-11-01'),
(53, 5, '2020-11-01'),
(54, 5, '2020-11-01'),
(55, 12, '2020-11-01'),
(56, 13, '2020-11-01'),
(57, 8, '2020-12-01'),
(58, 12, '2020-12-01'),
(59, 12, '2020-12-01'),
(60, 13, '2020-12-01'),
(61, 4, '2020-12-01'),
(62, 5, '2020-12-01'),
(63, 5, '2020-12-01'),
(64, 5, '2021-01-01'),
(65, 13, '2021-01-01'),
(66, 4, '2021-01-01'),
(67, 12, '2021-01-01'),
(68, 12, '2021-01-01'),
(69, 12, '2021-01-01'),
(70, 5, '2021-02-01'),
(71, 13, '2021-02-01'),
(72, 13, '2021-02-01'),
(73, 13, '2021-02-01'),
(74, 13, '2021-02-01'),
(75, 13, '2021-02-01'),
(76, 14, '2021-02-01'),
(77, 14, '2021-02-01'),
(78, 16, '2021-02-01'),
(79, 17, '2021-02-01'),
(80, 18, '2021-02-01'),
(81, 7, '2021-02-01'),
(82, 8, '2021-02-01'),
(83, 7, '2021-01-01'),
(84, 8, '2021-01-01'),
(85, 14, '2020-12-01'),
(86, 14, '2021-01-01'),
(89, 5, '2021-03-01'),
(90, 13, '2021-03-01'),
(91, 16, '2021-03-01'),
(92, 14, '2021-03-01'),
(93, 17, '2021-03-01'),
(94, 1, '2021-03-01'),
(95, 2, '2021-04-01'),
(96, 5, '2021-04-01'),
(97, 13, '2021-04-01'),
(98, 14, '2021-04-01'),
(99, 16, '2021-04-01'),
(100, 16, '2021-04-01'),
(101, 17, '2021-04-01'),
(102, 7, '2021-04-01'),
(103, 5, '2021-05-01'),
(104, 13, '2021-05-01'),
(105, 2, '2021-05-01'),
(106, 16, '2021-05-01'),
(107, 14, '2021-05-01'),
(108, 14, '2021-05-01'),
(109, 13, '2021-07-01'),
(110, 2, '2021-06-01'),
(111, 16, '2021-06-01'),
(112, 14, '2021-06-01'),
(113, 2, '2021-07-01'),
(114, 14, '2021-07-01'),
(115, 16, '2021-07-01'),
(116, 2, '2021-08-01'),
(117, 14, '2021-08-01'),
(118, 16, '2021-08-01'),
(119, 2, '2021-10-01'),
(120, 2, '2021-10-01'),
(121, 2, '2021-10-01'),
(122, 2, '2021-10-01'),
(123, 2, '2021-10-01'),
(124, 2, '2021-10-01'),
(125, 2, '2021-10-01'),
(126, 2, '2021-10-01'),
(127, 2, '2021-09-01'),
(128, 14, '2021-09-01'),
(129, 16, '2021-09-01'),
(130, 16, '2021-10-01'),
(131, 14, '2021-10-01'),
(132, 19, '2021-10-01'),
(133, 1, '2021-10-01'),
(134, 2, '2021-11-01'),
(135, 14, '2021-11-01'),
(136, 16, '2021-11-01'),
(137, 19, '2021-11-01'),
(138, 2, '2021-12-01'),
(139, 14, '2021-12-01'),
(140, 16, '2021-12-01'),
(141, 16, '2021-12-01'),
(142, 16, '2021-12-01'),
(143, 16, '2021-12-01'),
(144, 16, '2021-12-01'),
(145, 19, '2021-12-01'),
(146, 14, '2022-01-01'),
(147, 2, '2022-01-01'),
(148, 16, '2022-01-01'),
(149, 19, '2022-01-01'),
(150, 2, '2022-02-01'),
(151, 16, '2022-02-01'),
(152, 19, '2022-02-01'),
(153, 20, '2022-02-01'),
(154, 16, '2022-03-01'),
(155, 2, '2022-03-01'),
(156, 19, '2022-03-01'),
(157, 20, '2022-03-01'),
(158, 21, '2022-03-01'),
(159, 22, '2022-03-01'),
(160, 16, '2021-01-01'),
(161, 2, '2022-06-01'),
(162, 2, '2022-08-01'),
(163, 20, '2022-04-01'),
(164, 2, '2022-04-01'),
(165, 2, '2022-04-01'),
(166, 2, '2022-04-01'),
(167, 2, '2022-04-01'),
(168, 2, '2022-04-01'),
(169, 2, '2022-04-01'),
(170, 19, '2022-04-01'),
(171, 21, '2022-04-01'),
(172, 22, '2022-04-01'),
(173, 1, '2022-04-01'),
(174, 2, '2022-05-01'),
(175, 19, '2022-05-01'),
(176, 20, '2022-05-01'),
(177, 21, '2022-05-01'),
(178, 22, '2022-05-01'),
(179, 1, '2022-05-01'),
(180, 21, '2022-06-01'),
(181, 19, '2022-06-01'),
(182, 20, '2022-06-01'),
(183, 22, '2022-06-01'),
(184, 22, '2022-06-01'),
(185, 22, '2022-06-01'),
(186, 22, '2022-06-01'),
(187, 1, '2022-06-01'),
(188, 7, '2022-06-01'),
(189, 7, '2022-07-01'),
(190, 19, '2022-07-01'),
(191, 20, '2022-07-01'),
(192, 22, '2022-07-01'),
(193, 23, '2022-07-01'),
(194, 24, '2022-07-01'),
(195, 1, '2022-07-01'),
(196, 20, '2022-08-01'),
(197, 24, '2022-08-01'),
(198, 19, '2022-08-01'),
(199, 19, '2022-08-01'),
(200, 22, '2022-08-01'),
(201, 23, '2022-08-01'),
(202, 1, '2022-08-01'),
(203, 25, '2022-08-01'),
(204, 22, '2022-09-01'),
(205, 22, '2022-10-01'),
(206, 20, '2022-09-01'),
(207, 19, '2022-09-01'),
(208, 19, '2022-10-01'),
(209, 23, '2022-09-01'),
(210, 25, '2022-09-01'),
(211, 24, '2022-09-01'),
(212, 7, '2022-09-01'),
(213, 1, '2022-09-01'),
(214, 20, '2022-10-01'),
(215, 23, '2022-10-01'),
(216, 7, '2022-10-01'),
(217, 20, '2022-11-01'),
(218, 19, '2022-11-01'),
(219, 22, '2022-11-01'),
(220, 23, '2022-11-01'),
(221, 25, '2022-11-01'),
(222, 1, '2022-11-01'),
(223, 1, '2023-01-01'),
(224, 20, '2022-12-01'),
(225, 19, '2022-12-01'),
(226, 22, '2022-12-01'),
(227, 23, '2022-12-01'),
(228, 25, '2022-12-01'),
(229, 1, '2022-12-01'),
(230, 19, '2023-01-01'),
(231, 20, '2023-01-01'),
(232, 20, '2023-01-01'),
(233, 22, '2023-01-01'),
(234, 23, '2023-01-01'),
(235, 7, '2023-01-01'),
(236, 20, '2023-02-01'),
(237, 19, '2023-02-01'),
(238, 22, '2023-02-01'),
(239, 23, '2023-02-01'),
(240, 25, '2023-02-01'),
(241, 7, '2023-02-01'),
(242, 1, '2023-02-01'),
(243, 1, '2023-03-01'),
(244, 19, '2023-03-01'),
(245, 20, '2023-03-01'),
(246, 22, '2023-03-01'),
(247, 23, '2023-03-01'),
(248, 26, '2023-03-01'),
(249, 26, '2023-04-01'),
(250, 19, '2023-04-01'),
(251, 20, '2023-04-01'),
(252, 22, '2023-04-01'),
(253, 23, '2023-04-01'),
(254, 1, '2023-04-01'),
(255, 7, '2023-04-01'),
(256, 19, '2023-05-01'),
(257, 20, '2023-05-01'),
(258, 22, '2023-05-01'),
(259, 23, '2023-05-01'),
(260, 26, '2023-05-01'),
(261, 7, '2023-05-01'),
(262, 1, '2023-05-01'),
(263, 19, '2023-06-01'),
(264, 26, '2023-06-01'),
(265, 23, '2023-06-01'),
(266, 22, '2023-06-01'),
(267, 20, '2023-06-01'),
(268, 20, '2023-06-01'),
(269, 7, '2023-06-01'),
(270, 7, '2023-06-01'),
(271, 1, '2023-06-01'),
(272, 20, '2023-07-01'),
(273, 19, '2023-07-01'),
(274, 22, '2023-07-01'),
(275, 23, '2023-07-01'),
(276, 26, '2023-07-01'),
(277, 1, '2023-07-01');

-- --------------------------------------------------------

--
-- Table structure for table `creche_paye_details`
--

CREATE TABLE `creche_paye_details` (
  `id_creche_paye_detail` int(11) NOT NULL,
  `rubrique` varchar(50) NOT NULL,
  `quantity` int(10) UNSIGNED DEFAULT NULL,
  `amount` double DEFAULT NULL,
  `pourcent` decimal(4,1) DEFAULT NULL,
  `of_id_creche_paye_detail` int(11) DEFAULT NULL,
  `id_creche_paye` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `creche_paye_details`
--

INSERT INTO `creche_paye_details` (`id_creche_paye_detail`, `rubrique`, `quantity`, `amount`, `pourcent`, `of_id_creche_paye_detail`, `id_creche_paye`) VALUES
(1, 'Salaire de base', 176, 55.11364, NULL, NULL, 1),
(2, 'Transport', 0, 54, NULL, NULL, 1),
(3, 'NFP', NULL, 0, -3.0, 1, 1),
(4, 'NSF', NULL, NULL, -1.0, 1, 1),
(5, 'Salaire de base', 176, 55.11364, NULL, NULL, 2),
(6, 'Transport', 22, 54, NULL, NULL, 2),
(7, 'NFP', NULL, NULL, -3.0, 5, 2),
(8, 'NSF', NULL, NULL, -1.0, 5, 2),
(9, 'Salaire de base', 176, 55.11364, NULL, NULL, 3),
(10, 'Transport', 0, 54, NULL, NULL, 3),
(11, 'NFP', NULL, NULL, -3.0, 9, 3),
(12, 'NSF', NULL, NULL, -1.0, 9, 3),
(13, 'Salaire de base', 1, 2000, NULL, NULL, 4),
(14, 'Transport', 0, 0, NULL, NULL, 4),
(15, 'NFP', NULL, 0, 0.0, 13, 4),
(16, 'NSF', NULL, 0, 0.0, 13, 4),
(17, 'Salaire de base', 0, 0, NULL, NULL, 5),
(18, 'Transport', 0, 0, NULL, NULL, 5),
(19, 'NFP', NULL, 0, 0.0, 17, 5),
(20, 'NSF', NULL, 0, 0.0, 17, 5),
(21, 'Salaire de base', 0, 0, NULL, NULL, 6),
(22, 'Transport', 0, 0, NULL, NULL, 6),
(23, 'NFP', NULL, 0, 0.0, 22, 6),
(24, 'NSF', NULL, 0, 0.0, 22, 6),
(25, 'Salaire de base', 176, 55.11364, NULL, NULL, 7),
(26, 'Transport', 20, 54, NULL, NULL, 7),
(27, 'NFP', NULL, NULL, -3.0, 25, 7),
(28, 'NSF', NULL, NULL, -1.0, 25, 7),
(29, 'Salaire de base', 176, 55.11364, NULL, NULL, 8),
(30, 'Transport', 22, 54, NULL, NULL, 8),
(31, 'NFP', NULL, NULL, -3.0, 29, 8),
(32, 'NSF', NULL, NULL, -1.0, 29, 8),
(33, 'Salaire de base', 0, 55.11364, NULL, NULL, 9),
(34, 'Transport', 0, 54, NULL, NULL, 9),
(35, 'NFP', NULL, 0, 0.0, 33, 9),
(36, 'NSF', NULL, 0, 0.0, 33, 9),
(37, 'Salaire de base', 2, 404.55, NULL, NULL, 10),
(38, 'Transport', 0, 54, NULL, NULL, 10),
(39, 'NFP', NULL, 0, 0.0, 37, 10),
(40, 'NSF', NULL, 0, 0.0, 37, 10),
(41, 'Salaire de base', 176, 55.11364, NULL, NULL, 11),
(42, 'Transport', 20, 62, NULL, NULL, 11),
(43, 'NFP', NULL, NULL, -3.0, 41, 11),
(44, 'NSF', NULL, NULL, -1.0, 41, 11),
(45, 'Salaire de base', 176, 55.11364, NULL, NULL, 12),
(46, 'Transport', 22, 54, NULL, NULL, 12),
(47, 'NFP', NULL, NULL, -3.0, 45, 12),
(48, 'NSF', NULL, NULL, -1.0, 45, 12),
(49, 'Salaire de base', 1, 2270, NULL, NULL, 13),
(50, 'Transport', 0, 0, NULL, NULL, 13),
(51, 'NFP', NULL, 0, 0.0, 49, 13),
(52, 'NSF', NULL, 0, 0.0, 49, 13),
(53, 'Salaire de base', 176, 55.11364, NULL, NULL, 14),
(54, 'Transport', 22, 54, NULL, NULL, 14),
(55, 'NFP', NULL, NULL, -3.0, 53, 14),
(56, 'NSF', NULL, NULL, -1.0, 53, 14),
(61, 'Salaire de base', 1, 4000, NULL, NULL, 16),
(62, 'Transport', 0, 0, NULL, NULL, 16),
(63, 'NFP', NULL, 0, 0.0, 61, 16),
(64, 'NSF', NULL, 0, 0.0, 61, 16),
(65, 'Salaire de base', 176, 55.11364, NULL, NULL, 17),
(66, 'Transport', 21, 62, NULL, NULL, 17),
(67, 'NFP', NULL, NULL, -3.0, 65, 17),
(68, 'NSF', NULL, NULL, -1.0, 65, 17),
(71, 'Arrêt maladie du 13 et 21 juil 2020', 1, -882, NULL, NULL, 17),
(76, 'Salaire de base', 176, 55.11364, NULL, NULL, 19),
(77, 'Transport', 22, 54, NULL, NULL, 19),
(78, 'NFP', NULL, NULL, -3.0, 76, 19),
(79, 'NSF', NULL, NULL, -1.0, 76, 19),
(84, 'Salaire de base', 176, 55.11364, NULL, NULL, 21),
(85, 'Transport', 15, 54, NULL, NULL, 21),
(86, 'NFP', NULL, NULL, -3.0, 84, 21),
(87, 'NSF', NULL, NULL, -1.0, 84, 21),
(92, 'Salaire de base', 1, 5000, NULL, NULL, 23),
(93, 'Transport', 0, 0, NULL, NULL, 23),
(94, 'NFP', NULL, 0, 0.0, 92, 23),
(95, 'NSF', NULL, 0, 0.0, 92, 23),
(96, 'Salaire de base', 1, 3672, NULL, NULL, 24),
(97, 'Transport', 18, 54, NULL, NULL, 24),
(98, 'NFP', NULL, 0, 0.0, 96, 24),
(99, 'NSF', NULL, 0, 0.0, 96, 24),
(100, 'Déduction transport aller du 13 juillet', 1, -27, NULL, NULL, 24),
(113, 'Salaire de base', 1, 2000, NULL, NULL, 28),
(114, 'Transport', 1, 0, NULL, NULL, 28),
(115, 'NFP', NULL, 0, 0.0, 113, 28),
(116, 'NSF', NULL, 0, 0.0, 113, 28),
(117, 'Salaire de base', 176, 55.11364, NULL, NULL, 29),
(118, 'Transport', 19, 54, NULL, NULL, 29),
(119, 'NFP', NULL, NULL, -3.0, 117, 29),
(120, 'NSF', NULL, NULL, -1.0, 117, 29),
(121, 'Salaire de base', 1, 5000, NULL, NULL, 30),
(122, 'Transport', 1, 0, NULL, NULL, 30),
(123, 'NFP', NULL, 0, 0.0, 121, 30),
(124, 'NSF', NULL, 0, 0.0, 121, 30),
(125, 'Salaire de base', 176, 55.11364, NULL, NULL, 31),
(126, 'Transport', 22, 54, NULL, NULL, 31),
(127, 'NFP', NULL, NULL, -3.0, 125, 31),
(128, 'NSF', NULL, NULL, -1.0, 125, 31),
(146, 'Salaire de base', 1, 4500, NULL, NULL, 36),
(147, 'Transport', 21, 54, NULL, NULL, 36),
(148, 'NFP', NULL, 0, 0.0, 146, 36),
(149, 'NSF', NULL, 0, 0.0, 146, 36),
(150, 'Salaire de base', 1, 9700, NULL, NULL, 37),
(151, 'Transport', 19, 62, NULL, NULL, 37),
(152, 'NFP', NULL, NULL, -3.0, 150, 37),
(153, 'NSF', NULL, NULL, -1.0, 150, 37),
(154, 'Déduction congés (2 jours)', 2, -441, NULL, NULL, 37),
(155, 'Salaire de base', 176, 55.11364, NULL, NULL, 38),
(156, 'Transport', 18, 54, NULL, NULL, 38),
(157, 'NFP', NULL, NULL, -3.0, 155, 38),
(158, 'NSF', NULL, NULL, -1.0, 155, 38),
(159, 'Salaire de base', 176, 55.11364, NULL, NULL, 39),
(160, 'Transport', 22, 54, NULL, NULL, 39),
(161, 'NFP', NULL, NULL, -3.0, 159, 39),
(162, 'NSF', NULL, NULL, -1.0, 159, 39),
(163, 'Salaire de base', 176, 55.11364, NULL, NULL, 40),
(164, 'Transport', 22, 54, NULL, NULL, 40),
(165, 'NFP', NULL, NULL, -3.0, 163, 40),
(166, 'NSF', NULL, NULL, -1.0, 163, 40),
(167, 'Salaire de base', 176, 55.11364, NULL, NULL, 41),
(168, 'Transport', 19, 62, NULL, NULL, 41),
(169, 'NFP', NULL, NULL, -3.0, 167, 41),
(170, 'NSF', NULL, NULL, -1.0, 167, 41),
(171, 'Salaire de base', 1, 5000, NULL, NULL, 42),
(172, 'Transport', 0, 0, NULL, NULL, 42),
(173, 'NFP', NULL, 0, 0.0, 171, 42),
(174, 'NSF', NULL, 0, 0.0, 171, 42),
(175, 'Salaire de base', 1, 7000, NULL, NULL, 43),
(176, 'Transport', 17, 108, NULL, NULL, 43),
(177, 'NFP', NULL, 0, 0.0, 175, 43),
(178, 'NSF', NULL, 0, 0.0, 175, 43),
(179, 'Déduction au prorata du 01 au 07, 5 jrs', 1, -1590, NULL, NULL, 43),
(180, 'Salaire de base', 1, 4500, NULL, NULL, 44),
(181, 'Transport', 21, 54, NULL, NULL, 44),
(182, 'NFP', NULL, 0, 0.0, 180, 44),
(183, 'NSF', NULL, 0, 0.0, 180, 44),
(184, 'Déduction absence', 1, -204, NULL, NULL, 44),
(187, 'Déductions absences', 1, -1323, NULL, NULL, 41),
(188, 'Salaire de base', 1, 0, NULL, NULL, 45),
(189, 'Transport', 2, 54, NULL, NULL, 45),
(190, 'NFP', NULL, 0, 0.0, 188, 45),
(191, 'NSF', NULL, 0, 0.0, 188, 45),
(192, 'Paiement journalier du 1 et 2 oct', 2, 204.5, NULL, NULL, 45),
(193, 'Salaire de base', 176, 55.11364, NULL, NULL, 46),
(194, 'Transport', 18, 54, NULL, NULL, 46),
(195, 'NFP', NULL, NULL, -3.0, 193, 46),
(196, 'NSF', NULL, NULL, -1.0, 193, 46),
(198, 'Salaire de base', 176, 55.11364, NULL, NULL, 47),
(199, 'Transport', 20, 62, NULL, NULL, 47),
(200, 'NFP', NULL, NULL, -3.0, 198, 47),
(201, 'NSF', NULL, NULL, -1.0, 198, 47),
(202, 'Salaire de base', 176, 55.11364, NULL, NULL, 48),
(203, 'Transport', 22, 54, NULL, NULL, 48),
(204, 'NFP', NULL, NULL, -3.0, 202, 48),
(205, 'NSF', NULL, NULL, -1.0, 202, 48),
(206, 'Déduction absence du 29, 30', 1, -882, NULL, NULL, 47),
(207, 'Salaire de base', 1, 7000, NULL, NULL, 49),
(208, 'Transport', 22, 108, NULL, NULL, 49),
(209, 'NFP', NULL, 0, 0.0, 207, 49),
(210, 'NSF', NULL, 0, 0.0, 207, 49),
(211, 'Salaire de base', 176, 55.11364, NULL, NULL, 50),
(212, 'Transport', 22, 54, NULL, NULL, 50),
(213, 'NFP', NULL, NULL, -3.0, 211, 50),
(214, 'NSF', NULL, NULL, -1.0, 211, 50),
(215, 'Salaire de base', 1, 5200, NULL, NULL, 51),
(216, 'Transport', 0, 0, NULL, NULL, 51),
(217, 'NFP', NULL, 0, 0.0, 219, 51),
(218, 'NSF', NULL, 0, 0.0, 219, 51),
(219, 'Heures additionnels, 13,15,19,20,29,30', 1, 846, NULL, NULL, 51),
(220, 'Salaire de base', 176, 55.11364, NULL, NULL, 52),
(221, 'Transport', 18, 54, NULL, NULL, 52),
(222, 'NFP', NULL, NULL, -3.0, 220, 52),
(223, 'NSF', NULL, NULL, -1.0, 220, 52),
(224, 'Salaire de base', 176, 55.11364, NULL, NULL, 53),
(225, 'Transport', 19, 62, NULL, NULL, 53),
(226, 'NFP', NULL, NULL, -3.0, 224, 53),
(227, 'NSF', NULL, NULL, -1.0, 224, 53),
(228, 'Salaire de base', 176, 55.11364, NULL, NULL, 54),
(229, 'Transport', 22, 54, NULL, NULL, 54),
(230, 'NFP', NULL, NULL, -3.0, 228, 54),
(231, 'NSF', NULL, NULL, -1.0, 228, 54),
(232, 'déduction du 16 nov', 1, -441, NULL, NULL, 53),
(233, 'Salaire de base', 1, 7000, NULL, NULL, 55),
(234, 'Transport', 18, 108, NULL, NULL, 55),
(235, 'NFP', NULL, 0, 0.0, 233, 55),
(236, 'NSF', NULL, 0, 0.0, 233, 55),
(237, 'déduction du 4 et 24 novembre', 1, -636, NULL, NULL, 55),
(238, 'Salaire de base', 1, 5200, NULL, NULL, 56),
(239, 'Transport', 0, 0, NULL, NULL, 56),
(240, 'NFP', NULL, 0, 0.0, 238, 56),
(241, 'NSF', NULL, 0, 0.0, 238, 56),
(242, 'heures additionnels 3,4,6,9,16,24', 1, 1128, NULL, NULL, 56),
(243, 'Salaire de base', 176, 55.11364, NULL, NULL, 57),
(244, 'Transport', 22, 54, NULL, NULL, 57),
(245, 'NFP', NULL, NULL, -3.0, 243, 57),
(246, 'NSF', NULL, NULL, -1.0, 243, 57),
(247, 'Salaire de base', 1, 7000, NULL, NULL, 58),
(248, 'Transport', 22, 108, NULL, NULL, 58),
(249, 'NFP', NULL, 0, 0.0, 247, 58),
(250, 'NSF', NULL, 0, 0.0, 247, 58),
(251, 'Salaire de base', 176, 55.11364, NULL, NULL, 59),
(252, 'Transport', 22, 54, NULL, NULL, 59),
(253, 'NFP', NULL, NULL, -3.0, 251, 59),
(254, 'NSF', NULL, NULL, -1.0, 251, 59),
(255, 'Salaire de base', 176, 55.11364, NULL, NULL, 60),
(256, 'Transport', 1, 0, NULL, NULL, 60),
(257, 'NFP', NULL, 0, 0.0, 255, 60),
(258, 'NSF', NULL, 0, 0.0, 255, 60),
(259, 'Salaire de base', 176, 55.11364, NULL, NULL, 61),
(260, 'Transport', 20, 54, NULL, NULL, 61),
(261, 'NFP', NULL, NULL, -3.0, 259, 61),
(262, 'NSF', NULL, NULL, -1.0, 259, 61),
(263, 'Salaire de base', 176, 55.11364, NULL, NULL, 62),
(264, 'Transport', 19, 62, NULL, NULL, 62),
(265, 'NFP', NULL, NULL, -3.0, 263, 62),
(266, 'NSF', NULL, NULL, -1.0, 263, 62),
(267, 'Salaire de base', 176, 55.11364, NULL, NULL, 63),
(268, 'Transport', 22, 54, NULL, NULL, 63),
(269, 'NFP', NULL, NULL, -3.0, 267, 63),
(270, 'NSF', NULL, NULL, -1.0, 267, 63),
(271, 'Salaire de base', 1, 10075, NULL, NULL, 64),
(272, 'Transport', 10, 62, NULL, NULL, 64),
(273, 'CGS', NULL, 0, -1.5, 271, 64),
(274, 'NSF', NULL, NULL, -1.0, 271, 64),
(275, 'Salaire de base', 1, 10075, NULL, NULL, 65),
(276, 'Transport', 10, 0, NULL, NULL, 65),
(277, 'CGS', NULL, 0, -1.5, 275, 65),
(278, 'NSF', NULL, NULL, -1.0, 275, 65),
(279, 'Salaire de base', 1, 10075, NULL, NULL, 66),
(280, 'Transport', 0, 54, NULL, NULL, 66),
(281, 'CGS', NULL, 0, -1.5, 279, 66),
(282, 'NSF', NULL, NULL, -1.0, 279, 66),
(283, 'Déduction absence 2020 4.5 jours', 1, -1980, NULL, NULL, 66),
(284, 'Salaire de base', 0, 0, NULL, NULL, 67),
(285, 'Transport', 0, 0, NULL, NULL, 67),
(286, 'NFP', NULL, 0, 0.0, 284, 67),
(287, 'NSF', NULL, 0, 0.0, 284, 67),
(288, 'Salaire de base', 176, 55.11364, NULL, NULL, 68),
(289, 'Transport', 22, 54, NULL, NULL, 68),
(290, 'NFP', NULL, NULL, -3.0, 288, 68),
(291, 'NSF', NULL, NULL, -1.0, 288, 68),
(292, 'Salaire de base', 176, 55.11364, NULL, NULL, 69),
(293, 'Transport', 22, 54, NULL, NULL, 69),
(294, 'NFP', NULL, NULL, -3.0, 292, 69),
(295, 'NSF', NULL, NULL, -1.0, 292, 69),
(296, 'Payement exceptionnel au pro rata du 01 au 15 jan ', 1, 3499.98, NULL, NULL, 67),
(297, 'Base de salaire Rs 7000/11 jours', 1, -7000, NULL, NULL, 67),
(298, 'Salaire de base', 1, 10075, NULL, NULL, 70),
(299, 'Transport', 13, 62, NULL, NULL, 70),
(300, 'CGS', NULL, NULL, -1.5, 298, 70),
(301, 'NSF', NULL, NULL, -1.0, 298, 70),
(302, 'Salaire de base', 1, 10075, NULL, NULL, 71),
(303, 'Transport', 0, 0, NULL, NULL, 71),
(304, 'CGS', NULL, NULL, -1.5, 302, 71),
(305, 'NSF', NULL, NULL, -1.0, 302, 71),
(306, 'Salaire de base', 176, 55.11364, NULL, NULL, 72),
(307, 'Transport', 22, 54, NULL, NULL, 72),
(308, 'CGS', NULL, NULL, -1.5, 306, 72),
(309, 'NSF', NULL, NULL, -1.0, 306, 72),
(310, 'Salaire de base', 176, 55.11364, NULL, NULL, 73),
(311, 'Transport', 22, 54, NULL, NULL, 73),
(312, 'CGS', NULL, NULL, -1.5, 310, 73),
(313, 'NSF', NULL, NULL, -1.0, 310, 73),
(314, 'Salaire de base', 176, 55.11364, NULL, NULL, 74),
(315, 'Transport', 22, 54, NULL, NULL, 74),
(316, 'CGS', NULL, NULL, -1.5, 314, 74),
(317, 'NSF', NULL, NULL, -1.0, 314, 74),
(318, 'Salaire de base', 176, 55.11364, NULL, NULL, 75),
(319, 'Transport', 22, 54, NULL, NULL, 75),
(320, 'CGS', NULL, NULL, -1.5, 318, 75),
(321, 'NSF', NULL, NULL, -1.0, 318, 75),
(322, 'Salaire de base', 1, 7000, NULL, NULL, 76),
(323, 'Transport', 17, 48, NULL, NULL, 76),
(324, 'CGS', NULL, 0, 0.0, 322, 76),
(325, 'NSF', NULL, 0, 0.0, 322, 76),
(326, 'Salaire de base', 176, 55.11364, NULL, NULL, 77),
(327, 'Transport', 22, 54, NULL, NULL, 77),
(328, 'CGS', NULL, NULL, -1.5, 326, 77),
(329, 'NSF', NULL, NULL, -1.0, 326, 77),
(330, 'Salaire de base', 0, 7700, NULL, NULL, 78),
(331, 'Transport', 7, 62, NULL, NULL, 78),
(332, 'CGS', NULL, 0, 0.0, 330, 78),
(333, 'NSF', NULL, 0, 0.0, 330, 78),
(334, 'Salaire de base', 1, 724, NULL, NULL, 79),
(335, 'Transport', 0, 0, NULL, NULL, 79),
(336, 'CGS', NULL, 0, 0.0, 334, 79),
(337, 'NSF', NULL, 0, 0.0, 334, 79),
(338, 'Prorata du 23 au 26 février', 1, 0, NULL, NULL, 79),
(339, 'Salaire de base', 0, 4000, NULL, NULL, 80),
(340, 'Transport', 0, 0, NULL, NULL, 80),
(341, 'CGS', NULL, 0, 0.0, 339, 80),
(342, 'NSF', NULL, 0, 0.0, 339, 80),
(343, 'Prorata du 15 au 19 février', 1, 909, NULL, NULL, 80),
(344, 'Salaire de base', 1, 2000, NULL, NULL, 81),
(345, 'Transport', 0, 0, NULL, NULL, 81),
(346, 'CGS', NULL, 0, 0.0, 344, 81),
(347, 'NSF', NULL, 0, 0.0, 344, 81),
(348, 'Salaire de base', 1, 1600, NULL, NULL, 82),
(349, 'Transport', 0, 0, NULL, NULL, 82),
(350, 'CGS', NULL, 0, 0.0, 348, 82),
(351, 'NSF', NULL, 0, 0.0, 348, 82),
(352, 'Salaire de base', 1, 2000, NULL, NULL, 83),
(353, 'Transport', 0, 0, NULL, NULL, 83),
(354, 'CGS', NULL, 0, 0.0, 352, 83),
(355, 'NSF', NULL, 0, 0.0, 352, 83),
(356, 'Salaire de base', 1, 1600, NULL, NULL, 84),
(357, 'Transport', 0, 0, NULL, NULL, 84),
(358, 'CGS', NULL, 0, 0.0, 356, 84),
(359, 'NSF', NULL, 0, 0.0, 356, 84),
(360, 'Salaire de base', 176, 55.11364, NULL, NULL, 85),
(361, 'Transport', 22, 54, NULL, NULL, 85),
(362, 'Salaire de base', 0, 7000, NULL, NULL, 86),
(363, 'Transport', 4, 48, NULL, NULL, 86),
(364, 'CGS', NULL, NULL, -1.5, 360, 85),
(365, 'NSF', NULL, NULL, -1.0, 360, 85),
(366, 'CGS', NULL, 0, 0.0, 362, 86),
(367, 'NSF', NULL, 0, 0.0, 362, 86),
(368, 'Prorata 4 jours', 1, 1272, NULL, NULL, 86),
(369, 'Prorata 7 jours', 1, 2450, NULL, NULL, 78),
(378, 'Salaire de base', 1, 10075, NULL, NULL, 89),
(379, 'Transport', 5, 62, NULL, NULL, 89),
(380, 'CGS', NULL, NULL, -1.5, 378, 89),
(381, 'NSF', NULL, NULL, -1.0, 378, 89),
(382, 'nouvelle ligne', 1, 0, NULL, NULL, 89),
(383, 'Salaire de base', 1, 10075, NULL, NULL, 90),
(384, 'Transport', 0, 0, NULL, NULL, 90),
(385, 'CGS', NULL, NULL, -1.5, 383, 90),
(386, 'NSF', NULL, NULL, -1.0, 383, 90),
(387, 'Salaire de base', 1, 7700, NULL, NULL, 91),
(388, 'Transport', 5, 62, NULL, NULL, 91),
(389, 'CGS', NULL, 0, 0.0, 387, 91),
(390, 'NSF', NULL, 0, 0.0, 387, 91),
(391, 'Salaire de base', 1, 7000, NULL, NULL, 92),
(392, 'Transport', 5, 48, NULL, NULL, 92),
(393, 'CGS', NULL, 0, 0.0, 391, 92),
(394, 'NSF', NULL, 0, 0.0, 391, 92),
(395, 'Salaire de base', 1, 4000, NULL, NULL, 93),
(396, 'Transport', 0, 0, NULL, NULL, 93),
(397, 'CGS', NULL, 0, 0.0, 395, 93),
(398, 'NSF', NULL, 0, 0.0, 395, 93),
(399, 'Salaire de base', 1, 15000, NULL, NULL, 94),
(400, 'Transport', 1, 4000, NULL, NULL, 94),
(401, 'CGS', NULL, NULL, -1.5, 399, 94),
(402, 'NSF', NULL, NULL, -1.0, 399, 94),
(403, 'Salaire de base', 1, 16000, NULL, NULL, 95),
(404, 'Transport', 1, 0, NULL, NULL, 95),
(405, 'CGS', NULL, NULL, -1.5, 403, 95),
(406, 'NSF', NULL, NULL, -1.0, 403, 95),
(407, 'Salaire de base', 1, 10075, NULL, NULL, 96),
(408, 'Transport', 1, 0, NULL, NULL, 96),
(409, 'CGS', NULL, NULL, -1.5, 407, 96),
(410, 'NSF', NULL, NULL, -1.0, 407, 96),
(411, 'Salaire de base', 1, 10075, NULL, NULL, 97),
(412, 'Transport', 1, 0, NULL, NULL, 97),
(413, 'CGS', NULL, NULL, -1.5, 411, 97),
(414, 'NSF', NULL, NULL, -1.0, 411, 97),
(415, 'Salaire de base', 1, 7000, NULL, NULL, 98),
(416, 'Transport', 5, 48, NULL, NULL, 98),
(417, 'CGS', NULL, 0, 0.0, 415, 98),
(418, 'NSF', NULL, 0, 0.0, 415, 98),
(419, 'Salaire de base', 1, 7700, NULL, NULL, 99),
(420, 'Transport', 3, 62, NULL, NULL, 99),
(421, 'CGS', NULL, 0, 0.0, 419, 99),
(422, 'NSF', NULL, 0, 0.0, 419, 99),
(423, 'Salaire de base', 176, 55.11364, NULL, NULL, 100),
(424, 'Transport', 22, 54, NULL, NULL, 100),
(425, 'CGS', NULL, NULL, -1.5, 423, 100),
(426, 'NSF', NULL, NULL, -1.0, 423, 100),
(427, 'Salaire de base', 1, 4000, NULL, NULL, 101),
(428, 'Transport', 1, 0, NULL, NULL, 101),
(429, 'CGS', NULL, 0, 0.0, 427, 101),
(430, 'NSF', NULL, 0, 0.0, 427, 101),
(431, 'Salaire de base', 1, 2000, NULL, NULL, 102),
(432, 'Transport', 0, 54, NULL, NULL, 102),
(433, 'CGS', NULL, 0, 0.0, 431, 102),
(434, 'NSF', NULL, 0, 0.0, 431, 102),
(435, 'Déduction absence du 05 mars', 1, -318, NULL, NULL, 98),
(436, 'Bonus de présence mensuelle Rs 500', 1, 0, NULL, NULL, 95),
(437, 'Salaire de base', 1, 10075, NULL, NULL, 103),
(438, 'Transport', 2, 62, NULL, NULL, 103),
(439, 'CGS', NULL, 0, -1.5, 437, 103),
(440, 'NSF', NULL, 0, -1.0, 437, 103),
(441, 'Salaire de base', 1, 10075, NULL, NULL, 104),
(442, 'Transport', 0, 0, NULL, NULL, 104),
(443, 'CGS', NULL, 0, -1.5, 441, 104),
(444, 'NSF', NULL, 0, -1.0, 441, 104),
(447, 'Salaire de base', 1, 16000, NULL, NULL, 105),
(448, 'Transport', 7, 62, NULL, NULL, 105),
(449, 'CGS', NULL, NULL, -1.5, 447, 105),
(450, 'NSF', NULL, NULL, -1.0, 447, 105),
(451, 'Compensation garde d\'enfants du 3 au 6 ', 1, 364, NULL, NULL, 104),
(452, 'Calcul au prorata Rs 2000/22 jours', 1, 0, NULL, NULL, 104),
(453, 'Salaire de base', 176, 55.11364, NULL, NULL, 106),
(454, 'Transport', 22, 54, NULL, NULL, 106),
(455, 'CGS', NULL, NULL, -1.5, 453, 106),
(456, 'NSF', NULL, NULL, -1.0, 453, 106),
(457, 'Salaire de base', 1, 7000, NULL, NULL, 107),
(458, 'Transport', 9, 48, NULL, NULL, 107),
(459, 'CGS', NULL, 0, 0.0, 457, 107),
(460, 'NSF', NULL, 0, 0.0, 457, 107),
(461, 'Salaire de base', 176, 55.11364, NULL, NULL, 108),
(462, 'Transport', 22, 54, NULL, NULL, 108),
(463, 'CGS', NULL, NULL, -1.5, 461, 108),
(464, 'NSF', NULL, NULL, -1.0, 461, 108),
(465, 'Déduc Rs48/1jour de transp payé en surplus', 1, -48, NULL, NULL, 107),
(466, 'en mars 2021', 1, 0, NULL, NULL, 107),
(467, 'Remboursement transport du 07', 1, 31, NULL, NULL, 99),
(468, '*Compensation garde d\'enfants pour 10 jours', 1, 450, NULL, NULL, 99),
(469, '*Calcul au prorata Rs 1000/22 jours', 1, 0, NULL, NULL, 99),
(470, 'Salaire de base', 1, 10075, NULL, NULL, 109),
(471, 'Transport', 0, 0, NULL, NULL, 109),
(472, 'CGS', NULL, NULL, -1.5, 470, 109),
(473, 'NSF', NULL, NULL, -1.0, 470, 109),
(474, 'Déduction (démission le 8 mai) montant payé en exc', 1, -6411, NULL, NULL, 109),
(475, 'Salaire de base', 1, 16000, NULL, NULL, 110),
(476, 'Transport', 0, 0, NULL, NULL, 110),
(477, 'CGS', NULL, NULL, -1.5, 475, 110),
(478, 'NSF', NULL, NULL, -1.0, 475, 110),
(479, 'Salaire de base', 1, 7700, NULL, NULL, 111),
(480, 'Transport', 4, 62, NULL, NULL, 111),
(481, 'CGS', NULL, 0, 0.0, 479, 111),
(482, 'NSF', NULL, 0, 0.0, 479, 111),
(483, 'Salaire de base', 1, 7000, NULL, NULL, 112),
(484, 'Transport', 11, 48, NULL, NULL, 112),
(485, 'CGS', NULL, 0, 0.0, 483, 112),
(486, 'NSF', NULL, 0, 0.0, 483, 112),
(487, 'Journées complètes du 28 au 30 juin, 6 hrs', 1, 300, NULL, NULL, 112),
(488, '14 hrs à 16 hrs @ Rs 50/hr ', 1, 0, NULL, NULL, 112),
(489, 'Salaire de base', 1, 16000, NULL, NULL, 113),
(490, 'Bonus de présence mensuelle ', 1, 500, NULL, NULL, 113),
(491, 'CGS', NULL, NULL, -1.5, 489, 113),
(492, 'NSF', NULL, NULL, -1.0, 489, 113),
(493, 'Salaire de base', 1, 10075, NULL, NULL, 114),
(494, 'Transport', 18, 48, NULL, NULL, 114),
(495, 'CGS', NULL, 0, 0.0, 493, 114),
(496, 'NSF', NULL, 0, 0.0, 493, 114),
(497, 'Déduction absences du 01, 26 au 28 juillet', 1, -1832, NULL, NULL, 114),
(498, 'Déduction écolage pour le mois de juillet Nolwenn', 1, -2000, NULL, NULL, 114),
(499, 'Salaire de base', 1, 10075, NULL, NULL, 115),
(500, 'Transport', 15, 62, NULL, NULL, 115),
(501, 'CGS', NULL, 0, 0.0, 499, 115),
(502, 'NSF', NULL, 0, 0.0, 499, 115),
(503, 'Déduction absences du 12, 23, 26 au 20 aout', 1, -3206, NULL, NULL, 115),
(505, '1 jour = Rs 458', 1, 0, NULL, NULL, 115),
(506, 'Salaire de base', 1, 16000, NULL, NULL, 116),
(507, 'Transport', 0, 0, NULL, NULL, 116),
(508, 'CGS', NULL, NULL, -1.5, 506, 116),
(509, 'NSF', NULL, NULL, -1.0, 506, 116),
(510, 'nouvelle ligne', 1, 0, NULL, NULL, 116),
(511, 'Bonus de présence mensuelle Rs 500', 1, 500, NULL, NULL, 116),
(512, 'Salaire de base', 1, 10075, NULL, NULL, 117),
(513, 'Transport', 22, 48, NULL, NULL, 117),
(514, 'CGS', NULL, NULL, -1.5, 512, 117),
(515, 'NSF', NULL, NULL, -1.0, 512, 117),
(516, 'Salaire de base', 1, 10075, NULL, NULL, 118),
(517, 'Transport', 22, 62, NULL, NULL, 118),
(518, 'CGS', NULL, NULL, -1.5, 516, 118),
(519, 'NSF', NULL, NULL, -1.0, 516, 118),
(521, 'Déduction écolage Nolwenn pour le mois d\'aout', 1, -2000, NULL, NULL, 117),
(522, 'Salaire de base', 1, 16000, NULL, NULL, 119),
(523, 'Transport', 0, 0, NULL, NULL, 119),
(524, 'CGS', NULL, NULL, -1.5, 522, 119),
(525, 'NSF', NULL, NULL, -1.0, 522, 119),
(526, 'Salaire de base', 176, 55.11364, NULL, NULL, 120),
(527, 'Transport', 22, 54, NULL, NULL, 120),
(528, 'CGS', NULL, NULL, -1.5, 526, 120),
(529, 'NSF', NULL, NULL, -1.0, 526, 120),
(530, 'Salaire de base', 176, 55.11364, NULL, NULL, 121),
(531, 'Transport', 22, 54, NULL, NULL, 121),
(532, 'CGS', NULL, NULL, -1.5, 530, 121),
(533, 'NSF', NULL, NULL, -1.0, 530, 121),
(534, 'Salaire de base', 176, 55.11364, NULL, NULL, 122),
(535, 'Transport', 22, 54, NULL, NULL, 122),
(536, 'CGS', NULL, NULL, -1.5, 534, 122),
(537, 'NSF', NULL, NULL, -1.0, 534, 122),
(538, 'Salaire de base', 176, 55.11364, NULL, NULL, 123),
(539, 'Transport', 22, 54, NULL, NULL, 123),
(540, 'CGS', NULL, NULL, -1.5, 538, 123),
(541, 'NSF', NULL, NULL, -1.0, 538, 123),
(542, 'Salaire de base', 176, 55.11364, NULL, NULL, 124),
(543, 'Transport', 22, 54, NULL, NULL, 124),
(544, 'CGS', NULL, NULL, -1.5, 542, 124),
(545, 'NSF', NULL, NULL, -1.0, 542, 124),
(546, 'Salaire de base', 176, 55.11364, NULL, NULL, 125),
(547, 'Transport', 22, 54, NULL, NULL, 125),
(548, 'CGS', NULL, NULL, -1.5, 546, 125),
(549, 'NSF', NULL, NULL, -1.0, 546, 125),
(550, 'Salaire de base', 176, 55.11364, NULL, NULL, 126),
(551, 'Transport', 22, 54, NULL, NULL, 126),
(552, 'CGS', NULL, NULL, -1.5, 550, 126),
(553, 'NSF', NULL, NULL, -1.0, 550, 126),
(554, 'Salaire de base', 1, 16000, NULL, NULL, 127),
(555, 'Transport', 0, 0, NULL, NULL, 127),
(556, 'CGS', NULL, NULL, -1.5, 554, 127),
(557, 'NSF', NULL, NULL, -1.0, 554, 127),
(558, 'Bonus de présence mensuelle Rs 500', 1, 500, NULL, NULL, 127),
(560, 'Salaire de base', 1, 10075, NULL, NULL, 128),
(561, 'Transport', 22, 48, NULL, NULL, 128),
(562, 'CGS', NULL, NULL, -1.5, 560, 128),
(563, 'NSF', NULL, NULL, -1.0, 560, 128),
(564, 'Déduction Ecolage:  Nolwenn Dwarika', 1, -2000, NULL, NULL, 128),
(565, 'Salaire de base', 1, 10075, NULL, NULL, 129),
(566, 'Transport', 21, 62, NULL, NULL, 129),
(567, 'CGS', NULL, NULL, -1.5, 565, 129),
(568, 'NSF', NULL, NULL, -1.0, 565, 129),
(569, 'Bonus de présence mensuelle Rs 0', 1, 0, NULL, NULL, 119),
(570, 'Salaire de base', 1, 10075, NULL, NULL, 130),
(571, 'Transport', 18, 62, NULL, NULL, 130),
(572, 'CGS', NULL, NULL, -1.5, 570, 130),
(573, 'NSF', NULL, NULL, -1.0, 570, 130),
(574, 'Salaire de base', 1, 10075, NULL, NULL, 131),
(575, 'Transport', 16, 48, NULL, NULL, 131),
(576, 'CGS', NULL, NULL, -1.5, 574, 131),
(577, 'NSF', NULL, NULL, -1.0, 574, 131),
(578, 'Déduction écolage Nolwenn', 1, -2000, NULL, NULL, 131),
(579, 'Déduction maladie du 26 au 29 oct', 1, -1832, NULL, NULL, 131),
(580, 'Salaire de base', 1, 7000, NULL, NULL, 132),
(581, 'Transport', 20, 48, NULL, NULL, 132),
(582, 'CGS', NULL, 0, 0.0, 580, 132),
(583, 'NSF', NULL, 0, 0.0, 580, 132),
(584, 'Salaire de base', 1, 15000, NULL, NULL, 133),
(585, 'Transport', 1, 4000, NULL, NULL, 133),
(586, 'CGS', NULL, NULL, -1.5, 584, 133),
(587, 'NSF', NULL, NULL, -1.0, 584, 133),
(588, 'Salaire de base', 1, 16000, NULL, NULL, 134),
(589, 'Transport', 0, 0, NULL, NULL, 134),
(590, 'CGS', NULL, NULL, -1.5, 588, 134),
(591, 'NSF', NULL, NULL, -1.0, 588, 134),
(592, 'Bonus de présence mensuelle ', 1, 0, NULL, NULL, 134),
(593, 'Déduction absences du 16,17 nov', 1, -1454, NULL, NULL, 134),
(594, 'Congés du 27 oct et 05 nov offert pas de déduction', 1, 0, NULL, NULL, 134),
(595, 'Salaire de base', 1, 10075, NULL, NULL, 135),
(596, 'Transport', 12, 48, NULL, NULL, 135),
(597, 'CGS', NULL, NULL, -1.5, 595, 135),
(598, 'NSF', NULL, NULL, -1.0, 595, 135),
(599, 'Déduction absences du 3,11, 08 ', 1, -1374, NULL, NULL, 135),
(600, 'Déduction écolage déc avec remise spéciale ', 1, -1000, NULL, NULL, 135),
(601, 'Absences du 9,10,11,12 exceptionnellement non dédu', 1, 0, NULL, NULL, 135),
(602, 'Salaire de base', 1, 10075, NULL, NULL, 136),
(603, 'Transport', 17, 62, NULL, NULL, 136),
(604, 'CGS', NULL, NULL, -1.5, 602, 136),
(605, 'NSF', NULL, NULL, -1.0, 602, 136),
(606, 'Déduction abs: 8,24,25 nov (Rs458x2+229)', 1, -1145, NULL, NULL, 136),
(607, 'Salaire de base', 1, 7000, NULL, NULL, 137),
(608, 'Transport', 18, 48, NULL, NULL, 137),
(609, 'CGS', NULL, 0, 0.0, 607, 137),
(610, 'NSF', NULL, 0, 0.0, 607, 137),
(611, 'Salaire de base', 1, 16000, NULL, NULL, 138),
(612, 'Transport', 0, 0, NULL, NULL, 138),
(613, 'CGS', NULL, NULL, -1.5, 611, 138),
(614, 'NSF', NULL, NULL, -1.0, 611, 138),
(615, 'Absences des 13,14,15 déc ', 1, -2181, NULL, NULL, 138),
(616, 'Salaire de base', 1, 10075, NULL, NULL, 139),
(617, 'Transport', 15, 48, NULL, NULL, 139),
(618, 'CGS', NULL, NULL, -1.5, 616, 139),
(619, 'NSF', NULL, NULL, -1.0, 616, 139),
(620, 'Salaire de base', 1, 10075, NULL, NULL, 140),
(621, 'Transport', 9, 62, NULL, NULL, 140),
(622, 'CGS', NULL, NULL, -1.5, 620, 140),
(623, 'NSF', NULL, NULL, -1.0, 620, 140),
(624, 'Salaire de base', 176, 55.11364, NULL, NULL, 141),
(625, 'Transport', 22, 54, NULL, NULL, 141),
(626, 'CGS', NULL, NULL, -1.5, 624, 141),
(627, 'NSF', NULL, NULL, -1.0, 624, 141),
(628, 'Salaire de base', 176, 55.11364, NULL, NULL, 142),
(629, 'Transport', 22, 54, NULL, NULL, 142),
(630, 'CGS', NULL, NULL, -1.5, 628, 142),
(631, 'NSF', NULL, NULL, -1.0, 628, 142),
(632, 'Salaire de base', 176, 55.11364, NULL, NULL, 143),
(633, 'Transport', 22, 54, NULL, NULL, 143),
(634, 'CGS', NULL, NULL, -1.5, 632, 143),
(635, 'NSF', NULL, NULL, -1.0, 632, 143),
(636, 'Salaire de base', 176, 55.11364, NULL, NULL, 144),
(637, 'Transport', 22, 54, NULL, NULL, 144),
(638, 'CGS', NULL, NULL, -1.5, 636, 144),
(639, 'NSF', NULL, NULL, -1.0, 636, 144),
(640, 'Déduction absence du 01 au 03 déc', 1, -1374, NULL, NULL, 140),
(641, 'Salaire de base', 1, 7000, NULL, NULL, 145),
(642, 'Transport', 16, 48, NULL, NULL, 145),
(643, 'CGS', NULL, 0, 0.0, 641, 145),
(644, 'NSF', NULL, 0, 0.0, 641, 145),
(645, 'Salaire de base', 1, 10575, NULL, NULL, 146),
(646, 'Transport', 9, 48, NULL, NULL, 146),
(647, 'CGS', NULL, NULL, -1.5, 645, 146),
(648, 'NSF', NULL, NULL, -1.0, 645, 146),
(649, 'Salaire de base', 1, 16400, NULL, NULL, 147),
(650, 'Transport', 0, 0, NULL, NULL, 147),
(651, 'CGS', NULL, NULL, -1.5, 649, 147),
(652, 'NSF', NULL, NULL, -1.0, 649, 147),
(653, 'Congés maladie du 20, 21 jan', 1, -1490, NULL, NULL, 147),
(654, 'Salaire de base', 1, 10575, NULL, NULL, 148),
(655, 'Transport', 14, 62, NULL, NULL, 148),
(656, 'CGS', NULL, NULL, -1.5, 654, 148),
(657, 'NSF', NULL, NULL, -1.0, 654, 148),
(658, 'Congé maladie du 19 jan', 1, -458, NULL, NULL, 148),
(659, 'Congé maladie du 24 jan', 1, -458, NULL, NULL, 146),
(660, 'Frais de scolarité janvier Nolwenn', 1, -2000, NULL, NULL, 146),
(661, 'Salaire de base', 1, 10575, NULL, NULL, 149),
(662, 'Transport', 15, 48, NULL, NULL, 149),
(663, 'CGS', NULL, 0, 0.0, 661, 149),
(664, 'NSF', NULL, 0, 0.0, 661, 149),
(665, 'Salaire de base', 1, 16900, NULL, NULL, 150),
(666, 'Transport', 0, 0, NULL, NULL, 150),
(667, 'CGS', NULL, NULL, -1.5, 665, 150),
(668, 'NSF', NULL, NULL, -1.0, 665, 150),
(669, 'Salaire de base', 1, 10575, NULL, NULL, 151),
(670, 'Transport', 8, 62, NULL, NULL, 151),
(671, 'CGS', NULL, NULL, -1.5, 669, 151),
(672, 'NSF', NULL, NULL, -1.0, 669, 151),
(673, 'Salaire de base', 1, 10575, NULL, NULL, 152),
(674, 'Transport', 17, 48, NULL, NULL, 152),
(675, 'CGS', NULL, NULL, -1.5, 673, 152),
(676, 'NSF', NULL, NULL, -1.0, 673, 152),
(677, 'Special leave granted on 25 Feb -  no deduction', 1, 0, NULL, NULL, 152),
(678, 'Prorata 10 jours (du 14 au 28)', 1, 4810, NULL, NULL, 153),
(679, 'Transport', 0, 0, NULL, NULL, 153),
(680, 'CGS', NULL, 0, 0.0, 678, 153),
(681, 'NSF', NULL, 0, 0.0, 678, 153),
(682, 'Base de salaire ', 0, 10575, NULL, NULL, 154),
(683, 'Transport', 2, 62, NULL, NULL, 154),
(684, 'CGS', NULL, 0, 0.0, 682, 154),
(685, 'NSF', NULL, 0, 0.0, 682, 154),
(686, 'Prorata: 14 jours x Rs 481', 1, 6734, NULL, NULL, 154),
(687, 'Salaire de base', 1, 16900, NULL, NULL, 155),
(688, 'Transport', 0, 0, NULL, NULL, 155),
(689, 'CGS', NULL, NULL, -1.5, 687, 155),
(690, 'NSF', NULL, NULL, -1.0, 687, 155),
(691, 'Déduction 6 jours de maladies ', 1, -768, NULL, NULL, 155),
(692, 'Pas de déduction pour les absences du 02, 21', 1, 0, NULL, NULL, 155),
(693, 'Salaire de base', 1, 10575, NULL, NULL, 156),
(694, 'Transport', 21, 48, NULL, NULL, 156),
(695, 'CGS', NULL, NULL, -1.5, 693, 156),
(696, 'NSF', NULL, NULL, -1.0, 693, 156),
(697, 'Salaire de base', 1, 10575, NULL, NULL, 157),
(698, 'Transport', 0, 0, NULL, NULL, 157),
(699, 'CGS', NULL, 0, 0.0, 697, 157),
(700, 'NSF', NULL, 0, 0.0, 697, 157),
(701, 'Salaire de base', 1, 6000, NULL, NULL, 158),
(702, 'Transport', 22, 54, NULL, NULL, 158),
(703, 'CGS', NULL, 0, 0.0, 701, 158),
(704, 'NSF', NULL, 0, 0.0, 701, 158),
(705, 'Salaire de base', 0, 10575, NULL, NULL, 159),
(706, 'Transport', 14, 84, NULL, NULL, 159),
(707, 'CGS', NULL, 0, 0.0, 705, 159),
(708, 'NSF', NULL, 0, 0.0, 705, 159),
(709, 'Prorata 14 jours Rs 481 x 14', 1, 6734, NULL, NULL, 159),
(710, 'Déduction congé maladie ', 1, -273, NULL, NULL, 158),
(711, 'Paiement de la journée du 28 fév 2022 ', 1, 273, NULL, NULL, 158),
(712, 'Salaire de base', 1, 2450, NULL, NULL, 160),
(713, 'Transport', 8, 62, NULL, NULL, 160),
(714, 'CGS', NULL, 0, 0.0, 712, 160),
(715, 'NSF', NULL, 0, 0.0, 712, 160),
(716, 'Salaire de base', 1, 16900, NULL, NULL, 161),
(717, 'Transport', 0, 0, NULL, NULL, 161),
(718, 'CGS', NULL, NULL, -1.5, 716, 161),
(719, 'NSF', NULL, NULL, -1.0, 716, 161),
(720, 'Salaire de base', 176, 55.11364, NULL, NULL, 162),
(721, 'Transport', 22, 54, NULL, NULL, 162),
(722, 'CGS', NULL, NULL, -1.5, 720, 162),
(723, 'NSF', NULL, NULL, -1.0, 720, 162),
(724, 'Salaire de base', 1, 10575, NULL, NULL, 163),
(725, 'Transport', 0, 0, NULL, NULL, 163),
(726, 'CGS', NULL, 0, 0.0, 724, 163),
(727, 'NSF', NULL, 0, 0.0, 724, 163),
(728, 'Salaire de base', 1, 16900, NULL, NULL, 164),
(729, 'Transport', 0, 54, NULL, NULL, 164),
(730, 'Salaire de base', 176, 55.11364, NULL, NULL, 165),
(731, 'Transport', 22, 54, NULL, NULL, 165),
(732, 'CGS', NULL, NULL, -1.5, 728, 164),
(733, 'NSF', NULL, NULL, -1.0, 728, 164),
(734, 'CGS', NULL, NULL, -1.5, 730, 165),
(735, 'NSF', NULL, NULL, -1.0, 730, 165),
(736, 'Salaire de base', 176, 55.11364, NULL, NULL, 166),
(737, 'Transport', 22, 54, NULL, NULL, 166),
(738, 'CGS', NULL, NULL, -1.5, 736, 166),
(739, 'NSF', NULL, NULL, -1.0, 736, 166),
(740, 'Salaire de base', 176, 55.11364, NULL, NULL, 167),
(741, 'Transport', 22, 54, NULL, NULL, 167),
(742, 'CGS', NULL, NULL, -1.5, 740, 167),
(743, 'NSF', NULL, NULL, -1.0, 740, 167),
(744, 'Salaire de base', 176, 55.11364, NULL, NULL, 168),
(745, 'Transport', 22, 54, NULL, NULL, 168),
(746, 'CGS', NULL, NULL, -1.5, 744, 168),
(747, 'NSF', NULL, NULL, -1.0, 744, 168),
(748, 'Salaire de base', 176, 55.11364, NULL, NULL, 169),
(749, 'Transport', 22, 54, NULL, NULL, 169),
(750, 'CGS', NULL, NULL, -1.5, 748, 169),
(751, 'NSF', NULL, NULL, -1.0, 748, 169),
(752, 'Salaire de base', 1, 10575, NULL, NULL, 170),
(753, 'Transport', 20, 48, NULL, NULL, 170),
(754, 'CGS', NULL, NULL, -1.5, 752, 170),
(755, 'NSF', NULL, NULL, -1.0, 752, 170),
(756, 'Salaire de base', 1, 6000, NULL, NULL, 171),
(757, 'Transport', 20, 54, NULL, NULL, 171),
(758, 'CGS', NULL, 0, 0.0, 756, 171),
(759, 'NSF', NULL, 0, 0.0, 756, 171),
(760, 'Salaire de base', 1, 10575, NULL, NULL, 172),
(761, 'Transport', 20, 84, NULL, NULL, 172),
(762, 'CGS', NULL, 0, 0.0, 760, 172),
(763, 'NSF', NULL, 0, 0.0, 760, 172),
(764, 'Salaire de base', 1, 15000, NULL, NULL, 173),
(765, 'Transport', 1, 4000, NULL, NULL, 173),
(766, 'CGS', NULL, NULL, -1.5, 764, 173),
(767, 'NSF', NULL, NULL, -1.0, 764, 173),
(769, 'Salaire de base', 1, 16900, NULL, NULL, 174),
(770, 'Transport', 0, 0, NULL, NULL, 174),
(771, 'CGS', NULL, NULL, -1.5, 769, 174),
(772, 'NSF', NULL, NULL, -1.0, 769, 174),
(773, 'Salaire de base', 1, 10575, NULL, NULL, 175),
(774, 'Transport', 1, 1212, NULL, NULL, 175),
(775, 'CGS', NULL, NULL, -1.5, 773, 175),
(776, 'NSF', NULL, NULL, -1.0, 773, 175),
(777, 'Salaire de base', 1, 10575, NULL, NULL, 176),
(778, 'Transport', 0, 0, NULL, NULL, 176),
(779, 'CGS', NULL, NULL, -1.5, 777, 176),
(780, 'NSF', NULL, NULL, -1.0, 777, 176),
(781, 'Salaire de base', 1, 6000, NULL, NULL, 177),
(782, 'Transport', 1, 1406, NULL, NULL, 177),
(783, 'CGS', NULL, 0, 0.0, 781, 177),
(784, 'NSF', NULL, 0, 0.0, 781, 177),
(785, 'Salaire de base', 1, 10575, NULL, NULL, 178),
(786, 'Transport', 1, 2044, NULL, NULL, 178),
(787, 'CGS', NULL, NULL, -1.5, 785, 178),
(788, 'NSF', NULL, NULL, -1.0, 785, 178),
(789, 'Déduction absences du 02 et 23 mai', 1, -962, NULL, NULL, 178),
(790, 'Salaire de base', 1, 15000, NULL, NULL, 179),
(791, 'Transport', 1, 4000, NULL, NULL, 179),
(792, 'CGS', NULL, NULL, -1.5, 790, 179),
(793, 'NSF', NULL, NULL, -1.0, 790, 179),
(794, 'Salaire de base', 1, 6000, NULL, NULL, 180),
(795, 'Transport', 21, 70, NULL, NULL, 180),
(796, 'CGS', NULL, NULL, -1.5, 794, 180),
(797, 'NSF', NULL, NULL, -1.0, 794, 180),
(798, 'Déduction absence du 24 juin', 1, -273, NULL, NULL, 180),
(800, 'Salaire de base', 1, 10575, NULL, NULL, 181),
(801, 'Transport', 21, 60, NULL, NULL, 181),
(802, 'CGS', NULL, NULL, -1.5, 800, 181),
(803, 'NSF', NULL, NULL, -1.0, 800, 181),
(804, 'Salaire de base', 1, 10575, NULL, NULL, 182),
(805, 'Transport', 0, 0, NULL, NULL, 182),
(806, 'CGS', NULL, NULL, -1.5, 804, 182),
(807, 'NSF', NULL, NULL, -1.0, 804, 182),
(808, 'Déduction absence du 22', 1, -481, NULL, NULL, 182),
(809, 'Déduction absence 1 jour additionnel ', 1, -768, NULL, NULL, 161),
(810, 'Salaire de base', 1, 10575, NULL, NULL, 183),
(811, 'Transport', 19, 112, NULL, NULL, 183),
(812, 'CGS', NULL, NULL, -1.5, 810, 183),
(813, 'NSF', NULL, NULL, -1.0, 810, 183),
(814, 'Salaire de base', 176, 55.11364, NULL, NULL, 184),
(815, 'Transport', 22, 54, NULL, NULL, 184),
(816, 'CGS', NULL, NULL, -1.5, 814, 184),
(817, 'NSF', NULL, NULL, -1.0, 814, 184),
(818, 'Salaire de base', 176, 55.11364, NULL, NULL, 185),
(819, 'Transport', 22, 54, NULL, NULL, 185),
(820, 'CGS', NULL, NULL, -1.5, 818, 185),
(821, 'NSF', NULL, NULL, -1.0, 818, 185),
(822, 'Salaire de base', 176, 55.11364, NULL, NULL, 186),
(823, 'Transport', 22, 54, NULL, NULL, 186),
(824, 'CGS', NULL, NULL, -1.5, 822, 186),
(825, 'NSF', NULL, NULL, -1.0, 822, 186),
(826, 'Déduction absence du 6,7,28', 1, -1443, NULL, NULL, 183),
(827, 'Salaire de base', 1, 15000, NULL, NULL, 187),
(828, 'Transport', 1, 4000, NULL, NULL, 187),
(829, 'CGS', NULL, NULL, -1.5, 827, 187),
(830, 'NSF', NULL, NULL, -1.0, 827, 187),
(831, 'Salaire de base', 1, 2200, NULL, NULL, 188),
(832, 'Transport', 0, 0, NULL, NULL, 188),
(833, 'CGS', NULL, 0, 0.0, 831, 188),
(834, 'NSF', NULL, 0, 0.0, 831, 188),
(835, 'Salaire de base', 1, 2200, NULL, NULL, 189),
(836, 'Transport', 0, 0, NULL, NULL, 189),
(837, 'CGS', NULL, NULL, -1.5, 835, 189),
(838, 'NSF', NULL, NULL, -1.0, 835, 189),
(839, 'Salaire de base', 1, 10575, NULL, NULL, 190),
(840, 'Transport', 20, 60, NULL, NULL, 190),
(841, 'CGS', NULL, NULL, -1.5, 839, 190),
(842, 'NSF', NULL, NULL, -1.0, 839, 190),
(844, 'Remboursement transport RDV CDU du 13/07', 1, 79, NULL, NULL, 190),
(845, 'Salaire de base', 1, 10575, NULL, NULL, 191),
(846, 'Transport', 0, 0, NULL, NULL, 191),
(847, 'CGS', NULL, NULL, -1.5, 845, 191),
(848, 'NSF', NULL, NULL, -1.0, 845, 191),
(849, 'Déduction absence du 26/07', 1, -481, NULL, NULL, 191),
(850, 'Salaire de base', 1, 10575, NULL, NULL, 192),
(851, 'Transport', 21, 112, NULL, NULL, 192),
(852, 'CGS', NULL, NULL, -1.5, 850, 192),
(853, 'NSF', NULL, NULL, -1.0, 850, 192),
(854, 'Pro rata 10 jours du 18 au 29 (base Rs 10575)', 10, 481, NULL, NULL, 193),
(855, 'Transport', 10, 70, NULL, NULL, 193),
(858, 'Pro rata 8 jours du 18 au 29 (base Rs 6000)', 8, 273, NULL, NULL, 194),
(859, 'Transport', 0, 0, NULL, NULL, 194),
(860, 'CGS', NULL, 0, 0.0, 858, 194),
(861, 'NSF', NULL, 0, 0.0, 858, 194),
(862, 'Salaire de base', 1, 15000, NULL, NULL, 195),
(863, 'Transport', 1, 4000, NULL, NULL, 195),
(864, 'CGS', NULL, NULL, -1.5, 862, 195),
(865, 'NSF', NULL, NULL, -1.0, 862, 195),
(866, 'Salaire de base', 1, 10575, NULL, NULL, 196),
(867, 'Transport', 0, 0, NULL, NULL, 196),
(868, 'CGS', NULL, NULL, -1.5, 866, 196),
(869, 'NSF', NULL, NULL, -1.0, 866, 196),
(870, 'Salaire de base', 1, 6000, NULL, NULL, 197),
(871, 'Transport', 0, 0, NULL, NULL, 197),
(872, 'CGS', NULL, 0, 0.0, 870, 197),
(873, 'NSF', NULL, 0, 0.0, 870, 197),
(874, 'Salaire de base', 1, 10575, NULL, NULL, 198),
(875, 'Transport', 22, 60, NULL, NULL, 198),
(876, 'CGS', NULL, NULL, -1.5, 874, 198),
(877, 'NSF', NULL, NULL, -1.0, 874, 198),
(878, 'Salaire de base', 176, 55.11364, NULL, NULL, 199),
(879, 'Transport', 22, 54, NULL, NULL, 199),
(880, 'CGS', NULL, NULL, -1.5, 878, 199),
(881, 'NSF', NULL, NULL, -1.0, 878, 199),
(882, 'Bonus de présence juillet ', 1, 500, NULL, NULL, 198),
(883, 'Salaire de base', 1, 10575, NULL, NULL, 200),
(884, 'Transport', 20, 112, NULL, NULL, 200),
(885, 'CGS', NULL, NULL, -1.5, 883, 200),
(886, 'NSF', NULL, NULL, -1.0, 883, 200),
(887, 'Salaire de base', 1, 10575, NULL, NULL, 201),
(888, 'Transport', 21, 70, NULL, NULL, 201),
(889, 'CGS', NULL, 0, 0.0, 887, 201),
(890, 'NSF', NULL, 0, 0.0, 887, 201),
(891, 'Salaire de base', 1, 15000, NULL, NULL, 202),
(892, 'Transport', 1, 4000, NULL, NULL, 202),
(893, 'CGS', NULL, NULL, -1.5, 891, 202),
(894, 'NSF', NULL, NULL, -1.0, 891, 202),
(895, 'Déduction absences du 02 et 16 aout', 1, -962, NULL, NULL, 200),
(896, 'Bonus de présence juillet ', 1, 500, NULL, NULL, 200),
(897, 'Déduction absences du 08 et 19 aout', 1, -962, NULL, NULL, 201),
(898, 'Déduction maladie 8 jours', 1, -3848, NULL, NULL, 196),
(899, 'Déduction absence du 09', 1, -273, NULL, NULL, 197),
(901, 'Salaire de base', 1, 2000, NULL, NULL, 203),
(902, 'Transport', 5, 70, NULL, NULL, 203),
(903, 'CGS', NULL, 0, 0.0, 901, 203),
(904, 'NSF', NULL, 0, 0.0, 901, 203),
(905, 'Daily Rs 400, 29,30,31 aout, 2, 5 sept', 1, 0, NULL, NULL, 203),
(906, 'Salaire de base', 1, 10575, NULL, NULL, 204),
(907, 'Transport', 15, 112, NULL, NULL, 204),
(908, 'CGS', NULL, 0, -1.5, 906, 204),
(909, 'NSF', NULL, NULL, -1.0, 906, 204),
(910, 'Salaire de base', 1, 10575, NULL, NULL, 205),
(911, 'Transport', 17, 112, NULL, NULL, 205),
(912, 'CGS', NULL, NULL, -1.5, 910, 205),
(913, 'NSF', NULL, NULL, -1.0, 910, 205),
(914, 'Ajustement absence + transport du 31 aout', 1, -593, NULL, NULL, 204),
(915, 'Déduction absences maladies (50%)', 1, -1443, NULL, NULL, 204),
(916, 'Salaire de base', 1, 10575, NULL, NULL, 206),
(917, 'Transport', 0, 0, NULL, NULL, 206),
(918, 'CGS', NULL, NULL, -1.5, 916, 206),
(919, 'NSF', NULL, NULL, -1.0, 916, 206),
(920, 'Déduction: congé maladie, 8 jours', 1, -3848, NULL, NULL, 206),
(921, 'Salaire de base', 176, 60.08522, NULL, NULL, 207),
(922, 'Transport', 21, 60, NULL, NULL, 207),
(923, 'CGS', NULL, NULL, -1.5, 921, 207),
(924, 'NSF', NULL, NULL, -1.0, 921, 207),
(925, 'Salaire de base', 176, 60.08522, NULL, NULL, 208),
(926, 'Transport', 18, 60, NULL, NULL, 208),
(927, 'CGS', NULL, NULL, -1.5, 925, 208),
(928, 'NSF', NULL, NULL, -1.0, 925, 208),
(929, 'Salaire de base', 176, 60.08522, NULL, NULL, 209),
(930, 'Transport', 20, 70, NULL, NULL, 209),
(931, 'CGS', NULL, 0, 0.0, 929, 209),
(932, 'NSF', NULL, 0, 0.0, 929, 209),
(933, 'Salaire de base', 1, 3200, NULL, NULL, 210),
(934, 'Transport', 8, 70, NULL, NULL, 210),
(935, 'CGS', NULL, 0, 0.0, 933, 210),
(936, 'NSF', NULL, 0, 0.0, 933, 210),
(937, 'Salaire de base', 1, 7754, NULL, NULL, 211),
(938, 'Transport', 0, 0, NULL, NULL, 211),
(939, 'CGS', NULL, NULL, -1.5, 937, 211),
(940, 'NSF', NULL, NULL, -1.0, 937, 211),
(941, 'Bonus de présence aug 2022', 1, 500, NULL, NULL, 207),
(942, 'Une heure effectué le 07 aug ', 1, 60, NULL, NULL, 206),
(943, 'Bonus de présence aug 2022', 1, 0, NULL, NULL, 206),
(944, 'Bonus de présence aout', 1, 0, NULL, NULL, 204),
(945, 'Déduction absences ', 1, -481, NULL, NULL, 209),
(946, 'Déductions absences 11 jours', 1, -3872, NULL, NULL, 211),
(947, 'Salaire de base', 1, 2200, NULL, NULL, 212),
(948, 'Transport', 0, 54, NULL, NULL, 212),
(949, 'CGS', NULL, NULL, -1.5, 947, 212),
(950, 'NSF', NULL, NULL, -1.0, 947, 212),
(951, 'Salaire de base', 1, 30000, NULL, NULL, 213),
(952, 'Transport', 1, 4000, NULL, NULL, 213),
(953, 'CGS', NULL, NULL, -1.5, 951, 213),
(954, 'NSF', NULL, NULL, -1.0, 951, 213),
(955, 'Bonus de présence - septembre', 1, 500, NULL, NULL, 208),
(956, 'Déduction absences restantes du mois de sep ', 1, -1443, NULL, NULL, 205),
(957, 'Déduction absences oct', 1, -962, NULL, NULL, 205),
(958, 'Salaire de base', 176, 60.08522, NULL, NULL, 214),
(959, 'Transport', 0, 0, NULL, NULL, 214),
(960, 'CGS', NULL, NULL, -1.5, 958, 214),
(961, 'NSF', NULL, NULL, -1.0, 958, 214),
(962, 'Bonus de présence - septembre', 1, 0, NULL, NULL, 214),
(963, 'Bonus de présence - septembre', 1, 0, NULL, NULL, 205),
(964, 'Salaire de base', 176, 60.08522, NULL, NULL, 215),
(965, 'Transport', 18, 70, NULL, NULL, 215),
(966, 'CGS', NULL, NULL, -1.5, 964, 215),
(967, 'NSF', NULL, NULL, -1.0, 964, 215),
(968, 'Déduction absence oct', 1, -481, NULL, NULL, 215),
(969, 'Salaire de base', 1, 2200, NULL, NULL, 216),
(970, 'Transport', 0, 0, NULL, NULL, 216),
(971, 'CGS', NULL, 0, 0.0, 969, 216),
(972, 'NSF', NULL, 0, 0.0, 969, 216),
(973, 'Salaire de base', 176, 60.08522, NULL, NULL, 217),
(974, 'Transport', 0, 0, NULL, NULL, 217),
(975, 'CGS', NULL, NULL, -1.5, 973, 217),
(976, 'NSF', NULL, NULL, -1.0, 973, 217),
(977, 'Déduction congés maladie du 28 au 30 nov', 1, -1440, NULL, NULL, 217),
(978, 'Bonus de néttoyage oct et nov', 1, 1000, NULL, NULL, 217),
(979, 'Salaire de base', 176, 60.08522, NULL, NULL, 218),
(980, 'Transport', 19, 60, NULL, NULL, 218),
(981, 'CGS', NULL, NULL, -1.5, 979, 218),
(982, 'NSF', NULL, NULL, -1.0, 979, 218),
(983, 'Bonus de néttoyage oct et nov', 1, 1000, NULL, NULL, 218),
(984, 'Bonus de présence oct', 1, 0, NULL, NULL, 218),
(985, 'Bonus de présence octobre ', 1, 500, NULL, NULL, 217),
(986, 'Salaire de base', 176, 60.08522, NULL, NULL, 219),
(987, 'Transport', 19, 112, NULL, NULL, 219),
(988, 'CGS', NULL, NULL, -1.5, 986, 219),
(989, 'NSF', NULL, NULL, -1.0, 986, 219),
(990, 'Déduction absences: 7 & 24 novembre', 1, -960, NULL, NULL, 219),
(991, 'Bonus de néttoyage oct et nov ', 1, 1000, NULL, NULL, 219),
(992, 'Bonus de présence : Octobre ', 1, 0, NULL, NULL, 219),
(993, 'Salaire de base', 176, 60.08522, NULL, NULL, 220),
(994, 'Transport', 21, 70, NULL, NULL, 220),
(995, 'CGS', NULL, NULL, -1.5, 993, 220),
(996, 'NSF', NULL, NULL, -1.0, 993, 220),
(997, 'Bonus de néttoyage oct & nov ', 1, 1000, NULL, NULL, 220),
(998, 'Salaire de base', 1, 3600, NULL, NULL, 221),
(999, 'Transport', 9, 70, NULL, NULL, 221),
(1000, 'CGS', NULL, 0, 0.0, 998, 221),
(1001, 'NSF', NULL, 0, 0.0, 998, 221),
(1002, 'Salaire de base', 1, 30000, NULL, NULL, 222),
(1003, 'Transport', 1, 4000, NULL, NULL, 222),
(1004, 'CGS', NULL, NULL, -1.5, 1002, 222),
(1005, 'NSF', NULL, NULL, -1.0, 1002, 222),
(1006, 'Salaire de base', 1, 30000, NULL, NULL, 223),
(1007, 'Transport', 1, 4000, NULL, NULL, 223),
(1008, 'CGS', NULL, NULL, -1.5, 1006, 223),
(1009, 'NSF', NULL, NULL, -1.0, 1006, 223),
(1010, 'Salaire de base', 176, 60.08522, NULL, NULL, 224),
(1011, 'Transport', 0, 54, NULL, NULL, 224),
(1012, 'CGS', NULL, NULL, -1.5, 1010, 224),
(1013, 'NSF', NULL, NULL, -1.0, 1010, 224),
(1014, 'Salaire de base', 176, 60.08522, NULL, NULL, 225),
(1015, 'Transport', 16, 60, NULL, NULL, 225),
(1016, 'CGS', NULL, NULL, -1.5, 1014, 225),
(1017, 'NSF', NULL, NULL, -1.0, 1014, 225),
(1018, 'Cleaning Bonus Nov', 1, 0, NULL, NULL, 225),
(1019, 'Bonus de néttoyage nov', 1, 0, NULL, NULL, 224),
(1020, 'Déduction congé maladie du 1 & 2 déc', 1, -0, NULL, NULL, 224),
(1021, 'Salaire de base', 176, 60.08522, NULL, NULL, 226),
(1022, 'Transport', 16, 112, NULL, NULL, 226),
(1023, 'CGS', NULL, NULL, -1.5, 1021, 226),
(1024, 'NSF', NULL, NULL, -1.0, 1021, 226),
(1025, 'Bonus de néttoyage nov', 1, 0, NULL, NULL, 226),
(1026, 'Salaire de base', 176, 60.08522, NULL, NULL, 227),
(1027, 'Transport', 16, 70, NULL, NULL, 227),
(1028, 'CGS', NULL, NULL, -1.5, 1026, 227),
(1029, 'NSF', NULL, NULL, -1.0, 1026, 227),
(1031, 'Salaire de base', 1, 6000, NULL, NULL, 228),
(1032, 'Transport', 15, 70, NULL, NULL, 228),
(1033, 'CGS', NULL, 0, 0.0, 1031, 228),
(1034, 'NSF', NULL, 0, 0.0, 1031, 228),
(1035, 'Salaire de base', 1, 30000, NULL, NULL, 229),
(1036, 'Transport', 1, 4000, NULL, NULL, 229),
(1037, 'CGS', NULL, NULL, -1.5, 1035, 229),
(1038, 'NSF', NULL, NULL, -1.0, 1035, 229),
(1039, 'Salaire de base', 1, 11575, NULL, NULL, 230),
(1040, 'Transport', 14, 60, NULL, NULL, 230),
(1041, 'CGS', NULL, NULL, -1.5, 1039, 230),
(1042, 'NSF', NULL, NULL, -1.0, 1039, 230),
(1043, 'Bonus de présence déc 2022', 1, 500, NULL, NULL, 230),
(1045, 'Bonus de néttoyage déc 2022', 1, 500, NULL, NULL, 230),
(1046, 'Salaire de base', 1, 11575, NULL, NULL, 231),
(1047, 'Transport', 1, 0, NULL, NULL, 231),
(1048, 'CGS', NULL, NULL, -1.5, 1046, 231),
(1049, 'NSF', NULL, NULL, -1.0, 1046, 231),
(1050, 'Salaire de base', 176, 60.08522, NULL, NULL, 232),
(1051, 'Transport', 22, 54, NULL, NULL, 232),
(1052, 'CGS', NULL, NULL, -1.5, 1050, 232),
(1053, 'NSF', NULL, NULL, -1.0, 1050, 232),
(1054, 'Bonus de présence déc 2022', 1, 500, NULL, NULL, 231),
(1055, 'Bonus de néttoyage déc 2022', 1, 500, NULL, NULL, 231),
(1056, 'Congé maladie du 18 jan pas de déduction', 1, 0, NULL, NULL, 231),
(1057, 'Salaire de base', 1, 11575, NULL, NULL, 233),
(1058, 'Transport', 14, 112, NULL, NULL, 233),
(1059, 'CGS', NULL, NULL, -1.5, 1057, 233),
(1060, 'NSF', NULL, NULL, -1.0, 1057, 233),
(1061, 'Bonus de néttoyage déc 2022', 1, 500, NULL, NULL, 233),
(1062, 'Bonus de présence décembre 2022', 1, 500, NULL, NULL, 233),
(1063, 'Salaire de base', 1, 11575, NULL, NULL, 234),
(1064, 'Transport', 15, 70, NULL, NULL, 234),
(1065, 'CGS', NULL, NULL, -1.5, 1063, 234),
(1066, 'NSF', NULL, NULL, -1.0, 1063, 234),
(1067, 'Bonus de néttoyage déc 2022', 1, 500, NULL, NULL, 234),
(1068, 'Salaire de base', 1, 2400, NULL, NULL, 235),
(1069, 'Transport', 1, 0, NULL, NULL, 235),
(1070, 'CGS', NULL, NULL, -1.5, 1068, 235),
(1071, 'NSF', NULL, NULL, -1.0, 1068, 235),
(1072, 'Salaire de base', 1, 11575, NULL, NULL, 236),
(1073, 'Transport', 1, 0, NULL, NULL, 236),
(1074, 'CGS', NULL, NULL, -1.5, 1072, 236),
(1075, 'NSF', NULL, NULL, -1.0, 1072, 236),
(1076, 'Déduction absences maladie du 7,8,13 fév', 1, -1578, NULL, NULL, 236),
(1077, 'Salaire de base', 1, 11575, NULL, NULL, 237),
(1078, 'Transport', 16, 60, NULL, NULL, 237),
(1079, 'CGS', NULL, NULL, -1.5, 1077, 237),
(1080, 'NSF', NULL, NULL, -1.0, 1077, 237),
(1081, 'Bonus de présence janvier', 1, 0, NULL, NULL, 237),
(1082, 'Bonus de présence janvier', 1, 0, NULL, NULL, 236),
(1083, 'Salaire de base', 1, 11575, NULL, NULL, 238),
(1084, 'Transport', 16, 112, NULL, NULL, 238),
(1085, 'CGS', NULL, NULL, -1.5, 1083, 238),
(1086, 'NSF', NULL, NULL, -1.0, 1083, 238),
(1087, 'Déduction absence du 16', 1, -526, NULL, NULL, 238),
(1088, 'Bonus de présence janvier', 1, 0, NULL, NULL, 238),
(1089, 'Salaire de base', 1, 11575, NULL, NULL, 239),
(1090, 'Transport', 14, 70, NULL, NULL, 239),
(1091, 'CGS', NULL, NULL, -1.5, 1089, 239),
(1092, 'NSF', NULL, NULL, -1.0, 1089, 239),
(1093, 'Déduction absences du 2 et 13 février', 1, -1052, NULL, NULL, 239),
(1094, 'Salaire de base', 1, 450, NULL, NULL, 240),
(1095, 'Transport', 1, 70, NULL, NULL, 240),
(1096, 'CGS', NULL, 0, 0.0, 1094, 240),
(1097, 'NSF', NULL, 0, 0.0, 1094, 240),
(1098, 'Salaire de base', 1, 2400, NULL, NULL, 241),
(1099, 'Transport', 1, 0, NULL, NULL, 241),
(1100, 'CGS', NULL, NULL, -1.5, 1098, 241),
(1101, 'NSF', NULL, NULL, -1.0, 1098, 241),
(1102, 'Salaire de base', 1, 30000, NULL, NULL, 242),
(1103, 'Transport', 1, 4000, NULL, NULL, 242),
(1104, 'CGS', NULL, NULL, -1.5, 1102, 242),
(1105, 'NSF', NULL, NULL, -1.0, 1102, 242),
(1106, 'Salaire de base', 1, 30000, NULL, NULL, 243),
(1107, 'Transport', 1, 4000, NULL, NULL, 243),
(1108, 'CGS', NULL, NULL, -1.5, 1106, 243),
(1109, 'NSF', NULL, NULL, -1.0, 1106, 243),
(1110, 'Salaire de base', 1, 11575, NULL, NULL, 244),
(1111, 'Transport', 19, 60, NULL, NULL, 244),
(1112, 'CGS', NULL, NULL, -1.5, 1110, 244),
(1113, 'NSF', NULL, NULL, -1.0, 1110, 244),
(1114, 'Salaire de base', 1, 11575, NULL, NULL, 245),
(1115, 'Transport', 21, 0, NULL, NULL, 245),
(1116, 'CGS', NULL, NULL, -1.5, 1114, 245),
(1117, 'NSF', NULL, NULL, -1.0, 1114, 245),
(1118, 'Salaire de base', 1, 11575, NULL, NULL, 246),
(1119, 'Transport', 21, 112, NULL, NULL, 246),
(1120, 'CGS', NULL, NULL, -1.5, 1118, 246),
(1121, 'NSF', NULL, NULL, -1.0, 1118, 246),
(1122, 'Salaire de base', 1, 11575, NULL, NULL, 247),
(1123, 'Transport', 22, 70, NULL, NULL, 247),
(1124, 'CGS', NULL, NULL, -1.5, 1122, 247),
(1125, 'NSF', NULL, NULL, -1.0, 1122, 247),
(1126, 'Salaire de base', 1, 7000, NULL, NULL, 248),
(1127, 'Transport', 18, 60, NULL, NULL, 248),
(1128, 'CGS', NULL, 0, 0.0, 1126, 248),
(1129, 'NSF', NULL, 0, 0.0, 1126, 248),
(1130, 'Déduction absences 3 jours', 1, -954, NULL, NULL, 248),
(1131, 'Salaire de base', 1, 7000, NULL, NULL, 249),
(1132, 'Transport', 18, 60, NULL, NULL, 249),
(1133, 'CGS', NULL, 0, 0.0, 1131, 249),
(1134, 'NSF', NULL, 0, 0.0, 1131, 249),
(1135, 'Ajustement absence + transport du 31 mars', 1, -378, NULL, NULL, 249),
(1136, 'Salaire de base', 1, 11575, NULL, NULL, 250),
(1137, 'Transport', 17, 60, NULL, NULL, 250),
(1138, 'CGS', NULL, NULL, -1.5, 1136, 250),
(1139, 'NSF', NULL, NULL, -1.0, 1136, 250),
(1140, 'Salaire de base', 1, 11575, NULL, NULL, 251),
(1141, 'Transport', 1, 0, NULL, NULL, 251),
(1142, 'CGS', NULL, NULL, -1.5, 1140, 251),
(1143, 'NSF', NULL, NULL, -1.0, 1140, 251),
(1144, 'Salaire de base', 1, 11575, NULL, NULL, 252),
(1145, 'Transport', 15, 112, NULL, NULL, 252),
(1146, 'CGS', NULL, NULL, -1.5, 1144, 252),
(1147, 'NSF', NULL, NULL, -1.0, 1144, 252),
(1148, 'Salaire de base', 1, 11575, NULL, NULL, 253),
(1149, 'Transport', 18, 70, NULL, NULL, 253),
(1150, 'CGS', NULL, NULL, -1.5, 1148, 253),
(1151, 'NSF', NULL, NULL, -1.0, 1148, 253),
(1152, 'Déduction absences : 1.5 jours', 1, -789, NULL, NULL, 253),
(1153, 'Déduction absence du 17 avril', 1, -318, NULL, NULL, 249),
(1154, 'Salaire de base', 1, 30000, NULL, NULL, 254),
(1155, 'Transport', 1, 4000, NULL, NULL, 254),
(1156, 'CGS', NULL, NULL, -1.5, 1154, 254),
(1157, 'NSF', NULL, NULL, -1.0, 1154, 254),
(1158, 'Salaire de base', 1, 2400, NULL, NULL, 255),
(1159, 'Transport', 1, 0, NULL, NULL, 255),
(1160, 'CGS', NULL, NULL, -1.5, 1158, 255),
(1161, 'NSF', NULL, NULL, -1.0, 1158, 255),
(1162, 'Salaire de base', 1, 11575, NULL, NULL, 256),
(1163, 'Transport', 20, 60, NULL, NULL, 256),
(1164, 'CGS', NULL, NULL, -1.5, 1162, 256),
(1165, 'NSF', NULL, NULL, -1.0, 1162, 256),
(1166, 'Salaire de base', 1, 11575, NULL, NULL, 257),
(1167, 'Transport', 0, 0, NULL, NULL, 257),
(1168, 'CGS', NULL, NULL, -1.5, 1166, 257),
(1169, 'NSF', NULL, NULL, -1.0, 1166, 257);
INSERT INTO `creche_paye_details` (`id_creche_paye_detail`, `rubrique`, `quantity`, `amount`, `pourcent`, `of_id_creche_paye_detail`, `id_creche_paye`) VALUES
(1170, 'Salaire de base', 1, 11575, NULL, NULL, 258),
(1171, 'Transport', 21, 112, NULL, NULL, 258),
(1172, 'CGS', NULL, NULL, -1.5, 1170, 258),
(1173, 'NSF', NULL, NULL, -1.0, 1170, 258),
(1174, 'Salaire de base', 1, 11575, NULL, NULL, 259),
(1175, 'Transport', 21, 70, NULL, NULL, 259),
(1176, 'CGS', NULL, NULL, -1.5, 1174, 259),
(1177, 'NSF', NULL, NULL, -1.0, 1174, 259),
(1178, 'Déduction absences ', 1, -1052, NULL, NULL, 259),
(1179, 'Salaire de base', 1, 7000, NULL, NULL, 260),
(1180, 'Transport', 20, 60, NULL, NULL, 260),
(1181, 'CGS', NULL, 0, 0.0, 1179, 260),
(1182, 'NSF', NULL, 0, 0.0, 1179, 260),
(1183, 'Déduction absences', 1, -636, NULL, NULL, 260),
(1184, 'Salaire de base', 1, 2400, NULL, NULL, 261),
(1185, 'Transport', 22, 0, NULL, NULL, 261),
(1186, 'CGS', NULL, NULL, -1.5, 1184, 261),
(1187, 'NSF', NULL, NULL, -1.0, 1184, 261),
(1188, 'Salaire de base', 1, 30000, NULL, NULL, 262),
(1189, 'Transport', 1, 4000, NULL, NULL, 262),
(1190, 'CGS', NULL, NULL, -1.5, 1188, 262),
(1191, 'NSF', NULL, NULL, -1.0, 1188, 262),
(1192, 'Salaire de base', 1, 11575, NULL, NULL, 263),
(1193, 'Transport', 14, 60, NULL, NULL, 263),
(1194, 'CGS', NULL, NULL, -1.5, 1192, 263),
(1195, 'NSF', NULL, NULL, -1.0, 1192, 263),
(1196, 'Salaire de base', 1, 7000, NULL, NULL, 264),
(1197, 'Transport', 21, 60, NULL, NULL, 264),
(1198, 'CGS', NULL, NULL, -1.5, 1196, 264),
(1199, 'NSF', NULL, NULL, -1.0, 1196, 264),
(1200, 'Heures supplémentaires du 19 au 22 (Rs 53 x 4.5 hr', 1, 954, NULL, NULL, 264),
(1201, 'Salaire de base', 1, 11575, NULL, NULL, 265),
(1202, 'Transport', 19, 70, NULL, NULL, 265),
(1203, 'CGS', NULL, NULL, -1.5, 1201, 265),
(1204, 'NSF', NULL, NULL, -1.0, 1201, 265),
(1205, 'Déduction absences ', 1, -1841, NULL, NULL, 265),
(1206, 'Salaire de base', 1, 11575, NULL, NULL, 266),
(1207, 'Transport', 19, 112, NULL, NULL, 266),
(1208, 'CGS', NULL, NULL, -1.5, 1206, 266),
(1209, 'NSF', NULL, NULL, -1.0, 1206, 266),
(1210, 'Salaire de base', 1, 11575, NULL, NULL, 267),
(1211, 'Transport', 0, 0, NULL, NULL, 267),
(1212, 'CGS', NULL, NULL, -1.5, 1210, 267),
(1213, 'NSF', NULL, NULL, -1.0, 1210, 267),
(1214, 'Salaire de base', 176, 60.08522, NULL, NULL, 268),
(1215, 'Transport', 22, 0, NULL, NULL, 268),
(1216, 'CGS', NULL, NULL, -1.5, 1214, 268),
(1217, 'NSF', NULL, NULL, -1.0, 1214, 268),
(1218, 'Ajustement absence du 31 mai, transport', 1, -112, NULL, NULL, 258),
(1219, 'Ajustement absences du 31 mai ', 1, -112, NULL, NULL, 266),
(1220, 'Salaire de base', 1, 2400, NULL, NULL, 269),
(1221, 'Transport', 0, 0, NULL, NULL, 269),
(1222, 'CGS', NULL, NULL, -1.5, 1220, 269),
(1223, 'NSF', NULL, NULL, -1.0, 1220, 269),
(1224, 'Salaire de base', 176, 60.08522, NULL, NULL, 270),
(1225, 'Transport', 22, 0, NULL, NULL, 270),
(1226, 'CGS', NULL, NULL, -1.5, 1224, 270),
(1227, 'NSF', NULL, NULL, -1.0, 1224, 270),
(1228, 'Salaire de base', 1, 30000, NULL, NULL, 271),
(1229, 'Transport', 1, 4000, NULL, NULL, 271),
(1230, 'CGS', NULL, NULL, -1.5, 1228, 271),
(1231, 'NSF', NULL, NULL, -1.0, 1228, 271),
(1232, 'Salaire de base', 1, 11575, NULL, NULL, 272),
(1233, 'Transport', 0, 0, NULL, NULL, 272),
(1234, 'CGS', NULL, NULL, -1.5, 1232, 272),
(1235, 'NSF', NULL, NULL, -1.0, 1232, 272),
(1236, 'Salaire de base', 1, 11575, NULL, NULL, 273),
(1237, 'Transport', 0, 0, NULL, NULL, 273),
(1238, 'CGS', NULL, NULL, -1.5, 1236, 273),
(1239, 'NSF', NULL, NULL, -1.0, 1236, 273),
(1240, 'Salaire de base', 1, 11575, NULL, NULL, 274),
(1241, 'Transport', 19, 112, NULL, NULL, 274),
(1242, 'CGS', NULL, NULL, -1.5, 1240, 274),
(1243, 'NSF', NULL, NULL, -1.0, 1240, 274),
(1244, 'Ajustement absence du 27 juin', 1, -112, NULL, NULL, 274),
(1245, 'Salaire de base', 1, 11575, NULL, NULL, 275),
(1246, 'Transport', 19, 70, NULL, NULL, 275),
(1247, 'CGS', NULL, NULL, -1.5, 1245, 275),
(1248, 'NSF', NULL, NULL, -1.0, 1245, 275),
(1249, 'Déduction absences  10, 14 ', 1, -1052, NULL, NULL, 275),
(1250, 'Salaire de base', 1, 7000, NULL, NULL, 276),
(1251, 'Transport', 19, 60, NULL, NULL, 276),
(1252, 'CGS', NULL, NULL, -1.5, 1250, 276),
(1253, 'NSF', NULL, NULL, -1.0, 1250, 276),
(1254, 'Rémunération additionnel en remplacement', 1, 4075, NULL, NULL, 276),
(1255, 'Déduction absences du 5 et 6', 1, -636, NULL, NULL, 276),
(1256, 'Salaire de base', 1, 30000, NULL, NULL, 277),
(1257, 'Transport', 1, 4000, NULL, NULL, 277),
(1258, 'CGS', NULL, NULL, -1.5, 1256, 277),
(1259, 'NSF', NULL, NULL, -1.0, 1256, 277);

-- --------------------------------------------------------

--
-- Table structure for table `creche_personnel`
--

CREATE TABLE `creche_personnel` (
  `id_personnel` int(11) NOT NULL,
  `surname` varchar(50) DEFAULT NULL,
  `name` varchar(50) DEFAULT NULL,
  `start_date` date DEFAULT NULL,
  `end_date` date DEFAULT NULL,
  `employee_no` varchar(8) DEFAULT NULL,
  `id_no` varchar(15) DEFAULT NULL,
  `date_of_birth` date DEFAULT NULL,
  `contact_numbers_mobile` varchar(30) DEFAULT NULL,
  `email_address` varchar(50) DEFAULT NULL,
  `address_1` varchar(255) DEFAULT NULL,
  `address_2` varchar(255) DEFAULT NULL,
  `position` varchar(9) DEFAULT NULL,
  `status` varchar(9) DEFAULT NULL,
  `bank_account_no` varchar(14) DEFAULT NULL,
  `bank_name` varchar(20) DEFAULT NULL,
  `account_type` varchar(20) DEFAULT NULL,
  `NPF_REG_NO` varchar(10) DEFAULT NULL,
  `basic_salary_stipend` varchar(6) DEFAULT NULL,
  `transport_daily_rs` int(11) DEFAULT NULL,
  `transport_monthly_rs` varchar(5) DEFAULT NULL,
  `deductions_NPF_NSF_rs` varchar(3) DEFAULT NULL,
  `net_income_rs` int(11) DEFAULT NULL,
  `resigned` tinyint(1) NOT NULL,
  `background_color` char(7) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `creche_personnel`
--

INSERT INTO `creche_personnel` (`id_personnel`, `surname`, `name`, `start_date`, `end_date`, `employee_no`, `id_no`, `date_of_birth`, `contact_numbers_mobile`, `email_address`, `address_1`, `address_2`, `position`, `status`, `bank_account_no`, `bank_name`, `account_type`, `NPF_REG_NO`, `basic_salary_stipend`, `transport_daily_rs`, `transport_monthly_rs`, `deductions_NPF_NSF_rs`, `net_income_rs`, `resigned`, `background_color`) VALUES
(1, 'Claite', 'Marie Sandra Isabelle', '2019-05-02', NULL, 'CACIC00', 'C0908782804575', '1978-08-09', '59078420 Orange59333844 Emtel', 'crecheattitudecoltee@gmail.com', 'No 165, Avenue des Dahlias, Morcellement Beerjeeraz', 'Albion', 'Director', 'Full Time', '000033254354', 'MCB', 'Savings', NULL, '15000', 0, '4000', NULL, NULL, 0, '#666bff'),
(2, 'Poomaury', 'Kerlyna', '2021-04-01', '2022-06-30', 'CACKP01', 'D0210883041390', '1988-10-02', '59168789', 'seleji2660@gmail.com', 'Anenue des Hérons, Belle Vue', 'Albion', 'Manager /', 'Full Time', '052264637', 'MCB', 'Savings', 'N/A', '16500', 0, '0', '400', 16500, 0, '#d6ff66'),
(3, 'Martiale', 'Marie Pascale Mirella', '2019-05-02', '2019-09-01', 'CACMM02', 'M1810713019502', '1971-10-18', '58059954 Orange57321955 Emtel', 'mirellamartial@gmail.com', 'Avenue Bounty', 'Albion', 'Carer', 'Full Time', '000033536007', 'MCB', 'Savings', 'N/A', '8900', 0, '0', '0', 8900, 0, '#66fff5'),
(4, 'Castel', 'Marie-Anne Ronnica', '2019-06-10', '2021-01-21', 'CACAC04', 'C2301953801348', '1995-01-23', '58593744', 'castelcastel47@gmail.com', '27, Shakespear, Richelieu', 'Petite-Rivière', 'Carer', 'Full Time', '000444062971', 'MCB', 'Savings', NULL, '9700', 54, '1188', '388', 10500, 0, '#8f66ff'),
(5, 'Payendee', 'Varada Luxmee', '2019-12-02', '2021-05-24', 'CACVP06', 'P190895380056E', '1995-08-19', '5944004458255255', 'vanna.payendee@gmail.com', '7, Verger Bissambar', 'Mont Roches', 'Carer', 'Full Time', '000443690014', 'MCB', 'Savings', NULL, '9700', 62, '1364', '388', 10676, 0, '#66ff7f'),
(6, 'Townsend', 'Marie Emilie Sabrina', '2020-02-18', '2020-06-30', 'CACTE07', 'T010900390222B', '2000-09-01', '57266659', 'sabrinatownsend0602@gmail.com', '72, Allee Jacques, Morc Eaux Bonne', 'Bambous', 'Student f', 'Part Time', '020001339230', 'MAUBANK', 'Savings', NULL, '4000', 0, '0', '0', 4000, 0, '#ffb866'),
(7, 'Mootoo', 'Anne-Marie', '2019-06-01', NULL, 'CACAA03', 'A0807668106519', '1966-07-08', '59354726', NULL, 'Avenue Bounty', 'Albion', 'Maid', 'Part Time', '01810100238223', 'SBM', 'Savings', NULL, '2000', 0, '0', '0', 2200, 0, '#66ffbd'),
(8, 'Bundhoo', 'Iswarjeet', '2019-09-01', NULL, 'CACIB05', 'B3112703550007A', '1970-12-31', '54743488', NULL, 'Cr Simonet and Cresson Lane', 'Canot', 'Gardenner', 'Part Time', '000014844885', 'MCB', 'Savings', NULL, '1600', 0, '0', '0', 1600, 0, '#ff66f2'),
(10, 'Allet', 'Isabelle', '2020-06-17', '2020-09-30', 'CACIA08', 'A200276300547A', '1976-02-20', '57171310', 'izabelallet@gmail.com', 'Avenue des Nenuphars, Morcellement Belle Vue ', 'Albion', 'Part Time', 'Active', '000052214206', 'MCB', 'Savings', NULL, '5000', 0, '0', '0', 5000, 0, '#ff6666'),
(11, 'Bernard ', 'Marie Kelly', '2020-07-06', '2020-09-30', 'CAAKB09', 'L200388381168E', '2020-03-20', '54937897', 'kgbernard004.kl@gmail.com', '24, Iqbal ', 'Cité Richelieu', 'Part Time', 'Active', '000446645761', 'MCB', 'Savings', NULL, '4500', 54, '1188', NULL, 5680, 0, '#ff66b8'),
(12, 'Marie Davina Christiane', 'Thomas', '2020-09-08', '2020-12-31', 'CACTD10', 'J010483380892F', '1983-04-01', '57096372', 'danajeanmc@gmail.com', '2 Avenue La Ferme', 'Bambous', 'Maid and ', 'Active', '50300000104483', 'SBM', 'Savings', NULL, '7000', 108, '2376', '0', 9376, 0, '#66f5ff'),
(13, 'Johnnyza Anna Cheila', 'Juglall', '2020-10-02', '2021-05-08', 'CACJC11', 'E170863110478A', NULL, '59842917', 'cheilaernestjuglall@yahoo.com', 'Avenue des Longaniers', 'Morcellement Belle Vue, Albion', 'Assistant', 'Active', '000446257834', 'MCB', 'Savings', 'Carer resi', '10075', 0, '0', '0', 10075, 0, '#66b0ff'),
(14, 'Kateney Tracy Marie', 'Dwarika', '2021-01-25', '2022-01-31', 'CACDK12', 'D070399380555F', '1999-03-07', '54756786', 'katedwa07@gmail.com', '56, Acrise Lane, Petite Rivière', 'Albion', 'Maid and ', 'Active', '000033482403', 'MCB', 'Savings', NULL, '10075', 48, '1056', '0', NULL, 0, '#000000'),
(16, 'Claite', 'Marie Adèle Céline', '2021-01-20', NULL, 'CACCC13', 'C1109964102855', '1996-09-11', '59208810', 'collard329@gmail.com', 'App 3B, Mandarin Court, Rue Ambrose', 'Rose Hill', 'Carer / l', 'Active', '000033205272', 'MCB', 'Savings', NULL, '10075', 62, '1364', NULL, 9064, 0, '#000000'),
(17, 'Marie Anne Sarah Rachel', 'Appadoo', '2021-02-23', '2021-04-30', 'CACAA14', 'A230202006084D', '2002-03-23', '54742500', 'annsarahapp23@gmail.com', 'Avenue Bel Eau 61 Camp Créole', 'Albion', 'Part Time', 'Active', '000447813501', 'MCB', 'Savings', NULL, '4000', 0, '0', NULL, 4000, 0, '#000000'),
(18, 'Marie-Hélène', 'Adolphe', '2021-02-15', '2021-02-22', NULL, NULL, '1965-05-16', '59126584', NULL, 'Avenue des Bananiers', 'Albion', 'Part Time', 'Active', '000444951911', 'MCB', 'Savings', NULL, '4000', 0, '0', '0', 4000, 0, '#000000'),
(19, 'Marie Alisha Nathanielle', 'Angasamy', '2021-10-01', NULL, NULL, 'A0209993819714', '1999-09-02', '58540394', 'alishanathanielle@gmail.com', 'Route Albion', 'Petite Rivière, Petit Verger Road', 'Stagière ', 'Active', '000014980193', 'MCB', 'Savings', NULL, NULL, 60, NULL, NULL, NULL, 0, '#000000'),
(20, 'Clark-Pigeot', 'Rose Mary Catherine', '2022-02-14', '2023-07-31', NULL, 'C060186310007E', '1986-01-06', '57082583', 'catherineclarkpigeot06@gmail.com', 'Dhalia Av Morc Beerjeeraz', 'Albion', 'Carer', 'Active', '000202758788', 'MCB', 'Savings', NULL, '10575', 0, '0', NULL, NULL, 0, '#000000'),
(21, 'Catherine', 'Hurrucksing', '2022-02-28', '2022-07-04', NULL, 'H040368300555A', '1968-03-04', '58433086 / 57648304', NULL, 'Route Royale Petite Rivière', NULL, 'Maid and ', 'DECEASED', '000445336242', 'MCB', 'Savings', NULL, '6000', 24, '1188', NULL, NULL, 0, '#000000'),
(22, 'Stéphanie Marie Anabele', 'Rougeot', '2022-03-10', NULL, NULL, 'R2904873819041', NULL, '58017627', NULL, '5 Avenue Crocus Cité', 'Pointe aux Sables', 'Carer', 'Active', NULL, NULL, NULL, NULL, '10575', 112, NULL, NULL, NULL, 0, '#000000'),
(23, 'Marie Brinda Sorenza', 'Gaspard', '2022-07-18', NULL, NULL, 'M1606973815830', '1997-06-16', '58403540 / 54289805', 'sorenzagaspard1997@gmail.com', 'No 55 Winston Churchill', 'Richelieu, Petite Rivière', 'Carer', 'Active', '000445337931', 'MCB', 'Savings', NULL, '10575', 70, NULL, NULL, NULL, 0, '#000000'),
(24, 'Charonne', 'Poongavanon', '2022-07-18', '2022-09-23', NULL, 'B251188304981A', '1988-11-25', '57132241', 'charonne.poongavanon@gmail.com', 'Avenue des Dahlias, Morcellement Beerjeeraz', 'Albion', 'Cleaner /', 'Active', '000445754451', 'MCB', 'Savings', NULL, NULL, 0, NULL, NULL, NULL, 0, '#000000'),
(25, 'Gaspard', 'Mary Dawn Jamie Rachel', '2022-08-29', NULL, NULL, 'G250303006673E', '2003-03-25', '57342220', 'gaspardjaimie@gmail.com', 'S12 Avenue de l\'indépendence', 'Quatre-Bornes', 'Helper pa', 'Active', '000448743717', 'MCB', NULL, NULL, NULL, 70, NULL, NULL, NULL, 0, '#000000'),
(26, 'Tamby', 'Marie Véronique Pascaline', '2023-03-02', NULL, NULL, 'L240587382072D', '1987-05-24', '57677456', NULL, 'C24 Résidence Vetiver', 'Petite Rivière', 'Cleaner /', 'Active', '000448244144', 'MCB', 'Savings', NULL, 'Rs 700', 60, NULL, NULL, NULL, 0, '#000000');

-- --------------------------------------------------------

--
-- Table structure for table `creche_personnel_categories`
--

CREATE TABLE `creche_personnel_categories` (
  `id_personnel_categorie` int(11) NOT NULL,
  `nom` varchar(50) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `creche_personnel_categories`
--

INSERT INTO `creche_personnel_categories` (`id_personnel_categorie`, `nom`) VALUES
(1, 'DIRECTOR'),
(2, 'MANAGER'),
(3, 'STAFF CARERS'),
(4, 'STUDENT\'S STIPEN'),
(5, 'HOUSEKEEPING'),
(6, 'GARDENER');

-- --------------------------------------------------------

--
-- Table structure for table `creche_personnel_conges`
--

CREATE TABLE `creche_personnel_conges` (
  `id_personnel` int(11) NOT NULL,
  `date_from` date NOT NULL,
  `date_to` date NOT NULL,
  `AM_PM` enum('AM','PM','allday') NOT NULL,
  `classique_maladie` enum('classique','maladie') NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `creche_personnel_conges`
--

INSERT INTO `creche_personnel_conges` (`id_personnel`, `date_from`, `date_to`, `AM_PM`, `classique_maladie`) VALUES
(1, '2020-09-03', '2020-09-03', 'PM', 'classique'),
(1, '2021-05-03', '2021-03-05', 'allday', 'classique'),
(1, '2022-01-04', '2022-01-06', 'allday', 'classique'),
(1, '2023-01-05', '2023-01-06', 'allday', 'classique'),
(1, '2023-01-09', '2023-01-09', 'allday', 'classique'),
(1, '2023-03-07', '2023-03-07', 'allday', 'maladie'),
(1, '2023-03-23', '2023-03-24', 'allday', 'classique'),
(1, '2023-06-01', '2023-06-09', 'allday', 'classique'),
(2, '2021-10-22', '2021-10-22', 'allday', 'classique'),
(2, '2021-10-25', '2021-10-27', 'allday', 'classique'),
(2, '2021-11-05', '2021-11-05', 'allday', 'classique'),
(2, '2021-11-16', '2021-11-16', 'allday', 'maladie'),
(2, '2021-11-17', '2021-11-17', 'allday', 'maladie'),
(2, '2021-12-13', '2021-12-13', 'allday', 'classique'),
(2, '2021-12-14', '2021-12-14', 'allday', 'classique'),
(2, '2021-12-15', '2021-12-15', 'allday', 'classique'),
(2, '2022-01-03', '2022-01-03', 'allday', 'classique'),
(2, '2022-01-04', '2022-01-04', 'allday', 'classique'),
(2, '2022-01-05', '2022-01-05', 'allday', 'classique'),
(2, '2022-01-20', '2022-01-20', 'allday', 'maladie'),
(2, '2022-01-21', '2022-01-21', 'allday', 'maladie'),
(2, '2022-03-02', '2022-03-02', 'AM', 'classique'),
(2, '2022-03-14', '2022-03-14', 'allday', 'maladie'),
(2, '2022-03-18', '2022-03-18', 'allday', 'maladie'),
(2, '2022-03-21', '2022-03-21', 'PM', 'maladie'),
(2, '2022-03-22', '2022-03-24', 'allday', 'maladie'),
(2, '2022-03-25', '2022-03-25', 'allday', 'maladie'),
(2, '2022-04-01', '2022-04-01', 'PM', 'classique'),
(2, '2022-04-12', '2022-04-12', 'PM', 'classique'),
(2, '2022-04-15', '2022-04-15', 'allday', 'maladie'),
(2, '2022-04-29', '2022-04-29', 'PM', 'classique'),
(2, '2022-05-18', '2022-05-18', 'allday', 'maladie'),
(2, '2022-05-27', '2022-05-27', 'PM', 'classique'),
(2, '2022-05-31', '2022-05-31', 'allday', 'classique'),
(2, '2022-06-01', '2022-06-01', 'allday', 'classique'),
(2, '2022-06-02', '2022-06-02', 'allday', 'classique'),
(2, '2022-06-03', '2022-06-03', 'allday', 'classique'),
(2, '2022-06-06', '2022-06-10', 'allday', 'classique'),
(2, '2022-06-13', '2022-06-14', 'allday', 'classique'),
(2, '2022-06-15', '2022-06-17', 'allday', 'classique'),
(2, '2022-06-20', '2022-06-24', 'allday', 'classique'),
(2, '2022-06-27', '2022-06-30', 'allday', 'classique'),
(4, '2020-01-23', '2020-01-24', 'allday', 'classique'),
(4, '2020-03-03', '2020-03-03', 'allday', 'classique'),
(4, '2020-07-02', '2020-07-03', 'allday', 'maladie'),
(4, '2020-07-16', '2020-07-17', 'allday', 'maladie'),
(4, '2020-07-20', '2020-07-24', 'allday', 'maladie'),
(4, '2020-08-06', '2020-08-06', 'allday', 'classique'),
(4, '2020-08-07', '2020-08-07', 'allday', 'classique'),
(4, '2020-09-02', '2020-09-02', 'PM', 'classique'),
(4, '2020-09-03', '2020-09-03', 'allday', 'classique'),
(4, '2020-09-04', '2020-09-04', 'allday', 'maladie'),
(4, '2020-09-07', '2020-09-07', 'allday', 'classique'),
(4, '2020-09-18', '2020-09-18', 'allday', 'classique'),
(4, '2020-10-12', '2020-10-12', 'allday', 'classique'),
(4, '2020-10-13', '2020-10-13', 'allday', 'maladie'),
(4, '2020-10-20', '2020-10-20', 'PM', 'classique'),
(4, '2020-10-21', '2020-10-21', 'allday', 'maladie'),
(4, '2020-11-03', '2020-11-03', 'allday', 'classique'),
(4, '2020-11-16', '2020-11-16', 'allday', 'classique'),
(4, '2020-12-02', '2020-12-02', 'allday', 'maladie'),
(4, '2020-12-11', '2020-12-11', 'allday', 'classique'),
(4, '2021-01-04', '2021-01-06', 'allday', 'classique'),
(4, '2021-01-15', '2021-01-15', 'allday', 'classique'),
(4, '2021-01-18', '2021-01-21', 'allday', 'maladie'),
(5, '2020-01-29', '2020-01-29', 'allday', 'maladie'),
(5, '2020-02-17', '2020-02-17', 'allday', 'classique'),
(5, '2020-07-13', '2020-07-13', 'allday', 'maladie'),
(5, '2020-07-21', '2020-07-21', 'allday', 'maladie'),
(5, '2020-08-19', '2020-08-19', 'allday', 'classique'),
(5, '2020-08-31', '2020-08-31', 'allday', 'maladie'),
(5, '2020-09-01', '2020-09-01', 'allday', 'maladie'),
(5, '2020-09-23', '2020-09-24', 'allday', 'maladie'),
(5, '2020-10-15', '2020-10-15', 'AM', 'classique'),
(5, '2020-10-29', '2020-10-30', 'allday', 'classique'),
(5, '2020-11-16', '2020-11-16', 'allday', 'maladie'),
(5, '2020-12-04', '2020-12-04', 'allday', 'classique'),
(5, '2020-12-15', '2020-12-15', 'allday', 'classique'),
(5, '2020-12-23', '2020-12-23', 'allday', 'maladie'),
(5, '2021-01-04', '2021-01-06', 'allday', 'classique'),
(5, '2021-02-03', '2021-02-04', 'allday', 'maladie'),
(5, '2021-02-22', '2021-02-23', 'allday', 'maladie'),
(5, '2021-02-26', '2021-02-26', 'allday', 'maladie'),
(5, '2021-05-04', '2021-05-04', 'allday', 'classique'),
(5, '2021-05-05', '2021-05-05', 'allday', 'maladie'),
(5, '2021-05-07', '2021-05-07', 'allday', 'classique'),
(5, '2021-05-11', '2021-05-21', 'allday', 'maladie'),
(10, '2020-07-01', '2020-07-01', 'allday', 'classique'),
(10, '2020-07-09', '2020-07-09', 'allday', 'maladie'),
(10, '2020-07-31', '2020-07-31', 'allday', 'maladie'),
(10, '2020-08-03', '2020-08-03', 'allday', 'maladie'),
(10, '2020-08-07', '2020-08-07', 'allday', 'classique'),
(10, '2020-08-10', '2020-08-10', 'allday', 'classique'),
(10, '2020-08-24', '2020-08-24', 'allday', 'classique'),
(10, '2020-09-17', '2020-09-17', 'allday', 'classique'),
(10, '2020-09-28', '2020-09-28', 'allday', 'classique'),
(11, '2020-07-27', '2020-07-27', 'allday', 'classique'),
(11, '2020-07-28', '2020-07-28', 'allday', 'maladie'),
(11, '2020-09-11', '2020-09-11', 'allday', 'classique'),
(12, '2020-11-04', '2020-11-04', 'allday', 'maladie'),
(12, '2020-11-24', '2020-11-24', 'allday', 'maladie'),
(12, '2021-01-15', '2021-01-15', 'allday', 'maladie'),
(12, '2021-01-18', '2021-01-31', 'allday', 'maladie'),
(13, '2021-01-04', '2021-01-06', 'allday', 'classique'),
(14, '2021-02-16', '2021-02-16', 'allday', 'maladie'),
(14, '2021-03-01', '2021-03-01', 'PM', 'classique'),
(14, '2021-03-05', '2021-03-05', 'allday', 'maladie'),
(14, '2021-07-01', '2021-07-01', 'allday', 'classique'),
(14, '2021-07-26', '2021-07-28', 'allday', 'maladie'),
(14, '2021-10-26', '2021-10-29', 'allday', 'maladie'),
(14, '2021-11-03', '2021-11-03', 'allday', 'maladie'),
(14, '2021-11-05', '2021-11-05', 'allday', 'maladie'),
(14, '2021-11-08', '2021-11-08', 'allday', 'maladie'),
(14, '2021-11-09', '2021-11-09', 'allday', 'maladie'),
(14, '2021-11-10', '2021-11-10', 'allday', 'maladie'),
(14, '2021-11-11', '2021-11-11', 'allday', 'maladie'),
(14, '2021-11-12', '2021-11-12', 'allday', 'maladie'),
(14, '2021-12-07', '2021-12-07', 'PM', 'classique'),
(14, '2022-01-24', '2022-01-26', 'allday', 'classique'),
(14, '2022-01-27', '2022-01-28', 'allday', 'classique'),
(14, '2022-01-31', '2022-01-31', 'allday', 'classique'),
(16, '2021-01-26', '2021-01-26', 'allday', 'maladie'),
(16, '2021-02-18', '2021-02-18', 'allday', 'classique'),
(16, '2021-07-12', '2021-07-12', 'allday', 'maladie'),
(16, '2021-07-23', '2021-07-23', 'allday', 'classique'),
(16, '2021-07-26', '2021-07-26', 'allday', 'classique'),
(16, '2021-07-27', '2021-07-27', 'allday', 'classique'),
(16, '2021-07-28', '2021-07-28', 'allday', 'classique'),
(16, '2021-07-29', '2021-07-29', 'allday', 'classique'),
(16, '2021-07-30', '2021-07-30', 'allday', 'classique'),
(16, '2021-09-13', '2021-09-13', 'allday', 'classique'),
(16, '2021-10-19', '2021-10-19', 'allday', 'maladie'),
(16, '2021-11-08', '2021-11-08', 'allday', 'maladie'),
(16, '2021-11-24', '2021-11-24', 'PM', 'maladie'),
(16, '2021-11-25', '2021-11-25', 'allday', 'maladie'),
(16, '2021-11-30', '2021-11-30', 'allday', 'maladie'),
(16, '2021-12-01', '2021-12-01', 'allday', 'classique'),
(16, '2021-12-02', '2021-12-02', 'allday', 'classique'),
(16, '2021-12-03', '2021-12-03', 'allday', 'classique'),
(16, '2021-12-06', '2021-12-06', 'allday', 'classique'),
(16, '2021-12-07', '2021-12-07', 'allday', 'classique'),
(16, '2021-12-08', '2021-12-08', 'allday', 'classique'),
(16, '2021-12-09', '2021-12-09', 'allday', 'classique'),
(16, '2022-01-19', '2022-01-19', 'allday', 'maladie'),
(16, '2022-02-04', '2022-02-04', 'allday', 'classique'),
(16, '2022-02-10', '2022-02-10', 'allday', 'maladie'),
(16, '2022-02-11', '2022-02-11', 'allday', 'maladie'),
(16, '2022-02-17', '2022-02-17', 'allday', 'classique'),
(16, '2022-02-22', '2022-02-22', 'allday', 'classique'),
(16, '2022-02-23', '2022-02-23', 'allday', 'classique'),
(16, '2022-02-24', '2022-02-24', 'allday', 'maladie'),
(16, '2022-02-25', '2022-02-25', 'allday', 'maladie'),
(16, '2022-02-28', '2022-02-28', 'allday', 'maladie'),
(16, '2022-03-02', '2022-03-02', 'allday', 'maladie'),
(16, '2022-03-03', '2022-03-03', 'allday', 'maladie'),
(16, '2022-03-07', '2022-03-08', 'allday', 'maladie'),
(16, '2022-03-09', '2022-03-09', 'PM', 'classique'),
(16, '2022-03-10', '2022-03-11', 'allday', 'classique'),
(16, '2022-03-14', '2022-03-18', 'allday', 'classique'),
(19, '2022-01-03', '2022-01-05', 'allday', 'classique'),
(19, '2022-01-04', '2022-01-06', 'allday', 'classique'),
(19, '2022-02-25', '2022-02-25', 'allday', 'classique'),
(19, '2022-03-21', '2022-03-21', 'allday', 'maladie'),
(19, '2022-06-08', '2022-06-08', 'allday', 'maladie'),
(19, '2022-06-15', '2022-06-15', 'PM', 'classique'),
(19, '2022-10-14', '2022-10-14', 'allday', 'maladie'),
(19, '2022-11-08', '2022-11-08', 'allday', 'classique'),
(19, '2022-11-28', '2022-11-28', 'allday', 'classique'),
(19, '2023-01-05', '2023-01-06', 'allday', 'classique'),
(19, '2023-01-09', '2023-01-09', 'allday', 'classique'),
(19, '2023-01-13', '2023-01-13', 'allday', 'classique'),
(19, '2023-02-10', '2023-02-10', 'allday', 'classique'),
(19, '2023-02-13', '2023-02-13', 'PM', 'classique'),
(19, '2023-02-28', '2023-02-28', 'allday', 'classique'),
(19, '2023-03-01', '2023-03-02', 'allday', 'classique'),
(19, '2023-03-07', '2023-03-07', 'allday', 'maladie'),
(19, '2023-04-12', '2023-04-12', 'PM', 'classique'),
(19, '2023-04-13', '2023-04-13', 'allday', 'classique'),
(19, '2023-04-20', '2023-04-20', 'allday', 'maladie'),
(19, '2023-04-24', '2023-04-24', 'PM', 'classique'),
(19, '2023-05-04', '2023-05-04', 'allday', 'classique'),
(19, '2023-05-12', '2023-05-12', 'allday', 'classique'),
(19, '2023-05-24', '2023-05-24', 'PM', 'classique'),
(19, '2023-05-26', '2023-05-26', 'PM', 'classique'),
(19, '2023-06-06', '2023-06-06', 'PM', 'classique'),
(19, '2023-06-09', '2023-06-09', 'AM', 'classique'),
(19, '2023-06-15', '2023-06-15', 'allday', 'classique'),
(19, '2023-06-19', '2023-06-21', 'allday', 'maladie'),
(19, '2023-06-21', '2023-06-21', 'allday', 'maladie'),
(19, '2023-06-22', '2023-06-22', 'allday', 'classique'),
(19, '2023-06-28', '2023-06-29', 'allday', 'classique'),
(19, '2023-06-30', '2023-06-30', 'allday', 'classique'),
(20, '2022-01-03', '2022-01-05', 'allday', 'classique'),
(20, '2022-01-04', '2022-01-06', 'allday', 'classique'),
(20, '2022-02-16', '2022-02-16', 'allday', 'maladie'),
(20, '2022-03-07', '2022-03-07', 'allday', 'maladie'),
(20, '2022-04-06', '2022-04-08', 'allday', 'maladie'),
(20, '2022-06-21', '2022-06-21', 'allday', 'maladie'),
(20, '2022-06-22', '2022-06-22', 'allday', 'maladie'),
(20, '2022-07-26', '2022-07-26', 'allday', 'classique'),
(20, '2022-08-22', '2022-08-26', 'allday', 'maladie'),
(20, '2022-08-29', '2022-08-31', 'allday', 'maladie'),
(20, '2022-09-02', '2022-09-02', 'allday', 'maladie'),
(20, '2022-09-05', '2022-09-09', 'allday', 'maladie'),
(20, '2022-09-12', '2022-09-12', 'allday', 'maladie'),
(20, '2022-09-13', '2022-09-13', 'allday', 'maladie'),
(20, '2022-11-22', '2022-11-22', 'allday', 'classique'),
(20, '2022-11-28', '2022-11-30', 'allday', 'maladie'),
(20, '2022-12-01', '2022-12-02', 'allday', 'maladie'),
(20, '2023-01-05', '2023-01-06', 'allday', 'classique'),
(20, '2023-01-09', '2023-01-09', 'allday', 'classique'),
(20, '2023-01-18', '2023-01-18', 'allday', 'maladie'),
(20, '2023-02-07', '2023-02-08', 'allday', 'maladie'),
(20, '2023-02-13', '2023-02-16', 'allday', 'maladie'),
(20, '2023-03-09', '2023-03-09', 'allday', 'classique'),
(20, '2023-05-08', '2023-05-08', 'AM', 'classique'),
(20, '2023-05-09', '2023-05-09', 'AM', 'classique'),
(20, '2023-05-15', '2023-05-15', 'allday', 'maladie'),
(20, '2023-05-16', '2023-05-16', 'allday', 'maladie'),
(20, '2023-05-17', '2023-05-17', 'PM', 'maladie'),
(20, '2023-06-02', '2023-06-02', 'allday', 'classique'),
(20, '2023-06-19', '2023-06-19', 'allday', 'maladie'),
(20, '2023-06-20', '2023-06-20', 'allday', 'maladie'),
(20, '2023-06-21', '2023-06-21', 'allday', 'maladie'),
(20, '2023-07-11', '2023-07-11', 'PM', 'classique'),
(20, '2023-07-20', '2023-07-20', 'allday', 'classique'),
(20, '2023-07-24', '2023-07-24', 'allday', 'maladie'),
(20, '2023-07-25', '2023-07-25', 'allday', 'maladie'),
(20, '2023-07-26', '2023-07-26', 'allday', 'maladie'),
(20, '2023-07-27', '2023-07-27', 'allday', 'classique'),
(21, '2022-01-03', '2022-01-05', 'allday', 'classique'),
(21, '2022-01-04', '2022-01-06', 'allday', 'classique'),
(21, '2022-03-08', '2022-03-08', 'allday', 'maladie'),
(21, '2022-06-24', '2022-06-24', 'allday', 'classique'),
(22, '2022-01-03', '2022-01-05', 'allday', 'classique'),
(22, '2022-01-04', '2022-01-06', 'allday', 'classique'),
(22, '2022-03-24', '2022-03-25', 'allday', 'maladie'),
(22, '2022-05-02', '2022-05-02', 'allday', 'classique'),
(22, '2022-05-23', '2022-05-23', 'allday', 'maladie'),
(22, '2022-05-31', '2022-05-31', 'allday', 'classique'),
(22, '2022-06-06', '2022-06-06', 'allday', 'maladie'),
(22, '2022-06-07', '2022-06-07', 'allday', 'maladie'),
(22, '2022-06-28', '2022-06-28', 'allday', 'classique'),
(22, '2022-08-02', '2022-08-02', 'allday', 'classique'),
(22, '2022-08-16', '2022-08-16', 'allday', 'maladie'),
(22, '2022-08-31', '2022-08-31', 'allday', 'maladie'),
(22, '2022-09-02', '2022-09-02', 'allday', 'maladie'),
(22, '2022-09-05', '2022-09-09', 'allday', 'maladie'),
(22, '2022-10-06', '2022-10-06', 'allday', 'maladie'),
(22, '2022-10-25', '2022-10-25', 'allday', 'maladie'),
(22, '2022-11-07', '2022-11-07', 'allday', 'classique'),
(22, '2022-11-24', '2022-11-24', 'allday', 'maladie'),
(22, '2023-01-05', '2023-01-06', 'allday', 'classique'),
(22, '2023-01-09', '2023-01-09', 'allday', 'classique'),
(22, '2023-01-23', '2023-01-23', 'allday', 'classique'),
(22, '2023-02-16', '2023-02-16', 'allday', 'maladie'),
(22, '2023-03-14', '2023-03-14', 'allday', 'classique'),
(22, '2023-04-03', '2023-04-03', 'allday', 'maladie'),
(22, '2023-04-17', '2023-04-17', 'allday', 'maladie'),
(22, '2023-04-28', '2023-04-28', 'allday', 'classique'),
(22, '2023-05-26', '2023-05-26', 'allday', 'classique'),
(22, '2023-05-31', '2023-05-31', 'allday', 'classique'),
(22, '2023-06-07', '2023-06-07', 'allday', 'classique'),
(22, '2023-06-14', '2023-06-14', 'allday', 'classique'),
(22, '2023-07-03', '2023-07-03', 'allday', 'maladie'),
(22, '2023-07-04', '2023-07-04', 'allday', 'maladie'),
(22, '2023-07-13', '2023-07-13', 'AM', 'classique'),
(23, '2022-08-08', '2022-08-08', 'allday', 'maladie'),
(23, '2022-08-19', '2022-08-19', 'allday', 'classique'),
(23, '2022-09-06', '2022-09-06', 'allday', 'maladie'),
(23, '2022-09-19', '2022-09-19', 'allday', 'classique'),
(23, '2022-10-10', '2022-10-10', 'allday', 'maladie'),
(23, '2023-01-05', '2023-01-06', 'allday', 'classique'),
(23, '2023-01-09', '2023-01-09', 'allday', 'classique'),
(23, '2023-02-02', '2023-02-02', 'allday', 'classique'),
(23, '2023-02-13', '2023-02-13', 'allday', 'maladie'),
(23, '2023-04-18', '2023-04-18', 'PM', 'classique'),
(23, '2023-04-24', '2023-04-24', 'allday', 'maladie'),
(23, '2023-05-03', '2023-05-03', 'allday', 'classique'),
(23, '2023-05-04', '2023-05-04', 'AM', 'classique'),
(23, '2023-05-16', '2023-05-16', 'allday', 'classique'),
(23, '2023-05-22', '2023-05-22', 'PM', 'classique'),
(23, '2023-06-05', '2023-06-05', 'PM', 'classique'),
(23, '2023-06-13', '2023-06-13', 'allday', 'maladie'),
(23, '2023-06-16', '2023-06-16', 'allday', 'classique'),
(23, '2023-06-22', '2023-06-22', 'allday', 'classique'),
(23, '2023-07-10', '2023-07-10', 'allday', 'maladie'),
(23, '2023-07-14', '2023-07-14', 'allday', 'maladie'),
(23, '2023-07-18', '2023-07-18', 'AM', 'classique'),
(23, '2023-07-19', '2023-07-19', 'AM', 'classique'),
(24, '2022-07-26', '2022-07-26', 'allday', 'classique'),
(24, '2022-07-28', '2022-07-28', 'allday', 'classique'),
(24, '2022-08-09', '2022-08-09', 'allday', 'maladie'),
(24, '2022-08-23', '2022-08-23', 'allday', 'classique'),
(24, '2022-09-05', '2022-09-05', 'allday', 'maladie'),
(24, '2022-09-15', '2022-09-15', 'allday', 'classique'),
(24, '2022-09-19', '2022-09-19', 'allday', 'maladie'),
(24, '2022-09-20', '2022-09-20', 'allday', 'maladie'),
(24, '2022-09-22', '2022-09-22', 'allday', 'maladie'),
(24, '2022-09-23', '2022-09-23', 'allday', 'maladie'),
(24, '2022-09-26', '2022-09-30', 'allday', 'classique'),
(26, '2023-03-07', '2023-03-07', 'allday', 'maladie'),
(26, '2023-03-16', '2023-03-16', 'allday', 'maladie'),
(26, '2023-03-21', '2023-03-21', 'allday', 'classique'),
(26, '2023-03-31', '2023-03-31', 'allday', 'maladie'),
(26, '2023-04-17', '2023-04-17', 'allday', 'classique'),
(26, '2023-05-15', '2023-05-15', 'allday', 'maladie'),
(26, '2023-05-25', '2023-05-25', 'allday', 'classique'),
(26, '2023-06-26', '2023-06-26', 'allday', 'maladie'),
(26, '2023-07-05', '2023-07-05', 'allday', 'maladie'),
(26, '2023-07-06', '2023-07-06', 'allday', 'maladie');

-- --------------------------------------------------------

--
-- Table structure for table `creche_planning`
--

CREATE TABLE `creche_planning` (
  `id_creche_planning` int(11) NOT NULL,
  `id_personnel` int(11) NOT NULL,
  `datetime_from` datetime NOT NULL,
  `datetime_to` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `creche_planning`
--

INSERT INTO `creche_planning` (`id_creche_planning`, `id_personnel`, `datetime_from`, `datetime_to`) VALUES
(1, 5, '2020-12-01 07:00:00', '2020-12-01 15:00:00'),
(2, 13, '2020-12-01 08:30:00', '2020-12-01 17:30:00'),
(3, 4, '2020-12-01 10:00:00', '2020-12-01 18:00:00'),
(4, 4, '2020-12-02 07:00:00', '2020-12-02 15:00:00'),
(5, 13, '2020-12-02 08:30:00', '2020-12-02 17:30:00'),
(6, 5, '2020-12-02 10:00:00', '2020-12-02 18:00:00'),
(7, 5, '2020-12-03 07:00:00', '2020-12-03 15:00:00'),
(8, 13, '2020-12-03 08:30:00', '2020-12-03 17:30:00'),
(9, 4, '2020-12-03 10:00:00', '2020-12-03 18:00:00');

-- --------------------------------------------------------

--
-- Table structure for table `documentation`
--

CREATE TABLE `documentation` (
  `id_documentation` int(11) NOT NULL,
  `niveau` varchar(20) NOT NULL,
  `titre` varchar(255) NOT NULL,
  `html` mediumtext NOT NULL,
  `orientation` enum('portrait','landscape') NOT NULL,
  `datetime_update` datetime NOT NULL,
  `id_personnel_update` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `documentation`
--

INSERT INTO `documentation` (`id_documentation`, `niveau`, `titre`, `html`, `orientation`, `datetime_update`, `id_personnel_update`) VALUES
(1, '1', 'Documentation de conformité à la RGPD', '<p>Le <strong>25 mai 2018</strong>, le R&egrave;glement (UE) 2016/679 du Parlement europ&eacute;en et du Conseil du 27 avril 2016, entrera en application.</p>\r\n<p>Pour prouver notre conformit&eacute; au r&egrave;glement, nous avons constitu&eacute; et regroup&eacute; au sein de notre base de donn&eacute;e la documentation suivante. Dans cette documentation, le R&egrave;glement g&eacute;n&eacute;ral sur la protection des donn&eacute;es sera repr&eacute;sent&eacute; sous le signe \"RGPD\"</p>\r\n<p><span style=\"text-decoration: underline;\">Donn&eacute;es sensibles</span> (origine CNIL)&nbsp;:</p>\r\n<p>Ce sont des informations qui r&eacute;v&egrave;lent les origines raciales ou ethniques, les opinions politiques, philosophiques ou religieuses, l\'appartenance syndicale, la sant&eacute; ou la vie sexuelle d\'une personne. La loi informatique et libert&eacute;s interdit de recueillir et d\'utiliser ces donn&eacute;es, sauf dans certains cas et notamment :</p>\r\n<ul>\r\n<li>Si la personne concern&eacute;e a donn&eacute; son consentement expr&egrave;s (d&eacute;marche active, explicite et de pr&eacute;f&eacute;rence &eacute;crite, qui doit &ecirc;tre libre, sp&eacute;cifique, et inform&eacute;e),</li>\r\n<li>Si les informations sont rendues publiques par la personne concern&eacute;e,</li>\r\n<li>Si elles sont n&eacute;cessaires &agrave; la sauvegarde de la vie humaine,</li>\r\n<li>Si leur utilisation est justifi&eacute;e par l\'int&eacute;r&ecirc;t public et autoris&eacute; par la CNIL,</li>\r\n<li>Si elles concernent les membres ou adh&eacute;rents d\'une association ou d\'une organisation politique, religieuse, philosophique, politique ou syndicale.</li>\r\n</ul>\r\n<p><span style=\"text-decoration: underline;\">Attention aux champs libres et aux zones commentaires</span> (origine CNIL)</p>\r\n<p>Les progiciels de gestion de relation client disposent parfois de champs &agrave; remplir librement, appel&eacute;s &laquo;zones commentaires&raquo; ou &laquo;bloc-notes&raquo;.</p>\r\n<p>Ces champs de texte libre sont utiles pour assurer le suivi d&rsquo;un dossier ou pour personnaliser une relation. S&rsquo;il n&rsquo;est pas interdit d&rsquo;y recourir, des actions de sensibilisation et des r&egrave;gles de gestion doivent encadrer leur utilisation pour &eacute;viter que les commentaires saisis puissent porter atteinte aux droits des personnes concern&eacute;es.</p>\r\n<p>Certains commentaires peuvent en effet &ecirc;tre d&eacute;sobligeants, discriminants, voire injurieux, ou encore faire apparaitre des donn&eacute;es dites &laquo; sensibles &raquo; telles que des donn&eacute;es relatives &agrave; la sant&eacute;.</p>\r\n<p>La meilleure des pr&eacute;cautions est de garder &agrave; l&rsquo;esprit que les personnes concern&eacute;es (clients, usagers, salari&eacute;s&hellip;) peuvent, &agrave; tout moment et sur simple demande, acc&eacute;der au contenu de ces zones commentaires en exer&ccedil;ant leur droit d&rsquo;acc&egrave;s.</p>\r\n<p><span style=\"text-decoration: underline;\">L&eacute;gislation</span> (Code p&eacute;nal)</p>\r\n<ul>\r\n<li>Code p&eacute;nal - Article 226-16-1</li>\r\n<li>Code p&eacute;nal - Article 226-18</li>\r\n<li>Code p&eacute;nal - Article 226-19</li>\r\n</ul>', 'portrait', '2019-02-27 06:51:10', 1);
INSERT INTO `documentation` (`id_documentation`, `niveau`, `titre`, `html`, `orientation`, `datetime_update`, `id_personnel_update`) VALUES
(2, '1.1', 'Localisation et technologies du stockage des données', '<p>Les donn&eacute;es sont stock&eacute;es physiquement sur les serveurs OVH</p>\r\n<ol>\r\n<li><strong>Contr&ocirc;le des acc&egrave;s</strong> des site de Roulaix Valley (RBX 1,2, 3, 4,5) / Beauharnois (BHS) / Paris 19e (P19) et Strasbourg (SBG 1 et 3) et Gravelines (GRA) :\r\n<ul>\r\n<li>P&eacute;rimetres s&eacute;curis&eacute; par des cl&ocirc;tures &eacute;quip&eacute;es de barbel&eacute;s.</li>\r\n<li>Syst&egrave;me de vid&eacute;o-surveillance + d&eacute;tection de mouvement</li>\r\n<li>Activit&eacute; des centres de donn&eacute;es et &agrave; l\'ext&eacute;rieur des b&acirc;timents est monitor&eacute;e et enregistr&eacute; sur des serveyrs s&eacute;curis&eacute;s</li>\r\n<li>Equipe de surveillance 24h/24 ej/7</li>\r\n</ul>\r\n</li>\r\n<li><strong>Gestion des risques d\'incendie</strong>\r\n<ul>\r\n<li>Syst&egrave;me de d&eacute;tection d\'incendie + extinction incendie sur chaque salle du datacenter</li>\r\n<li>Portes coupe-feu</li>\r\n<li>R&egrave;gle APSAD R4 pour extincteurs portatifs et mobiles</li>\r\n<li>Certificat de conformit&eacute; N4</li>\r\n</ul>\r\n</li>\r\n<li><strong>R&eacute;seau OVH</strong> (Europe)<br /><br /><img title=\"reseau-ovh-europe.jpg\" src=\"data:image/jpeg;base64,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\" alt=\"\" width=\"900\" height=\"612\" /></li>\r\n<li><strong>Serveurs</strong><br />\r\n<ul>\r\n<li>Pr&eacute;sence humaine 24/7/365</li>\r\n<li>En cas d\'incident technique : retablissement dans les meilleurs d&eacute;lais</li>\r\n</ul>\r\n</li>\r\n<li><strong>Alimentation electrique</strong>\r\n<ul>\r\n<li>2 arriv&eacute;es &eacute;lectriques ind&eacute;pendante</li>\r\n<li>Onduleurs</li>\r\n<li>Groupes electrog&egrave;nes d\'une autonomie de 48h</li>\r\n</ul>\r\n</li>\r\n<li><strong>Centres de donn&eacute;es g&eacute;ographiquement distants</strong>\r\n<ul>\r\n<li>11 datacenter en France et 1 au Canada</li>\r\n<li>Continuit&eacute; de service m&ecirc;me en cas d\'incident majeur</li>\r\n<li>Exemple : sauvegarde de l\'h&eacute;bergement&nbsp; web h&eacute;berg&eacute; &agrave; Paris est repliqu&eacute;e chaque jour sur des machines &agrave; Roubaix</li>\r\n</ul>\r\n</li>\r\n<li><strong>Protection anti-DDOS (attaque)</strong>\r\n<ul>\r\n<li>3 infrastructures anti-DDoS de 160 Gbps (Roubaix / Strasbourg / Beauharnois)</li>\r\n</ul>\r\n</li>\r\n<li><strong>Certification ISO 27001</strong>\r\n<ul>\r\n<li>Mesures de s&eacute;curit&eacute;, appreciation des risques, plan de traitement des risques</li>\r\n<li>Donn&eacute;es disponibles, preserv&eacute;es de toute pertes, vol ou alt&eacute;ration</li>\r\n</ul>\r\n</li>\r\n</ol>\r\n<table style=\"border-collapse: collapse; width: 110.559%; height: 661px;\" border=\"1\">\r\n<tbody>\r\n<tr style=\"height: 643px;\">\r\n<td style=\"width: 50%;\"><img title=\"cisco-6k.jpg\" src=\"data:image/jpeg;base64,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\" alt=\"\" width=\"960\" height=\"639\" /></td>\r\n<td style=\"width: 50%;\"><img title=\"ovh.jpg\" src=\"data:image/jpeg;base64,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\" alt=\"\" width=\"800\" height=\"500\" /></td>\r\n</tr>\r\n<tr style=\"height: 18px;\">\r\n<td style=\"width: 50%;\"><img title=\"6261002-9355725.jpg\" src=\"data:image/jpeg;base64,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