<?php
require($_SERVER['DOCUMENT_ROOT'].'/espace_personnel/inc/head.php');
require($_SERVER['DOCUMENT_ROOT'].'/espace_personnel/inc/sidebar-eleve.php');
?>

<ul class="tabs" style="display:none">
  <li><a href="#1">Menu</a></li>
  <li><a href="#2">Planning perso</a></li>
  <li><a href="#3">Plannings excel</a></li>
</ul>
 
<div class="panes">

<!-- 1 * MENU-->

	<div>
		<div class="tab-content submenu">
			<div class="bloc bloc-img-1x2" style="background:url(/espace_personnel/images/plannings.jpg)" alt="Plannings"></div>
			<a class="bloc bloc-small bg-green" href="#2"><p><span>Mon planning<br>personnalisé</span></p></a>
			<a class="bloc bloc-small bg-light" href="#3"><p><span>Tous les plannings<br>en version téléchargeables</span></p></a>
			<span class="smaller clearfloat"><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br>Pour toute information sur les plannings, contactez le service scolarité à l'adresse suivante :<br><a href="mailto:scolarite@cnam.re">scolarite@cnam.re</a></span>
		</div>
	</div>


<!-- 2 * PLANNING PERSO-->

	<div>
		<?php require($_SERVER['DOCUMENT_ROOT'].'/espace_personnel/inc/back-button.php'); ?>
		<div class="tab-content">
			<select data-placeholder="-- Choisir le mois --" class="chzn-select" style="width:140px;position:absolute;top:145px;left:230px;" name="mois" id="mois" >
				<option value="2013-09-01">Septembre 2013</option>
				<option value="2013-10-01">Octobre 2013</option>
				<option value="2013-11-01">Novembre 2013</option>
				<option value="2013-12-01">Décembre 2013</option>
				<option value="2014-01-01">Janvier 2014</option>
				<option value="2014-02-01">Février 2014</option>
				<option value="2014-03-01">Mars 2014</option>
				<option value="2014-04-01">Avril 2014</option>
				<option value="2014-05-01">Mai 2014</option>
				<option value="2014-06-01" selected>Juin 2014</option>
			</select>
		</div>

		<div id="planning_display" style="position:relative;margin-top:40px;"></div>

	</div>

<!-- 3 * VERSIONS TELECHARGEABLES-->

	<?php
	// ========
	// PLANNING
	// ========

	$sql_planning_regroupement			= dbquery("SELECT * FROM planning_date_maj WHERE type = 'regroupement' AND actif='1'");
	$sql_planning_chat					= dbquery("SELECT * FROM planning_date_maj WHERE type = 'chat' AND actif='1'");
	$sql_planning_ich_annee_partie_1	= dbquery("SELECT * FROM planning_date_maj WHERE type = 'ich_annee_partie_1' AND actif='1'");
	$sql_planning_ich_annee_partie_2	= dbquery("SELECT * FROM planning_date_maj WHERE type = 'ich_annee_partie_2' AND actif='1'");

	if (dbnumrows($sql_planning_regroupement) > 0)		$date_maj_regroupement		= new DateTime(dbresult($sql_planning_regroupement,0,"date_maj"));
	if (dbnumrows($sql_planning_chat) > 0)				$date_maj_chat				= new DateTime(dbresult($sql_planning_chat,0,"date_maj"));


// ===============
// CNE (TEPE / LP)
// ===============
$sql_planning_TEPE	= dbquery("SELECT * FROM planning_date_maj WHERE type = 'cne_TEPE' AND actif='1'");
$sql_planning_LP	= dbquery("SELECT * FROM planning_date_maj WHERE type = 'cne_LP' AND actif='1'");

if (dbnumrows($sql_planning_TEPE) > 0)	$date_maj_TEPE	= new DateTime(dbresult($sql_planning_TEPE,0,"date_maj"));
if (dbnumrows($sql_planning_LP) > 0)	$date_maj_LP	= new DateTime(dbresult($sql_planning_LP,0,"date_maj"));
	?>

	<div>
		<?php require($_SERVER['DOCUMENT_ROOT'].'/espace_personnel/inc/back-button.php'); ?>
		<div class="tab-content">
			<h1>Formations générales <?php echo $annee_universitaire;?></h1>
			<?php
			if (dbnumrows($sql_planning_regroupement) > 0)
			{
				?>
				<p class="liste"><a href="/site/docs/plannings/cours/regroupement_<?php echo $date_maj_regroupement->format('d_M_Y') ?>.xls"><img src="/site/img/css/icones/excel.png"  /></a>
				<a href="/site/docs/plannings/cours/regroupement_<?php echo $date_maj_regroupement->format('d_M_Y') ?>.xls">Regroupements<br><span>MAJ le <b><?php echo $date_maj_regroupement->format('j/m/Y') ?></b></span></a></p>
				<?php
			}

			if (dbnumrows($sql_planning_chat) > 0)
			{
				?>
				<p class="liste"><a href="/site/docs/plannings/cours/chat_<?php echo $date_maj_chat->format('d_M_Y') ?>.xls"><img src="/site/img/css/icones/excel.png" /></a>
				<a href="/site/docs/plannings/cours/chat_<?php echo $date_maj_chat->format('d_M_Y') ?>.xls">Chats<br><span>MAJ le <b><?php echo $date_maj_chat->format('j/m/Y') ?></b></span></a></p>
				<?php
			}
			?>

			<h1>ICH <?php echo $annee_universitaire;?></h1>
			
			<?php
			if (dbnumrows($sql_planning_ich_annee_partie_1) > 0)
			{
				?>
				<p class="liste"><a href="/site/docs/plannings/include.php?file=xls_planning_annee_ich&partie=1&annee_universitaire=<?php echo $annee_universitaire;?>"><img src="/site/img/css/icones/excel.png"/></a>
				<a style='position:relative;top:10px' href="/site/docs/plannings/include.php?file=xls_planning_annee_ich&partie=1&annee_universitaire=<?php echo $annee_universitaire;?>">Planning 2013</a></p>
				<?php
			}
			if (dbnumrows($sql_planning_ich_annee_partie_2) > 0)
			{
				?>
				<p class="liste"><a href="/site/docs/plannings/include.php?file=xls_planning_annee_ich&partie=2&annee_universitaire=<?php echo $annee_universitaire;?>"><img src="/site/img/css/icones/excel.png"/></a>
				<a style='position:relative;top:10px' href="/site/docs/plannings/include.php?file=xls_planning_annee_ich&partie=2&annee_universitaire=<?php echo $annee_universitaire;?>">Planning 2014</a></p>
				<?php
			}
			?>


			<h1>CNE <?php echo $annee_universitaire;?></h1>
			<?php
			if (dbnumrows($sql_planning_TEPE) > 0)
			{
				?>
				<p class="liste"><a href="/site/docs/plannings/cours/TEPE1213_global_maj170913.pdf"><img src="/site/img/css/icones/pdf.png"/></a>
				<a href="/site/docs/plannings/cours/TEPE1213_global_maj170913.pdf">Planning TEPE<br><span>MAJ le <b><?php echo $date_maj_TEPE->format('d/m/Y') ?></b></span></a></p>
				<?php
			}

			if (dbnumrows($sql_planning_LP) > 0)
			{
				?>
				<p class="liste"><a href="/site/docs/plannings/cours/planning_LP_2013_2014.pdf"><img src="/site/img/css/icones/pdf.png"/></a>
				<a href="/site/docs/plannings/cours/planning_LP_2013_2014.pdf">Planning Licence professionnelle<br><span>MAJ le <b><?php echo $date_maj_LP->format('d/m/Y') ?></b></span></a></p>
				<?php
			}
			?>
		
		</div>
	</div>
</div>
	
</div>


<script>
function planning_change(){
	var mois = $('#mois').val();
	$.ajax({
		url:		'planning_perso.php?mois='+mois,
		beforeSend:	function()
			{	
				$('#ep-layer-loading').show();	
			},

		success:	function(response)
			{	
				$('#ep-layer-loading').hide();
				$('#planning_display').html(response);
				//alert("ok");
			}
	 });	
}

function planning_control(){
	$('#mois').change(function(){
		planning_change();
	});
}

$(document).ready(planning_change(),planning_control());
</script>

<?php
require_once($_SERVER['DOCUMENT_ROOT'].'/espace_personnel/inc/end.php');
?>