<?php
// ======================
// Récapitulatif auditeur
// ======================

session_start();

require($_SERVER['DOCUMENT_ROOT']."/base_adm/config/config.global.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/base_adm/config/dbconfig.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/base_adm/lib/lib.main.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/base_adm/lib/lib.db.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/base_adm/lib/lib.files.inc.php");
?>

<!-- jqueryui  (JS) -->
<script src="/lib/jqueryui/1.12.1.custom/jquery-ui.min.js"  crossorigin="anonymous"></script>


<script type="text/javascript">
<!--
$(document).ready(function()
{
	<?php
	/*
	+------------+-----------------------------------+
	| BUNDY Yann | RABODONANTENAINA Hanitra, Koloina |
	+------------+-----------------------------------+
	*/
	
	$sql_search_id = dbquery("SELECT auditeurs.* FROM auditeurs,auditeurs_diplomes
		WHERE auditeurs.id = auditeurs_diplomes.id
			AND auditeurs_diplomes.id_auditeur='".$_GET['id_auditeur']."'");

	if (dbnumrows($sql_search_id)>0)
	{
		$id	= dbresult($sql_search_id,0,"id");
		?>
		$( "#tabs_annee_univ-<?php echo $_GET['id_auditeur'] ?>" ).tabs();
		<?php
	}
	

	
	/*
	+---------------+---------+---------+
	| Toutes années | 2020-21 | 2019-20 |
	+---------------+---------+---------+
	*/
	
	$id_auditeur = $_GET['id_auditeur'];

	$sql_search_id = dbquery("SELECT auditeurs.* FROM auditeurs,auditeurs_diplomes
		WHERE auditeurs.id = auditeurs_diplomes.id
			AND auditeurs_diplomes.id_auditeur='".$id_auditeur."'");

	if (dbnumrows($sql_search_id)>0)
	{
		$id	= dbresult($sql_search_id,0,"id");
		?>			
			
		<!-- Toutes années -->
		$( "#tabs-annee-univ-<?php echo $_GET['id_auditeur'] ?>-00").load("parcours_by_annee_ajax.php?id=<?php echo $id ?>");
		<?php
		// Sur chaques année universitaire
		$sql_annee_universitaire_distinct = dbquery("SELECT DISTINCT annee_universitaire
			FROM auditeurs_diplomes
			WHERE id='".$id."'
			ORDER BY annee_universitaire DESC");
			
		for ($j=0;$j<dbnumrows($sql_annee_universitaire_distinct);$j++)
		{
			$annee_universitaire = dbresult($sql_annee_universitaire_distinct,$j,"annee_universitaire");
			?>
			$( "#tabs-annee-univ-<?php echo $_GET['id_auditeur'] ?>-<?php echo $j ?>").load("parcours_by_annee_ajax.php?id=<?php echo $id ?>&annee_universitaire=<?php echo $annee_universitaire ?>");
			<?php
		}
	}
	?>
});

//-->
</script>


<!-- Recap par auditeur
+------------+-----------------------------------+
| BUNDY Yann | RABODONANTENAINA Hanitra, Koloina |
+------------+-----------------------------------+
-->

<?php
$sql = dbquery("SELECT * FROM auditeurs,auditeurs_diplomes,centres_enseignement,pays
WHERE auditeurs.id=auditeurs_diplomes.id
	AND auditeurs.id_centre_enseignement=centres_enseignement.id_centre_enseignement
	AND centres_enseignement.id_pays=pays.id_pays
	AND auditeurs_diplomes.id_auditeur='".$_GET['id_auditeur']."'");

if (dbnumrows($sql)>0)
{
	$id							= dbresult($sql,0,"auditeurs.id");
	$login						= dbresult($sql,0,"login");
	$ENF_login					= dbresult($sql,0,"ENF_login");
	$password					= dbresult($sql,0,"password");
	$date_inscription			= date_iso_fr(dbresult($sql,0,"auditeurs.date_inscription"));
	$date_modif					= date_iso_fr(dbresult($sql,0,"auditeurs.date_modif"));
	$civil						= dbresult($sql,0,"civil");
	$nom_patronyme				= dbresult($sql,0,"nom_patronyme");
	$ine_interne				= dbresult($sql,0,"ine_interne");
	if( strlen($ine_interne)==0) $ine_interne="indéterminé";
	$nom_marital				= dbresult($sql,0,"nom_marital");
	$prenom						= dbresult($sql,0,"prenom");

	$dispositif					= dbresult($sql,0,"dispositif");

	$date_naissance				= date_iso_fr(dbresult($sql,0,"date_naissance"));
	$lieu_naissance				= dbresult($sql,0,"lieu_naissance");
	$departement_naissance		= dbresult($sql,0,"departement_naissance");
	$pays_naissance				= dbresult($sql,0,"pays_naissance");

	$nationalite				= dbresult($sql,0,"nationalite");
	$adresse					= dbresult($sql,0,"auditeurs.adresse");
	$code_postal				= dbresult($sql,0,"auditeurs.code_postal");
	$commune					= dbresult($sql,0,"auditeurs.commune");
	$centre_enseignement		= dbresult($sql,0,"centres_enseignement.ville")." - ".dbresult($sql,0,"pays.pays");
	$tel_etudiant				= dbresult($sql,0,"tel_etudiant");
	$gsm_etudiant				= dbresult($sql,0,"gsm_etudiant");
	$email_auditeur				= dbresult($sql,0,"email_auditeur");
	$situation_famille			= dbresult($sql,0,"situation_famille");

	$identifiant_pole_emploi	= dbresult($sql,0,"identifiant_pole_emploi");

	$profession					= dbresult($sql,0,"profession");
	$date_entree_entreprise		= dbresult($sql,0,"date_entree_entreprise");
	$fonction					= dbresult($sql,0,"fonction");
	$depuis						= dbresult($sql,0,"depuis");
	$type_contrat				= dbresult($sql,0,"type_contrat");
	$temps_de_travail			= dbresult($sql,0,"temps_de_travail");

	$nom_entreprise				= dbresult($sql,0,"nom_entreprise");
	$adresse_entreprise			= dbresult($sql,0,"adresse_entreprise");
	$siret						= dbresult($sql,0,"siret");
	$code_ape_naf				= dbresult($sql,0,"code_ape_naf");
	$representant				= dbresult($sql,0,"representant");
	$tel_entreprise				= dbresult($sql,0,"tel_entreprise");
	$email_entreprise			= dbresult($sql,0,"email_entreprise");


	$dispense_frais_dossier		= dbresult($sql,0,"dispense_frais_dossier");
	$dispense_directeur			= dbresult($sql,0,"dispense_directeur");
	$dispense_droit_base_annuel	= dbresult($sql,0,"dispense_droit_base_annuel");
		 

	$date_inscription	= str_replace("00/00/0000","-",$date_inscription);
	$date_modif			= str_replace("00/00/0000","-",$date_modif);
}

if ($piece_cv ==1) {$piece_cv ="Oui";} else {$piece_cv ="Non";}
if ($piece_lettremotivation==1) {$piece_lettremotivation ="Oui";} else {$piece_lettremotivation ="Non";}
if ($piece_enveloppe==1) {$piece_enveloppe ="Oui";} else {$piece_enveloppe ="Non";}
if ($piece_photos==1) {$piece_photos ="Oui";} else {$piece_photos ="Non";}
if ($piece_attestation_emploi==1) {$piece_attestation_emploi ="Oui";} else {$piece_attestation_emploi ="Non";}
if ($piece_identite==1) {$piece_identite ="Oui";} else {$piece_identite ="Non";}
if ($piece_secu==1) {$piece_secu ="Oui";} else {$piece_secu ="Non";}
if ($piece_valeurs==1) {$piece_valeurs ="Oui";} else {$piece_valeurs ="Non";}
if ($piece_frais==1) {$piece_frais ="Oui";} else {$piece_frais ="Non";}
if ($piece_dossier==1) {$piece_dossier ="Oui";} else {$piece_dossier ="Non";}

if ($dispense_frais_dossier==1) {$dispense_frais_dossier ="Oui";} else {$dispense_frais_dossier ="Non";}
if ($dispense_directeur==1) {$dispense_directeur ="Oui";} else {$dispense_directeur ="Non";}
?>



<style type="text/css">
	table, caption, tbody, tfoot, thead, tr, th, td {
    margin: 0px;
    padding: 5px;
    border: 0px;
    outline: 0;
    font-size: 12px;
    vertical-align: baseline;
    background: transparent;
	height:6px;
	color:black;
	text-align:left;
}
</style>


<!-- Planning regroupement et chat -->
		

<table style='position: absolute; top:50px; left:20px;width:300px'>
<thead>
</thead>
<tbody>
<tr>
	<th>Civil</th>
	<td><?php echo $global["civil"][$civil]?></td>
</tr>
<tr>
	<th>Nom patronyme</th>
	<td><?php echo $nom_patronyme?></td>
</tr>
<tr>
	<th>Nom marital</th>
	<td><?php echo $nom_marital?></td>
</tr>
<tr>
	<th>Prénom</th>
	<td><?php echo $prenom?></td>
</tr>
<tr>
	<th>INE</th>
	<td><?php echo $ine_interne?></td>
</tr>
</table>


<table style='position: absolute; top:384px; left:20px;width:630px'>
<thead>
</thead>
<tbody>
<tr>
	<th>Naissance</th>
	<td>le <?php echo $date_naissance?></td>
	<td style='width:150px'> à <?php echo $lieu_naissance?></td>
	<td>Dept : <?php echo $departement_naissance ?></td>
	<td><?php echo $pays_naissance?></td>
</tr>
<tr>
	<th>Nationalité</th>
	<td colspan='4'><?php echo $nationalite?></td>
</tr>
</tbody>
</table>
		
<table style='position: absolute; top:510px; left:20px;width:500px'>
<thead>
</thead>
<tbody>
<tr>
	<th>Adresse</th>
	<td colspan='2'><?php echo $adresse?></td>
</tr>
<tr>	
	<th>Code postal + Commune</th>
	<td><?php echo $code_postal?></td>
	<td><?php echo $commune?></td>
</tr>
<tr>
	<th>Centre d'inscription</th>
	<td colspan='2'><?php echo $centre_enseignement?></td>
</tr>
</tbody>
</table>

<table style='position: absolute; top:156px; left:340px;width:310px'>
<thead>
</thead>
<tbody>
<tr>
	<th>Téléphone fixe</th>
	<td><?php echo $tel_etudiant?></td>
</tr>
<tr>
	<th>Téléphone portable</th>
	<td><?php echo $gsm_etudiant?></td>
</tr>
<tr>
	<th>Email</th>
	<td><a href='mailto:<?php echo $email_auditeur?>'><?php echo $email_auditeur?></a></td>
</tr>
</tbody>
</table>

<!-- PHOTO -->
<div style="position: absolute; top:10px; right:10px;">
	<?php
		if (file_exists('../../base_adm/service_scolaire/carte_eleve/photos/'.$id_auditeur.'.jpg'))	echo "<img style='height:120px' src='../../base_adm/service_scolaire/carte_eleve/photos/".$id_auditeur.".jpg'>";
	?>
</div>




<!-- mailto:p.dupond@example.com?subject=Sujet%20du%20courrier&cc=pierre@example.org&bcc=jacques@example.net&body=Bonjour
-->

	

<table style="position: absolute; top:720px; left:20px; width:600px">
<thead>
</thead>
<tbody>
<tr>
	<th>Date création</th>
	<td><?php echo $date_inscription?></td>
	<th>Date modification</th>
	<td><?php echo $date_modif?></td>
</tr>
<tr>
	<th>Situation de famille</th>
	<td colspan='3'><?php echo $global["situation"][$situation_famille]?></td>
</tr>
<tr>
	<th>Dispense frais de dossiers</th>
	<td><?php echo $dispense_frais_dossier?></td>
	<th>Dispense directeur</th>
	<td><?php echo $dispense_directeur?></td></tr>
<tr>
	<th>Identifiant Pôle Emploi</th>
	<td colspan='3'><?php echo $identifiant_pole_emploi?></td>
</tr>
<tr>
	<th>Activite&nbsp;salariale</th>
	<td colspan='3'><?php echo $activite_salariale?></td>
</tr>
<tr>
	<th>Dernier emploi</th>
	<td colspan='3'><?php echo $dernier_emploi?></td>
</tr>
<tr>
	<th>Profession</th>
	<td colspan='3'><?php echo $profession?></td>
</tr>
<tr>	
	<th>Anciennete</th>
	<td colspan='3'><?php echo $anciennete?></td>
</tr>
<tr>	
	<th>Fonction</th>
	<td><?php echo $fonction?></td>
	<th>Depuis</th>
	<td><?php echo $depuis?></td>
</tr>
<tr>	
	<th>Type de contrat</th>
	<td>
		<?php
		$sql_type_contrat = dbquery("SELECT *
			FROM type_contrat
			WHERE type_contrat = '".$type_contrat."'");
		if (dbnumrows($sql_type_contrat) > 0)
		{
			$nom_contrat = dbresult($sql_type_contrat,0,"nom");
			echo $nom_contrat;
		}
		?>
	</td>
	<th>Temps de travail</th>
	<td><?php echo $global["temps_de_travail"][$temps_de_travail]?></td>
</tr>
<tr>
	<th>Nom entreprise</th>
	<td colspan='3'><?php echo $nom_entreprise?></td>
</tr>
<tr>
	<th>Adresse entreprise</th>
	<td colspan='3'><?php echo $adresse_entreprise?></td>
</tr>
<tr>
	<th>Siret</th>
	<td><?php echo $siret?></td>
</tr>
<tr>
	<th>Code ape / naf</th>
	<td colspan='3'><?php echo $code_ape_naf?></td>
</tr>
<tr>
	<th>Representant</th>
	<td colspan='3'><?php echo $representant?></td>
</tr>
<tr>
	<th>Tel entreprise</th>
	<td colspan='3'><?php echo $tel_entreprise?></td>
</tr>
<tr>
	<th>Email entreprise</th>
	<td colspan='3'><?php echo $email_entreprise?></td>
</tr>
</tbody>
</table>

<table style="position: absolute; top:1600px; left:10px; width:800px">
<tr>
	<th>Situation professionnelle</th><td>

	<?php
	$sql_sp = dbquery("SELECT * FROM situation_pro WHERE id_auditeur='".$id."'");
	if (dbnumrows($sql_sp)>0)
	{
	?>
		<table>
		<thead>
		<tr>
			<th>Employeur</th>
			<th>Fonction</th>
			<th>Du</th>
			<th>Au</th>
			<th>Durée</th>
		</tr>
		</thead>
		<tbody>
		<?php
		for ($g=0;$g<dbnumrows($sql_sp);$g++)
		{
			?>
			<tr>
				<td><?php echo dbresult($sql_sp,$g,"employeur") ?></td>
				<td><?php echo dbresult($sql_sp,$g,"fonction") ?></td>
				<td><?php echo dbresult($sql_sp,$g,"du") ?></td>
				<td><?php echo dbresult($sql_sp,$g,"au") ?></td>
				<td><?php echo dbresult($sql_sp,$g,"duree") ?></td>
			</tr>
			<?php
		}
		?>
		</tbody>
		</table>
		<?php
	}
	?>
	</td></tr>
	<tr><td colspan='2'><hr></td></tr>
		   
	<tr><th>Diplômes</th><td>
	<?php
	$sql_diplome_auditeur = dbquery("SELECT *
				FROM diplomes_auditeur
				WHERE id_auditeur='".$id."'");
	if (dbnumrows($sql_diplome_auditeur)>0)
	{
		?>
		<table>
		<thead>
		<tr>
			<th style='text-align:center'>Abreviation</th>
			<th style='text-align:center'>Specialite</th>
			<th style='text-align:center'>Année</th>
			<th style='text-align:center'>Niveau</th>
			<th style='text-align:center'>Obtenu</th>
		</tr>
		</thead>
		<tbody>
		<?php
		$from	= array(0    ,1);
		$to		= array('Non','Oui');
			
		for ($h=0;$h<dbnumrows($sql_diplome_auditeur);$h++)
		{
			$id_code_diplome= dbresult($sql_diplome_auditeur,$h,"id_code_diplome");
			$abreviation	= dbresult($sql_diplome_auditeur,$h,"abreviation");
			$specialite		= dbresult($sql_diplome_auditeur,$h,"specialite");
			$annee			= dbresult($sql_diplome_auditeur,$h,"annee");
			$obtenu			= dbresult($sql_diplome_auditeur,$h,"obtenu");
			?>
			<tr>
				<td><?php echo $abreviation ?></td>
				<td><?php echo $specialite ?></td>
				<td><?php echo $annee ?></td>
				<td>
					<?php
					$sql_niveaux_qualification = dbquery("SELECT id_nomenclature
								FROM codes_diplomes
								WHERE id_code_diplome = '".$id_code_diplome."'");
					if (dbnumrows($sql_niveaux_qualification) > 0)
					{
						echo "Niveau ".dbresult($sql_niveaux_qualification,0,"id_nomenclature");
					}
					?>
				</td>
				<td><?php echo str_replace($from,$to,$obtenu) ?></td>
			</tr>
			<?php
		}
		?>
				
		</tbody>
		</table>
		<?php
	}
	?>
	</td></tr>
		   
	<tr><td colspan='2'><hr></td></tr>
		   
	<tr><th>Bac</th><td><?php echo $bac?></td></tr>
	<tr><th>Bac serie</th><td><?php echo $bac_serie?></td></tr>
	<tr><th>Bac mention</th><td><?php echo $bac_mention?></td></tr>
	<tr><th>Bac annee</th><td><?php echo $bac_annee?></td></tr>
	<tr><th>Bac etablissement</th><td><?php echo $bac_etablissement?></td></tr>
	<tr><th>Bac departement</th><td><?php echo $bac_departement?></td></tr>
	<tr><th>Universite annee</th><td><?php echo $universite_annee?></td></tr>
	<tr><th>Universite etablissement</th><td><?php echo $universite_etablissement?></td></tr>
	<tr><th>Universite code</th><td><?php echo $universite_code?></td></tr>
	<tr><td colspan='2'><hr></td></tr>


	<?php
	$sql_langue = dbquery("SELECT * FROM langues_auditeurs, langues, langues_mode, langues_niveau
		WHERE id_auditeur='".$id."'
			AND langues_auditeurs.id_langue=langues.id_langue
			AND langues_auditeurs.id_mode=langues_mode.id_mode
			AND langues_auditeurs.id_niveau=langues_niveau.id_niveau
		ORDER BY langues.id_langue,langues_niveau.id_niveau,langues_mode.id_mode");
	if (dbnumrows($sql_langue)>0)
	{
		?>
		<tr>
			<th>Langues parlées</th>
			<td>
				
				<table>
				<thead>
				<tr>
					<th style='text-align:center'>Langue</th>
					<th style='text-align:center'>Mode</th>
					<th style='text-align:center'>Niveau</th>
				</tr>
				</thead>
				<tbody>

				<?php
				for ($j=0;$j<dbnumrows($sql_langue);$j++)
				{
					echo "<tr>";
					echo "<td>".dbresult($sql_langue,$j,"langue")."</td>";
					echo "<td>".dbresult($sql_langue,$j,"mode")."</td>";
					echo "<td>".dbresult($sql_langue,$j,"niveau")."</td>";
					echo "</tr>";
				}
				?>
				</tbody>
				</table>

			</td>
		</tr>
		<?php
	}
	?>
	<tr><td colspan='2'><hr></td></tr>
	<tr>
		<th>Formation continue</th><td>

		<?php
		$sql_fc = dbquery("SELECT * FROM formations_continue WHERE id_auditeur='".$id."'");
		if (dbnumrows($sql_fc)>0)
		{
		?>
			<table>
			<thead>
			<tr>
				<th style='text-align:center'>Date</th>
				<th style='text-align:center'>Durée</th>
				<th style='text-align:center'>Intitulé du stage</th>
				<th style='text-align:center'>Organisme</th>
				<th style='text-align:center'>Diplôme / Certificat</th>
			</tr>
			</thead>
			<tbody>
			<?php
			for ($j=0;$j<dbnumrows($sql_fc);$j++)
			{
				echo "<tr class=".$class."><td>".dbresult($sql_fc,$j,"date")."</td>";
				echo "<td>".dbresult($sql_fc,$j,"duree")."</td>";
				echo "<td>".dbresult($sql_fc,$j,"intitule_stage")."</td>";
				echo "<td>".dbresult($sql_fc,$j,"organisme")."</td>";
			}
			?>
			</tbody>
			</table>
			<?php
		}
		?>
				
		</td>
	</tr>

	<tr><td colspan='2'><hr></td></tr>

	<tr><td colspan='2'>
				
		<?php
		$colors = array(
			"VAE" =>	"#7574DC",
			"VES" =>	"#4EA2AC",
			"VAP" =>	"#7A37AB"
		);
				
		$sql_auditeurs = dbquery("SELECT DISTINCT(auditeurs_ves.id_auditeur),auditeurs_diplomes.annee_universitaire,auditeurs.*
			FROM auditeurs_ves,auditeurs_diplomes,auditeurs
			WHERE auditeurs_diplomes.id = auditeurs.id
				AND auditeurs_ves.id_auditeur = auditeurs_diplomes.id_auditeur
				AND auditeurs_diplomes.id_auditeur = '".$id_auditeur."'
			ORDER BY auditeurs.nom_patronyme,auditeurs.prenom");

		if (dbnumrows($sql_auditeurs) > 0)
		{
			?>
			<table class="tablesorter" style='width:260px'>
			<thead>
			</thead>
			<thead>
			<tr>
				<th style='width:60px'>Validation&nbsp;/&nbsp;N°</th>
				<th style='width:60px'>Modalité</th>
				<th style='width:60px'>Date réal. locale</th>
				<th style='width:60px'>Date notif. nationale</th>
				<th style='width:120px' colspan='4'>Fichier</th>
			</tr>
			</head>

			<tbody>
			<?php

			for ($i=0;$i<dbnumrows($sql_auditeurs);$i++)
			{
				$id						= dbresult($sql_auditeurs,$i,"auditeurs.id");
				$id_auditeur			= dbresult($sql_auditeurs,$i,"id_auditeur");
				$annee_universitaire	= dbresult($sql_auditeurs,$i,"auditeurs_diplomes.annee_universitaire");
				$nom_auditeur			= dbresult($sql_auditeurs,$i,"auditeurs.nom_patronyme");
				$prenom_auditeur		= dbresult($sql_auditeurs,$i,"auditeurs.prenom");

				$sql_auditeurs_ves = dbquery("SELECT *
						FROM auditeurs_ves
						WHERE id_auditeur = '".$id_auditeur."'");

				?>
				<tr>
							
					<?php
					for ($j=0;$j<dbnumrows($sql_auditeurs_ves);$j++)
					{
						$id_auditeur				= dbresult($sql_auditeurs_ves,$j,"id_auditeur");
						$validation					= dbresult($sql_auditeurs_ves,$j,"validation");
						$numero						= dbresult($sql_auditeurs_ves,$j,"numero");
						$modalite					= dbresult($sql_auditeurs_ves,$j,"modalite");
						$date_realisation_locale	= dbresult($sql_auditeurs_ves,$j,"date_realisation_locale");
						$date_notification_nationale= dbresult($sql_auditeurs_ves,$j,"date_notification_nationale");
						$fichier					= dbresult($sql_auditeurs_ves,$j,"fichier");
						?>

						<td style='text-align:center'><span style='padding:10px;font-weight:bold;background-color:<?php echo $colors[$validation] ?>;color:white'><?php echo $validation ?> n°<?php echo $numero ?></span></td>
						<td><?php echo $modalite ?></td>
						<td><?php echo date_iso_fr($date_realisation_locale) ?></td>
						<td><?php echo date_iso_fr($date_notification_nationale) ?></td>

						<?php
						if ($fichier <> "")
						{
							?>
								
							<td><?php echo get_font_awesome_icon_from_file($fichier) ?></td>
							<td><?php echo $fichier ?></td>
							<td style='width:100px'>
								<?php
								if (is_file("../vap_vae_ves/files/".$fichier))
								{
									echo size_of_file(filesize("../vap_vae_ves/files/".$fichier));
								}
								else
									echo "<i style='color:red' class='fa fa-2x fa-exclamation-triangle' aria-hidden='true'></i>";
								?>
							</td>
							<td>
								<?php
								if (is_file("../vap_vae_ves/files/".$fichier))
								{
									?>
									<a target='_new' href='/base_adm/vap_vae_ves/files/<?php echo $fichier ?>'><i class='fa fa-external-link fa-lg' aria-hidden='true'></i></a>
									<?php
								}
								?>
							</td>
							<?php
						}
						else
						{
							?>
							<td colspan='4'><span style='color:red'>Fichier&nbsp;non&nbsp;présent</span></td>
							<?php
						}
						?>
						</tr>
						<?php
					}
					?>
				</tr>
				<?php
			}
		}
		?>
	</td></tr>


	<tr><td colspan='2'><hr></td></tr>
	<tr>
		<?php
		// Recupere l'ensemble des numéros auditeur lié a cet auditeur
		$sql_annee_universitaire_distinct = dbquery("SELECT DISTINCT annee_universitaire
			FROM auditeurs_diplomes
			WHERE id='".$id."'
			ORDER BY annee_universitaire DESC");
		?>

		<!-- Recap par année
		+---------------+---------+---------+
		| Toutes années | 2020-21 | 2019-20 |
		+---------------+---------+---------+
		-->
		<td colspan='2'>

			<div style='' id="tabs_annee_univ-<?php echo $_GET['id_auditeur'] ?>">
				<ul>
					<li><a href="#tabs-annee-univ-<?php echo $_GET['id_auditeur'] ?>-00"><span style='background-color:#007FFF;color:white'>Toutes années</span></a></li>

					<?php
					for ($j=0;$j<dbnumrows($sql_annee_universitaire_distinct);$j++)
					{
						$annee_universitaire = dbresult($sql_annee_universitaire_distinct,$j,"annee_universitaire");
						?>
						<li><a href="#tabs-annee-univ-<?php echo $_GET['id_auditeur'] ?>-<?php echo $j ?>"><span style='background-color:#007FFF;color:white'><?php echo substr($annee_universitaire,0,4) ?>-<?php echo substr($annee_universitaire,7,2) ?></span></a></li>
						<?php
					}
					?>
				</ul>

				<div id="tabs-annee-univ-<?php echo $_GET['id_auditeur'] ?>-00"></div>
				<?php
				for ($j=0;$j<dbnumrows($sql_annee_universitaire_distinct);$j++)
				{
					?>
					<div id="tabs-annee-univ-<?php echo $_GET['id_auditeur'] ?>-<?php echo $j ?>"></div>
					<?php
				}
				?>

			</div>
		</td>
	</tr>
	</table>
</table>
</div>
