<!doctype html>
<html lang="en">
<head>
	<title>Document</title>

	<meta name="viewport" content="width=device-width,initial-scale=1,maximum-scale=1">

	<link rel="stylesheet" type="text/css" href="/espace/css/reset.css">
	<link rel="stylesheet" type="text/css" href="/espace/css/grid.css">
	<link rel="stylesheet" type="text/css" href="/espace/css/style.css">
	<link href='http://fonts.googleapis.com/css?family=Varela+Round' rel='stylesheet' type='text/css'>
	<link href='http://fonts.googleapis.com/css?family=Open+Sans:400,700,700italic,400italic' rel='stylesheet' type='text/css'>
    <link type="text/css" rel="stylesheet" href="/espace/css/responsive-tabs.css" />
    <script src="/espace/js/jquery-3.5.1.min.js" type="text/javascript"></script>
    <script src="/espace/js/plugins/tabs/responsive-tabs.js" type="text/javascript"></script>
	<script src="/espace/js/lib.js" type="text/javascript"></script>
	
	<style>
body.active { background-color: #4e4e4e; }
.container { max-width: 100%; margin: 0px auto; overflow: hidden; width: 100%; }

.nav, .main_content { 
	-webkit-transition: .2s all ease;
	-moz-transition: .2s all ease;
	transition: .2s all ease; 
	width: 100%; 
}

.menu_container, .footer { clear:both; overflow: hidden; background-color: #fff; }
.footer { padding: 0.8em 0; }
.menu_container, .anchor-link { display: none; }
.menu_container { border-bottom: 1px solid #000; }
.anchor-link { font-weight: bold; padding: 1em; text-align: right; text-decoration: none; background-color: #48c9b0; color: #fff; float: right; }
.anchor-link:hover { background-color: #ccc; color: #fff; }

.nav { width:100%; border-bottom: 1px solid #000; }
.nav ul { list-style: none; padding: 0px; margin: 0px; font-weight: bold; text-align: center; }
.nav ul li { display: inline-block; text-align: left; }
.nav ul li a { display: block; padding: 10px 12px; text-decoration: none; color: #444; }
.nav ul li a:hover { background-color: #ccc; }

.main_content { padding: 1.5em; position: relative; max-width: 70em; margin: 0 auto; background-color: #f4f4f4; }
body.active .main_content:before {
	content: " ";
	position: absolute;
	z-index: -1;
	top: 0;
	left: -100%;
	width: 100%;
	height: 100%;	
	background-color: #4e4e4e;
}
h1 { text-align: center;  }

p.copyright { text-align: center; }


@media (max-width:48.000em){
	
	.menu_container, .anchor-link { display: block; }
	
	.nav { margin-left: -100%; float: left;}
	.main_content { margin-left: 0; float: left; }
	
	body.active .nav { margin-left: 0; width:60%; }
	body.active .main_content { margin-right: -100%; }
	
	.nav { padding: 0.6em 0; border: none; padding: 0; }
	.nav ul { text-align: left; font-weight: normal; }
	.nav ul li { display: block; }
	.nav ul li a { border-bottom: 1px solid #3E3E3E; border-top: 1px solid #717171; color: #ffffff; padding: 12px; }
	.nav ul li a:hover { background-color:#5C5C5C; }
	
}
	</style>
</head>

<body>

<div class="container">
	<div class="menu_container" >
		<a id="menu-toggle" class="anchor-link" href="#mobile-nav">MENU</a>
	</div>
	
	<nav id="#mobile-nav" class="nav clearfix" role="navigation">
		<ul>
			<li><a href="#">Home</a></li>
			<li><a href="#">About</a></li>
			<li><a href="#">Collection</a></li>
			<li><a href="#">Blog</a></li>
			<li><a href="#">Contact</a></li>
			<li><a href="#">Directions</a></li>
		</ul>
	</nav>

<section class="main-content">	
	<section class="page-title">
		<div class="grid-container">
			<h1>CV</h1>
			<h6>Grâce à cette interface créez, consultez, modifiez ou supprimez vos CV.</h6>
		</div>
	</section>

   <!--Horizontal Tab-->
    <div id="horizontalTab">
		<ul class="grid-container tab-titles">
			<li class="grid-25 infos"><a href="#tab-1" class="infos"><span class="picto infos"></span><h5>Information générales</h5></a></li>
			<li class="grid-25 diplomes"><a href="#tab-2" class="diplomes"><span class="picto diplomes"></span><h5>Diplômes</h5></a></li>
			<li class="grid-25 competences"><a href="#tab-3" class="competences"><span class="picto experiences"></span><h5>Expériences</h5></a></li>
			<li class="grid-25 experiences"><a href="#tab-4" class="experiences"><span class="picto competences"></span><h5>Compétences</h5></a></li>
		</ul>

<!-- Informations générales -->
        <div id="tab-1" class="tab">

			<section class="bg-light">

				<div class="grid-container">

					<form>
						<div class="grid-50">
							<label class="">Nom du CV</label>
							<input type="text"/>
						</div>
						<div class="grid-50">
							<label class="">Permis B</label>
							<input type="text"/>
						</div>
						<div class="grid-50">
							<label class="">Véhicule</label>
							<input type="text"/>
						</div>
						<div class="grid-50">
							<label class="">Autre permis</label>
							<input type="text"/>
						</div>
						<div class="grid-100">
							<hr/>
						</div>
						<div class="grid-50">
							<label class="">Langue étrangère 1</label>
							<input type="text"/>
						</div>
						<div class="grid-50">
							<label class="">Pratique</label>
							<input type="text"/>
						</div>
						<div class="grid-50">
							<label class="">Langue étrangère 2</label>
							<input type="text"/>
						</div>
						<div class="grid-50">
							<label class="">Pratique</label>
							<input type="text"/>
						</div>
						<div class="grid-100">
							<hr/>
						</div>
						<div class="grid-50">
							<label>Sport 1</label>
							<input type="text"/>
						</div>
						<div class="grid-50">
							<label>Sport 2</label>
							<input type="text"/>
						</div>
						<div class="grid-50">
							<label>Loisir 1</label>
							<input type="text"/>
						</div>
						<div class="grid-50">
							<label>Loisir 2</label>
							<input type="text"/>
						</div>
						<div class="grid-100 clearboth">
							<label></label>
							<input type="submit" value="Valider"/>
						</div>
					</form>
				</div>
			</section>
        </div>

<!-- Diplômes -->
        <div id="tab-2" class="tab">
            <section class="bg-light">
				<div class="grid-container">
					<header>
						<h2>Liste des diplômes</h2>
						Pensez à ajouter vos dernières expériences sur vos CV
					</header>

					<table>
						<tr>
							<th style="width:98%">Diplôme</th>
							<th style="width:1%" class="align-center"><span class="hide-on-mobile">Modifier</span><span class="hide-on-desktop">Modif.</span></th>
							<th style="width:1%" class="align-center"><span class="hide-on-mobile">Supprimer</span><span class="hide-on-desktop">Suppr.</span></th>
						</tr>
						<tr>
							<td><span class="red">2000 - Baccalauréat Scientifique</span><br>Spécialité Mathématiques<br></td>
							<td class="align-center"><img src="/espace/css/img/ico-modifier.png"></td>
							<td class="align-center"><img src="/espace/css/img/ico-supprimer.png"></td>
						</tr>
						<tr>
							<td><span class="red">2002 - BTS Communication</span><br>Communication des entreprises</td>
							<td class="align-center"><img src="/espace/css/img/ico-modifier.png"></td>
							<td class="align-center"><img src="/espace/css/img/ico-supprimer.png"></td>
						</tr>
						<tr>
							<td colspan="3" class="btn bg-dark">
								<a style="display:block" class="scroll-trigger" href="#ajouter-un-diplome">Ajouter un diplôme</a>
							</td>
						</tr>
					</table>
				</div>
			</section>

			<section class="bg-white arrow" id="ajouter-un-diplome">
				
				<div class="arrow-down"></div>

				<div class="grid-container">
				
					<header>
						<h2>Ajouter un diplôme</h2>
						Veuillez remplir les champs ci-dessous puis valider.
					</header>

					<form>
						<div class="grid-100">
							<label class="">Type de diplôme</label>
							<input type="text"/>
						</div>
						<div class="grid-100">
							<label class="">Diplôme</label>
							<input type="text"/>
						</div>
						<div class="grid-100">
							<label class="">Spécialité</label>
							<input type="text"/>
						</div>
						<div class="grid-100">
							<label class="">Intitulé exact</label>
							<input type="text"/>
						</div>
						<div class="grid-100">
							<label class="">Etablissement / institution</label>
							<input type="text"/>
						</div>
						<div class="grid-50">
							<label class="">Lieu de délivrance</label>
							<input type="text"/>
						</div>
						<div class="grid-50">
							<label class="">Année d'obtention</label>
							<input type="text"/>
						</div>
						<div class="grid-100 clearboth">
							<label></label>
							<input type="submit" value="Valider"/>
						</div>
					</form>
				</div>
			</section>
        </div>

<!-- Expériences -->
        <div id="tab-3" class="tab">
            <section class="bg-light">
				<div class="grid-container">
					<header>
						<h2>Liste des expériences</h2>
						Pensez à ajouter vos dernières expériences sur vos CV
					</header>

					<table>
						<tr>
							<th style="width:98%">Entreprise / Fonction</th>
							<th style="width:1%" class="align-center"><span class="hide-on-mobile">Modifier</span><span class="hide-on-desktop">Modif.</span></th>
							<th style="width:1%;" class="align-center"><span class="hide-on-mobile">Supprimer</span><span class="hide-on-desktop">Suppr.</span></th>
						</tr>
						<tr>
							<td><span class="red">A + Architecture</span><br>Chef de projet - Responsable d'opération<br></td>
							<td class="align-center"><img src="/espace/css/img/ico-modifier.png"></td>
							<td class="align-center"><img src="/espace/css/img/ico-supprimer.png"></td>
						</tr>
						<tr>
							<td><span class="red">A + Architecture</span><br>Chef de projet - Responsable d'opération</td>
							<td class="align-center"><img src="/espace/css/img/ico-modifier.png"></td>
							<td class="align-center"><img src="/espace/css/img/ico-supprimer.png"></td>
						</tr>
						<tr>
							<td colspan="3" class="btn bg-dark">
								<a class="scroll-trigger" href="#ajouter-une-experience">Ajouter une expérience</a>
							</td>
						</tr>
					</table>
				</div>
			</section>

			<section class="bg-white arrow" id="ajouter-une-experience">
				
				<div class="arrow-down"></div>

				<div class="grid-container">
				
					<header>
						<h2>Ajouter une expérience</h2>
						Veuillez remplir les champs ci-dessous puis valider.
					</header>

					<form>
						<div class="grid-50">
							<label class="">Type d'emploi</label>
							<input type="text"/>
						</div>
						<div class="grid-50">
							<label class="">Taille de l'entreprise</label>
							<input type="text"/>
						</div>
						<div class="grid-100">
							<label class="">Secteur d'activité</label>
							<input type="text"/>
						</div>
						<div class="grid-50">
							<label class="">Fonction exercée</label>
							<input type="text"/>
						</div>
						<div class="grid-50">
							<label class="">Lieu d'exercice</label>
							<input type="text"/>
						</div>
						<div class="grid-100">
							<label class="">CSP</label>
							<input type="text"/>
						</div>
						<div class="grid-50">
							<label class="">Début d'exercice</label>
							<input type="text"/>
						</div>
						<div class="grid-50 clearboth">
							<label class="">Fin d'exercice</label>
							<input type="text"/>
						</div>
						<div class="grid-100">
							<label>Description du poste</label>
							<textarea></textarea>
						</div>	
						<div class="grid-100 clearboth">
							<label></label>
							<input type="submit" value="Valider"/>
						</div>
					</form>
				</div>
			</section>
        </div>

<!-- Compétences -->
		<div id="tab-4" class="tab">
            <section class="bg-light">
				<div class="grid-container">
					<header>
						<h2>Liste des compétences</h2>
						Pensez à ajouter vos compétences à votre CV
					</header>

					<table>
						<tr>
							<th style="width:98%">Intitulé</th>
							<th style="width:1%" class="align-center"><span class="hide-on-mobile">Modifier</span><span class="hide-on-desktop">Modif.</span></th>
							<th style="width:1%" class="align-center"><span class="hide-on-mobile">Supprimer</span><span class="hide-on-desktop">Suppr.</span></th>
						</tr>
						<tr>
							<td>Travail en équipe<br></td>
							<td class="align-center"><img src="/espace/css/img/ico-modifier.png"></td>
							<td class="align-center"><img src="/espace/css/img/ico-supprimer.png"></td>
						</tr>
						<tr>
							<td>Polyvalence</td>
							<td class="align-center"><img src="/espace/css/img/ico-modifier.png"></td>
							<td class="align-center"><img src="/espace/css/img/ico-supprimer.png"></td>
						</tr>
						<tr>
							<td colspan="3" class="btn bg-dark">
								<a class="scroll-trigger" href="#ajouter-une-competence">Ajouter une compétence</a>
							</td>
						</tr>
					</table>
				</div>
			</section>

			<section class="bg-white arrow" id="ajouter-une-competence">
				
				<div class="arrow-down"></div>

				<div class="grid-container">
				
					<header>
						<h2>Ajouter une compétence</h2>
						Veuillez remplir les champs ci-dessous puis valider.
					</header>

					<form>
						<div class="grid-100">
							<label class="">Intitulé</label>
							<input type="text"/>
						</div>
						<div class="grid-100">
							<label>Description</label>
							<textarea></textarea>
						</div>	
						<div class="grid-100 clearboth">
							<label></label>
							<input type="submit" value="Valider"/>
						</div>
					</form>
				</div>
			</section>
        </div>
    </div>

	<div id="footer" style="width:100%;color:#757777;position:relative;" class="bg-dark">
		<a class="scroll-trigger" href="body" style="position:absolute;left:50%;top:-29px;margin-left:-15px;height:30px;width:60px;background:transparent url(/espace/css/img/arrow-footer.png)"></a>
		<div style="margin: 0 auto;text-align:center;padding:25px 15px;line-height:1.5em;">
			<a>Plannings</a> | 
			<a>Examens</a> | 
			<a>Mon dossier Cnam</a> | 
			<a>Documents</a> | 
			<a>CDI</a> | 
			<a>CV</a> | 
			<a>Offres</a> | 
			<a>Paramètres du compte</a> | 
			<a>Nous contacter</a> | 
			<a>Se déconnecter</a>
		</div>
	</div>

</section>
</div>
<script type="text/javascript">
	
</script>
</body>
</html>
