<?php

// Librairies php
require($_SERVER['DOCUMENT_ROOT'].'/site/config/php/lib.inc.php');
require($_SERVER['DOCUMENT_ROOT'].'/site/config/php/var.inc.php');
require($_SERVER['DOCUMENT_ROOT'].'/espace/php/var.php');

// session
require($_SERVER['DOCUMENT_ROOT'].'/espace/inc/session-e.php');

// head
require($_SERVER['DOCUMENT_ROOT'].'/espace/inc/head-e.php');

// menu
require($_SERVER['DOCUMENT_ROOT'].'/espace/inc/menu-e.php');


// Contenu
?>
<style>
.dark			{color:#273338 !important}
.dark:hover		{color:#c1002a !important}
</style>

	<div id="wrapper">

		<section class="page-title">
			<div class="grid-container">
				<h1>Offres</h1>
				<h6>Faites-nous part de vos offres d'emploi ou vos offres de stage</h6>
			</div>
		</section>

		<div id="horizontalTab">
			<ul class="grid-container tab-titles">
				<li class="grid-33"><a href="#tab-1"><span class="picto offres-gestion"></span><h5>Visualisez vos offres</h5></a></li>
				<li class="grid-33"><a href="#tab-2"><span class="picto offres-stage"></span><h5>Déposez une offre de stage</h5></a></li>
				<li class="grid-33"><a href="#tab-3"><span class="picto offres-emploi"></span><h5>Déposez une offre d'emploi</h5></a></li>
			</ul>
			
			<div id="tab-1" class="tab">
				<section class="bg-light">
					<div class="grid-container" style="position:relative">
						<table>
							<tr>
								<th class="align-left">Intitulé</th>
								<th>État</th>
								<th>Aperçu</th>
							</tr>
						<?php
							$sql = dbquery("SELECT * FROM espace_offres WHERE id_entreprise = '".$_SESSION['entreprise']['id']."' ");
							
							echo '
								
							';
							if(dbnumrows($sql) > 0){
								for($i=0;$i<dbnumrows($sql);$i++){
									$id_offre		= dbresult($sql,$i,"id_offre");
									$intitule		= dbresult($sql,$i,"intitule");
									$type_contrat	= dbresult($sql,$i,"type_contrat");
									$validation		= dbresult($sql,$i,"validation");

									if($validation == 'O')	$etat = "En attente de validation";
									if($validation == 'V')	$etat = "Offre validée";
									if($validation == 'R')	$etat = "En attente de modifications";
									
									echo'
										<tr>
											<td style="width:70%" class="align-left"><span class="dark bold">'.$intitule.'</span></td>
											<td style="width:29%">'.$etat.'</td>
											<td style="width:1%" class="td-picto"><a class="ajax-popup-link open" href="view.php?id_offre='.$id_offre.'"></a></td>
										</tr>
									';
								}
							}
							else{
								echo'
									<tr>
										<td class="align-left">Aucune offre enregistrée</td>
										<td>-</td>
										<td>-</td>
									</tr>
								';
							}
						?>
						</table>

						<p>
							<br><br>
							Pour toute demande de modification ou de suppression d'une offre, merci de contacter le service Entreprises :
							<br><br>
							<b>CONTACT : </b>Eva Micconi <br>
							<b>TEL : </b>02 62 42 28 37 <br>
							<b>MAIL : </b><a href="mailto:emicconi@cnam.re" class="dark">emicconi@cnam.re</a>
						</p>
					</div>
				</section>
			</div>

			<div id="tab-2" class="tab">
				<section class="bg-light">
					<div class="grid-container" style="position:relative">
						<form action="insert.php" method="POST" class="idealforms">
				
							<input type="hidden" name="type_contrat" value="stage"/>
							
							<div class="grid-50 field">
								<label>Intitulé du stage *</label>
								<input type="text" name="intitule" data-idealforms-rules="required minmax:3:255" />
							</div>
							
							<div class="grid-50 field">
								<label>Lieu du stage *</label>
								<?php echo $_SELECT['select']["commune"]?>
							</div>
							
							<div class="grid-25 field">
								<label>Début du stage *</label>
								<?php echo $_SELECT['select']["offre_mois"]?>
							</div>

							<div class="grid-25 field">
								<label>&nbsp</label>
								<?php echo $_SELECT['select']["offre_annee"]?>
							</div>

							<div class="grid-50 field">
								<label>Durée du stage *</label>
								<select  name='duree_contrat' data-idealforms-rules="select:default">
									<option selected value="default">Sélectionner une durée</option>
									<option value="1">1 mois</option>
									<option value="2">2 mois</option>
									<option value="3">3 mois</option>
									<option value="4">4 mois</option>
									<option value="5">5 mois</option>
									<option value="6">6 mois</option>	
								</select>
							</div>
							
							<div class="grid-100 field">
								<label>Descriptif / Contexte *</label>
								<textarea name="descriptif" data-idealforms-rules="required"></textarea>
							</div>
								
							<div class="grid-100 field">
								<label>Objectifs *</label>
								<textarea name="objectifs" data-idealforms-rules="required"></textarea>
							</div>
								
							<div class="grid-100 field">
								<label>Missions *</label>
								<textarea cols="75" rows="3" name="missions" data-idealforms-rules="required"></textarea>
							</div>
								
							<div class="grid-50 field">
								<label>Niveau de formation requis *</label>
								<?php echo $_SELECT['select']['niveau_formation'] ?>
							</div>
								
							<div class="grid-100 field">
								<label>Diplôme(s) exigé(s) *</label>
								<textarea name="diplomes_exiges" data-idealforms-rules="required"></textarea>
							</div>
								
							<div class="grid-100 field">
								<label>Compétences exigées *</label>
								<textarea name="competences_exigees" data-idealforms-rules="required"></textarea>
							</div>
								
							<div class="grid-50 field">
								<label>Rémunération mensuelle en euros *</label>	
								<input type="text" name="remuneration_mensuelle"/>
							</div>
							
							<div class="grid-50 field">
								<label></label><br>
								<a class="dark" href="http://www.legifrance.gouv.fr/affichTexte.do?cidTexte=JORFTEXT000021312490&categorieLien=id#JORFARTI000021327238" target="_blank" > Article 30 de la loi n° 2009-1437 du 24 novembre 2009
								</a><br>
								<a class="dark" href="http://www.legifrance.gouv.fr/affichTexteArticle.do;jsessionid=28792382E7420B1C8B0E9055B504EFFE.tpdjo14v_3?cidTexte=JORFTEXT000000268539&idArticle=LEGIARTI000021342300&dateTexte=20131114&categorieLien=id#LEGIARTI000021342300" target="_blank">Loi n° 2006-396 du 31 mars 2006 pour l'égalité des chances</a>
							</div>

							<header>
								<h2>Tuteur du stagiaire dans l'entreprise </h2>
								Ces informations resteront invisibles lors de l'affichage de l'offre
							</header>

							<div class="grid-50 field">	
								<label>Civilité *</label>
								<select name="contact_civilite" data-idealforms-rules="select:default">
									<option selected value="default">Sélectionner une civilité</option>
									<option value="Mr">Mr</option>
									<option value="Mme">Mme</option>
									<option value="Mlle">Mlle</option>				
								</select>
							</div>

							<div class="grid-50 field clearboth">
								<label>Prénom *</label>
								<input type="text" name="contact_prenom" id="prenom" size="20" maxlength="30" data-idealforms-rules="required minmax:2:255"/>
							</div>
								
							<div class="grid-50 field">
								<label>Nom *</label>
								<input type="text" name="contact_nom" id="nom" size="20" maxlength="30" data-idealforms-rules="required minmax:2:255"/>
							</div>
								
							<div class="grid-50 field">
								<label>Fonction *</label>
								<input type="text" name="contact_fonction" id="contact_fonction" size="25" maxlength="30" data-idealforms-rules="required minmax:2:255"/>
							</div>
								
							<div class="grid-50 field">
								<label>Service *</label>
								<input type="text" name="contact_service" id="contact_service" size="25" maxlength="30" data-idealforms-rules="required minmax:2:255"/>
							</div>
								
							<div class="grid-50 field">
								<label>Téléphone *</label>
								<input type="text" name="contact_tel" size="15" maxlength="14" data-idealforms-rules="required min:10"/>
							</div>
								
							<div class="grid-50 field">
								<label>Adresse e-mail *</label>
								<input type="text" name="contact_mail" size="40" maxlength="30" data-idealforms-rules="email minmax:3:255"/>
							</div>
								
							<div class="grid-100 field">
								<label>Modalités de candidature *</label>
								<textarea name="modalites" data-idealforms-rules="required"></textarea>
							</div>
								
							<div class="grid-100 submit">
								<input type="submit" value="Enregistrer" class="bg-red"/>
							</div>

						</form>
					</div>
				</section>
			</div>

			<div id="tab-3" class="tab">
				<section class="bg-light">
					<div class="grid-container" style="position:relative">
						<form action="insert.php" method="POST" class="idealforms">

							<div class="grid-50 field">
								<label>Intitulé du poste *</label>
								<input type="text" name="intitule" data-idealforms-rules="required minmax:3:255" />
							</div>
								
							<div class="grid-50 field clearboth">
								<label>Type du contrat *</label>
								<select name="type_contrat" id="type_contrat">
									<option value="default">Sélectionner un type de contrat</option>
									<option value="cdd">CDD</option>
									<option value="cdi">CDI</option>
									<option value="pro">Contrat de professionnalisation</option>
									<option value="autre">Autre type de contrat</option>
								</select>
							</div>
							
							<div class="grid-50 field clearboth" >
								<label >Durée du contrat en mois *</label>
								<input id="duree_contrat" type="text" name="duree_contrat" disabled/>			
							</div>

							<div class="grid-50 field" >
								<label>Précisez le type de contrat *</label>
								<input type="text" name="autre_type" id="autre_type" disabled/>	
							</div>
							
							<div class="grid-25 field">
								<label>Début du contrat *</label>
								<?php echo $_SELECT['select']["offre_mois"]?>
							</div>

							<div class="grid-25 field">
								<label>&nbsp</label>
								<?php echo $_SELECT['select']["offre_annee"]?>
							</div>

							<!-- <div class="grid-50 field">
								<label></label>
								<span class="smaller red">Laisser vide si la date est encore à définir</span>
							</div> -->

							<div class="grid-50 field">														
								<label>Lieu d'exercice *</label>
								<?php echo $_SELECT['select']["commune"]?>
							</div>
								
							<div class="grid-100 field">
								<label>Descriptif / Contexte *</label>
								<textarea name="descriptif" data-idealforms-rules="required"></textarea>
							</div>
								
							<div class="grid-100 field">
								<label>Objectifs *</label>
								<textarea name="objectifs" data-idealforms-rules="required"></textarea>
							</div>
								
							<div class="grid-100 field">
								<label>Missions *</label>
								<textarea name="missions" data-idealforms-rules="required"></textarea>
							</div>
								
							<div class="grid-50 field">
								<label>Niveau de formation requis *</label>
								<?php echo $_SELECT['select']['niveau_formation']?>
							</div>
								
							<div class="grid-100 field">
								<label>Diplôme(s) exigé(s) *</label>
								<textarea name="diplomes_exiges" data-idealforms-rules="required"></textarea>
							</div>
								
							<div class="grid-100 field">
								<label>Compétences exigées *</label>
								<textarea name="competences_exigees" data-idealforms-rules="required"></textarea>
							</div>
								
							<div class="grid-50 field">
								<label>Rémunération mensuelle en euros *</label>	
								<input type="text" name="remuneration_mensuelle"/>
							</div>
									
							<header>
								<h2>Contact de l'entreprise</h2>
								Ces informations resteront invisibles lors de l'affichage de l'offre
							</header>
							
							<div class="grid-50 field">
								<label>Civilité *</label>
								<select name="contact_civilite" data-idealforms-rules="select:default">
									<option selected value="default">Sélectionner une civilité</option>
									<option value="Mr">Mr</option>
									<option value="Mme">Mme</option>
									<option value="Mlle">Mlle</option>						
								</select>
							</div>
							
							<div class="grid-50 field clearboth">
								<label>Prénom *</label>
								<input type="text" name="contact_prenom" id="prenom" size="20" maxlength="30" data-idealforms-rules="required minmax:3:255"/>
							</div>

							<div class="grid-50 field">
								<label>Nom *</label>
								<input type="text" name="contact_nom" id="nom" size="20" maxlength="30" data-idealforms-rules="required minmax:3:255"/>
							</div>
								
							<div class="grid-50 field">
								<label>Fonction *</label>
								<input type="text" name="contact_fonction" id="contact_fonction" size="25" maxlength="30" data-idealforms-rules="required minmax:3:255"/>
							</div>
								
							<div class="grid-50 field">
								<label>Service *</label>
								<input type="text" name="contact_service" id="contact_service" size="25" maxlength="30" data-idealforms-rules="required minmax:3:255"/>
							</div>
								
							<div class="grid-50 field">
								<label>Téléphone *</label>
								<input type="text" name="contact_tel" size="15" maxlength="14" class="phone-mask" data-idealforms-rules="required minmax:3:255"/>
							</div>
								
							<div class="grid-50 field">		
								<label>Adresse e-mail *</label>
								<input type="text" name="contact_mail" size="40" maxlength="30" data-idealforms-rules="required email"/>
							</div>
								
							<div class="grid-100 field">
								<label>Modalités de candidature *</label>
								<textarea name="modalites" data-idealforms-rules="required"></textarea>
							</div>
								
							<div class="grid-100 submit">
								<input type="submit" value="Enregistrer" class="bg-red" style="padding:10px 15px;"/>
							</div>

						</form>
					</div>
				</section>
			</div>
		</div>
<?php

// Footer
require($_SERVER['DOCUMENT_ROOT'].'/espace/inc/footer-e.php');

// Scripts js
require($_SERVER['DOCUMENT_ROOT'].'/espace/inc/script-p.php');

?>
<script>
	function type_contrat(){
		$('#type_contrat .options li').click(function(){

			var val = $(this).attr('data-raw-value');
			
			//alert(val);

			if( val == 'cdd' || val == 'pro' || val == 'autre' )	$('#duree_contrat').prop('disabled', false);
			else													$('#duree_contrat').prop('disabled', true);

			if( val == 'autre' )	$('#autre_type').prop('disabled', false);
			else					$('#autre_type').prop('disabled', true);
				
		});
	}
</script>

<?php require($_SERVER['DOCUMENT_ROOT'].'/espace/inc/script-form.php');?>

	<script>
	$(window).load(type_contrat());
	</script>

</body>
</html>