<?php
// ----------
// Ordonnance
// ----------

if (isset($_GET['ordonnance']))
{
	$sql_ordonnance = dbquery("SELECT * FROM ordonnances,clients
		WHERE ordonnances.id_client = clients.id_client
			AND ordonnances.id_ordonnance='".$id_ordonnance."'");

	if (dbnumrows($sql_ordonnance) > 0)
	{
		$prenom			= dbresult($sql_ordonnance,0,"clients.prenom");
		$nom			= dbresult($sql_ordonnance,0,"clients.nom");
		$date			= dbresult($sql_ordonnance,0,"ordonnances.date");

		$QSP_affection_exonerante		= dbresult($sql_ordonnance,0,"ordonnances.QSP_affection_exonerante");
		$QSP_maladies_intercurrentes	= dbresult($sql_ordonnance,0,"ordonnances.QSP_maladies_intercurrentes");
	}

	// Date
	$pdf -> SetFont('Helvetica','',11);
	$pdf -> MultiCell(50,10,"Saint-Denis le ".date_iso_fr($date) , 0, 'L', $fill=false,$ln=2, 114,52,true,0,false,true,0,'T',true);
}

if (!isset($_GET['champs_manquant']))
{
	$sql_medicaments_affection_exonorante = dbquery("SELECT *
		FROM ordonnances_lignes
		WHERE id_ordonnance='".$id_ordonnance."'
			AND type_prescription = 'affection_exonorante'
		ORDER BY id_ordonnance ASC");

	$sql_medicaments_maladies_intercurrentes = dbquery("SELECT *
		FROM ordonnances_lignes
		WHERE id_ordonnance='".$id_ordonnance."'
			AND type_prescription = 'maladies_intercurrentes'
		ORDER BY id_ordonnance ASC");

	// ----------------------------
	// AFFECTION EXONÉRANTE : CADRE
	// ----------------------------
	if (dbnumrows($sql_medicaments_affection_exonorante) > 0 || $_GET['ordonnance_vierge'] == 1)
	{
		// --------
		// CERFA
		// --> Logo
		// --------
		$pdf->ImageSVG($file='../documents/formulaires_cerfa/logo_cerfa.svg', $x=98, $y=10, $w=13, $h='', $link='', $align='', $palign='', $border=0, $fitonpage=false);

		// --> Reference
		$pdf -> SetFont('Helvetica','',8);
		$pdf -> SetXY(95,19);
		$pdf -> Cell(20,10, 'N° 60-3937',  $border=0, $ln=0,'C', $fill=false,'', $stretch=0, false, 'C','C');
		// --------------

		// ------------
		// Prescripteur
		//	--> Cadre
		// ------------
		$pdf -> SetFont('Helvetica','',9);
		$pdf -> SetXY(5,10);
		$pdf -> Cell(90,40, 'Identification du prescripteur',  $border=1, $ln=1,'C', $fill=false,'', $stretch=0, false, 'T','T');

		// ------------------
		// Footer : Reference
		// ------------------
		$pdf -> SetFont('Helvetica','',10);
		$pdf -> SetXY(182,288);
		$pdf -> Cell(20,10, 'S3321a',  $border=0, $ln=0,'C', $fill=false,'', $stretch=0, false, 'C','C');

		// ----------
		// Malade
		// --> cadre
		// ---------
		$pdf -> SetFont('Helvetica','B',9);
		$pdf -> SetXY(115,10);
		$pdf -> Cell(90,40, "Nom - prénoms du malade",  1, $ln=0,'C', $fill=false,'', $stretch=0, false, 'T','T');

		// --> Nom + Prénom
		$pdf -> SetFont('Helvetica','B',11);
		$pdf -> SetXY(115,10);
		$pdf -> Cell(90,40, $nom." ".$prenom,  1, $ln=0,'C', $fill=false,'', $stretch=0, false, 'T','C');


		$pdf -> SetFont('Helvetica','B',11);
		$pdf -> MultiCell(200,12, "Prescriptions relatives au traitement de l'affection de longue durée reconnue (liste ou hors liste)\n(AFFECTION EXONÉRANTE)", $border='TB', 'C', $fill=false,$ln=2, 5,58);
	}
	else
	{
		// Nom + Prénom du malade
		$pdf -> SetFont('Helvetica','BU',13);
		$pdf -> MultiCell(200,12, "Patient : ".$nom." ".$prenom, $border='', 'L', $fill=false,$ln=2, 15,60);
	}

	$pdf -> SetFont('Helvetica','',11);
	$pdf -> SetXY(10,75);

	for ($j=0;$j<dbnumrows($sql_medicaments_affection_exonorante);$j++)
	{
		// ------------------------------
		// Nb lignes AFFECTION EXONÉRANTE
		// ------------------------------
		$nb_lignes_affection_exonorante = dbnumrows($sql_medicaments_affection_exonorante);
		if ($QSP_affection_exonerante <> '')	$nb_lignes_affection_exonorante++;

		// -
		// y
		// -
		if (dbnumrows($sql_medicaments_affection_exonorante) <=4)
		{
			$increment_vertical = 22;
			$margin_vertical	= 9;
			$margin_QSP			= 8;
		}
		else
		{
			$increment_vertical = 85/$nb_lignes_affection_exonorante;
			$margin_vertical	= 5;
			$margin_QSP			= 0;
		}

		$y = 75+$increment_vertical*$j;
		
		$id_ordonnance_ligne	= dbresult($sql_medicaments_affection_exonorante,$j,"id_ordonnance_ligne");
		$medicament				= dbresult($sql_medicaments_affection_exonorante,$j,"medicament");
		$posologie				= str_replace('/',' / ',dbresult($sql_medicaments_affection_exonorante,$j,"posologie"));
		$non_substituable		= dbresult($sql_medicaments_affection_exonorante,$j,"non_substituable");

		$numero = $j+1;

		$pdf -> setColor('text',0,0,0);
		$pdf -> SetFont('Helvetica','B',11);
		$pdf -> MultiCell(170,12, $numero.". ".$medicament, $border='', 'L', $fill=false,$ln=2, 10,$y);
		$pdf -> SetFont('Helvetica','I',11);
		$pdf -> MultiCell(200,12, $posologie, $border='', 'L', $fill=false,$ln=2, 15,$y+$margin_vertical);

		if ($non_substituable == 1)
		{
			$pdf->Image_non_substituable(160,$y+$increment_y);
		}

		$pdf -> setColor('text',0,0,0);
	}

	// ---
	// QSP
	// ---
	$pdf -> SetFont('Helvetica','B',12);
	$pdf -> setColor('text',38,127,0);
	if ($QSP_affection_exonerante <> '')
		$pdf -> MultiCell($pdf->getPageWidth(),12, "QSP : ".$QSP_affection_exonerante, $border='', 'C', $fill=false,$ln=2, 0,$y+10+$margin_QSP);
	$pdf -> SetFont('Helvetica','',11);
	$pdf -> setColor('text',0,0,0);


	
	// -------------------------------
	// MALADIES INTERCURRENTES : CADRE
	// -------------------------------
	if (dbnumrows($sql_medicaments_affection_exonorante) > 0 || $_GET['ordonnance_vierge'] == 1)
	{
		$pdf -> SetFont('Helvetica','B',11);
		$pdf -> MultiCell(200,12, "Prescriptions SANS RAPPORT avec l’affection de longue durée\n(MALADIES INTERCURRENTES)", $border='TB', 'C', $fill=false,$ln=2, 5,165);
	}


	for ($j=0;$j<dbnumrows($sql_medicaments_maladies_intercurrentes);$j++)
	{
		// ------------------------------
		// Nb lignes AFFECTION EXONÉRANTE
		// ------------------------------
		$nb_lignes_maladies_intercurrentes = dbnumrows($sql_medicaments_maladies_intercurrentes);
		if ($QSP_maladies_intercurrentes <> '')	$nb_lignes_maladies_intercurrentes++;
		
		// -
		// y
		// -
		if (dbnumrows($sql_medicaments_maladies_intercurrentes) <=4)
		{
			$increment_vertical = 22;
			$margin_vertical	= 9;
			$margin_QSP			= 8;
		}
		else
		{
			$increment_vertical = 85/$nb_lignes_maladies_intercurrentes;
			$margin_vertical	= 5;
			$margin_QSP			= 0;
		}

		$y = 75+$increment_vertical*$j;

		$id_ordonnance_ligne	= dbresult($sql_medicaments_maladies_intercurrentes,$j,"id_ordonnance_ligne");
		$medicament				= dbresult($sql_medicaments_maladies_intercurrentes,$j,"medicament");
		$posologie				= str_replace('/',' / ',dbresult($sql_medicaments_maladies_intercurrentes,$j,"posologie"));
		$non_substituable		= dbresult($sql_medicaments_maladies_intercurrentes,$j,"non_substituable");

		$numero = $j+1;

		$increment_y = 110;
		if (dbnumrows($sql_medicaments_affection_exonorante) == 0)
			$increment_y = 0;

		$pdf -> setColor('text',0,0,0);
		$pdf -> SetFont('Helvetica','B',11);
		$pdf -> MultiCell(170,12, $numero.". ".$medicament, $border='', 'L', $fill=false,$ln=2, 10,$y+$increment_y);
		$pdf -> SetFont('Helvetica','I',11);
		$pdf -> MultiCell(200,12, $posologie, $border='', 'L', $fill=false,$ln=2, 15,$y+$increment_y+$margin_vertical);

		if ($non_substituable == 1)
		{
			$pdf->Image_non_substituable(160,$y+$increment_y);
		}
	}

	// ---
	// QSP
	// ---
	$pdf -> SetFont('Helvetica','B',12);
	$pdf -> setColor('text',38,127,0);
	if ($QSP_maladies_intercurrentes <> '')
		$pdf -> MultiCell($pdf->getPageWidth(),12, "QSP : ".$QSP_maladies_intercurrentes, $border='', 'C', $fill=false,$ln=2, 0,$y+$increment_y+10+$margin_QSP);
	$pdf -> SetFont('Helvetica','',11);
	$pdf -> setColor('text',0,0,0);
}


// Info docteur
$sql_docteur = dbquery("SELECT docteurs.* FROM docteurs,ordonnances
	WHERE docteurs.id_docteur = ordonnances.id_docteur
		AND ordonnances.id_ordonnance = '".$id_ordonnance."'");

$nom_docteur	= dbresult($sql_docteur,0,"nom_docteur");
$specialite		= dbresult($sql_docteur,0,"specialite");
$entete			= dbresult($sql_docteur,0,"entete");
$AM				= dbresult($sql_docteur,0,"AM");
$RPPS			= dbresult($sql_docteur,0,"RPPS");

// --> Texte
// COULEUR PANTONE
$sql_couleur_1 = dbquery("SELECT * FROM couleurs WHERE pantone='".param('pantone_enveloppe')."'");

$p_enveloppe = dbresult($sql_couleur_1,0,"C");
$C_enveloppe = dbresult($sql_couleur_1,0,"C");
$M_enveloppe = dbresult($sql_couleur_1,0,"M");
$Y_enveloppe = dbresult($sql_couleur_1,0,"Y");
$K_enveloppe = dbresult($sql_couleur_1,0,"K");

$pdf->AddSpotColor('Pantone '.param('pantone_enveloppe').' C', $C_enveloppe, $M_enveloppe, $Y_enveloppe, $K_enveloppe);

// Couleur pantone
if (dbresult($sql_personnel,0,"quadrichromie") == 1) 
$pdf->SetTextSpotColor('Pantone '.param('pantone_enveloppe').' C', 100);


$pdf -> SetFont('Helvetica','B',11);
$pdf -> MultiCell(90,12, 'Docteur '.$nom_docteur.'
'.strtoupper($specialite), $border='', 'C', $fill=false,$ln=1, 5,16);

// Couleur noir
$pdf -> SetTextColor(0, 0, 0);
$pdf -> SetFont('Helvetica','',10);
$pdf -> MultiCell(90,12, $entete, $border='', 'C', $fill=false,$ln=1, 5,29);


// --------
// Code 128 
// --------
$pdf -> SetFont('Helvetica','',10);

// --> AM
$pdf -> SetXY(30,276);
$pdf->Cell(0, 0, 'N° AM', 0, 1);
$pdf->write1DBarcode($AM, 'C128', 30, '', 35, 4, '', $style, 'N');
$pdf -> SetXY(30,285);
$pdf->Cell(0, 0, $AM, 0, 1);


// --> RPPS
$pdf -> SetXY(120,276);
$pdf->Cell(0, 0, 'N° RPPS', 0, 1);
$pdf->write1DBarcode($RPPS, 'C128', 120, '', 35, 4, '', $style, 'N');
$pdf -> SetXY(120,285);
$pdf->Cell(0, 0, $RPPS, 0, 1);
