<?php
// =======
// ETATS
// --> pdf
// =======

session_start();

require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/config.global.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/dbconfig.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/lib/lib.main.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/lib/lib.db.inc.php");
libraries(array('TCPDF'));



// extend TCPF with custom functions
class MYPDF extends TCPDF
{
	/**
	* @buggy svg handler in 6.2.
	*
	* @param        $file
	* @param string $x
	* @param string $y
	* @param int    $w
	* @param int    $h
	* @param string $link
	* @param string $align
	* @param string $palign
	* @param int    $border
	* @param bool   $fitonpage
	*
	* @return \image|void
	*/
	public function ImageSVG($file, $x = '', $y = '', $w = 0, $h = 0, $link = '', $align = '', $palign = '', $border = 0, $fitonpage = false)
	{
		if (is_file($file) && is_readable($file))
		{
			$file = '@' . file_get_contents($file);
		}

		return parent::ImageSVG($file, $x, $y, $w, $h, $link, $align, $palign, $border, $fitonpage);
	}
	
	// Image non substituable
	public function Image_non_substituable($x,$y)
	{
		$tab_image = array();

		$tab_image[0] = "non_substituable_01.png";
		$tab_image[1] = "non_substituable_02.png";
		$tab_image[2] = "non_substituable_03.png";
		$tab_image[3] = "non_substituable_04.png";
		$tab_image[4] = "non_substituable_05.png";
		$tab_image[5] = "non_substituable_06.png";
		$tab_image[6] = "non_substituable_07.png";
		$tab_image[7] = "non_substituable_08.png";
		$tab_image[8] = "non_substituable_09.png";
		
		$image = "../images/non_substituable/".$tab_image[rand(0,8)];
	
		$this->Image($image, $x+rand(0,2),$y, 45,0 , 'PNG', '', '', true, 300, '', false, false, 0, false, false, false);
	}
}




// A4 portrait
// (0,0)               (210,0)
//   +-------------------+
//   |         |         |
//   +---------+---------+
//   |         |         |
//   +---------+---------+
//   |         |         |
//   +---------+---------+
//   |         |         |
//   +---------+---------+
//   |         |         |
//   +-------------------+
// (0,297)             (210,297)



if (!isset($_SESSION['id_personnel']))
{
	header("Location:/cabinet/authentification/login_form.php?message=Fin de session. Veuillez vous reconnecter.");
	exit;
}

$sql_personnel		= dbquery("SELECT * FROM personnel WHERE id_personnel='".$_SESSION['id_personnel']."'");
if (dbnumrows($sql_personnel) == 0)
	die('Attention : Personnel non reconnu');


// create new PDF document
$pdf = new MYPDF('portrait', 'mm', 'A4', true ,'utf-8' , false);

// set document information
$pdf->SetCreator(PDF_CREATOR);
$pdf->SetAuthor('Cabinet');
$pdf->SetTitle('PDF');
$pdf->SetSubject('PDF');
$pdf->SetKeywords('PDF');


//set image scale factor
$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

//set some language-dependent strings
$pdf->setLanguageArray($l);

// ---------------------------------------------------------

// set font
$pdf->SetFont('helvetica');

$pdf->SetAutoPageBreak(false);
$pdf->setPrintHeader(false);
$pdf->setPrintFooter(false);

// Marges
$pdf->SetMargins(20,20,20,20);


$pdf->SetTextColor(0,0,0);


// ======
// ENTETE
// ======

// -------------------
// Ordonnance vierge
// -> bi-zone complete
// -------------------
if (isset($_GET['ordonnance_vierge']))
{
	$pdf -> addPage();
	require($_SERVER['DOCUMENT_ROOT']."/cabinet/pdf/pdf_ordonnance.inc.php");
}

// ----------
// Ordonnance
// -> Simple
// -> Bi-zone
// ----------
if (isset($_GET['ordonnance']))
{
	foreach($_GET['ordonnance'] as $id_ordonnance => $value)
	{
		$pdf -> addPage();
		require($_SERVER['DOCUMENT_ROOT']."/cabinet/pdf/pdf_ordonnance.inc.php");
	}
}

// -------------------------------------
// Ordonnance vierge
// -> Ordonnance bi-zone champs manquant
// -> Ordonnance normale
// -------------------------------------
if (isset($_GET['champs_manquant']))
{
	$pdf -> addPage();
	require($_SERVER['DOCUMENT_ROOT']."/cabinet/pdf/pdf_courrier.inc.php");
}

// --------
// Courrier
// --------
if (isset($_GET['courrier']))
{
	$pdf -> SetAutoPageBreak(true,19);
	
	foreach($_GET['courrier'] as $id_courrier => $value)
	{
		$pdf -> addPage();
		require($_SERVER['DOCUMENT_ROOT']."/cabinet/pdf/pdf_courrier.inc.php");
	}
}


// -----------------------------
// Close and output PDF document
// -----------------------------
ob_end_clean();
$pdf->Output('courrier_ordonnance.pdf', 'I');