<?php
// =================
// ETIQUETTES
// --> pdf
// =================

session_start();

require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/config.global.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/dbconfig.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/lib/lib.main.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/lib/lib.db.inc.php");
libraries(array('TCPDF'));


// A4 portrait
// (0,0)               (210,0)
//   +-------------------+
//   |         |         |
//   +---------+---------+
//   |         |         |
//   +---------+---------+
//   |         |         |
//   +---------+---------+
//   |         |         |
//   +---------+---------+
//   |         |         |
//   +-------------------+
// (0,297)             (210,297)



if (!isset($_SESSION['id_personnel']))
{
	header("Location:/cabinet/authentification/login_form.php?message=Fin de session. Veuillez vous reconnecter.");
	exit;
}



// Extend the TCPDF class to create custom Header and Footer
class MYPDF extends TCPDF {
	// Page footer
	public function Footer() {
		// Position at 15 mm from bottom
		$this->SetY(-15);
		// Set font
		$this->SetFont('helvetica', 'I', 8);
		// Page number
		$this->Cell(0, 10, $this->getAliasNumPage().'/'.$this->getAliasNbPages(), 0, false, 'C', 0, '', 0, false, 'T', 'M');
	}
}



// create new PDF document
$pdf = new MYPDF('portrait', 'mm', 'A4', true ,'utf-8' , false);


// set document information
$pdf->SetCreator(PDF_CREATOR);
$pdf->SetAuthor('Cabinet');
$pdf->SetTitle('Courrier');
$pdf->SetSubject('Courrier');
$pdf->SetKeywords('Courrier');


//set image scale factor
$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

//set some language-dependent strings
$pdf->setLanguageArray($l);

// ---------------------------------------------------------

// set font
$pdf->SetFont('helvetica');

$pdf->SetAutoPageBreak(true,20);
$pdf->setPrintHeader(false);
$pdf->setPrintFooter(true);

// Marges
$pdf->SetMargins(20,20,20,20);


$pdf->SetTextColor(0,0,0);


// ======
// ENTETE
// ======

$pdf -> addPage();

$pdf -> SetFont('Helvetica','B',11);
$pdf -> MultiCell(85,12, 'Docteur '.param('nom_docteur').'
'.strtoupper(param('specialite')), $border='', 'C', $fill=false,$ln=1, 10,20);

$pdf -> SetFont('Helvetica','',9);
$pdf -> MultiCell(85,12, param('entete'), $border='', 'C', $fill=false,$ln=1, 10,31);


$pdf -> SetFont('Helvetica','',11);

$sql_courrier = dbquery("SELECT * FROM courrier
	WHERE id_courrier='".$_GET['id_courrier']."'");

if (dbnumrows($sql_courrier) > 0)
{
	$date			= dbresult($sql_courrier,0,"date");
	$destinataires	= dbresult($sql_courrier,0,"destinataires");
	$corps			= dbresult($sql_courrier,0,"corps");
	
	
	// Date
	$pdf -> MultiCell(50,10,"Saint-Denis le ".date_iso_fr($date) , 0, 'L', $fill=false,$ln=2, 140,50,true,0,false,true,0,'T',true);

	// A l'intention de 
	$pdf -> MultiCell(50,0, $destinataires , 0, 'L', $fill=false,$ln=2, 140,60,true,0,false,true,0,'T',true);

	// Corps du courrier
	$pdf -> SetY($pdf->getY()+5);
	$pdf -> writeHTML($corps,$ln = true,$fill = false,$reseth = true,$cell = false,$align = 'L');
}

// -----------------------------
// Close and output PDF document
// -----------------------------
ob_end_clean();
$pdf->Output('courrier.pdf', 'I');