<?php
// ================
// Classes GEOMETRY
// ================


class Point
{
	public $x;
	public $y;
	
	public function __construct($x=0,$y=0)
	{
		$this->x = $x;
		$this->y = $y;
	}

	//convert to string
	public function __toString()
	{
		return(
"Point 
   - X: {$this -> x}
   - Y: {$this -> y}
   ");
	}
}


class Line
{
	public $point_1 = NULL;
	public $point_2 = NULL;
	public $label	= "";

	//creates a line
	public function __construct($p1, $p2)
	{
		$this -> point_1 = $p1;
		$this -> point_2 = $p2;
	}

	//convert to string
	public function __toString()
	{
		return(
"Line:
 - Point 1
   - X: {$this -> point_1 -> x}
   - Y: {$this -> point_1 -> y}
 - Point 2
   - X: {$this -> point_2 -> x}
   - Y: {$this -> point_2 -> y}

 - Width: {$this -> Width()}
 - Height: {$this -> Height()}
 - Length: {$this -> Length()}
   ");
	}

	// Width of the Bounding Box
	public function Width()
	{
		return $this -> point_2 -> x - $this -> point_1 -> x;
	}

	// Height of the Bounding Box
	public function Height()
	{
		return $this -> point_2 -> y - $this -> point_1 -> y;
	}

	// Length
	public function Length()
	{
		return (sqrt(pow(abs($this -> Width()), 2) + pow(abs($this -> Height()), 2)));
	}

	// Center of line
	public function Center()
	{
		$point_center =  new Point();
		
		$point_center -> x = ($this -> point_2 -> x + $this -> point_1 -> x) / 2;
		$point_center -> y = ($this -> point_2 -> y + $this -> point_1 -> y) / 2;

		return $point_center;
	}

}


class Polyline
{
	public $points	= array(NULL);
	public $lines	= array(NULL);

	//creates a polyline.
	//@param array points The list of points
	public function __construct($points)
	{
		$this -> points = $points;
		$this -> lines = $points;

		for($i = 0; $i <= count($points)-1; $i++)
		{
			$this -> lines[$i] = new Line($points[$i], $points[$i+1]);
		}
	}

	//converts to String
	public function __toString()
	{
		$i = 1;
		$str = "Polyline:\n";

		$str .=
" - Sides: {$this -> Points()}\n\n";

		//show all lines' info
		foreach ($this -> points as $v)
		{
			$str .=
" - Point $i:
   - X: ";
			$str .= $v -> x;
			$str .=
"\n   - Y: ";
			$str .= $v -> y;
			$str .= "\n";
		$i++;
		}

		$str .=
"\n - Area: {$this -> Area()}\n";
		$str .=
" - Perimeter: {$this -> Perimeter()}\n";
		return $str;
	}


	// ======================================
	// array for GD + TcPDF polygon functions
	// ======================================
	/*Array
	(
		[0] => 72.466412434868
		[1] => 110.03858009584
		[2] => 73.428987724384
		[3] => 110.01088008743
	)
	*/
	public function GD_TcPDF_Polyline($offset_x=0,$offset_y=0)
	{
		$poly = array();
	
		for ($i = 0; $i < count($this -> points); $i++)
		{
			$poly[] = $this -> points[$i] -> x + $offset_x;
			$poly[] = $this -> points[$i] -> y + $offset_y;
		}

		return $poly;
	}

	
	//returns the numbers of points
	public function Points()
	{
		return count($this -> points);
	}
}


class Polygon
{
	public $points	= array(NULL);
	public $lines	= array(NULL);

	//creates a polygon.
	//@param array points The list of points
	public function __construct($points)
	{
		$this -> points = $points;
		$this -> lines = $points;

		for($i = 0; $i <= count($points)-1; $i++)
		{
			$this -> lines[$i] = new Line($points[$i], $points[$i+1]);
		}
		$this -> points[count($this -> lines)] = new Point($points[0]->x,$points[0]->y);
		$this -> lines[count($this -> lines)] = new Line($points[count($this -> lines)],$points[0]);
	}

	//converts to String
	public function __toString()
	{
		$i = 1;
		$str = "Polygon:\n";

		$str .=
" - Sides: {$this -> Points()}\n\n";

		//show all lines' info
		foreach ($this -> points as $v)
		{
			$str .=
" - Point $i:
   - X: ";
			$str .= $v -> x;
			$str .=
"\n   - Y: ";
			$str .= $v -> y;
			$str .= "\n";
		$i++;
		}

		$str .=
"\n - Area: {$this -> Area()}\n";
		$str .=
" - Perimeter: {$this -> Perimeter()}\n";
		return $str;
	}

	// ======================================
	// array for GD + TcPDF polygon functions
	// ======================================
	/*Array
	(
		[0] => 72.466412434868
		[1] => 110.03858009584
		[2] => 73.428987724384
		[3] => 110.01088008743
	)
	*/
	public function GD_TcPDF_Polygon($offset_x=0,$offset_y=0)
	{
		$poly = array();
	
		for ($i = 0; $i < count($this -> points); $i++)
		{
			$poly[] = $this -> points[$i] -> x + $offset_x;
			$poly[] = $this -> points[$i] -> y + $offset_y;
		}

		return $poly;
	}

	// ------------------
	// Centre du polygone
	// --> Premier point
	// ------------------
	public function Center_First_Node()
	{		
		$center_polygon_first_node = new Point();

		$array = $this->Alternative_Polygon();
		
		$center_polygon_first_node -> x = $array[0]['x'];
		$center_polygon_first_node -> y = $array[0]['y'];

		return $center_polygon_first_node;
	}


	// ------------------
	// Centre du polygone
	// ------------------
	public function Center()
	{		
		$center = new Point();

		$array = $this->Alternative_Polygon();
		
		if ($this->Aire() <> 0)
		{
			$sum = 0;
			for ($i=0 ; $i <= count($array) - 2 ; $i++)
			{
				$sum += ($array[$i]['x'] + $array[$i+1]['x'])  *  (($array[$i]['x'] * $array[$i+1]['y'])  -  ($array[$i+1]['x'] * $array[$i]['y']));
			}
			$center->x = abs($sum / (6 * $this->Aire()));

			$sum = 0;
			for ($i=0 ; $i <= count($array) - 2 ; $i++)
			{
				$sum += ($array[$i]['y'] + $array[$i+1]['y'])  *  (($array[$i]['x'] * $array[$i+1]['y'])  -  ($array[$i+1]['x'] * $array[$i]['y']));
			}
			$center->y = abs($sum / (6 * $this->Aire()));
		}
		else
		{
			$center->x = $array[0]['x'];
			$center->y = $array[0]['y'];
		}

		return $center;
	}



	// ------------------
	// Aire du polygone
	// ------------------
	public function Aire()
	{		
		$array = $this->Alternative_Polygon();
		
		$sum = 0;
		for ($i=0 ; $i <= count($array) - 2 ; $i++)
		{
			$sum += $array[$i]['x'] * $array[$i+1]['y']  -  $array[$i+1]['x'] * $array[$i]['y'];
		}
		return abs($sum / 2);
	}



	// =================
	// Forme alternative
	// =================
	/*
	Array
	(
		[0] => Array
			(
				[x] => 72.466412434868
				[y] => 110.03858009584
			)

		[1] => Array
			(
				[x] => 73.428987724384
				[y] => 110.01088008743
			)
	)*/

	public function Alternative_Polygon()
	{
		$poly = array();
		
		foreach ($this->points as $key => $value)
		{
			$poly[$key]['x'] = $value -> x;
			$poly[$key]['y'] = $value -> y;
		}

		return $poly;
	}

	
	//returns the numbers of points
	public function Points()
	{
		return count($this -> points);
	}
}

?>