<?php
// =================
// ETIQUETTES
// --> pdf
// =================

session_start();

require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/config.global.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/dbconfig.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/lib/lib.main.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/lib/lib.db.inc.php");
libraries(array('TCPDF'));


// A4 portrait
// (0,0)               (210,0)
//   +-------------------+
//   |         |         |
//   +---------+---------+
//   |         |         |
//   +---------+---------+
//   |         |         |
//   +---------+---------+
//   |         |         |
//   +---------+---------+
//   |         |         |
//   +-------------------+
// (0,297)             (210,297)
// extend TCPF with custom functions


class MYPDF extends TCPDF
{
	// Table UE
	public function TableActe($header,$data,$x,$y)
	{
		$this->SetXY($x,$y);

		$this->SetLeftMargin($x);
			
		// Colors, line width and bold font
		$this->SetFillColor(255, 255, 255);
		$this->SetTextColor(0,0,0);
		$this->SetDrawColor(0, 100, 80, 20);
		$this->SetLineWidth(0.3);
		$this->SetFont('', 'B');
		
		// Header
		$w = array(52, 135, 24, 23, 23);
		$num_headers = count($header);
		for($i = 0; $i < $num_headers; ++$i)
		{
			$this->Cell($w[$i], 10, $header[$i], 1, 0, 'C', 1);
		}
		$this->Ln();
		$this->SetFont('', '');
	
	}
}

$bordure_rouge_cnam	= array(193, 0, 42);


$sql_personnel = dbquery("SELECT * FROM personnel
	WHERE id_personnel='".$_SESSION['id_personnel']."'");
if (dbnumrows($sql_personnel) == 0)	die('Erreur : Personnel non identifié');


// create new PDF document
$pdf = new MYPDF('portrait', 'mm', 'A3', true ,'utf-8' , false);


// set document information
$pdf->SetCreator(PDF_CREATOR);
$pdf->SetAuthor('Cabinet');
$pdf->SetTitle('Etiquettes');
$pdf->SetSubject('Etiquettes');
$pdf->SetKeywords('Etiquettes');


//set image scale factor
$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

//set some language-dependent strings
$pdf->setLanguageArray($l);

// ---------------------------------------------------------

// set font
$pdf->SetFont('helvetica');

$pdf->SetTopMargin(0);
$pdf->SetLeftMargin(0);
$pdf->SetRightMargin(0);

$pdf->SetAutoPageBreak(false);
$pdf->setPrintHeader(false);
$pdf->setPrintFooter(false);

$pdf->SetTextColor(0,0,0);


$pdf->AddPage('portrait');


// Image header
$pdf->Image('../../images/header.png', 0,0, $pdf->getPageWidth(),0 , 'PNG', '', '', true, 300, '', false, false, 0, false, false, false);



// Cabinet du Docteur xxx
$pdf->SetFont('helvetica', '', 18);
$pdf -> SetXY(20,20);
$pdf -> Cell($pdf->getPageWidth()-40,0, 'Cabinet du Docteur '.param('nom_docteur').' - '.param('telephone_1'), 0 , $ln=0,'C', $fill=false,'', $stretch=0, false, 'C','C');


// Tarifs des consultations de pneumologie
$pdf->SetFont('helvetica', '', 15);
$pdf -> SetXY(20,32);
$pdf -> Cell($pdf->getPageWidth()-40,0, 'Tarifs des consultations de pneumologie', 0 , $ln=0,'C', $fill=false,'', $stretch=0, false, 'C','C');



// ACTES
$pdf->SetFont('helvetica', '', 12);


$y = 58;

// Entete de table
$data_ue = array();
$header = array('Acte', 'Intitulé','Cotation','Prix','TOTAL');
$pdf -> TableActe($header,$data_ue, 20, $y-13);


$sql_actes = dbquery("SELECT id_acte,acte
	FROM actes
	ORDER BY id_acte ASC");
for ($i=0;$i<dbnumrows($sql_actes);$i++)
{
	$id_acte	= dbresult($sql_actes,$i,"id_acte");
	$acte		= dbresult($sql_actes,$i,"acte");

	$sql_actes_ccam = dbquery("SELECT ccam.*
		FROM ccam,actes_ccam
		WHERE ccam.code_ccam = actes_ccam.code_ccam
			AND actes_ccam.id_acte = '".$id_acte."'
		ORDER BY ccam.code_ccam ASC");



	
	$prix_acte_total = 0;
	$y_from = $y;
	for ($j=0;$j<dbnumrows($sql_actes_ccam);$j++)
	{
		$code_ccam	= dbresult($sql_actes_ccam,$j,"ccam.code_ccam");
		$libelle	= dbresult($sql_actes_ccam,$j,"ccam.libelle");
		$prix_acte	= dbresult($sql_actes_ccam,$j,"ccam.prix_acte");
		$coefficiant_2e_acte	= dbresult($sql_actes_ccam,$j,"ccam.coefficiant_2e_acte");


		$increment_vertical = 11;
		if (strlen($libelle) > 120)	$increment_vertical = 15;


		// 1er acte
		if ($j == 0)	$coefficiant_2e_acte = 1;
	

		$pdf -> MultiCell(130,12, $libelle , 0, 'L', $fill=false,$ln=2, 76,$y,true,3,false,true,$increment_vertical,'M',true);

		$pdf -> SetXY(210,$y+$increment_vertical/2+1);
		$pdf -> Cell(18,10, $code_ccam,     0, $ln=0,'C', $fill=false,'', $stretch=0, false, 'C','C');

		// Prix acte
		$pdf -> SetXY(234,$y+$increment_vertical/2+1);
		$pdf -> Cell(18,10, number_format($prix_acte*$coefficiant_2e_acte,2,',',' ').' €',     0, $ln=0,'C', $fill=false,'', $stretch=0, false, 'C','C');

		
		$y += $increment_vertical+2;
		$prix_acte_total += $prix_acte*$coefficiant_2e_acte;
	}
 
	// ACTE
	$pdf -> MultiCell(146,12, $acte , 0, 'L', $fill=false,$ln=2, 23,$y_from+2,true,3,false,true,$y-$y_from-4,'M',false);

 
	// TOTAL
	$pdf -> MultiCell(146,12, number_format($prix_acte_total,2,',',' ').' €' , 0, 'L', $fill=false,$ln=2, 257,$y_from+2,true,3,false,true,$y-$y_from-4,'M',false);


	// Lignes horizontales
	$pdf -> Line(20,  $y, 277,  $y, $bordure_rouge_cnam);

}

// Lignes verticales
$pdf -> Line(20,  55, 20,  $y, $bordure_rouge_cnam);
$pdf -> Line(72,  55, 72,  $y, $bordure_rouge_cnam);
$pdf -> Line(207, 55, 207, $y, $bordure_rouge_cnam);
$pdf -> Line(231, 55, 231, $y, $bordure_rouge_cnam);
$pdf -> Line(254, 55, 254, $y, $bordure_rouge_cnam);
$pdf -> Line(277, 55, 277, $y, $bordure_rouge_cnam);






// Mention CNIL
$mention_cnil = "<p>Ce cabinet dispose d’un système informatique destiné à faciliter la gestion des dossiers des patients et à assurer la facturation des actes et la télétransmission des feuilles de soins aux caisses de sécurité sociale.
Les informations recueillies lors de votre consultation feront l’objet, sauf opposition justifiée de votre part, d’un enregistrement informatique réservé à l’usage de votre professionnel de santé.<br>
Votre professionnel de santé traitant se tient à votre disposition pour vous communiquer ces renseignements ainsi que toutes informations nécessaires sur votre état de santé*.<br>
Tout médecin désigné par vous peut également prendre connaissance de l’ensemble de votre dossier médical.</p>
<p><i>* Loi n°78-17 du 6 janvier 1978 modifiée relative à l’informatique, aux fichiers et aux libertés</i></p>";

// --> Cadre
$pdf -> SetDrawColor(79, 184, 71);
$pdf -> SetXY(20,342);
$pdf -> Cell($pdf->getPageWidth()-40,56, '', 1 , $ln=0,'C', $fill=false,'', $stretch=0, false, 'T','C');

// --> Texte
$pdf->SetFont('helvetica', '', 12);
$pdf -> writeHTMLCell( 	$pdf->getPageWidth()-48,
		70,
		24,
		346,
		$mention_cnil,
		$border = 0,
		$ln = 0,
		$fill = false,
		$reseth = true,
		$align = 'L',
		$autopadding = false 
	);


// Couleurs
$green1 = array(79, 184, 71);
$green2 = array(101, 229, 89);

// set the coordinates x1,y1,x2,y2 of the gradient (see linear_gradient_coords.jpg)
$coords = array(0, 0, 1, 0);

// Footer : paint a linear gradient
$pdf->LinearGradient(0, $pdf->getPageHeight()-15, $pdf->getPageWidth(), 15, $green1, $green2, $coords);



// -----------------------------
// Close and output PDF document
// -----------------------------
ob_end_clean();
$pdf->Output('fiche_tarif.pdf', 'I');