<?php
// ==============
// ETIQUETTE FACE
// --> pdf
// ==============

session_start();


require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/config.global.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/dbconfig.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/lib/lib.main.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/lib/lib.db.inc.php");
libraries(array('TCPDF'));


// A4 portrait
// (0,0)               (210,0)
//   +-------------------+
//   |         |         |
//   +---------+---------+
//   |         |         |
//   +---------+---------+
//   |         |         |
//   +---------+---------+
//   |         |         |
//   +---------+---------+
//   |         |         |
//   +-------------------+
// (0,297)             (210,297)


// extend TCPF with custom functions
class MYPDF extends TCPDF
{
	// Nb de lignes / colonnes
	var $nb_lignes;
	var $nb_colonnes;
	
	// Etiquette
	public function etiquette($position)
	{
		$margin = $this -> getMargins();

		$x = $margin['left'] + ($this->getPageWidth() - $margin['left'] - $margin['right'])/$this->nb_colonnes*($position%$this -> nb_colonnes);
		$y = $margin['top']  + ($this->getPageHeight()- 2*$margin['top'])/$this->nb_lignes*(floor($position/$this->nb_colonnes)%$this->nb_lignes);

		$this->SetXY($x,$y);
	}
}


// ==========
// ETIQUETTES
// ==========


// create new PDF document
$pdf = new MYPDF();

// Sur chaque page
$id_format_papier	= "A4";
$orientation		= "landscape";

// Parametres generaux

// -> Nb de lignes et de colonnes
$pdf->nb_lignes		= 2;
$pdf->nb_colonnes	= 3;

// Marges
$pdf->SetTopMargin(10);
$pdf->SetLeftMargin(10);
$pdf->SetRightMargin(10);


// set document information
$pdf->SetCreator(PDF_CREATOR);
$pdf->SetAuthor('Cnam');
$pdf->SetTitle('Etiquette Dossier Suspendu');
$pdf->SetSubject('Etiquette Dossier Suspendu');
$pdf->SetKeywords('Etiquette,Dossier Suspendu');


//set image scale factor
$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

//set some language-dependent strings
$pdf->setLanguageArray($l);

// ---------------------------------------------------------

// set font
$pdf->SetFont('helvetica');


$pdf->SetAutoPageBreak(false);
$pdf->setPrintHeader(false);
$pdf->setPrintFooter(false);

$pdf->SetTextColor(0,0,0);
$pdf -> SetFontSize(10);

$margin = $pdf -> getMargins();

$sql_client = dbquery("SELECT *
	FROM clients
	WHERE date_dossier_suspendu = '".$_GET['date']."'
	ORDER BY nom, prenom ASC");

for ($i=0;$i<dbnumrows($sql_client);$i++)
{
	// SAUT DE PAGE
	// --> Tous les nb_lignes x nb_colonnes etiquettes
	if ($i%($pdf->nb_lignes*$pdf->nb_colonnes)==0)		$pdf->AddPage($orientation,$id_format_papier);


	$id_client	= dbresult($sql_client,$i,"id_client");
	$prenom		= dbresult($sql_client,$i,"prenom");
	$nom		= dbresult($sql_client,$i,"nom");


	// --------------
	// Les téléphones
	// --------------
	$telephone_fixe		= "";
	$sql_client_telephone_fixe = dbquery("SELECT *
		FROM clients_telephone
		WHERE id_client = '".$id_client."'
			AND type_telephone = 'fixe'
		ORDER BY type_telephone ASC");
	if (dbnumrows($sql_client_telephone_fixe) > 0)
		$telephone_fixe		= dbresult($sql_client_telephone_fixe,0,"telephone");

	$telephone_portable	= "";
	$sql_client_telephone_portable = dbquery("SELECT *
		FROM clients_telephone
		WHERE id_client = '".$id_client."'
			AND type_telephone = 'portable'
		ORDER BY type_telephone ASC");
	if (dbnumrows($sql_client_telephone_portable) > 0)
		$telephone_portable		= dbresult($sql_client_telephone_portable,0,"telephone");

	
	$adresse			= dbresult($sql_client,$i,"adresse");
	$code_postal		= dbresult($sql_client,$i,"code_postal");
	$ville				= dbresult($sql_client,$i,"ville");
	$pays				= dbresult($sql_client,$i,"pays");
	$sexe				= dbresult($sql_client,$i,"sexe");
	$numero_nir			= new NumeroNIR(dbresult($sql_client,$i,"numero_nir"));
	$medecin_traitant	= dbresult($sql_client,$i,"medecin_traitant");

	if ($nom == '')
		$nom	= " ..............";

	if ($prenom == '')
		$prenom	= " ..............";

	if ($telephone_fixe == '')
		$telephone_fixe		= " .......................";
	else
		$telephone_fixe		= numero_telephone($telephone_fixe);

	if ($telephone_portable == '')
		$telephone_portable = " .......................";
	else
		$telephone_portable	= numero_telephone($telephone_portable);

	if ($adresse == '')
		$adresse = ".............................................";

	if ($medecin_traitant == '')
		$medecin_traitant = " ..............................";


	
	/*
	+----------------------------------+----------------------------------+
 	|                                  |                                  |
 	|  AMACOUTY Marie Angele           |  ASENSIO Jacqueline              |
	|                                  |                                  |
	+----------------------------------+----------------------------------+
 	|                                  |                                  |
 	|  BADOURALY Dilavarhoussen        |  BELAIR Paul                     |
	|                                  |                                  |
	+----------------------------------+----------------------------------+
    */
	
	$pdf -> etiquette($i);

	// Civilité, Nom Prénom
	// Adresse
	// Code postal et commune

	$x_encours = $pdf->getX();
	$y_encours = $pdf->getY();

	// Nom et prénom sexe
	$pdf->SetFont('helvetica', '', 14);

	// Nom + prénom
	$pdf -> writeHTMLCell( ($pdf->getPageWidth() - $margin['left'] - $margin['right'])/$pdf->nb_colonnes -5,
		70,
		$x_encours,
		$y_encours,
		"<b>".$nom."</b> ".$prenom,
		$border = 0,
		$ln = 0,
		$fill = false,
		$reseth = true,
		$align = 'L',
		$autopadding = false 
	);


	// Nom et prénom sexe
	$pdf->SetFont('helvetica', '', 12);


	// Gauche
	$pdf -> writeHTMLCell( ($pdf->getPageWidth() - $margin['left'] - $margin['right'])/$pdf->nb_colonnes -5,
		70,
		$x_encours,
		$y_encours+15,
		"Téléphone fixe :<br>
		Téléphone portable :<br><br>
		Numéro NIR :<br><br>
		Médecin traitant : ".$medecin_traitant,
		$border = 0,
		$ln = 0,
		$fill = false,
		$reseth = true,
		$align = 'L',
		$autopadding = false 
	);

	// Droite
	$pdf -> writeHTMLCell( ($pdf->getPageWidth() - $margin['left'] - $margin['right'])/$pdf->nb_colonnes - 20,
		70,
		$x_encours,
		$y_encours+15,
		$telephone_fixe."<br>
		".$telephone_portable."<br><br>
		".$numero_nir->format_espace()."<br><br>",
		$border = 0,
		$ln = 0,
		$fill = false,
		$reseth = true,
		$align = 'R',
		$autopadding = false 
	);
}

// -----------------------------
// Close and output PDF document
// -----------------------------
ob_end_clean();
$pdf->Output('etiquettes_dos.pdf', 'I');