<?php
session_start();

require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/config.global.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/dbconfig.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/lib/lib.main.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/lib/lib.db.inc.php");
libraries(array('PHPExcel'));


$datetime_from	= new DateTime(date_fr_iso($_GET['date_from']));
$datetime_to	= new DateTime(date_fr_iso($_GET['date_to']));



$styleEntete = array(
	'font'=>array(
		'bold'=>true,
		'size'=>12,
		'name'=>Arial,
		'color'=>array(
			'rgb'=>'6666CC'),
		));

$stylePiedDePage = array(
	'font'=>array(
		'bold'=>true,
		'size'=>10,
		'name'=>Arial,
		'color'=>array(
			'rgb'=>'ff0000'),
		));

$styleEnteteGradiant = array(
	'fill' => array(
		'type' => PHPExcel_Style_Fill::FILL_GRADIENT_LINEAR,
		'rotation' => 90,
		'startcolor' => array(
			'argb' => 'FFFFCC00'),
		'endcolor' => array(
			'argb' => 'FFFFFFFF')));

$style1ereLigne = array(
	'fill' => array(
		'type' => PHPExcel_Style_Fill::FILL_GRADIENT_LINEAR,
		'rotation' => 90,
		'startcolor' => array(
			'argb' => 'FF66CCFF'),
		'endcolor' => array(
			'argb' => 'FFFFFFFF')));


$styleSimpleBorder = array(
	'borders' => array(
		'left' => array(
			'style' => PHPExcel_Style_Border::BORDER_THIN,
			'color' => array('argb' => 'FF993300'),
		),
		'right' => array(
			'style' => PHPExcel_Style_Border::BORDER_THIN,
			'color' => array('argb' => 'FF993300'),
		),
		'top' => array(
			'style' => PHPExcel_Style_Border::BORDER_THIN,
			'color' => array('argb' => 'FF993300'),
		),
		'bottom' => array(
			'style' => PHPExcel_Style_Border::BORDER_THIN,
			'color' => array('argb' => 'FF993300'),
		),
	)
);


$styleDoubleBorder = array(
	'borders' => array(
		'left' => array(
			'style' => PHPExcel_Style_Border::BORDER_DOUBLE,
			'color' => array('argb' => 'FF993300'),
		),
		'right' => array(
			'style' => PHPExcel_Style_Border::BORDER_DOUBLE,
			'color' => array('argb' => 'FF993300'),
		),
		'top' => array(
			'style' => PHPExcel_Style_Border::BORDER_DOUBLE,
			'color' => array('argb' => 'FF993300'),
		),
		'bottom' => array(
			'style' => PHPExcel_Style_Border::BORDER_DOUBLE,
			'color' => array('argb' => 'FF993300'),
		),
	)
);




$styleBold = array(
	'font'=>array(
		'bold'=>true));


$styleHCenter = array(
	'alignment' => array(
		'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER)
);

$styleVCenter = array(
	'alignment' => array(
		'vertical'   => PHPExcel_Style_Alignment::VERTICAL_CENTER)
);


$xls_tuteur_ue_without_extension = "comptes_2016";


// Create new PHPExcel object
$objPHPExcel = new PHPExcel();


$sql_year = dbquery("SELECT DISTINCT(YEAR(datetime_debut)) AS year
				FROM agenda
				WHERE   YEAR(datetime_debut) >= '".$datetime_from->format('Y')."'
					AND YEAR(datetime_debut) <= '".$datetime_to->format('Y')."'");

for ($i=0;$i<dbnumrows($sql_year);$i++)
{
	$year = dbresult($sql_year,$i,"year");

	
	if ($i > 0)	$objPHPExcel->createSheet();



	$objPHPExcel->setActiveSheetIndex($i);
	$objPHPExcel->getActiveSheet()->setTitle($year);

	
	// -----------------------------------------------------
	// Range 1 (Entete ligne 1)
	// --> centrage texte
	// --> couleur texte (#6666CC)
	// --> concaténation cellules
	// -----------------------------------------------------
	$range_1 = 'A1:D1';
	$objPHPExcel->getActiveSheet()->getStyle($range_1)->applyFromArray($styleEntete);
	$objPHPExcel->getActiveSheet()->getStyle($range_1)->applyFromArray($styleHCenter);
	$objPHPExcel->getActiveSheet()->getStyle($range_1)->applyFromArray($styleEnteteGradiant);
	$objPHPExcel->getActiveSheet()->mergeCells($range_1);


	// -----------------------------------------------------
	// Range 2 (Entete ligne 2)
	// --> centrage texte
	// --> couleur texte (#6666CC)
	// --> concaténation cellules
	// -----------------------------------------------------
	$range_2 = 'A2:D2';
	$objPHPExcel->getActiveSheet()->getStyle($range_2)->applyFromArray($styleEntete);
	$objPHPExcel->getActiveSheet()->getStyle($range_2)->applyFromArray($styleHCenter);
	$objPHPExcel->getActiveSheet()->mergeCells($range_2);


	// --------------------------
	// Range 3 (Entete ligne 1+2)
	// --> double bordure
	// --------------------------
	$range_3 = 'A1:D2';
	$objPHPExcel->getActiveSheet()->getStyle($range_3)->applyFromArray($styleDoubleBorder);


	// ------------------------
	// Range 4 (1ere ligne)
	// --> dégradé de couleur
	// --> double bordure
	// ------------------------
	$range_4 = 'A5:D5';
	$objPHPExcel->getActiveSheet()->getStyle($range_4)->applyFromArray($styleDoubleBorder);
	$objPHPExcel->getActiveSheet()->getStyle($range_4)->applyFromArray($style1ereLigne);
	$objPHPExcel->getActiveSheet()->getStyle($range_4)->applyFromArray($styleBold);


	// ----------------
	// Largeur colonnes
	// ----------------
	$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(40);
	$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(10);
	$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(10);
	$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(12);



	// -------
	// ENTETES
	// -------
	$previsionnel = $year;
	
	if ($i == 0)
		$previsionnel .= " depuis ".$datetime_from->format('d / m / Y');

	if ($i == dbnumrows($sql_year) - 1)
		$previsionnel .= " jusqu'a ".$datetime_to->format('d / m / Y');

	
	$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(0,1, "Prévisionnel");
	$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(0,2, $previsionnel);




	// ----------
	// 1ere ligne
	// ----------
	$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(0,5, "Type consultation");
	$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(1,5, "Nb");
	$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(2,5, "PU");
	$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(3,5, "Total");


	// -------------------
	// Les comptes du mois
	// -------------------
	$sql_type_rendez_vous = dbquery("SELECT *
		FROM type_rendez_vous");


	$ligne = 6;

	for ($j=0;$j<dbnumrows($sql_type_rendez_vous);$j++)
	{	
		$id_type_rendez_vous	= dbresult($sql_type_rendez_vous,$j,"id_type_rendez_vous");
		$intitule				= dbresult($sql_type_rendez_vous,$j,"intitule");
		$previsionnel			= dbresult($sql_type_rendez_vous,$j,"previsionnel");


		$sql_nb_rendez_vous = dbquery("SELECT COUNT(*) AS nb_rendez_vous
			FROM agenda,clients
			WHERE agenda.id_client = clients.id_client
				AND agenda.id_type_rendez_vous = '".$id_type_rendez_vous."'
				AND datetime_debut >= '".$datetime_from->format('Y-m-d') ."'
				AND datetime_debut <= '".$datetime_to->format('Y-m-d') ."'
				AND YEAR(datetime_debut )= '".$year ."'
				AND clients.deces = '0'");

		$nb_rendez_vous		= dbresult($sql_nb_rendez_vous,0,"nb_rendez_vous");


		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(0,$ligne, $intitule);
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(1,$ligne, $nb_rendez_vous);
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(2,$ligne, $previsionnel);
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(3,$ligne, '=B'.$ligne.'*C'.$ligne);

		$ligne++;
	}

	$to_centre_enseignement = 6 + dbnumrows($sql_type_rendez_vous) - 1;
	$to_centre_enseignement_plus_un = $to_centre_enseignement + 1;


	// Double Bordure body
	$range_body = 'A6:D'.$to_centre_enseignement;
	$objPHPExcel->getActiveSheet()->getStyle($range_body)->applyFromArray($styleDoubleBorder);


	// Pied de Page (TOTAL)
	$range_body = 'A'.$to_centre_enseignement_plus_un.':D'.$to_centre_enseignement_plus_un;
	$objPHPExcel->getActiveSheet()->getStyle($range_body)->applyFromArray($styleDoubleBorder);
	$objPHPExcel->getActiveSheet()->getStyle($range_body)->applyFromArray($stylePiedDePage);


	// TOTAL
	$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(0,$to_centre_enseignement_plus_un, "TOTAL");
	$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(1,$to_centre_enseignement_plus_un, "=SUM(B6:B".$to_centre_enseignement.")");
	$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(3,$to_centre_enseignement_plus_un, "=SUM(D6:D".$to_centre_enseignement.")");

	// SEPARATEUR DE MILLIER
	$objPHPExcel->getActiveSheet()->getStyle('B6:B'.$to_centre_enseignement_plus_un)->getNumberFormat()->setFormatCode('#,##0');

	
	// EUROS
	$objPHPExcel->getActiveSheet()->getStyle('C6:C'.$to_centre_enseignement_plus_un)->getNumberFormat()->setFormatCode('#,##0.00 €');
	$objPHPExcel->getActiveSheet()->getStyle('D6:D'.$to_centre_enseignement_plus_un)->getNumberFormat()->setFormatCode('#,##0 €');
}

// Set active sheet index to the first sheet, so Excel opens this as the first sheet
$objPHPExcel->setActiveSheetIndex(0);



// -------------------
// Format : Excel 2007
// -------------------

header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment;filename="'.$xls_tuteur_ue_without_extension.'.xlsx"');
header('Cache-Control: max-age=0');

$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
$objWriter->save('php://output');