<?php
// ================================
// FORMULAIRE D'AJOUT D'UN PLANNING
// ================================

require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/dbconfig.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/lib/lib.db.inc.php");
?>

<!-- jQuery UI DatePicker français -->
<script type="text/javascript" src="https://www.pneumo.re/lib/jqueryui/jquery.ui.datepicker-fr.js"></script>


<script> 
$(function() {
	$.datepicker.setDefaults( $.datepicker.regional[ "fr" ] );
	$( "#date_debut" ).datepicker();
	$( "#date_fin" ).datepicker();


	$("#form_add").validate({    
		rules: {
			id_personnel: {
				required: true,
			},
			nom_conge: {
				required: true,
			},
			date_debut: {
				required: true,
				minlength: 2
			},
			date_fin: {
				required: true,
				minlength: 2
			},
		},
		messages: {
			id_personnel: {
				required: "Précisez un personnel !",
			},
			nom_conge: {
				required: "Donnez un nom au congé",
			},
			date_debut: {
				required: "vide !",
				minlength: "..."
			},
			date_fin: {
				required: "vide !",
				minlength: "..."
			}
		}
	});

	// -------------------------------
	// Permet de valider le formulaire
	// avant de l'envoyer
	// -------------------------------
	$("#form_add").submit(function()
	{
		$.ajax({
			type:		"POST",
			url:		"classique/add.php",
			data:		$(this).serialize(),
			beforeSend:	function(){
				$('#submit').html("Ajouter cette fiche <div class='spinner-border spinner-border-sm' role='status'></div>");
			},
			complete:	function(){	
			},
			success:	function(response){
				if (response == "ok")
					$('#submit').html("Ajouter cette fiche <i style='color:green' class='fa fa-check' aria-hidden='true'></i>");
			}
		 });

		return false;
	});

	$("table").tablesorter({
		theme : "bootstrap",
		widthFixed: true,
		widgets : [ "uitheme", "zebra" ],
		widgetOptions : {
		}
	})

});
//-->
</script>

<?php
$sql_personnel = dbquery("SELECT *
	FROM personnel
	ORDER BY id_personnel ASC");
?>


<form id="form_add">
	<div class="title">Ajouter un congé</div>
	<table border cellpadding='5' style='width:350px'>
	<thead>
	</thead>
	<tbody>
	<tr>
		<td style='text-align:right;width:150px'>Personnel :</td>
		<td style='text-align:left' colspan="2">
			<select class='form-control' id='id_personnel' name='id_personnel'>
				<option value=''></option>
				<?php
				for ($i=0;$i<dbnumrows($sql_personnel);$i++)
				{
					$id_personnel		= dbresult($sql_personnel,$i,"id_personnel");
					$nom			= strtoupper(dbresult($sql_personnel,$i,"nom"));
					$prenom			= dbresult($sql_personnel,$i,"prenom");

					echo "<option value='".$id_personnel."'>".$nom." ".$prenom."</option>";
				}
				?>
			</select>
		</td>
	</tr>
	<tr>
		<td style='text-align:right'>Nom du congé :</td>
		<td style='text-align:left' colspan="2"><input class='form-control' id='nom_conge' name='nom_conge' type='text' style='width:340px' value=""></td>
	</tr>
	<tr>
		<td style='text-align:right'>Date début :</td>
		<td style='text-align:left'>
			<input class='form-control' id='date_debut' name='date_debut' type='text' style='width:110px' value="">
		</td>
		<td>
			<input class='form-control' id='time_debut' name='time_debut' type="time" style='width:100px' value="00:00">
		</td>
	</tr>
	<tr>
		<td style='text-align:right'>Date fin :</td>
		<td style='text-align:left'>
			<input class='form-control' id='date_fin' name='date_fin' type='text' style='width:110px' value="">
		</td>
		<td>
			<input class='form-control' id='time_fin' name='time_fin' type="time" style='width:100px' value="23:59">
		</td>
	</tr>
	<tr>
		<td align='right' colspan="3"><center><button type="submit" id="submit" class="btn btn-primary">Ajouter cette fiche</button></center></b></td>
	</tr>
	</tbody>
	</table>
</form>