<?php
// =============
// DOCUMENTATION
// --> pdf
// =============

session_start();

require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/config.global.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/dbconfig.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/lib/lib.main.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/lib/lib.db.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/lib/lib.files.inc.php");
libraries(array('TCPDF'));


if (!isset($_SESSION['id_personnel']))
{
	header("Location:/cabinet/authentification/login_form.php?message=Fin de session. Veuillez vous reconnecter.");
	exit;
}

// A4 portrait
// (0,0)               (210,0)
//   +-------------------+
//   |         |         |
//   +---------+---------+
//   |         |         |
//   +---------+---------+
//   |         |         |
//   +---------+---------+
//   |         |         |
//   +---------+---------+
//   |         |         |
//   +-------------------+
// (0,297)             (210,297)


// extend TCPF with custom functions
// Extend the TCPDF class to create custom Header and Footer
class MYPDF extends TCPDF
{
	/**
	* @buggy svg handler in 6.2.
	*
	* @param        $file
	* @param string $x
	* @param string $y
	* @param int    $w
	* @param int    $h
	* @param string $link
	* @param string $align
	* @param string $palign
	* @param int    $border
	* @param bool   $fitonpage
	*
	* @return \image|void
	*/
	public function ImageSVG($file, $x = '', $y = '', $w = 0, $h = 0, $link = '', $align = '', $palign = '', $border = 0, $fitonpage = false)
	{
		if (is_file($file) && is_readable($file))
		{
			$file = '@' . file_get_contents($file);
		}

		return parent::ImageSVG($file, $x, $y, $w, $h, $link, $align, $palign, $border, $fitonpage);
	}

	// Page footer
	public function Footer() {
		// Position at 15 mm from bottom
		$this->SetY(-15);
		// Set font
		$this->SetFont('helvetica', 'I', 8);
		// Page number
		$this->Cell(0, 10, $this->getPageNumGroupAlias().'/'.$this->getPageGroupAlias(), 0, false, 'C', 0, '', 0, false, 'T', 'M');
	}
}







// create new PDF document
$pdf = new MYPDF('portrait', 'mm', 'A4', true ,'utf-8' , false);


// set document information
$pdf->SetCreator(PDF_CREATOR);
$pdf->SetAuthor('Cabinet');
$pdf->SetTitle('Documentation');
$pdf->SetSubject('Documentation');
$pdf->SetKeywords('Documentation');


//set image scale factor
$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

// ---------------------------------------------------------

// set font
$pdf->SetFont('helvetica');

$pdf->SetAutoPageBreak(true,20);
$pdf->setPrintHeader(false);
$pdf->setPrintFooter(false);

// Marges
$pdf->SetMargins(20,20,20,20);


$pdf->SetTextColor(0,0,0);


// ======
// Pages
// ======

// =============
// Page de garde
// =============
$pdf->startPageGroup();
$pdf -> addPage('portrait', 'A4');

$tab_line = array();


$x_from_1 = ($pdf->getPageWidth() - 66)/2;
$x_from_2 = $x_from_1+1.5;
$x_from_3 = $x_from_1+3;
$x_from_4 = $x_from_1+4.5;


$x_to_1 = $pdf->getPageWidth() - ($pdf->getPageWidth() - 66)/2;
$x_to_2 = $x_to_1 - 1.5;
$x_to_3 = $x_to_1 - 3;
$x_to_4 = $x_to_1 - 4.5;



$y_from_1 = 30;
$y_from_2 = $y_from_1+1.5;
$y_from_3 = $y_from_1+3;
$y_from_4 = $y_from_1+4.5;


$y_to_1 = 50;
$y_to_2 = $y_to_1 - 1.5;
$y_to_3 = $y_to_1 - 3;
$y_to_4 = $y_to_1 - 4.5;




$pdf->PolyGon(array(	
		// HORIZONTAL haut
		$x_from_1, $y_from_1,
		$x_from_2, $y_from_1,
		$x_from_2, $y_from_4,
		$x_from_3, $y_from_4,
		$x_from_3, $y_from_1,
		$x_to_3,   $y_from_1,
		$x_to_3,   $y_from_4,
		$x_to_2,   $y_from_4,
		$x_to_2,   $y_from_1,
		$x_to_1,   $y_from_1,
		
		// VERTICAL droite
		$x_to_1, $y_from_2,
		$x_to_4, $y_from_2,
		$x_to_4, $y_from_3,
		$x_to_1, $y_from_3,
		$x_to_1, $y_to_3,
		$x_to_4, $y_to_3,
		$x_to_4, $y_to_2,
		$x_to_1, $y_to_2,
		
		// HORIZONTAL bas
		$x_to_1,   $y_to_1,
		$x_to_2,   $y_to_1,
		$x_to_2,   $y_to_4,
		$x_to_3,   $y_to_4,
		$x_to_3,   $y_to_1,
		$x_from_3, $y_to_1,
		$x_from_3, $y_to_4,
		$x_from_2, $y_to_4,
		$x_from_2, $y_to_1,
		$x_from_1, $y_to_1,

		// VERTICAL gauche
		$x_from_1, $y_to_1,
		$x_from_1, $y_to_2,
		$x_from_4, $y_to_2,
		$x_from_4, $y_to_3,
		$x_from_1, $y_to_3,
		$x_from_1, $y_from_3,
		$x_from_4, $y_from_3,
		$x_from_4, $y_from_2,
		$x_from_1, $y_from_2
	));

$pdf->SetFont('helvetica', 'B', 14);
$pdf->setXY(0,40);
$pdf->Cell($pdf->getPageWidth(),0, "Documentation", 0 , $ln=0,'C', $fill=false,'', $stretch=0, false, 'C','C');




// ==================
// TABLE DES MATIERES
// -> Pages vides
// ==================

$nb_pages_table_matiere = ceil(count($_GET['id_documentation']))/25;

$nb_pages_table_matiere_ = 1;
for($i=0;$i<$nb_pages_table_matiere;$i++)
{
	$pdf -> addPage('portrait', 'A4');
	$nb_pages_table_matiere_++;
}

// ========
// ARTICLES
// ========
$pdf->startPageGroup();


$table_matiere = array();

$numero_figure = 1;

$bool_add_page = true;

$key = 0;
foreach($_GET['id_documentation'] as $id_documentation)
{
	$sql_documentation = dbquery("SELECT *
		FROM documentation,personnel
		WHERE documentation.id_personnel_update = personnel.id_personnel
			AND documentation.id_documentation='".$id_documentation."'
		ORDER BY documentation.id_documentation ASC");

	if (dbnumrows($sql_documentation) > 0)
	{
		$datetime_update	= new DateTime(dbresult($sql_documentation,0,"datetime_update"));
		$niveau				= dbresult($sql_documentation,0,"niveau");
		$titre				= dbresult($sql_documentation,0,"titre");
		$html				= dbresult($sql_documentation,0,"html");		
		$orientation		= dbresult($sql_documentation,0,"orientation");		

		$nom_personnel		= dbresult($sql_documentation,0,"personnel.nom");
		$prenom_personnel	= dbresult($sql_documentation,0,"personnel.prenom");


		$sql_documentation_file = dbquery("SELECT nom,file,border,width_percent
			FROM documentation_files
			WHERE id_documentation='".$id_documentation."'");


		if ($bool_add_page)
		{
			$pdf -> addPage($orientation, 'A4');
			$pdf -> setPrintFooter(true);
		}
		

		if (strlen($html) == 0 && dbnumrows($sql_documentation_file) == 0)
			$bool_add_page = false;
		else
			$bool_add_page = true;


		// Numero de la page
		$numero_page_article = $pdf->PageNo() - $nb_pages_table_matiere_;
		
		$table_matiere[$key]['niveau']	= $niveau;
		$table_matiere[$key]['titre']	= $titre;
		$table_matiere[$key]['page']	= $numero_page_article;



		// Niveau + titre
		$pdf -> SetFont('Helvetica','B',11);
		$pdf -> MultiCell(200,12, $niveau.' : '.$titre, $border='', 'L', $fill=false,$ln=0, 20,$pdf->getY());

		// Modifié par xxx le xxx
		$mention = "";
		if (!(strlen($html) == 0 && dbnumrows($sql_documentation_file) == 0))
			$mention = "Modifié par ".$prenom_personnel." ".$nom_personnel."\nle ".$datetime_update->format('d / m / Y H:i');

		$pdf -> SetFont('Helvetica','',9);
		$pdf -> MultiCell($pdf->getPageWidth()-40,12, $mention, $border='', 'R', $fill=false,$ln=1, 20,$pdf->getY());



		// HTML
		if (strlen($html) > 0)
		{
			$pdf -> SetFont('Helvetica','',11);
			$pdf -> SetY($pdf->getY());
			$pdf -> writeHTML($html,$ln = true,$fill = false,$reseth = true,$cell = false,$align = 'L');
		}


		for ($j=0;$j<dbnumrows($sql_documentation_file);$j++)
		{
			$nom			= dbresult($sql_documentation_file,$j,"nom");
			$file			= dbresult($sql_documentation_file,$j,"file");
			$width_percent	= dbresult($sql_documentation_file,$j,"width_percent");
			$border_image	= dbresult($sql_documentation_file,$j,"border");		

			// File  disponible ?
			if ($file <> "" && is_file("files/".$file))
			{
				// PNG
				if (extension($file) == "png")
				{
					$image = imagesize("files/".$file);
					

					$png_height_mm = $image['height']/$image['width'] * ($pdf->getPageWidth()-40)*$width_percent/100;
				
					// Image PNG
					$pdf->Image("files/".$file, 0,$pdf->getY(), ($pdf->getPageWidth()-40)*$width_percent/100,0 , 'PNG', '', '', true, 300, 'C', false, false, $border_image, false, false, false);


					// Legende
					$pdf -> SetXY(0,$pdf->getY()+$png_height_mm+5);
					$pdf -> writeHTML("<u>Figure ".$numero_figure++."</u> : ".$nom,$ln = true,$fill = false,$reseth = true,$cell = false,$align = 'C');
				}
				
				// SVG
				if (extension($file) == "svg")
				{
					$image = imagesize("files/".$file);
					
					$svg_height_mm = $image['height']/$image['width'] * ($pdf->getPageWidth()-40)*$width_percent/100;
					
					// Image SVG
					$pdf->ImageSVG("files/".$file, 20,$pdf->getY(), $w=($pdf->getPageWidth()-40)*$width_percent/100, $h='', $link='', $align='', $palign='C', $border=0, $fitonpage=false);

					// Legende
					$pdf -> SetXY(0,$pdf->getY()+$svg_height_mm+5);
					$pdf -> writeHTML("<u>Figure ".$numero_figure++."</u> : ".$nom,$ln = true,$fill = false,$reseth = true,$cell = false,$align = 'C');
				}
			}
			else
				$pdf -> writeHTML('Fichier <b>'.$file."</b> non disponible",$ln = true,$fill = false,$reseth = true,$cell = false,$align = 'L');
			
			
			$pdf->setY($pdf->getY()+10);
		}
	}

	$key++;
}



// ==================
// TABLE DES MATIERES
// ==================
$pdf->setPrintFooter(true);

$pdf -> setPage(2);

$pdf->SetFont('helvetica', 'B', 12);
$pdf->setXY(20,20);
$pdf->Cell($pdf->getPageWidth(),0, "Table des matières", 0 , $ln=1,'L', $fill=false,'', $stretch=0, false, 'C','C');

$pdf->setXY(20,30);
foreach ($table_matiere as $key => $value)
{
	$pdf -> setPage(2+floor($key/25));

	if (substr_count($table_matiere[$key]['niveau'], '.') > 0)
		$pdf->SetFont('helvetica', '', 12);
	else
		$pdf->SetFont('helvetica', 'B', 12);

	$espace = "";
	for ($i=0;$i<substr_count($table_matiere[$key]['niveau'], '.');$i++)
		$espace .= "  ";

	$ligne = $espace.$table_matiere[$key]['niveau']." ".$table_matiere[$key]['titre'];
	$ligne_sans_espace = $table_matiere[$key]['niveau']." ".$table_matiere[$key]['titre'];

	$nb_caractere = 134-strlen($ligne_sans_espace)*1.6+strlen($espace)*1.6;
	
	$pdf->setY(30+($key%25)*10);
	$pdf->Cell($pdf->getPageWidth()-50,0, $ligne, 0 , $ln=0,'L', $fill=false,'', $stretch=0, false, 'C','C');
	$pdf->Cell(10,0, str_pad(" ".$table_matiere[$key]['page'], $nb_caractere, ".", STR_PAD_LEFT), 0 , $ln=1,'R', $fill=false,'', $stretch=0, false, 'C','C');
}


// -----------------------------
// Close and output PDF document
// -----------------------------
ob_end_clean();
$pdf->Output('documentation.pdf', 'I');