<?php
// =============
// Consultations
// =============

require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/config.global.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/dbconfig.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/lib/lib.main.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/lib/lib.db.inc.php");
?>

<script type="text/javascript"> 
$(document).ready(function()
{		
	$('[data-fancybox]').fancybox({
		afterClose : function() {
			$("#ajax").load('index_ajax.php?<?php echo $_SERVER['QUERY_STRING'] ?>');
		}
	});

	// ----------------------
	// Initialize tablesorter
	// ----------------------
	$("table").tablesorter({
		headers : { 0 : { sorter: false } },
		theme : "bootstrap",
		widthFixed: true,
	    headerTemplate : '{content} {icon}', // new in v2.7. Needed to add the bootstrap icon!
		widgets : [ "uitheme", "zebra" ],
		widgetOptions : {
		}
	})


	// ---------------
	// Change pagesize 
	// ---------------
	$( ".pagesize" ).change(function() {
		$.ajax({
			type: "GET",
			url: "change_pagesize.php",
			data: "pagesize="+this.value,
			success: function(msg){
			}
		});
	});

});	
</script> 

<?php
$where_client = "0=1";

// Letter
if (isset($_GET['letter']))
{
	if ($_GET['letter'] == "vide")
		$where_client = "nom = ''";
	else
		$where_client = "nom LIKE '".$_GET['letter']."%'";
}
// Cherche
else if (isset($_GET['cherche']))
{
	$tab_cherche = explode(' ',$_GET['cherche']);
	
	$where_client = "(1=1 ";
	foreach ($tab_cherche as $term)
	{
		$where_client .= "AND (prenom LIKE '%".addslashes($term)."%' OR nom LIKE '%".addslashes($term)."%')";
	}
	$where_client .= ")";
}


// Date de naissance
if (isset($_GET['date_naissance']) && $_GET['date_naissance'] <> '')
{
	$where_client .= "  AND clients.date_naissance =  '".$_GET['date_naissance']."'";
}

// NIR
if (isset($_GET['numero_nir']) && $_GET['numero_nir'] <> '')
{
	$where_client .= "  AND clients.numero_nir =  '".$_GET['numero_nir']."'";
}

// Medecin traitant
if (isset($_GET['medecin_traitant']) && $_GET['medecin_traitant'] <> '')
{
	$where_client .= "  AND clients.medecin_traitant LIKE '%".$_GET['medecin_traitant']."%'";
}


// Mutuelle
if (isset($_GET['mutuelle']) && $_GET['mutuelle'] <> '')
{
	$where_client .= "  AND clients.mutuelle LIKE '%".$_GET['mutuelle']."%'";
}


$avec_facture = "1=1";

if ($_GET['avec_facture'] == 1)
	$avec_facture = "id_client IN (
		SELECT id_client
		FROM agenda_ccam,agenda
		WHERE agenda.id_agenda = agenda_ccam.id_agenda
	)";



$sql_client = dbquery("SELECT * FROM clients
	WHERE ".$where_client."
		AND ".$avec_facture."
	ORDER BY nom ASC, prenom ASC
	LIMIT 0,100");


if (dbnumrows($sql_client)>0)
{
	?>
	
	<!-- Réponses -->
	<div style="position:absolute; top: 0px; left: 10px; color:green;width:400px"><b><?php echo dbnumrows($sql_client)?></b> réponse<?php if (dbnumrows($sql_client)>1) echo "s"?></div>
	
	<table id="table_client" class="tablesorter" style='position:absolute; top: 40px; left: 10px;width:700px'> 
	<thead> 
	<tr>
		<th></th>
		<th>Nom</th>
		<th>Prénom</th>
		<th>NIR</th>
		<th>Agenda</th>
		<th>Courrier</th>
		<th>Ordonnance</th>
	</tr>
	</thead>
	<tbody>

	<?php
	for ($i=0;$i<dbnumrows($sql_client);$i++)
	{
		$id_client	= dbresult($sql_client,$i,"id_client");
		$nom		= strtoupper(dbresult($sql_client,$i,"nom"));
		$prenom		= dbresult($sql_client,$i,"prenom");
		$numero_nir	= dbresult($sql_client,$i,"numero_nir");

		echo "<tr id='".$i."'><td style='text-align:center'><a href='/cabinet/consultations/gestion_clients/index.php?id_client=".$id_client."'><i style='color:orange' class='bi bi-pencil-fill fa-lg'></i></a></td>";
		echo "<td>".$nom."</td>";
		echo "<td>".$prenom."</td>";
		echo "<td>".substr($numero_nir,0,13)." ".substr($numero_nir,-2)."</td>";
		
		

		// ======
		// AGENDA
		// ======

		echo "<td>";

		echo "<table style='border:0px'>";
		
	
		$sql_agenda = dbquery("SELECT *
			FROM agenda,type_rendez_vous
			WHERE agenda.id_type_rendez_vous = type_rendez_vous.id_type_rendez_vous
				AND agenda.id_client='".$id_client."'
			ORDER BY agenda.datetime_debut ASC");
		
		for ($j=0;$j<dbnumrows($sql_agenda);$j++)
		{
			$id_agenda				= dbresult($sql_agenda,$j,"agenda.id_agenda");
			$datetime_debut			= new datetime(dbresult($sql_agenda,$j,"agenda.datetime_debut"));
			$datetime_fin			= new datetime(dbresult($sql_agenda,$j,"agenda.datetime_fin"));
			$type_rendez_vous		= dbresult($sql_agenda,$j,"type_rendez_vous.intitule");
			$background_color		= dbresult($sql_agenda,$j,"type_rendez_vous.background_color");

			echo "<tr>";
			echo "<td style='width:70px'>".$datetime_debut->format('d/m/Y')."</td>";
			echo "<td style='background-color:#".$background_color."'><a data-fancybox data-type='ajax' href='/cabinet/agenda/update_form.php?id_agenda=".$id_agenda."'>".$type_rendez_vous."</a></td>";
			
			$sql_agenda_ccam = dbquery("SELECT *
				FROM agenda_ccam
				WHERE id_agenda='".$id_agenda."'
				ORDER BY code_ccam ASC");

			if (dbnumrows($sql_agenda_ccam) > 0)
			{
				echo "<td style='background-color:#".$background_color.";text-align:center'><a href='/cabinet/consultations/etats/pdf_facture.php?id_agenda=".$id_agenda."' target='_new'><i style='color:red;background-color:white' class='fa fa-file-pdf-o fa-3x'></i></a><br><span style='color:grey;font-weight:bold'>Facture</span></td>";
				echo "<td style='background-color:#".$background_color.";text-align:center'><a href='/cabinet/consultations/etats/pdf_feuille_soin_medecin.php?id_agenda=".$id_agenda."' target='_new'><i style='color:red;background-color:white' class='fa fa-file-pdf-o fa-3x'></i></a><br><span style='color:grey;font-weight:bold'>FSP</span></td>";
				
				echo "<td  style='font-size:8pt;color:grey;font-weight:bold'>";
				for ($k=0;$k<dbnumrows($sql_agenda_ccam);$k++)
				{
					echo dbresult($sql_agenda_ccam,$k,"code_ccam")."<br>";
				}
				echo "</td>";
			}
			echo "</tr>";

			if ($type_rendez_vous == "EFR")
			{
				// Ecart entre aujourd'hui et EFR + param('delai_mois_entre_2_efr') mois
				$datetime_now = new datetime(dbresult($sql_agenda,$j,"datetime_debut"));
				$datetime_debut_4_mois	= clone $datetime_debut;
				$datetime_debut_4_mois->modify('-'.param('delai_mois_entre_2_efr').' month');

				$sql_agenda_date = dbquery("SELECT * FROM agenda,type_rendez_vous
					WHERE agenda.id_type_rendez_vous = type_rendez_vous.id_type_rendez_vous
						AND type_rendez_vous.intitule='EFR'
						AND agenda.id_agenda <> '".$id_agenda."'
						AND agenda.id_client = '".$id_client."'
						AND DATE(datetime_debut) > '".$datetime_debut_4_mois->format('Y-m-d')."'
						AND DATE(datetime_debut) <= '".$datetime_debut->format('Y-m-d')."'");
			
				if (dbnumrows($sql_agenda_date) > 0)	echo "<tr><td></td><td colspan='4'><img src='/images/icones/32px/failed.png' width='16' height='16' border='0' alt=''> <span style='color:red'>Trop d'EFR.</span> Délai : ".param('delai_mois_entre_2_efr')." mois</td></tr>";
			}
		}
		echo "</table>";
		echo "</td>";



		// ========
		// COURRIER
		// ========

		echo "<td><table style='border:0px'>";
		$sql_courrier = dbquery("SELECT *
			FROM clients,courrier_client
			WHERE clients.id_client = courrier_client.id_client
				AND clients.id_client='".$id_client."'
			ORDER BY courrier_client.date ASC");
		
	
		for ($j=0;$j<dbnumrows($sql_courrier);$j++)
		{
			$id_courrier		= dbresult($sql_courrier,$j,"courrier_client.id_courrier");
			$date				= new datetime(dbresult($sql_courrier,$j,"courrier_client.date"));

			echo "<tr><td style='background-color:#9CC773;text-align:center'><span style='color:#330066'>".$date->format('d/m/Y')."</span><br><a href='../pdf/pdf.php?courrier[".$id_courrier."]=1' target='_new'><i style='background-color:white;color:red' class='fa fa-file-pdf-o fa-3x'></i></a><br><span style='color:grey;font-weight:bold'>Lettre au<br>medecin</span></td>";
			echo "</tr>";
		}
		echo "</table>";
		echo "</td>";
	

		// ==========
		// ORDONNANCE
		// ==========

		echo "<td><table style='border:0px'>";
		
		$sql_ordonnance = dbquery("SELECT *
			FROM clients,ordonnances
			WHERE clients.id_client = ordonnances.id_client
				AND clients.id_client='".$id_client."'
			ORDER BY ordonnances.date ASC");
		
		for ($j=0;$j<dbnumrows($sql_ordonnance);$j++)
		{
			$id_ordonnance		= dbresult($sql_ordonnance,$j,"ordonnances.id_ordonnance");
			$date				= new datetime(dbresult($sql_ordonnance,$j,"ordonnances.date"));
			$type_ordonnance	= "en cours";

			echo "<tr><td style='background-color:#ffff99;text-align:center'><span style='color:#330066'>".$date->format('d/m/Y')."</span><br><a href='/cabinet/pdf/pdf.php?ordonnance[".$id_ordonnance."]=1' target='_new'><i style='color:red;background-color:white' class='fa fa-file-pdf-o fa-3x'></i></a><br><span style='color:grey;font-weight:bold'>Ordonnance ".$type_ordonnance."</span></td>";
			echo "</tr>";
		}
		echo "</table>";
		echo "</td></tr>";


	}
	?>
	</tbody>
	<tfoot>
	<tr>
		<th></th>
		<th>Nom</th>
		<th>Prénom</th>
		<th>NIR</th>
		<th>Agenda</th>
		<th>Courrier</th>
		<th>Ordonnance</th>
	</tr>
	<tr>
		<th colspan="7" class="ts-pager form-horizontal">
			<button type="button" class="btn first"><i class="icon-step-backward glyphicon glyphicon-step-backward"></i></button>
			<button type="button" class="btn prev"><i class="icon-arrow-left glyphicon glyphicon-backward"></i></button>
			<span class="pagedisplay"></span> <!-- this can be any element, including an input -->
			<button type="button" class="btn next"><i class="icon-arrow-right glyphicon glyphicon-forward"></i></button>
			<button type="button" class="btn last"><i class="icon-step-forward glyphicon glyphicon-step-forward"></i></button>
			<select class="pagesize input-mini" title="Select page size">
				<option selected="selected" value="10">10</option>
				<option value="20">20</option>
				<option value="30">30</option>
				<option value="40">40</option>
			</select>
			<select class="pagenum input-mini" title="Select page number"></select>
		</th>
	</tr>
	</tfoot>
	</table>

	<?php
}
else
{
	echo "<div style='left: 10px; color:green'><b>Aucun résultat</b> trouvé ...</div>";
}



// Footer
require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/footer.inc.php");
?>