<?php
/**
 * Copy $src to $dest, renaming it if the desired destination already exists.  The
 * string '.versionX' is inserted before the file extension if a file must be
 * renamed, with X incremented as needed.
 *
 * @return boolean true if copy was successful, false otherwise.
 */
function copy_with_rename($src, $dest)
{
	if (file_exists($dest))
	{		
		// See if it's the same.
		$existing_file_hash	= sha1_file($dest);
		$new_file_hash		= sha1_file($src);
		
		if ($existing_file_hash != $new_file_hash)
		{		
			// File of same name exists, but is different.
			$last_dot_pos = strrpos($dest,'.');
			$file_count = 2;
			// So find a new name.
			do
			{		
				$base_name	= substr($dest, 0, $last_dot_pos);
				$ext		= substr($dest, strlen($base_name)); // with dot
				$new_name = $base_name.'_version_'.$file_count.$ext;
				$file_count++;
			}
			while (file_exists($new_name) && sha1_file($src)!=sha1_file($new_name));
			// And then try the copy again, with the new name.
			return copy_with_rename($src, $new_name);
		}
		else
		{
			die('Le fichier a déjà été uploadé. SHA1 = '.$existing_file_hash);
			return true;
		}
	}
	else
	{		
		$dest_dir = dirname($dest);
		// Create (to any depth) the destination directory, if required.
		if (!file_exists($dest_dir))
		{
			mkdir($dest_dir, 0777, true);
		}

		dbquery("INSERT INTO documents_scan (id_client,nom,fichier)
				VALUES ('".$_POST['id_client']."',
						'Document médical',
						'".addslashes(basename($dest))."')");
		
		// And finally do the actual copy.
		return copy($src, $dest);
	}
}

function extension($file)
{
	$path_parts = pathinfo($file);
	return $path_parts['extension'];
}


if (extension($_FILES['document_scan_file']['name']) == "zip")
{
	require($_SERVER['DOCUMENT_ROOT']."/cabinet/lib/lib.main.inc.php");

	$repertoire_destination = "../../../documents_scan/tmp/";
	
	$file_name = wd_remove_accents(str_replace(" ","_",$_FILES['document_scan_file']['name']));

	
	// Copie du fichier ZIP vers le repertoire temporaire
	copy($_FILES['document_scan_file']['tmp_name'], $repertoire_destination.$file_name);

	
	Header('Location:upload_zip_form.php?id_client='.$_POST['id_client'].'&filename='.urlencode($repertoire_destination.$file_name));
	exit;
}


require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/config.global.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/dbconfig.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/lib/lib.main.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/lib/lib.db.inc.php");


$sql_client = dbquery("SELECT *
	FROM clients
	WHERE id_client = '".$_POST['id_client']."'");

if (dbnumrows($sql_client) == 0)
	die("Client inexistant");
{
	$nom	=  dbresult($sql_client,0,"nom");
	$prenom	=  dbresult($sql_client,0,"prenom");

	
	// UPLOAD du fichier
	if ($_FILES['document_scan_file']['type'] <> '')
	{
		$repertoire_destination = "../../../documents_scan/";
		
		$file_name = wd_remove_accents(str_replace(" ","_",$nom."_".$prenom."_".$_FILES['document_scan_file']['name']));


		$sql_document_scan = dbquery("SELECT *
			FROM documents_scan
			WHERE id_client = '".$_POST['id_client']."'
				AND fichier = '".$file_name."'");
		
		// ==> Renommer si possible (sauf si SHA1 identique)
		copy_with_rename($_FILES['document_scan_file']['tmp_name'], $repertoire_destination.$file_name);
		
		Header('Location:/cabinet/consultations/gestion_clients/index.php?id_client='.$_POST['id_client']);
	}
	else
		echo "Erreur d'upload du fichier";
}