<?php
// =============
// Recup fichier
// --> Form
// =============

require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/header_fancybox.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/lib/lib.files.inc.php");


// Formatage d'une date
function dd($date)
{
	return date("d/m/Y H:i",$date);
}
?>

<script type="text/javascript"> 
$(document).ready(function()
{
	$("table").tablesorter({
		theme : "bootstrap",
		widthFixed: true,
		widgets : [ "uitheme", "zebra" ],
		widgetOptions : {
		}
	})

	// --------------------------------------
	// Selectionne ou deselectionne une ligne
	// --------------------------------------
	$("tr").click(function()				
	{
		$(this).toggleClass("choix");
	
		var value = $(this).attr('id');		

		if ($(this).hasClass("choix"))
		{
			// Coche
			document.getElementsByName("files["+value+"]")[0].checked = true;
			$("#recup_fichier_ftp").show();
		}
		else
		{
			// Décoche
			document.getElementsByName("files["+value+"]")[0].checked = false;
		}
	});


	// ---------------------
	// Coche ou décoche tout
	// ---------------------
	$("#check_uncheck_all").click(function()				
	{
		if (this.checked)	$("#recup_fichier_ftp").show();
		else	$("#recup_fichier_ftp").hide();
		
		var checked_status = this.checked;
		$("input.checkbox").each(function()
		{
			this.checked = checked_status;
		});


		$("tr").each(function()
		{
			if (checked_status == true)	$(this).addClass("choix");
			else $(this).removeClass("choix");
		});

	});


});
</script>

<div class='title'>Document scanné : Récupération de fichiers à partir du scan2FTP</div>

<div>Pour mettre des fichiers sur le serveur FTP :
	
	<table style='width:300px'>
	<thead>
	</thead>
	<tbody>	
	<tr>
		<th>Host</th>
		<td>ftp.pneumo.re</td>
	</tr>
	<tr>
		<th>Port</th>
		<td>21</td>
	</tr>
	<tr>
		<th>User</th>
		<td>pneumo</td>
	</tr>
	<tr>
		<th>Password</th>
		<td>Cours2math</td>
	</tr>
	<tr>
		<th>Repertoire</th>
		<td>/www/cabinet/documents_scan/automatic_storage</td>
	</tr>
	</tbody>
	</table>

</div>

<form id='form1' name='form1' method='post'  enctype="multipart/form-data" action='recup_fichiers.php'>
	<input type="hidden" name="id_client"		value="<?php echo $_GET['id_client'] ?>">
	<input type="hidden" name="ss_repertoire"	value="automatic_storage">
	
	<table>
	<thead>
	<tr>
		<th><input type='checkbox' name='check_uncheck_all' id='check_uncheck_all'></th>
		<th></th>
		<th>Fichier</th>	
		<th>Date</th>	
		<th>Taille</th>	
	</tr>
	</thead>
	<tbody>

	<?php
	$rep_base = "../../../documents_scan/automatic_storage/";

	// Verifie si le repertoire existe
	if (is_dir($rep_base))
		$dir = opendir($rep_base);
	else
		die("Attention: le repertoire specifié n'existe pas");

	$i = 0;
	while ($f = readdir($dir))
	{
		// Fichier
		if(is_file($rep_base.$f) && $f <> "desktop.ini")
		{
			echo "<tr id='".$i."'><td><input class='checkbox' type='checkbox' name='files[".$i++."]' value='".urlencode($f)."'></td>";
			
			$icon = "<i style='background-color:white;color:red' class='fa fa-file-o fa-3x'></i>";
			if (extension($f) == "pdf")	$icon = "<i style='background-color:white;color:red' class='fa fa-file-pdf-o fa-2x'></i>";
			if (extension($f) == "doc" || extension($f) == "docx")	$icon = "<i style='background-color:white;color:blue' class='fa fa-file-word-o fa-2x'></i>";
			if (extension($f) == "xls" || extension($f) == "xlsx")	$icon = "<i style='background-color:white;color:green' class='bi bi-file-earmark-excel-fill fa-2x'></i>";

			echo "<td>".$icon."</td>";
			echo "<td><a href='/cabinet/documents_scan/automatic_storage/".urlencode($f)."'>".$f."</a></td>";
			echo "<td>".dd(filemtime($rep_base.$f))."</td>";
			echo "<td style='text-align:right'>".formatBytes(filesize($rep_base.$f))."</td></tr>";
		}
	}
	?>
	</tbody>
	<tfoot>
	<tr>
		<td colspan='5' style='text-align:center'><button style='display:none' id="recup_fichier_ftp" class="btn btn-primary" type="submit">Recupération de ces fichiers</button></td>
	</tr>
	</tfoot>
	</table>

</form>

<?php
// Footer
require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/footer.inc.php");
?>