<?php
// ===============
// Compte bancaire
// --> Ajout
// ===============

session_start();

require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/config.global.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/dbconfig.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/lib/lib.main.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/lib/lib.db.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/lib/lib.files.inc.php");



// Formatage d'une date
function dd($date)
{
	return date("d/m/Y H:i",$date);
}


function tab_file($id_document_scan)
{
	$rep_base = "../../../documents_scan";

	$sql_document_scan = dbquery("SELECT *
		FROM documents_scan
		WHERE id_document_scan='".$id_document_scan."'");

	if (dbnumrows($sql_document_scan) > 0)
	{
		$id_document_scan	= dbresult($sql_document_scan,$j,"id_document_scan");
		$fichier		= dbresult($sql_document_scan,$j,"fichier");

	
		// Fichier
		if(is_file($rep_base."/".$fichier) && $fichier <> "desktop.ini")
		{
			$icon = "<i style='background-color:white;color:black' class='fa fa-file-o fa-2x'></i>";
			if (extension($fichier) == "pdf")	$icon = "<i style='background-color:white;color:red' class='fa fa-file-pdf-o fa-2x'></i>";
			if (extension($fichier) == "doc" || extension($fichier) == "docx")	$icon = "<i style='background-color:white;color:blue' class='fa fa-file-word-o fa-2x'></i>";
			if (extension($fichier) == "xls" || extension($fichier) == "xlsx")	$icon = "<i style='background-color:white;color:green' class='bi bi-file-earmark-excel-fill fa-2x'></i>";

			$display['icon'] = $icon;
			$display['link'] = '/cabinet/documents_scan/'.urlencode($fichier);
			$display['link_name'] = $fichier;
			$display['creation_date'] = dd(filectime($rep_base."/".$fichier));
			$display['modified_date'] = dd(filemtime($rep_base."/".$fichier));
			$display['filesize'] = filesize($rep_base."/".$fichier);
		}
	}

	return $display;
}
?>

<script type="text/javascript"> 
$(document).ready(function()
{
	$("table").tablesorter({
		theme : "bootstrap",
		widthFixed: true,
		widgets : [ "uitheme", "zebra" ],
		widgetOptions : {
		}
	})

	// --------------------------------------
	// Selectionne ou deselectionne une ligne
	// --------------------------------------
	$("tr").click(function()				
	{
		$(this).toggleClass("choix");
	
		var value = $(this).attr('id');		

		if ($(this).hasClass("choix"))
		{
			// Coche
			document.getElementsByName("files["+value+"]")[0].checked = true;
			$("#concatenation").show();
		}
		else
		{
			// Décoche
			document.getElementsByName("files["+value+"]")[0].checked = false;
		}
	});


	// ---------------------
	// Coche ou décoche tout
	// ---------------------
	$("#check_uncheck_all").click(function()				
	{
		if (this.checked)	$("#concatenation").show();
		else	$("#concatenation").hide();
		
		var checked_status = this.checked;
		$("input.checkbox").each(function()
		{
			this.checked = checked_status;
		});


		$("tr").each(function()
		{
			if (checked_status == true)	$(this).addClass("choix");
			else $(this).removeClass("choix");
		});

	});


});
</script>


<form id='form1' name='form1' method='post'  enctype="multipart/form-data" action='/cabinet/consultations/gestion_clients/docs_scan/download.php'>
	<div class='title'>PDF : Concaténation</div>
	<input type="hidden" name="id_client" value="<?php echo $_GET['id_client'] ?>">

	
	<table border='0' cellpadding='10' cellpadding='0'>
	<thead>
	<tr>
		<th style='width:20px'><input type='checkbox' name='check_uncheck_all' id='check_uncheck_all'></th>
		<td style='width:20px'></td>
		<td style='width:150px'>Nom</td>
		<td style='width:150px'>Uploadé le</td>
		<td style='width:150px'>Modifié le</td>
		<td>Taille</td>
	</tr>
	</thead>
	<tbody>
	<?php
	$sql_document_scan = dbquery("SELECT *
		FROM documents_scan
		WHERE id_client='".$_GET['id_client']."'
		ORDER BY id_document_scan ASC");

	for ($i=0;$i<dbnumrows($sql_document_scan);$i++)
	{
		$id_document_scan	= dbresult($sql_document_scan,$i,"id_document_scan");
		$fichier			= dbresult($sql_document_scan,$i,"fichier");

		$tab_file = tab_file($id_document_scan);

		echo "<tr id='".$i."'><td style='text-align:right'><input class='checkbox' type='checkbox' name='files[".$i."]' value='".urlencode($fichier)."'></td>";
		echo "<td>".$tab_file['icon']."</td>";
		echo "<td><a style='color:black' href='".$tab_file['link']."'>".$fichier."</a></td>";
		echo "<td>".$tab_file['creation_date']."</td>";
		echo "<td>".$tab_file['modified_date']."</td>";
		echo "<td style='text-align:right'>".formatBytes($tab_file['filesize'])."</td></tr>";
	}
	?>
	</tbody>
	<tfoot>
	<tr>
		<td colspan='2'><button style='display:none' id="concatenation" class="btn btn-primary" type='submit'><i style='background-color:white;color:red' class='fa fa-file-pdf-o fa-lg'></i> Concaténer</button></td>
	</tr>
	</tfoot>
	</table>

	
</form>

<?php
// Footer
require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/footer.inc.php");
?>