<?php
// ====================
// Info sur les clients
// ====================

session_start();

require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/config.global.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/dbconfig.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/lib/lib.main.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/lib/lib.db.inc.php");

libraries(array('TCPDF'));

// Feuille A4 - Portrait
$pdf = new TCpdf('Portrait', 'mm', 'A4', true ,'utf-8' , false);


// set document information
$pdf->SetCreator(PDF_CREATOR);
$pdf->SetAuthor('Cabinet TANGUY');
$pdf->SetTitle('DOSSIER MEDICAL');
$pdf->SetSubject('DOSSIER MEDICAL');
$pdf->SetKeywords('DOSSIER MEDICAL');


//set image scale factor
$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

//set some language-dependent strings
$pdf->setLanguageArray($l);

// ---------------------------------------------------------

// set font
$pdf->SetFont('helvetica', '', 12);

$pdf->SetAutoPageBreak(false);
$pdf->setPrintHeader(false);
$pdf->setPrintFooter(false);


// Marges
$pdf->SetMargins(20,20,20,20);


foreach($_GET['id_client'] as $key=>$id_client)
{
	$sql = dbquery("SELECT * FROM clients WHERE id_client='".$id_client."'");

	if (dbnumrows($sql)<> 0)
	{
		$nom		= strtoupper(dbresult($sql,0,"nom"));
		$prenom		= dbresult($sql,0,"prenom");
		
		
		// --------------
		// Les téléphones
		// --------------
		$telephone_fixe		= "";
		$sql_client_telephone_fixe = dbquery("SELECT *
			FROM clients_telephone
			WHERE id_client = '".$id_client."'
				AND type_telephone = 'fixe'
			ORDER BY type_telephone ASC");
		if (dbnumrows($sql_client_telephone_fixe) > 0)
			$telephone_fixe		= dbresult($sql_client_telephone_fixe,0,"telephone");

		$telephone_portable	= "";
		$sql_client_telephone_portable = dbquery("SELECT *
			FROM clients_telephone
			WHERE id_client = '".$id_client."'
				AND type_telephone = 'portable'
			ORDER BY type_telephone ASC");
		if (dbnumrows($sql_client_telephone_portable) > 0)
			$telephone_portable		= dbresult($sql_client_telephone_portable,0,"telephone");

		
		$adresse			= dbresult($sql,0,"adresse");
		$code_postal		= dbresult($sql,0,"code_postal");
		$ville				= dbresult($sql,0,"ville");
		$pays				= dbresult($sql,0,"pays");
		$sexe				= dbresult($sql,0,"sexe");
		$numero_nir			= new NumeroNIR(dbresult($sql,0,"numero_nir"));
		$medecin_traitant	= dbresult($sql,0,"medecin_traitant");

		if ($nom == '')					$nom = " ______________";
		if ($prenom == '')				$prenom = " ______________";
		if ($telephone_fixe == '')		$telephone_fixe = " _______________";
		if ($telephone_portable == '')	$telephone_portable = " _______________";
		if ($adresse == '')	$adresse = "_____________________________________________";

		if ($medecin_traitant == '')	$medecin_traitant = " ___________________";

		// Add a page
		$pdf->AddPage();


		// Entete
		$pdf -> SetFont('Helvetica','B',15);
		$pdf -> SetXY(30,20);
		$pdf -> Cell($pdf->getPageWidth()-60,0, 'Cabinet du Docteur '.param('nom_docteur').' '.param('specialite'),     0, $ln=0,'R', $fill=false,'', $stretch=4, false, 'C','C');

		$pdf -> SetFont('Helvetica','',13);
		$pdf -> SetXY(30,30);
		$pdf -> Cell($pdf->getPageWidth()-60,0, param('lieu')." - ".param('telephone_1'),     0, $ln=0,'R', $fill=false,'', $stretch=4, false, 'C','C');

		$pdf -> SetFont('Helvetica','',15);
		$pdf -> SetXY(70,50);
		$pdf -> Cell($pdf->getPageWidth()-140,0, 'DOSSIER MÉDICAL',     'TB', $ln=0,'R', $fill=false,'', $stretch=4, false, 'C','C');



		// Repere
		$pdf->SetFont('helvetica', '', 22);
		$pdf -> SetXY(187,10);
		$pdf -> Cell(10,0, substr($nom,0,1), 0 , $ln=0,'R', $fill=false,'', $stretch=0, false, 'C','C');
		$pdf->SetFont('helvetica', '', 14);
		$pdf -> SetXY(196,11);
		$pdf -> Cell(6,0, substr($nom,1,1), 0 , $ln=0,'R', $fill=false,'', $stretch=0, false, 'C','C');



		// Nom et prénom sexe
		$pdf->SetFont('helvetica', '', 12);
		$pdf->Text(20,70,'NOM :',false,false,true,0,0,'L',false,'',1);
		$pdf->SetFont('helvetica', 'B', 12);
		$pdf->Text(34,70,$nom,false,false,true,0,0,'L',false,'',1);
		$pdf->SetFont('helvetica', '', 12);
		$pdf->Text(110,70,'PRÉNOM :',false,false,true,0,0,'L',false,'',1);
		$pdf->Text(133,70,$prenom,false,false,true,0,0,'L',false,'',1);
		$pdf->Text(20,80,'SEXE :',false,false,true,0,0,'L',false,'',1);
		$pdf->Text(35,80,$sexe,false,false,true,0,0,'L',false,'',1);

		// Adresse Code postal et ville
		$pdf->Text(20,90,'ADRESSE :',false,false,true,0,0,'L',false,'',1);
		$pdf->Text(45,90,$adresse." ".$code_postal." ".$ville,false,false,true,0,0,'L',false,'',1);


		// Telephone
		$pdf->SetFont('helvetica', '', 12);
		$pdf->Text(20,100,'Téléphone fixe :',false,false,true,0,0,'L',false,'',1);
		$pdf->Text(51,100,$telephone_fixe,false,false,true,0,0,'L',false,'',1);
		$pdf->Text(110,100,'Téléphone portable :',false,false,true,0,0,'L',false,'',1);
		$pdf->Text(151,100,$telephone_portable,false,false,true,0,0,'L',false,'',1);


		// NUMERO SECU
		$pdf->Text(20,110,'Numéro NIR :',false,false,true,0,0,'L',false,'',1);
		$pdf->Text(48,110,$numero_nir->format_espace(),false,false,true,0,0,'L',false,'',1);

		// MÉDECIN TRAITANT
		$pdf->Text(20,120,'Médecin traitant :',false,false,true,0,0,'L',false,'',1);
		$pdf->Text(53,120,$medecin_traitant,false,false,true,0,0,'L',false,'',1);

	
		// Actes effectués
		$sql_agenda = dbquery("SELECT * FROM agenda,type_rendez_vous
			WHERE agenda.id_type_rendez_vous=type_rendez_vous.id_type_rendez_vous
				AND agenda.id_client='".$id_client."'
			ORDER BY agenda.datetime_debut ASC");

		$rendez_vous = array();

		for ($i=0;$i<=3;$i++)
			$rendez_vous[$i] = "___________ - ______________";

		for ($i=0;$i<dbnumrows($sql_agenda);$i++)
		{
			$datetime_debut		= new datetime(dbresult($sql_agenda,$i,"agenda.datetime_debut"));
			$type_rendez_vous	= dbresult($sql_agenda,$i,"type_rendez_vous.intitule");
			
			$rendez_vous[$i] = $datetime_debut->format('d / m / Y')." - ".$type_rendez_vous;
		}

		foreach($rendez_vous as $key2 => $value2)
		{
			$pdf -> SetXY(20,150 + 14*$key2);
			$numero_rendez_vous = $key2+1;
			$pdf -> Cell(50,0, "Rendez-vous ".$numero_rendez_vous." : ".$value2, 0 , $ln=0,'L', $fill=false,'', $stretch=0, false, 'C','C');
		}
	}
}

// Nom du fichier
$file = "dossier_medical.pdf";

if (count($_GET['id_client']) == 1)	$file = "dossier_medical_".wd_remove_accents($nom,'UTF-8')."_".wd_remove_accents($prenom,'UTF-8').".pdf";

ob_end_clean();
$pdf->Output($file, 'I');