<?php
// ======================
// OPTIONS
// --> Formulaire d'ajout
// ======================

session_start();

require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/config.global.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/dbconfig.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/lib/lib.main.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/lib/lib.db.inc.php");
?>

<script> 
$(function() {
	$("#tabs_").tabs({ active: 0 });

	$("#form_option").validate({    
		rules: {
			nom: {
				required: true,
				minlength: 2
			},
			prenom: {
				required: true,
				minlength: 2
			},
			email: {
				required: true,
				minlength: 2
			},
		},
		messages: {
			nom: {
				required: "vide !",
				minlength: "..."
			},
			prenom: {
				required: "vide !",
				minlength: "..."
			},
			email: {
				required: "vide !",
				minlength: "..."
			}
		}
	});

	// -------------------------------
	// Permet de valider le formulaire
	// avant de l'envoyer
	// -------------------------------
	$("#form_option").submit(function()
	{
		$.ajax({
			type:		"GET",
			url:		"/cabinet/config/options/update.php",
			data:		$(this).serialize(),
			beforeSend:	function() {
				$('#submit').html("Modifier vos infos <div class='spinner-border spinner-border-sm' role='status'></div>");
			},
			success:	function(response){ 
				$('#submit').html("Modifier vos infos <i class='fa fa-check' aria-hidden='true'></i>");
			}
		});

		return false;

	});

	$(".personnel_service").click(function()
	{
		$.ajax({
				type:		"GET",
				url:		"/cabinet/config/options/personnel_service.php",
				data:		"id_personnel="+$("#id_personnel").val()+'&id_service='+$(this).val(),
				beforeSend:	function() {
					},
				complete:	function() {	
					},
				success:	function(response) { 

					}
			});

	});


	$.datepicker.setDefaults( $.datepicker.regional[ "fr" ] );

});
</script> 

<?php
// Identité
$sql_personnel		= dbquery("SELECT *
	FROM personnel
	WHERE id_personnel='".$_GET['id_personnel']."'");
if (dbnumrows($sql_personnel) == 0)
	die('Attention : Personnel non reconnu');
?>

<form id='form_option'>
	<input type="hidden" id="id_personnel" name="id_personnel" value="<?php echo $_GET['id_personnel'] ?>">

	<div id="tabs_">
		<ul>
			<li><a href="#tabs-1">Vos infos</a></li>
			<li><a href="#tabs-2">Agenda</a></li>
			<li><a href="#tabs-3">Menu</a></li>
			<li><a href="#tabs-4">Quadrichromie</a></li>
			<?php
			if ($_GET['admin'] == 1)
				echo "<li><a href='#tabs-5'>Services</a></li>";
			?>
		</ul>

		<div id="tabs-1">
			<table>
			<tr>
				<td style='text-align:right'>Nom :</td>
				<td><input class="form-control" name='nom' type='text' size='50' value="<?php echo dbresult($sql_personnel,0,"nom")?>"></td>
			</tr>
			<tr>
				<td style='text-align:right'>Prénom :</td>
				<td><input class="form-control" name='prenom' type='text' size='50' value="<?php echo dbresult($sql_personnel,0,"prenom")?>"></td>
			</tr>
			<tr>
				<td style='text-align:right'>Email :</td>
				<td><input class="form-control" name='email' type='text' size='30' value="<?php echo dbresult($sql_personnel,0,"email")?>"></td>
			</tr>
			</table>

		</div>

		<div id="tabs-2">
			<table>
			<tr>
				<td style='text-align:right'>Vue agenda :</td>
				<td>

				<?php
				// -------------------------
				// Menu deroulant Vue Agenda
				// -------------------------
				$sql = dbquery("SHOW COLUMNS FROM personnel LIKE 'agenda_defaultview'");

				// $type = "enum('month', 'agendaWeek', 'agendaDay')"
				$type = dbresult($sql,0,"Type");
				$type = str_replace("enum(","",$type);
				$type = str_replace(")","",$type);
				$type = str_replace("'","",$type);

				$type_tab = explode(",",$type);
				?>
				<p><select class="form-control" name="agenda_defaultview">
					<?php		
					for ($i=0;$i<count($type_tab);$i++)
					{
						if (dbresult($sql_personnel,0,"agenda_defaultview") == $type_tab[$i])	$selected = " selected";
						else $selected = "";

						echo "<option value='".$type_tab[$i]."'".$selected.">".$dico[$type_tab[$i]]."</option>";
					}
					?>
					</select>
				</td>
			</tr>
			<tr>
				<td>Vie :</td>
				<td>
					<select class="form-control" name='agenda_deces'>
						<option value='all' <?php if (dbresult($sql_personnel,0,"agenda_deces") == 'all')		echo " selected"; ?>>Tous</option>
						<option value='vivant' <?php if (dbresult($sql_personnel,0,"agenda_deces") == 'vivant')	echo " selected"; ?>>En vie</option>
						<option value='deces' <?php if (dbresult($sql_personnel,0,"agenda_deces") == 'deces')	echo " selected"; ?>>Décédé</option>
					</select>
				</td>
			</tr>
			<tr>
				<td style='text-align:right'>Taille agenda :</td>
				<td><input class="form-control" name='agenda_width' type='text' style='width:60px' value="<?php echo dbresult($sql_personnel,0,"agenda_width")?>"> x <input class="form-control" name='agenda_height' type='text' style='width:60px' value="<?php echo dbresult($sql_personnel,0,"agenda_height")?>"></td>
			</tr>
			</table>
		</div>


		<div id="tabs-3">
			<table>
			<tr>
				<td style='text-align:right'>Menu :</td>
				<td>

					<?php
					// -------------------
					// Menu deroulant Menu
					// -------------------
					$sql = dbquery("SHOW COLUMNS FROM personnel LIKE 'nav_bar'");

					// $type = "enum('text', 'icon', 'icon_text')
					$type = dbresult($sql,0,"Type");
					$type = str_replace("enum(","",$type);
					$type = str_replace(")","",$type);
					$type = str_replace("'","",$type);

					$type_tab = explode(",",$type);
					?>
					<select class="form-control" name="nav_bar">
					<?php		
					for ($i=0;$i<count($type_tab);$i++)
					{
						if (dbresult($sql_personnel,0,"nav_bar") == $type_tab[$i])	$selected = " selected";
						else $selected = "";

						echo "<option value='".$type_tab[$i]."'".$selected.">".$dico[$type_tab[$i]]."</option>";
					}
					?>
					</select>

				</td>
			</tr>
			</table>

		</div>

		<div id="tabs-4">
			<table>
			<tr>
				<td style='text-align:right'>États en quadrichromie :</td>
				<td>
					<?php
					if (dbresult($sql_personnel,0,"quadrichromie") == 1)
						$quadrichromie_cheked = "checked";
					else
						$quadrichromie_cheked = "";
					?>
					
					<input type="checkbox" name="quadrichromie" value="1" <?php echo $quadrichromie_cheked ?>>
				</td>
			</tr>
			</table>

		</div>

		<?php
		if ($_GET['admin'] == 1)
		{
			?>
			<div id="tabs-5">

				<div class='title'>Administration des services</div>

				<table class='tablesorter'>
				<thead>
				</thead>
				<tbody>
				<?php
				$sql_services = dbquery("SELECT * FROM services");
				for ($i=0;$i<dbnumrows($sql_services);$i++)
				{
					$id_service = dbresult($sql_services,$i,"id_service");
					$service	= dbresult($sql_services,$i,"service");
					
					$checked = "";
					
					$sql_services_personnel = dbquery("SELECT * 
							FROM personnel_services
							WHERE id_personnel = '".$_GET['id_personnel']."'
								AND id_service = '".$id_service."'");
					
					if (dbnumrows($sql_services_personnel))
						$checked = "checked";
					?>
					<tr>
						<td><input class='personnel_service' type="checkbox" name="id_service[<?php echo $i ?>]" value="<?php echo $id_service ?>"<?php echo $checked ?>></td>
						<td><?php echo $service ?></td>
					</tr>
					<?php
				}
				?>
				</table>


			</div>
			<?php
		}
		?>
	</div>


	</div>
	
	<button class="btn btn-primary" id='submit' type='submit'>Modifier vos infos</button>
</form>
