<?php
session_start();

require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/config.global.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/dbconfig.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/lib/lib.main.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/lib/lib.db.inc.php");
libraries(array('PHPExcel'));


$tab_mois = array(
	"1" => "Janvier",
	"2" => "Février",
	"3" => "Mars",
	"4" => "Avril",
	"5" => "Mai",
	"6" => "Juin",
	"7" => "Juillet",
	"8" => "Août",
	"9" => "Septembre",
	"10" => "Octobre",
	"11" => "Novembre",
	"12" => "Décembre");



$styleEntete = array(
	'font'=>array(
		'bold'=>true,
		'size'=>12,
		'name'=>Arial,
		'color'=>array(
			'rgb'=>'6666CC'),
		));

$stylePiedDePage = array(
	'font'=>array(
		'bold'=>true,
		'size'=>10,
		'name'=>Arial,
		'color'=>array(
			'rgb'=>'ff0000'),
		));

$styleEnteteGradiant = array(
	'fill' => array(
		'type' => PHPExcel_Style_Fill::FILL_GRADIENT_LINEAR,
		'rotation' => 90,
		'startcolor' => array(
			'argb' => 'FFFFCC00'),
		'endcolor' => array(
			'argb' => 'FFFFFFFF')));

$style1ereLigne = array(
	'fill' => array(
		'type' => PHPExcel_Style_Fill::FILL_GRADIENT_LINEAR,
		'rotation' => 90,
		'startcolor' => array(
			'argb' => 'FF66CCFF'),
		'endcolor' => array(
			'argb' => 'FFFFFFFF')));


$styleSimpleBorder = array(
	'borders' => array(
		'left' => array(
			'style' => PHPExcel_Style_Border::BORDER_THIN,
			'color' => array('argb' => 'FF993300'),
		),
		'right' => array(
			'style' => PHPExcel_Style_Border::BORDER_THIN,
			'color' => array('argb' => 'FF993300'),
		),
		'top' => array(
			'style' => PHPExcel_Style_Border::BORDER_THIN,
			'color' => array('argb' => 'FF993300'),
		),
		'bottom' => array(
			'style' => PHPExcel_Style_Border::BORDER_THIN,
			'color' => array('argb' => 'FF993300'),
		),
	)
);


$styleDoubleBorder = array(
	'borders' => array(
		'left' => array(
			'style' => PHPExcel_Style_Border::BORDER_DOUBLE,
			'color' => array('argb' => 'FF993300'),
		),
		'right' => array(
			'style' => PHPExcel_Style_Border::BORDER_DOUBLE,
			'color' => array('argb' => 'FF993300'),
		),
		'top' => array(
			'style' => PHPExcel_Style_Border::BORDER_DOUBLE,
			'color' => array('argb' => 'FF993300'),
		),
		'bottom' => array(
			'style' => PHPExcel_Style_Border::BORDER_DOUBLE,
			'color' => array('argb' => 'FF993300'),
		),
	)
);




$styleBold = array(
	'font'=>array(
		'bold'=>true));


$styleHCenter = array(
	'alignment' => array(
		'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER)
);

$styleVCenter = array(
	'alignment' => array(
		'vertical'   => PHPExcel_Style_Alignment::VERTICAL_CENTER)
);


$xls_tuteur_ue_without_extension = "comptes_".$_GET['year'];


// Create new PHPExcel object
$objPHPExcel = new PHPExcel();


$sql_comptes_bancaires_mois = dbquery("SELECT DISTINCT(MONTH(date)) AS mois
				FROM compte_bancaire_releve
				WHERE YEAR(date) = '".$_GET['year']."'");

for ($i=0;$i<dbnumrows($sql_comptes_bancaires_mois);$i++)
{
	$mois = dbresult($sql_comptes_bancaires_mois,$i,"mois");

	
	if ($i > 0)	$objPHPExcel->createSheet();

	$objPHPExcel->setActiveSheetIndex($i);
	$objPHPExcel->getActiveSheet()->setTitle($tab_mois[$mois]);

	
	// -----------------------------------------------------
	// Range 1 (Entete ligne 1)
	// --> centrage texte
	// --> couleur texte (#6666CC)
	// --> concaténation cellules
	// -----------------------------------------------------
	$range_1 = 'A1:E1';
	$objPHPExcel->getActiveSheet()->getStyle($range_1)->applyFromArray($styleEntete);
	$objPHPExcel->getActiveSheet()->getStyle($range_1)->applyFromArray($styleHCenter);
	$objPHPExcel->getActiveSheet()->getStyle($range_1)->applyFromArray($styleEnteteGradiant);
	$objPHPExcel->getActiveSheet()->mergeCells($range_1);


	// -----------------------------------------------------
	// Range 2 (Entete ligne 2)
	// --> centrage texte
	// --> couleur texte (#6666CC)
	// --> concaténation cellules
	// -----------------------------------------------------
	$range_2 = 'A2:E2';
	$objPHPExcel->getActiveSheet()->getStyle($range_2)->applyFromArray($styleEntete);
	$objPHPExcel->getActiveSheet()->getStyle($range_2)->applyFromArray($styleHCenter);
	$objPHPExcel->getActiveSheet()->mergeCells($range_2);


	// --------------------------
	// Range 3 (Entete ligne 1+2)
	// --> double bordure
	// --------------------------
	$range_3 = 'A1:E2';
	$objPHPExcel->getActiveSheet()->getStyle($range_3)->applyFromArray($styleDoubleBorder);


	// ------------------------
	// Range 4 (1ere ligne)
	// --> dégradé de couleur
	// --> double bordure
	// ------------------------
	$range_4 = 'A5:E5';
	$objPHPExcel->getActiveSheet()->getStyle($range_4)->applyFromArray($styleDoubleBorder);
	$objPHPExcel->getActiveSheet()->getStyle($range_4)->applyFromArray($style1ereLigne);
	$objPHPExcel->getActiveSheet()->getStyle($range_4)->applyFromArray($styleBold);


	// ----------------
	// Largeur colonnes
	// ----------------
	$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(14);
	$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(14);
	$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(60);
	$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(14);
	$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(14);



	// -------
	// ENTETES
	// -------
	$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(0,1, "Comptes");
	$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(0,2, $tab_mois[$mois]." ".$_GET['year']);




	// ----------
	// 1ere ligne
	// ----------
	$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(0,5, "Date");
	$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(1,5, "Date valeur");
	$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(2,5, "Libellé");
	$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(3,5, "Débit Euros");
	$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(4,5, "Crédit Euros");


	// -------------------
	// Les comptes du mois
	// -------------------
	$sql_comptes_bancaires = dbquery("SELECT *
		FROM compte_bancaire_releve
		WHERE YEAR(date) = '".$_GET['year']."'
			AND MONTH(date) = '".$mois."'");


	$ligne = 6;

	for ($j=0;$j<dbnumrows($sql_comptes_bancaires);$j++)
	{	
		$date			= new DateTime(dbresult($sql_comptes_bancaires,$j,"date"));
		$date_valeur	= dbresult($sql_comptes_bancaires,$j,"date_valeur");
		$libelle		= dbresult($sql_comptes_bancaires,$j,"libelle");
		$debit_euros	= dbresult($sql_comptes_bancaires,$j,"debit_euros");
		$credit_euros	= dbresult($sql_comptes_bancaires,$j,"credit_euros");


		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(0,$ligne, $date->format('d')." ".$dico[$date->format('F')]);
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(1,$ligne, $date_valeur);
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(2,$ligne, $libelle);
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(3,$ligne, $debit_euros);
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(4,$ligne, $credit_euros);

		$ligne++;
	}

	$to_centre_enseignement = 6 + dbnumrows($sql_comptes_bancaires) - 1;
	$to_centre_enseignement_plus_un = $to_centre_enseignement + 1;

	// EUROS
	$objPHPExcel->getActiveSheet()->getStyle('D6:E'.$to_centre_enseignement_plus_un)->getNumberFormat()->setFormatCode('#,##0.00 €');


	// Double Bordure body
	$range_body = 'A6:E'.$to_centre_enseignement;
	$objPHPExcel->getActiveSheet()->getStyle($range_body)->applyFromArray($styleDoubleBorder);


	// Pied de Page (TOTAL)
	$range_body = 'A'.$to_centre_enseignement_plus_un.':E'.$to_centre_enseignement_plus_un;
	$objPHPExcel->getActiveSheet()->getStyle($range_body)->applyFromArray($styleDoubleBorder);
	$objPHPExcel->getActiveSheet()->getStyle($range_body)->applyFromArray($stylePiedDePage);


	// TOTAL
	$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(0,$to_centre_enseignement_plus_un, "TOTAL");
	$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(3,$to_centre_enseignement_plus_un, "=SUM(D6:D".$to_centre_enseignement.")");
	$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(4,$to_centre_enseignement_plus_un, "=SUM(E6:E".$to_centre_enseignement.")");
}

// Set active sheet index to the first sheet, so Excel opens this as the first sheet
$objPHPExcel->setActiveSheetIndex(0);



// -------------------
// Format : Excel 2007
// -------------------

header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment;filename="'.$xls_tuteur_ue_without_extension.'.xlsx"');
header('Cache-Control: max-age=0');

$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
$objWriter->save('php://output');