<?php
session_start();

require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/config.global.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/dbconfig.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/lib/lib.main.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/lib/lib.db.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/lib/lib.files.inc.php");


function icone($file)
{
	$icon = "<i style='color:green' class='fa fa-file fa-lg'></i>";
	if (extension($file) == "pdf")	$icon = "<i style='color:red' class='fa fa-file-pdf-o fa-lg'></i>";
	if (extension($file) == "doc" || extension($file) == "docx")	$icon = "<i style='color:blue' class='fa fa-file-word-o fa-lg'></i>";
	if (extension($file) == "xls" || extension($file) == "xlsx" || extension($file) == "csv" || extension($file) == "slk")	$icon = "<i style='color:green' class='bi bi-file-earmark-excel-fill fa-lg'></i>";
	
	return $icon;
}

// Rend le fichier ouvrable avec IE et Firefox
function formate_file_name($file)
{
	$file = utf8_encode($file);

	return $file;
}









$tab_mois = array(
	"1" => "Janvier",
	"2" => "Février",
	"3" => "Mars",
	"4" => "Avril",
	"5" => "Mai",
	"6" => "Juin",
	"7" => "Juillet",
	"8" => "Août",
	"9" => "Septembre",
	"10" => "Octobre",
	"11" => "Novembre",
	"12" => "Décembre");

$sql_comptes_bancaires_mois = dbquery("SELECT DISTINCT(MONTH(date)) AS mois
	FROM compte_bancaire_releve
	WHERE YEAR(date) = '".$_GET['year']."'");

$date_actuelle	= new DateTime();
?>

<script type="text/javascript"> 
$(document).ready(function()
{
	$("table").tablesorter({
		headers: { 0: { sorter: false }, 1: { sorter: false }},
		theme : "bootstrap",
		widthFixed: true,
		widgets : [ "uitheme", "zebra" ],
		widgetOptions : {
		}
	})

	$(".import_releve_compte").click(function() {
		
		var value = $(this).attr('id');		

		document.location.href = "import_releve_compte.php?fichier="+value;
	});

	
	$("#edit").click(function()				
	{
		document.location.href = 'form.php';
	})
	

	// --------------------------------------
	// Selectionne ou deselectionne une ligne
	// --------------------------------------
	$("tr").click(function()				
	{
		$(this).toggleClass("choix");
	
		var value = $(this).attr('id');		

		if ($(this).hasClass("choix"))
		{
			// Coche
			document.getElementsByName("date["+value+"]")[0].checked = true;
			//$("#selection").show();
		}
		else
		{
			// Décoche
			document.getElementsByName("date["+value+"]")[0].checked = false;
		}
	});


	// ---------------------
	// Coche ou décoche tout
	// ---------------------
	$("#check_uncheck_all").click(function()				
	{
		if (this.checked)	$("#selection").show();
		else	$("#selection").hide();
		
		var checked_status = this.checked;
		$("input.checkbox").each(function()
		{
			this.checked = checked_status;
		});


		$("tr").each(function()
		{
			if (checked_status == true)	$(this).addClass("choix");
			else $(this).removeClass("choix");
		});

	});


	// -------------------------------
	// Permet de valider le formulaire
	// avant de l'envoyer
	// -------------------------------
	$("#form1").submit(function()
	{
		var valid = false;
	
		$("input.checkbox").each(function()
		{
			if (this.checked == true)
			{
				valid = true;
			}
		});

		if (valid == false)	alert('Veuillez selectionnez au moins un mois')

		return valid;
	});


	$( "#tab" ).tabs({ active: <?php echo $_GET['active'] ?> });

	$( "#tab-comptes-mois" ).tabs({ active: 0 });

	<?php
	for ($i=0;$i<dbnumrows($sql_comptes_bancaires_mois);$i++)
	{
		$mois = dbresult($sql_comptes_bancaires_mois,$i,"mois");

		?>
		$("#mois_<?php echo $mois ?>").load("read_comptes_ajax.php?year=<?php echo $_GET['year']?>&mois=<?php echo $mois ?>");
		<?php
	}
	?>

	$("#before_1").click(function() {
		$("#ajax").load("index_ajax.php?year="+$("#before_1").attr('year')+"&active="+$("#before_1").attr('active'));
	});

	$("#next_1").click(function() {
		$("#ajax").load("index_ajax.php?year="+$("#next_1").attr('year')+"&active="+$("#next_1").attr('active'));
	});


	$("#before_2").click(function() {
		$("#ajax").load("index_ajax.php?year="+$("#before_2").attr('year')+"&active="+$("#before_2").attr('active'));
	});

	$("#next_2").click(function() {
		$("#ajax").load("index_ajax.php?year="+$("#next_2").attr('year')+"&active="+$("#next_2").attr('active'));
	});

});
</script> 

<div class='title'>Comptes bancaires</div>

<?php
$sql_personnel_services_agenda = dbquery("SELECT *
	FROM personnel_services
	WHERE id_service = '7'
		AND id_personnel='4'");

 if (dbnumrows($sql_personnel_services_agenda) > 0)
 {
	echo "<button class='btn btn-secondary' id='edit'><i style='color:orange' class='bi bi-pencil-fill fa-lg'></i> Mise à jour</button>";
 }
?>

<div id="tab" style="width:940px">
	<ul>
		<li><a href='#tab-1'><i style='color:red' class='fa fa-file-pdf-o fa-lg'></i> Relevé des comptes</a></li>
		<li><a href='#tab-2'><i style='color:green' class='bi bi-file-earmark-excel-fill fa-lg'></i> Liste des opérations</a></li>
		<li><a href='#tab-3'>Comptes par mois</a></li>
		<li><a href='#tab-4'>Statistiques mois</a></li>
		<li><a href='#tab-5'>Statistiques année</a></li>
	</ul>

	<!-- RELEVE DES COMPTES -->
	<div id='tab-1'>

		<form id="form1" method="get" action="consultations.php">

			<div id="selection" style="position:absolute; top: 50px; left: 40px; width:540px; display:none;">
				
				<div style='position:absolute;left:140px' class="ui-widget">
					<div class="ui-state-highlight ui-corner-all">
						<p><span class="ui-icon ui-icon-info" style="float: left; margin-right: .3em;"></span>
							<strong>Attention !</strong> Le téléchargement en ZIP n'est pas encore disponible.</p>
					</div>
				</div>
				
				<button class="btn btn-primary" type="submit"><img src="/images/icomoon/16px/file-zip.png" width="16" height="16" border="0" alt="">&nbsp;&nbsp;Comptes</button>
			</div>	
			
			<table style="position:absolute; top: 86px; left: 10px; width:550px;" id="table">
			<thead>
				<th style="width:20px"><input type='checkbox' name='check_uncheck_all' id='check_uncheck_all'></th>
				<th>Fichier</th>
				<th>Date arret du relevé</th>
				<th style='width:36px'></th>
				<th style="text-align:center;width:40px;"><img src="/images/icomoon/16px/download3.png" width="16" height="16" border="0" alt=""></th>
			</thead>
			<tbody>
			<?php
			
			$sql_comptes_bancaires = dbquery("SELECT *
				FROM comptes_bancaires
				WHERE fichier <> ''
					AND type = 'releve_compte'
				ORDER BY date_arret_releve DESC");

			for ($i=0;$i<dbnumrows($sql_comptes_bancaires);$i++)
			{
				$type		= dbresult($sql_comptes_bancaires,$i,"type");
				$date		= new DateTime(dbresult($sql_comptes_bancaires,$i,"date_arret_releve"));
				$diff		= $date_actuelle->diff($date);  

				$fichier	= dbresult($sql_comptes_bancaires,$i,"fichier");

				echo "<tr id='".$i."'><td><input class='checkbox' type='checkbox' id='date[".$i."]' name='date[".$i."]' value='".$date->format('Y-m-d')."'></td>";
				echo "<td>".$fichier."</td>";
				echo "<td>".ucfirst($date->format('j')." ".$dico[$date->format('F')])." ".$date->format('Y')."</td>";
				
				// Logo new.png		
				echo "<td>";
				if ($diff->format('%a') <=5)	echo "<img src='/images/icones/new.png' width='23' height='12' border='0' alt='Nouveau'>";
				echo "</td>";
				
				// Icone et téléchargement
				echo "<td style='text-align:center'>";
				if ($fichier <> "")	echo "<a target='_new' href='download.php?f=".$fichier."'>".icone($fichier)."</a>";
				echo "</td></tr>";
			}
			?>
			</tbody>
			</table>
		</form>
	</div>
	
	<!-- LISTE DES OPERATIONS -->
	<div id='tab-2'>
		
		<table style="position:absolute; top: 86px; left: 10px; width:700px;" id="table">
		<thead>
			<th>Fichier</th>
			<th>Taille</th>
			<th>Date début</th>
			<th>Date arret du relevé</th>
			<th style='width:36px'></th>
			<th style="text-align:center;width:40px;"><img src="/images/icomoon/16px/download3.png" width="16" height="16" border="0" alt=""></th>
			<?php
			// Uniquement l'administrateur
			if ($_SESSION['id_personnel'] == 4)
				echo "<th>Import</th>";
			?>
		</thead>
		<tbody>
		<?php

		$sql_comptes_bancaires = dbquery("SELECT *
			FROM comptes_bancaires
			WHERE fichier <> ''
				AND type = 'liste_operation'
			ORDER BY id_compte_bancaire DESC");

		for ($i=0;$i<dbnumrows($sql_comptes_bancaires);$i++)
		{
			$date_debut			= new DateTime(dbresult($sql_comptes_bancaires,$i,"date_debut"));
			$date_arret_releve	= new DateTime(dbresult($sql_comptes_bancaires,$i,"date_arret_releve"));
			$diff				= $date_actuelle->diff($date_arret_releve);  

			$fichier	= dbresult($sql_comptes_bancaires,$i,"fichier");
			$import		= dbresult($sql_comptes_bancaires,$i,"import");

			$inputFileName = "files/".$fichier;
			
			echo "<tr id='".$i."'><td>".$fichier."</td>";
			echo "<td style='text-align:right'>";
			if (is_file($inputFileName))
				echo formatBytes(filesize($inputFileName),0);
			else
				echo "Fichier n'existe pas";
			echo "</td>";
			echo "<td>".ucfirst($date_debut->format('j')." ".$dico[$date_debut->format('F')])." ".$date_debut->format('Y')."</td>";
			echo "<td>".ucfirst($date_arret_releve->format('j')." ".$dico[$date_arret_releve->format('F')])." ".$date_arret_releve->format('Y')."</td>";
			
			// Logo new.png		
			echo "<td>";
			if ($diff->format('%a') <=5)	echo "<img src='/images/icones/new.png' width='23' height='12' border='0' alt='Nouveau'>";
			echo "</td>";
			
			// Icone
			echo "<td style='text-align:center'>";
			if ($fichier <> "")	echo "<a target='_new' href='download.php?f=".$fichier."'>".icone($fichier)."</a>";
			echo "</td>";

			// Import - TEST
			echo "<td style='text-align:center'>";
			// Uniquement l'administrateur
			if ($_SESSION['id_personnel'] == 4)
			{
				if ($import == 0 && extension($fichier) == "slk")
					echo "<button type='button' class='import_releve_compte' id='".$fichier."'>Import</button>";
				else
					echo "<i style='color:green' class='fa fa-check fa-lg'></i>";
			}
		}
		?>
		</tbody>
		</table>

	</div>

	<!-- COMPTES PAR MOIS -->
	<div id='tab-3'>

		<div class="title"> <i id="before_1" year='<?php echo ($_GET['year']-1) ?>' active='2' style="color:#E6564E" class="bi bi-chevron-left fa-2x"></i> <span style='color:#E6564E'> <?php echo $_GET['year'] ?></span> <i id="next_1" year='<?php echo ($_GET['year']+1) ?>' active='2' style="color:#E6564E" class="bi bi-chevron-right fa-2x"></i> </div>

		
		<div id="tab-comptes-mois">		
			<?php
			$sql_comptes_bancaires_mois = dbquery("SELECT DISTINCT(MONTH(date)) AS mois
				FROM compte_bancaire_releve
				WHERE YEAR(date) = '".$_GET['year']."'");

			echo "<ul>";
			for ($i=0;$i<dbnumrows($sql_comptes_bancaires_mois);$i++)
			{
				$mois = dbresult($sql_comptes_bancaires_mois,$i,"mois");

				echo "<li><a href='#tab-comptes-mois-".$mois."'>".$tab_mois[$mois]."</a></li>";
			}
			echo "</ul>";


			for ($i=0;$i<dbnumrows($sql_comptes_bancaires_mois);$i++)
			{
				$mois = dbresult($sql_comptes_bancaires_mois,$i,"mois");
				?>
				<div id='tab-comptes-mois-<?php echo $mois ?>'>

					<div id='mois_<?php echo $mois ?>'><div class='spinner-border spinner-border-sm' role='status'></div></div>

				</div>
				<?php
			}
			?>
		</div>

	</div>

	<!-- STATISTIQUE MOIS -->
	<div id='tab-4'>

		<div class="title"> <i id='before_2' year='<?php echo ($_GET['year']-1) ?>' active='3' style="color:#E6564E" class="before bi bi-chevron-left fa-2x"></i> <span style='color:#E6564E'> <?php echo $_GET['year'] ?></span> <i id='next_2' year='<?php echo ($_GET['year']+1) ?>' active='3' style="color:#E6564E" class="bi bi-chevron-right fa-2x"></i> </div>


		<?php
		$sql_comptes_bancaires_mois = dbquery("SELECT DISTINCT(MONTH(date)) AS mois
			FROM compte_bancaire_releve
			WHERE YEAR(date) = '".$_GET['year']."'");
		?>

		<table>
		<thead>
		<tr>
			<td></td>
			<?php
			for ($i=0;$i<dbnumrows($sql_comptes_bancaires_mois);$i++)
			{
				$mois = dbresult($sql_comptes_bancaires_mois,$i,"mois");

				echo "<td>".$tab_mois[$mois]."</a></td>";
			}
			?>
			<th>TOTAL année</th>
		</tr>
		</thead>
		<tbody>
		<tr>
			<th>Crédit Euros</th>
			<?php
			for ($i=0;$i<dbnumrows($sql_comptes_bancaires_mois);$i++)
			{
				$mois = dbresult($sql_comptes_bancaires_mois,$i,"mois");

				$sql_comptes_bancaires_sum_credit_euros = dbquery("SELECT SUM(credit_euros) AS sum_credit_euros
					FROM compte_bancaire_releve
					WHERE YEAR(date) = '".$_GET['year']."'
						AND MONTH(date) = '".$mois."'");
				echo "<td>".number_format((double)dbresult($sql_comptes_bancaires_sum_credit_euros,0,"sum_credit_euros"), 0, ',', ' ')." €</td>";
			}
			$sql_comptes_bancaires_sum_credit_euros = dbquery("SELECT SUM(credit_euros) AS sum_credit_euros
				FROM compte_bancaire_releve
				WHERE YEAR(date) = '".$_GET['year']."'");
			echo "<th>".number_format((double)dbresult($sql_comptes_bancaires_sum_credit_euros,0,"sum_credit_euros"), 0, ',', ' ')." €</th>";
			?>
		</tr>
		<tr>
			<th>Débit Euros</th>
			<?php
			for ($i=0;$i<dbnumrows($sql_comptes_bancaires_mois);$i++)
			{
				$mois = dbresult($sql_comptes_bancaires_mois,$i,"mois");

				$sql_comptes_bancaires_sum_debit_euros = dbquery("SELECT SUM(debit_euros) AS sum_debit_euros
					FROM compte_bancaire_releve
					WHERE YEAR(date) = '".$_GET['year']."'
						AND MONTH(date) = '".$mois."'");
				echo "<td>".number_format((double)dbresult($sql_comptes_bancaires_sum_debit_euros,0,"sum_debit_euros"), 0, ',', ' ')." €</td>";
			}

			$sql_comptes_bancaires_sum_debit_euros = dbquery("SELECT SUM(debit_euros) AS sum_debit_euros
				FROM compte_bancaire_releve
				WHERE YEAR(date) = '".$_GET['year']."'");
			echo "<th>".number_format((double)dbresult($sql_comptes_bancaires_sum_debit_euros,0,"sum_debit_euros"), 0, ',', ' ')." €</th>";
			?>
		</tr>
		</tbody>
		</table>

	</div>


	<!-- STATISTIQUE ANNÉE-->
	<div id='tab-5'>

		<?php
		$sql_comptes_bancaires_annee = dbquery("SELECT DISTINCT(YEAR(date)) AS year FROM compte_bancaire_releve");
		
		// ------------------------
		// Somme des credit + debit
		// --> Toutes années
		// ------------------------
		$sql_comptes_bancaires_sum_credit_euros = dbquery("SELECT SUM(credit_euros) AS sum_credit_euros FROM compte_bancaire_releve");

		$sql_comptes_bancaires_sum_debit_euros = dbquery("SELECT SUM(debit_euros) AS sum_debit_euros FROM compte_bancaire_releve");

		// ------------------------
		// Calcul du nombre de mois
		// ------------------------
		$sql_comptes_bancaires_min_date = dbquery("SELECT MIN(date) AS min_date FROM compte_bancaire_releve");
		$date_min = new DateTime(dbresult($sql_comptes_bancaires_min_date,0,"min_date"));

		$sql_comptes_bancaires_max_date = dbquery("SELECT MAX(date) AS max_date FROM compte_bancaire_releve");
		$date_max = new DateTime(dbresult($sql_comptes_bancaires_max_date,0,"max_date"));

		$nb_jour =  $date_max->diff($date_min)->format('%a');
		$nb_mois = $nb_jour*12/365;
		?>

		<table>
		<thead>
		<tr>
			<td></td>
			<?php
			for ($i=0;$i<dbnumrows($sql_comptes_bancaires_annee);$i++)
			{
				$year = dbresult($sql_comptes_bancaires_annee,$i,"year");

				echo "<td>".$year."</a></td>";
			}
			?>
			<th>TOTAL années<br>(<?php echo round($nb_mois) ?> mois)</th>
			<th>Moyenne par mois</th>
		</tr>
		</thead>
		<tbody>
		<tr>
			<th>Crédit Euros</th>
			<?php
			for ($i=0;$i<dbnumrows($sql_comptes_bancaires_annee);$i++)
			{
				$year = dbresult($sql_comptes_bancaires_annee,$i,"year");

				$sql_comptes_bancaires_sum_credit_euros_annee = dbquery("SELECT SUM(credit_euros) AS sum_credit_euros
					FROM compte_bancaire_releve
					WHERE YEAR(date) = '".$year."'");
				echo "<td>".number_format((double)dbresult($sql_comptes_bancaires_sum_credit_euros_annee,0,"sum_credit_euros"), 0, ',', ' ')." €</td>";
			}
			
			
			echo "<th>".number_format((double)dbresult($sql_comptes_bancaires_sum_credit_euros,0,"sum_credit_euros"), 2, ',', ' ')." €</th>";

			$moyenne_credit_mois = dbresult($sql_comptes_bancaires_sum_credit_euros,0,"sum_credit_euros")/$nb_mois;

			echo "<th>".number_format($moyenne_credit_mois, 2, ',', ' ')." €</th>";
			?>
		</tr>
		<tr>
			<th>Débit Euros</th>
			<?php
			for ($i=0;$i<dbnumrows($sql_comptes_bancaires_annee);$i++)
			{
				$year = dbresult($sql_comptes_bancaires_annee,$i,"year");

				$sql_comptes_bancaires_sum_debit_euros_annee = dbquery("SELECT SUM(debit_euros) AS sum_debit_euros
					FROM compte_bancaire_releve
					WHERE YEAR(date) = '".$year."'");
				echo "<td>".number_format(dbresult($sql_comptes_bancaires_sum_debit_euros_annee,0,"sum_debit_euros"), 0, ',', ' ')." €</td>";
			}

			echo "<th>".number_format(dbresult($sql_comptes_bancaires_sum_debit_euros,0,"sum_debit_euros"), 2, ',', ' ')." €</th>";

			$moyenne_debit_mois = dbresult($sql_comptes_bancaires_sum_debit_euros,0,"sum_debit_euros")/$nb_mois;

			echo "<th>".number_format($moyenne_debit_mois, 2, ',', ' ')." €</th>";
			?>
		</tr>
		<tr>
			<th>Apport initial</th>
			<td colspan='<?php echo dbnumrows($sql_comptes_bancaires_annee) ?>'></td>
			<th>
				<?php
				$apport_initial = 1000;
				echo number_format($apport_initial, 2, ',', ' ')." €";
				?></th>
		</tr>
		<tr>
			<th style='color:red'>Solde</th>
			<td colspan='<?php echo dbnumrows($sql_comptes_bancaires_annee) ?>'></td>
			<th style='color:red'>
				<?php
				$solde = dbresult($sql_comptes_bancaires_sum_credit_euros,0,"sum_credit_euros") - dbresult($sql_comptes_bancaires_sum_debit_euros,0,"sum_debit_euros") + $apport_initial;
				echo number_format((double)$solde, 2, ',', ' ')." €";
				?></th>
		</tr>
		</tbody>
		</table>

	</div>

</div>

<?php
require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/footer.inc.php");
?>