<?php
// ======================
// RENDEZ-VOUS
// --> Formulaire d'ajout
// ======================

session_start();

require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/config.global.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/dbconfig.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/lib/lib.main.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/lib/lib.db.inc.php");
?>

<script> 
$(function() {
	
	$(".tablesorter").tablesorter({
		theme : "bootstrap",
		widthFixed: true,
		widgets : [ "uitheme", "zebra" ],
		widgetOptions : {
		}
	})

	$("#tabs").tabs({ active: 1 });



	// -------------------------------
	// Permet de valider le formulaire
	// avant de l'envoyer
	// -------------------------------
	$("#form_agenda").submit(function()
	{
		$.ajax({
			type:		"GET",
			url:		"/cabinet/agenda/update.php",
			data:		$(this).serialize(),
			beforeSend:	function()
				{	$('#update').html("Modifier ce rendez-vous <div class='spinner-border spinner-border-sm' role='status'></div>");

				},
			complete:	function()
				{	
				},
			success:	function(response){ 
					$('#update').html("Modifier ce rendez-vous <i class='fa fa-check' aria-hidden='true'></i>");
				}
		 });

		return false;

	});


	$('#delete').click(function() {

		if ($('#delete').html() == "Voulez vous vraiment supprimer cette fiche ?")
		{
			$.ajax({
				type:		"GET",
				url:		"/cabinet/agenda/delete.php",
				data:		"id_agenda=<?php echo $_GET['id_agenda']?>",
				beforeSend:	function(){
					$('#delete').html("Supprimer cette fiche <div class='spinner-border spinner-border-sm' role='status'></div>");
				},
				complete:	function(){	
				},
				success:	function(response){
					if (response == "ok")
						$('#form_agenda').html("Fiche supprimée <i style='color:green' class='fa fa-check' aria-hidden='true'></i>");
				}
			 });
		 }
		
		// Changer la valeur du boutton
		$('#delete').html("Voulez vous vraiment supprimer cette fiche ?");

	});

});
</script> 

<?php
$sql_agenda = dbquery("SELECT *
	FROM clients,agenda
	WHERE clients.id_client = agenda.id_client
		AND agenda.id_agenda='".$_GET['id_agenda']."'");

if (dbnumrows($sql_agenda) > 0)
{
	$id_personnel			= dbresult($sql_agenda,0,"id_personnel");
	
	$id_client				= dbresult($sql_agenda,0,"clients.id_client");
	$nom_client				= dbresult($sql_agenda,0,"clients.nom");
	$prenom_client			= dbresult($sql_agenda,0,"clients.prenom");
	$taille					= dbresult($sql_agenda,0,"clients.taille");

	$datetime_debut			= new datetime(dbresult($sql_agenda,0,"agenda.datetime_debut"));
	$datetime_fin			= new datetime(dbresult($sql_agenda,0,"agenda.datetime_fin"));
	$id_type_rendez_vous	= dbresult($sql_agenda,0,"agenda.id_type_rendez_vous");
	$societe				= dbresult($sql_agenda,0,"agenda.societe");
	$masse					= dbresult($sql_agenda,0,"agenda.masse");
	$commentaire			= dbresult($sql_agenda,0,"agenda.commentaire");

	if ($time_fin == "00:00:00")
		$time_fin = "";

	// Identité
	$sql_personnel		= dbquery("SELECT nom,prenom FROM personnel WHERE id_personnel='".$id_personnel."'");
	$nom_personnel		= dbresult($sql_personnel,0,"nom");
	$prenom_personnel	= dbresult($sql_personnel,0,"prenom");


	$sql_client = dbquery("SELECT *
		FROM clients
		WHERE id_client='".$id_client."'");

	if (dbnumrows($sql_client) == 0)
		die("Client inexistant");

	$nom				=  htmlentities(dbresult($sql_client,0,"nom"),ENT_QUOTES);
	$prenom				=  htmlentities(dbresult($sql_client,0,"prenom"),ENT_QUOTES);
	$adresse			=  htmlentities(dbresult($sql_client,0,"adresse"),ENT_QUOTES);
	$code_postal		=  htmlentities(dbresult($sql_client,0,"code_postal"),ENT_QUOTES);
	$ville				=  htmlentities(dbresult($sql_client,0,"ville"),ENT_QUOTES);
	$pays				=  htmlentities(dbresult($sql_client,0,"pays"),ENT_QUOTES);
	$date_naissance		=  dbresult($sql_client,0,"date_naissance");

	$numero_nir			=  dbresult($sql_client,0,"numero_nir");
	$medecin_traitant	=  dbresult($sql_client,0,"medecin_traitant");

	$checked = array('homme'=>'','femme'=>'');
	if (dbresult($sql_client,0,"sexe") == 'H')	$checked['homme'] = "checked";
	else	$checked['femme'] = "checked";
	?>

	<form id='form_agenda'>
		<input type="hidden" name="id_client" value="<?php echo $id_client ?>">
		<input type="hidden" name="id_agenda" value="<?php echo $_GET['id_agenda'] ?>">

		<div id="tabs">
			<ul>
				<li><a href="#tabs-1">État civil</a></li>
				<li><a href="#tabs-2">Rendez-vous</a></li>
				<li><a href="#tabs-3">Données médicales</a></li>
				<li><a href="#tabs-4">Actes</a></li>
			</ul>
	
			<div id="tabs-1">
				<table class="tablesorter" style='width:300px' cellpadding='5'>
				<thead>
				</thead>
				<tbody>
				<tr>
					<td align='center' colspan='2'>
						<input type="radio" name="sexe" value="H" <?php echo $checked['homme'] ?>> Homme
						<input type="radio" name="sexe" value="F" <?php echo $checked['femme'] ?>> Femme
					</td>
				</tr>
				<tr>
					<td align='right' style='width:100px'>Nom :</td>
					<td style='text-align:left'><input class='form-control' id='nom' name='nom' type='text' size='15' value="<?php echo $nom ?>"></td>
				</tr>
				<tr>
					<td style='text-align:right'>Prénom :</td>
					<td style='text-align:left'><input class='form-control' id='prenom' name='prenom' type='text' size='15' value="<?php echo $prenom?>"></td>
				</tr>
				<tr>
					<td style='text-align:right'>Date de naissance :</td>
					<td style='text-align:left'><input class='form-control' id='date_naissance' name='date_naissance' type='date' style="width:130px" maxlength='10' value="<?php echo $date_naissance?>"></td>
				</tr>
				<tr>
					<td style='text-align:right'>Numéro NIR :</td>
					<td style='text-align:left'>
					
					<table>
					<tr>
						<td><input class='form-control' id='numero_nir_1' name='numero_nir_1' type='text' style='width:120px' maxlength='13' value="<?php echo substr($numero_nir,0,13)?>"></td>
						<td><input class='form-control' id='numero_nir_2' name='numero_nir_2' type='text' style='width:42px' maxlength='2' value="<?php echo substr($numero_nir,13,2)?>"></td>
					</tr>
					</table>
					
					</td>
				</tr>
				<tr>
					<td style='text-align:right'>Adresse :</td>
					<td style='text-align:left'><textarea class="form-control" name="adresse" rows="3" cols="25"><?php echo $adresse?></textarea></td>
				</tr>
				<tr>
					<td style='text-align:right'>Code postal :</td>
					<td style='text-align:left'><input class='form-control' id='code_postal' name='code_postal' type='text' size='5' maxlength='5' value="<?php echo $code_postal?>"></td>
				</tr>
				<?php
				// --------------
				// Les téléphones
				// --------------
				$sql_client_telephone = dbquery("SELECT *
					FROM clients_telephone
					WHERE id_client = '".dbresult($sql_agenda,$i,"id_client")."'
					ORDER BY type_telephone ASC");
				for ($j=0;$j<dbnumrows($sql_client_telephone);$j++)
				{
					$type_telephone	= dbresult($sql_client_telephone,$j,"type_telephone");
					$telephone		= dbresult($sql_client_telephone,$j,"telephone");
					$contact		= dbresult($sql_client_telephone,$j,"contact");
					
					echo "<tr><td style='text-align:right'>Tel. ".substr($type_telephone,0,4)." :</td>";
					echo "<td style='width:100px'>".$telephone." ".$contact."</td></tr>";
				}
				?>
				<tr>
					<td style='text-align:right'>Ville :</td>
					<td style='text-align:left'><input class='form-control' id='ville' name='ville' type='text' size='15' value="<?php echo $ville?>"></td>
				</tr>
				<tr>
					<td style='text-align:right'>Pays :</td>
					<td style='text-align:left'><input class='form-control' id='pays' name='pays' type='text' size='15' value="<?php echo $pays?>"></td>
				</tr>
				<tr>
					<td style='text-align:right'>Médecin traitant :</td>
					<td style='text-align:left'><input class='form-control' id='medecin_traitant' name='medecin_traitant' type='text' size='15' value="<?php echo $medecin_traitant?>"></td>
				</tr>
				</tbody>
				</table>
			</div>

			<div id="tabs-2">
				<table id="table2" class="tablesorter" style="width:380px">
				<thead>
				</thead>
				<tbody>
				<tr>
					<td style="width:120px"><b>RV saisi par :</b></td>
					<td colspan='3'><?php echo $prenom_personnel ?> <?php echo $nom_personnel ?></td>
				</tr>
				<tr>
					<td><b>Client</b></td>
					<td colspan='3'>
					<?php
					echo "<span style='font-weight:bold;color:blue'>".$nom_client." ".$prenom_client."</span>";
					
					// --------------
					// Les téléphones
					// --------------
					echo "<table style='width:100%'>";
					$sql_client_telephone = dbquery("SELECT *
						FROM clients_telephone
						WHERE id_client = '".dbresult($sql_agenda,$i,"id_client")."'
						ORDER BY type_telephone ASC");
					for ($j=0;$j<dbnumrows($sql_client_telephone);$j++)
					{
						$type_telephone	= dbresult($sql_client_telephone,$j,"type_telephone");
						$telephone		= dbresult($sql_client_telephone,$j,"telephone");
						$contact		= dbresult($sql_client_telephone,$j,"contact");
						
						echo "<tr><td style='width:70px'>Tel. ".substr($type_telephone,0,4)."</td>";
						echo "<td>".$telephone."</td>";
						echo "<td>".$contact."</td></tr>";
					}
					echo "</table>";
					?>
					</td>
				</tr>
				<tr>
					<td><b>Date :</b></td>
					<td colspan='3'><input class="form-control" type="date" id="date" name="date" style='width:170px' maxlength='10' value='<?php echo $datetime_debut->format('Y-m-d') ?>'></td>
				</tr>
				<tr>
					<td><b>Plage horaire&nbsp;:</b></td>
					<td><input class='form-control' id='time_debut' name='time_debut' type="time" class="form-control" value="<?php echo $datetime_debut->format('H:i')?>"></td>
					<td>à</td>
					<td><input class='form-control' id='time_fin' name='time_fin' type="time" class="form-control" value="<?php echo $datetime_fin->format('H:i')?>"></td>
				</tr>
				<tr>
					<td><b>Type rendez vous</b></td>
					<td colspan='3'>
						<select class="form-select" name="id_type_rendez_vous">
							<?php			
							// -----------------
							// Type rendez vous
							// -----------------
							$sql_type_rendez_vous = dbquery("SELECT * FROM type_rendez_vous ORDER BY id_type_rendez_vous ASC");
							for ($i=0;$i<dbnumrows($sql_type_rendez_vous);$i++)
							{
								if ($id_type_rendez_vous == dbresult($sql_type_rendez_vous,$i,"id_type_rendez_vous"))	$selected = " selected";
								else $selected = "";
							
								echo "<option value='".dbresult($sql_type_rendez_vous,$i,"id_type_rendez_vous")."'".$selected.">".dbresult($sql_type_rendez_vous,$i,"intitule")."</option>";
							}
							?>
						</select>
					</td>
				</tr>
				<tr>
					<td><b>Société</b></td>
					<td colspan='3'>
						<input class='form-control' type="text" name="societe" value="<?php echo htmlentities($societe) ?>">
					</td>
				</tr>
				<tr>
					<td><b>Commentaire</b></td>
					<td colspan='3'><textarea class="form-control" name="commentaire" rows="3" cols="40"><?php echo $commentaire ?></textarea></td>
				</tr>
				</tbody>
				</table>

				<p>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</p>
			</div>

			<div id="tabs-3">

				<table id="table3" class="tablesorter" style="width:500px">
				<thead>
				</thead>
				<tbody>
				<tr>
					<td style="width:120px"><b>Taille (cm) :</b></td>
					<td><input class="form-control" type="text" id="taille" name="taille" style='width:50px' maxlength='3' value='<?php echo $taille ?>'></td>
				</tr>
				<tr>
					<td style="width:120px"><b>Masse (kg)<br></b><span style='font-style: italic'>Uniquement ce rendez-vous</span>:</td>
					<td><input class="form-control" type="text" id="masse" name="masse" style='width:60px' maxlength='5' value='<?php echo $masse ?>'></td>
				</tr>
				<tr>
				</tbody>
				</table>

				<p>&nbsp;</p>
				<p>&nbsp;</p>
				<p>&nbsp;</p>
				<p>&nbsp;</p>
			</div>

			<div id="tabs-4">

				<table id="table4" class="tablesorter" style="width:500px">
				<thead>
				</thead>
				<tbody>

				<?php
				$sql_agenda_ccam = dbquery("SELECT *
					FROM ccam
					ORDER BY code_ccam ASC");
				
				for ($k=0;$k<dbnumrows($sql_agenda_ccam);$k++)
				{
					$sql_agenda_ccam_checked = dbquery("SELECT *
						FROM agenda_ccam
						WHERE id_agenda='".$_GET['id_agenda']."'
							AND code_ccam='".dbresult($sql_agenda_ccam,$k,"code_ccam")."'");

					if (dbnumrows($sql_agenda_ccam_checked) > 0)	$checked_ccam = " checked";
					else $checked_ccam = "";
					
					echo "<tr><td style='width:30px'><input type='checkbox' name='code_ccam[".dbresult($sql_agenda_ccam,$k,"code_ccam")."]' value='1'".$checked_ccam."></td>";
					echo "<td>".dbresult($sql_agenda_ccam,$k,"code_ccam")."</td>";
					echo "<td>".dbresult($sql_agenda_ccam,$k,"libelle")."</td></tr>";
				}
				?>
				</tbody>
				</table>

			</div>
		</div>
		
		<button type='submit' id='update' class="btn btn-primary">Modifier ce rendez-vous</button>&nbsp;&nbsp;&nbsp;&nbsp;
		<button type="button" id="delete" class="btn btn-danger">Supprimer cette fiche</button></td>
	</form>
	<?php
}
else
	echo "<div class='warning'>Attention, cette plannification (".$_GET['id_agenda'].") n'existe pas dans la base ou a été effacé. Merci</div> "
?>