<?php

/**
 * # Instantiate. Visit https://eu.api.ovh.com/createToken/ or https://eu.api.ovh.com/createToken/?GET=/sms/&GET=/sms/*/jobs/&POST=/sms/*/jobs/
 * to get your credentials
 * GET /sms/
 * GET/sms/sms-XXXXXX-1/jobs/
 * POST /sms/sms-XXXXXX-1/jobs/
 */

require __DIR__ . '/vendor/autoload.php';
use \Ovh\Api;

$applicationKey = "your_app_key";
$applicationSecret = "your_app_secret";
$consumer_key = "your_consumer_key";

$endpoint = 'ovh-eu';

$conn = new Api(    $applicationKey,
                    $applicationSecret,
                    $endpoint,
                    $consumer_key);
     
$smsServices = $conn->get('/sms/');

foreach ($smsServices as $smsService) {

    print_r($smsService);
}

$content = (object) array(
	"charset"=> "UTF-8",
	"class"=> "phoneDisplay",
	"coding"=> "7bit",
	"message"=> "Bonjour les SMS OVH par api.ovh.com",
	"noStopClause"=> false,
	"priority"=> "high",
	"receivers"=> [ "+33662043549" ],
	"senderForResponse"=> true,
	"validityPeriod"=> 2880
	);

$resultPostJob = $conn->post('/sms/'. $smsServices[0] . '/jobs/', $content); //appel sur le 1er compte SMS

print_r($resultPostJob);

$smsJobs = $conn->get('/sms/'. $smsServices[0] . '/jobs/');
print_r($smsJobs);
        
?>