<?php
session_start();

require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/config.global.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/dbconfig.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/lib/lib.main.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/lib/lib.db.inc.php");


$compteur = 0;

$sql_personnel = dbquery("SELECT * FROM personnel WHERE id_personnel='".$_SESSION['id_personnel']."'");
if (dbnumrows($sql_personnel) == 0)
	exit;

// -----
// Deces
// -----
$agenda_deces = dbresult($sql_personnel,0,"agenda_deces");

if ($agenda_deces == 'all')		$where_deces = "1=1";
if ($agenda_deces == 'vivant')	$where_deces = "clients.deces='0'";
if ($agenda_deces == 'deces')	$where_deces = "clients.deces='1'";


$datetime_calendar_start	= new DateTime($_GET['start']);
$datetime_calendar_end		= new DateTime($_GET['end']);


// --------------------
// Agenda
// --------------------
// Types de rendez vous
//  -> Consultation
//  -> EFR / Sommeil
//  -> Autre
// --------------------

$sql_agenda = dbquery("SELECT * FROM agenda,type_rendez_vous,personnel_type_rendez_vous_groupe,clients
	WHERE agenda.id_type_rendez_vous=type_rendez_vous.id_type_rendez_vous
		AND type_rendez_vous.id_type_rendez_vous_groupe = personnel_type_rendez_vous_groupe.id_type_rendez_vous_groupe
		AND personnel_type_rendez_vous_groupe.id_personnel = '".$_SESSION['id_personnel']."'
		AND agenda.datetime_debut >= '".$datetime_calendar_start->format('Y-m-d')." 00:00:00'
		AND agenda.datetime_debut <= '".$datetime_calendar_end->format('Y-m-d')." 23:59:59'
		AND agenda.id_client = clients.id_client
		AND ".$where_deces."
	ORDER BY agenda.datetime_debut ASC");

for ($i=0;$i<dbnumrows($sql_agenda);$i++)
{
	$id_agenda		= dbresult($sql_agenda,$i,"agenda.id_agenda");
	$id_client		= dbresult($sql_agenda,$i,"agenda.id_client");

	$commentaire	= dbresult($sql_agenda,$i,"agenda.commentaire");

	$sql_agenda_client = dbquery("SELECT * FROM clients
		WHERE id_client = '".$id_client."'
		AND ".$where_deces);
	
	if (dbnumrows($sql_agenda_client) > 0)
	{
		$nom	= dbresult($sql_agenda_client,0,"nom");
		$prenom	= dbresult($sql_agenda_client,0,"prenom");

		$title = $nom." ".$prenom;
	}
	else
	{
		// Limite la taille du commentaire
		$title = substr(htmlentities(addslashes($commentaire)),0,10);
	}

	
	$datetime_debut	= new datetime(dbresult($sql_agenda,$i,"agenda.datetime_debut"));
	$datetime_fin	= new datetime(dbresult($sql_agenda,$i,"agenda.datetime_fin"));
	
	$type_rendez_vous	= dbresult($sql_agenda,$i,"type_rendez_vous.intitule");
	$background_color	= dbresult($sql_agenda,$i,"type_rendez_vous.background_color");
	$border_color		= dbresult($sql_agenda,$i,"type_rendez_vous.border_color");
	

	$data[$compteur++] = array(
			'id'	=> $id_agenda,
			'title' => addslashes($title),
			'start' => substr($datetime_debut->format('c'),0,19),
			'end'	=> substr($datetime_fin->format('c'),0,19),
			'backgroundColor'	=> "#".$background_color,
			'borderColor'		=> "#".$border_color,
			'textColor'	=> 'black',
			'allDay'	=>  false
		);
}



// --------------------
// Affichage des congés
// --------------------
$sql_personnel_conges = dbquery("SELECT personnel_conges.id_personnel_conge,personnel.nom,personnel.prenom,personnel_conges.nom,datetime_debut,datetime_fin
	FROM personnel,personnel_conges
	WHERE personnel.id_personnel = personnel_conges.id_personnel
	ORDER BY personnel_conges.datetime_debut ASC");

for ($i=0;$i<dbnumrows($sql_personnel_conges);$i++)
{
	$id_personnel_conge	= dbresult($sql_personnel_conges,$i,"id_personnel_conge");
	$nom_personnel		= dbresult($sql_personnel_conges,$i,"nom");
	$prenom_personnel	= dbresult($sql_personnel_conges,$i,"prenom");
	$nom_conges			= dbresult($sql_personnel_conges,$i,"nom");

	$datetime_debut		= new DateTime(dbresult($sql_personnel_conges,$i,"datetime_debut"));
	$datetime_fin		= new DateTime(dbresult($sql_personnel_conges,$i,"datetime_fin"));

	$periode_conge		= format_periode_horaire($datetime_debut,$datetime_fin);

	$data[$compteur++] = array(
		'id'				=> "conge_classique_".$id_personnel_conge,
		'title'				=> $periode_conge." : ".$nom_conges." - ".$prenom_personnel." ".$nom_personnel,
		'start'				=> $datetime_debut->format('Y-m-d'),
		'end'				=> $datetime_fin->format('Y-m-d'),
		'backgroundColor'	=> "#ffff66",
		'borderColor'		=> "#ffcc00",
		'textColor'			=> 'black',
		'allDay'			=>  true
	);
}

// -----------------------------
// Affichage des congés cyclique
// -----------------------------
$sql_personnel_conges_cyclique = dbquery("SELECT personnel.*,personnel_conges_cyclique.*
	FROM personnel,personnel_conges_cyclique
	WHERE personnel.id_personnel = personnel_conges_cyclique.id_personnel
		AND DATE(personnel_conges_cyclique.date_debut) <= '".$datetime_calendar_end->format('Y-m-d')."'
	ORDER BY personnel_conges_cyclique.date_debut ASC");

for ($i=0;$i<dbnumrows($sql_personnel_conges_cyclique);$i++)
{
	$id_personnel_conge_cyclique	= dbresult($sql_personnel_conges_cyclique,$i,"id_personnel_conge_cyclique");
	$nom_conge_cyclique				= dbresult($sql_personnel_conges_cyclique,$i,"nom");
	$datetime_debut					= new DateTime(dbresult($sql_personnel_conges_cyclique,$i,"date_debut"));
	$datetime_fin					= new DateTime(dbresult($sql_personnel_conges_cyclique,$i,"date_fin"));
	$jour_semaine					= $datetime_debut->format('l');
	$time_debut						= dbresult($sql_personnel_conges_cyclique,$i,"time_debut");
	$time_fin						= dbresult($sql_personnel_conges_cyclique,$i,"time_fin");
	$periodicite					= dbresult($sql_personnel_conges_cyclique,$i,"periodicite");

	$id_personnel					= dbresult($sql_personnel_conges_cyclique,$i,"id_personnel");
	$nom_personnel					= dbresult($sql_personnel_conges_cyclique,$i,"nom");
	$prenom_personnel				= dbresult($sql_personnel_conges_cyclique,$i,"prenom");


	$daysOfWeek = "";
	if ($periodicite == "week")
		$daysOfWeek = $datetime_debut->format('N');


	$data[$compteur++] = array(
		'id'				=> "conge_cyclique_".$id_personnel_conge_cyclique,
		'title'				=> $nom_conge_cyclique." - ".$prenom_personnel." ".$nom_personnel." (cyclique)",
		'startTime'			=> $time_debut,
		'endTime'			=> $time_fin,
		'startRecur'		=> $datetime_debut->format('Y-m-d'),
		'endRecur'			=> $datetime_fin->format('Y-m-d'),
		'backgroundColor'	=> "#ffff66",
		'borderColor'		=> "#ffcc00",
		'textColor'			=> "black",
		'daysOfWeek'		=> $daysOfWeek
	);
}



// -----------
// Jours ferié
// -----------
$sql_jours_feries = dbquery("SELECT date,nom
	FROM jours_feries	
	WHERE date BETWEEN '".$_GET['start']."' AND '".$_GET['end']."'");

for ($i=0;$i<dbnumrows($sql_jours_feries);$i++)
{
	$date	= dbresult($sql_jours_feries,$i,"date");		
	$nom	= dbresult($sql_jours_feries,$i,"nom");

	$data[$compteur++] = array(
		'id'	=> "ferie_".$date,
		'title'	=> "FERIÉ : ".addslashes($nom),
		'start'	=> $date,
		'end'	=> $date,
		'backgroundColor' => "#ffcc33",
		'borderColor' => "#ff6600",
		'textColor' => 'black',
		'allDay' =>  true
	);
}

 // jQuery wants JSON data
echo json_encode($data);