<?php
// ===================
// RENDEZ-VOUS
// --> Choix du client
// ===================

session_start();

require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/config.global.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/dbconfig.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/lib/lib.main.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/lib/lib.db.inc.php");


// 2019-02-16T07:00:00 +04:00 --> 2019-02-16T07:00:00
$datetime_debut = new DateTime(substr($_GET['datetime_debut'],0,19));
?>

<style type="text/css">
.ui-autocomplete {
    z-index: 99999;
}
</style>

<script> 
$(function() {
	$( "#search_client" ).autocomplete({
		source: "/cabinet/consultations/gestion_clients/autocomplete_clients.php",
		minLength: 2,
		dataType: "jsonp",
		select: function( event, ui ){

			$( "#container" ).load('/cabinet/agenda/add_form.php?datetime_debut=<?php echo $datetime_debut->format('Y-m-d')."T".$datetime_debut->format('H:i') ?>&search_client=' + encodeURI(ui.item.value))
			
		}
	});


	$("#add_client").click(function()
	{
		$.ajax({
			type:		"GET",
			url:		"/cabinet/consultations/gestion_clients/add.php",
			data:		"timestamp=<?php echo time() ?>",
			beforeSend:	function(){
			},
			complete:	function(){	
			},
			success:	function(id_client) {
				if (id_client != "")
				{
					document.location.href='/cabinet/consultations/gestion_clients/index.php?id_client='+id_client;
				}
			}
		 });

	});

});
</script> 


<div id='container'>
	<form id='form_search_client'>
		<input type="hidden" name="datetime_debut"	value="<?php echo $datetime_debut->format('Y-m-d')."T".$datetime_debut->format('H:i') ?>">
		
		<table id="table" cellpadding='5'>
		<thead>
		</thead>
		<tbody>
		<tr>
			<td style='font-weight:bold'>Déjà client :</td>
			<td><input class='form-control' type='text' name='search_client' id='search_client' style='width:150px'></td>
		</tr>
		<tr>
			<td style="width:120px"><b>Si nouveau client :</b></td>
			<td><button id='add_client' type='button' class="btn btn-success"><img src="/images/icomoon/16px/user.png" width="16" height="16" border="0" alt="">Nouveau client</button></td>
		</tr>
		</tbody>
		</table>
		
		<input type="hidden" name="id_personnel" value="<?php echo $_SESSION['id_personnel']?>">
	</form>
</div>