<?php
// ====================
// Logs des Erreurs SQL
// --> par jour
// ====================

session_start();

require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/config.global.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/dbconfig.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/lib/lib.main.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/lib/lib.db.inc.php");



// Jour precedent, actuel et suivant
$date					= new DateTime($_GET['date']);
$date_jour_precedent	= new DateTime($_GET['date']);
$date_jour_suivant		= new DateTime($_GET['date']);

$date_jour_precedent->modify('-1 day');
$date_jour_suivant->modify('+1 day');
?>


<script type='text/javascript'>
$(document).ready(function() {

	$(".tablesorter").tablesorter({
		theme : "bootstrap",
		widthFixed: true,
		widgets : [ "uitheme", "zebra" ],
		widgetOptions : {
		}
	});

	$("#previous").click(function() {

		$("#ajax").load("index_ajax.php?date=<?php echo $date_jour_precedent->format('Y-m-d') ?>");
	
	});

	$("#next").click(function() {

		$("#ajax").load("index_ajax.php?date=<?php echo $date_jour_suivant->format('Y-m-d') ?>");
	});

	$(".delete").click(function() {

		id_log_sql_error = $(this).attr('id');
	
		$.ajax({
			type:		"GET",
			url:		"delete.php",
			data:		"id_log_sql_error="+id_log_sql_error,
			beforeSend:	function() {
					
				},
			complete:	function() {	
				},
			success:	function(response) { 

				$("#ajax").load("index_ajax.php?date=<?php echo $date->format('Y-m-d') ?>");
			}
		});

	});

});

</script>


<!-- PREVIOUS -->
<i style="position:absolute;top:0px; left:70px; width:20px; font-weight:bold; text-align:left; color:#6C7D96; cursor:pointer" id='previous' class="bi bi-chevron-left fa-2x"></i>

<!-- DATE EN COURS -->
<div style="position:absolute;top:3px; left:90px; width:380px; font-weight:bold; text-align:center"><?php echo date_iso_fr_complete($date->format("Y-m-d")) ?></div>

<!-- NEXT -->
<i style="position:absolute;top:0px; left:470px; width:20px; font-weight:bold; text-align:right;  color:#6C7D96; cursor:pointer" id='next' class="bi bi-chevron-right fa-2x"></i>



<table class="tablesorter" style="position:absolute;top:50px;">
<thead>
<tr>
	<th></th>
	<th>Date & Heure</th>
	<th>Requete SQL</th>
	<th>Erreur</th>
	<th>Personnel connecté</th>
	<th>Adresse IP</th>
	<th>Fichier</th>
</tr>
</thead>
<tbody>

<?php
$log_sql_error = dbquery("SELECT * FROM log_sql_error
	WHERE DATE(datetime) = '".$_GET['date']."'
	ORDER BY datetime");

for ($i=0;$i<dbnumrows($log_sql_error);$i++)
{		
	$id_log_sql_error		= dbresult($log_sql_error,$i,"id_log_sql_error");
	$datetime				= dbresult($log_sql_error,$i,"datetime");
	$requete				= dbresult($log_sql_error,$i,"requete");
	$erreur					= dbresult($log_sql_error,$i,"erreur");
	$id_personnel			= dbresult($log_sql_error,$i,"id_personnel");
	$adresse_ip_client		= dbresult($log_sql_error,$i,"adresse_ip_client");
	$fichier				= dbresult($log_sql_error,$i,"fichier");

	$log_sql_error_personnel = dbquery("SELECT nom,prenom FROM personnel WHERE id_personnel = '".$id_personnel."'");
	if (dbnumrows($log_sql_error_personnel) > 0)
		$personnel = dbresult($log_sql_error_personnel,0,"prenom")." ".dbresult($log_sql_error_personnel,0,"nom");
	else
		$personnel = "?";

	$from = array(
		"SELECT",
		"DISTINCT",
		"COUNT",
		"MIN",
		"MAX",
		"AS",
		"INSERT INTO",
		"VALUES",
		"UPDATE",
		"DELETE",
		"SET",
		"FROM",
		"WHERE",
		"GROUP BY",
		"ORDER BY",
		" AND",
		" OR");

	$to   = array(
		"<b><font color='red'>SELECT</font></b>",
		"<b><font color='red'>DISTINCT</font></b>",
		"<b><font color='red'>COUNT</font></b>",
		"<b><font color='red'>MIN</font></b>",
		"<b><font color='red'>MAX</font></b>",
		"<b><font color='red'>AS</font></b>",
		"<b><font color='red'>INSERT INTO</font></b>",
		"<b><font color='red'>VALUES</font></b>",
		"<b><font color='red'>UPDATE</font></b>",
		"<b><font color='red'>DELETE</font></b>",
		"<b><font color='red'>SET</font></b>",
		"<b><font color='red'>FROM</font></b>",
		"<b><font color='red'>WHERE</font></b>",
		"<b><font color='red'>GROUP BY</font></b>",
		"<b><font color='red'>ORDER BY</font></b>",
		" <b><font color='green'>AND</font></b>",
		" <b><font color='green'>OR</font></b>");

	$requete_color = str_replace($from,$to,$requete);
	
	echo "<tr id=".$i.">";
	echo "<td style='text-align:center'><i id='".$id_log_sql_error."' style='color:red;cursor:pointer' class='delete fa fa-trash fa-lg'></i></a></td>";
	echo "<td>".$datetime."</td>";
	echo "<td>".$requete_color."</td>";
	echo "<td>".$erreur."</td>";
	echo "<td style='color:red'>".$personnel."</td>";
	echo "<td>".$adresse_ip_client."</td>";
	echo "<td>".str_replace(".php?",".php?<br>",$fichier)."</td></tr>";
}
?>

</tbody>
</table>