<?php
// JPGraph
require_once("../../../../lib/jpgraph-4.2.6/src/jpgraph.php");
require_once("../../../../lib/jpgraph-4.2.6/src/jpgraph_pie.php");
require_once("../../../../lib/jpgraph-4.2.6/src/jpgraph_pie3d.php");
require_once("../../../../lib/jpgraph-4.2.6/src/jpgraph_bar.php");

// Some data
$data = array($_GET['espace_utilise'],$_GET['espace_libre']);

// Create the Pie Graph.
$graph = new PieGraph($_GET['width'],$_GET['height'],"auto");
$graph->SetAntiAliasing();
$graph->SetShadow();


// Title
$graph->title->Set($_GET['nom']);
$graph->title->SetFont(FF_VERDANA,FS_BOLD,$_GET['font_size']+2);
$graph->title->SetColor("darkblue");

// Legend
$graph->legend->SetFont(FF_VERDANA,FS_NORMAL,$_GET['font_size']-2);
$graph->legend->SetVColMargin($_GET['font_size']-2); 
$graph->legend->Pos(0.05,0.15);

// Create pie plot
$p1 = new PiePlot3d($data);
$p1->SetSliceColors(array('dodgerblue','pink'));
$p1->SetCenter(0.4);
$p1->SetAngle(30);
$p1->value->SetFont(FF_ARIAL,FS_NORMAL,12);
$p1->SetLegends(array("Utilisé","Libre"));


$graph->Add($p1);
if ($_GET['generate_image'] == 1)	$graph->Stroke("generated_images/pie_3d_hommes_femmes.png");
else	$graph->Stroke();

?>