<?php
// ====================
// Logs des Erreurs PHP
// --> par jour
// ====================

session_start();

require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/config.global.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/dbconfig.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/lib/lib.main.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/lib/lib.db.inc.php");

$key_not_dont_take_care = array(
		'favicon.ico',
		'robots.txt',
		'ocsinventory',
		'wamp/www/scripts',
		'wamp/www/admin',
		'wamp/www/db',
		'wamp/www/dbadmin',
		'wamp/www/myadmin',
		'wamp/www/mysql',
		'wamp/www/mysqladmin',
		'wamp/www/mysql-admin',
		'wamp/www/phpadmin',
		'wamp/www/pma',
		'wamp/www/xampp',
		'wamp/www/php-my-admin',
		'wamp/www/websql',
		'wamp/apps/phpmyadmin',
		'wamp/www/phpmyadmin',
		'wamp/www/php-my-admin',
		'wamp/www/sqlmanager',
		'wamp/www/mysqlmanager',
		'wamp/www/pma2005',
		'wamp/www/phpmanager',
		'wamp/www/php-myadmin',
		'wamp/www/phpmy-admin',
		'wamp/www/webadmin',
		'wamp/www/sqlweb',
		'wamp/www/webdb');


// Creer un tableau qui contient la liste
// des dates des erreurs PHP
// exemple :
// Array
//(
//    [0] => 2008-02-15
//    [1] => 2008-02-16
//    [2] => 2008-02-17
//    [3] => 2008-02-18
//) 


$filename = '../../../../../logs/apache_error.log';

if (file_exists($filename) == false)
	die("Le fichier $filename n'existe pas");

$string = file_get_contents($filename, "r");

$tab = explode("\n",$string);


// Jour precedent, actuel et suivant
$date					= new DateTime($_GET['date']);
$date_jour_precedent	= new DateTime($_GET['date']);
$date_jour_suivant		= new DateTime($_GET['date']);

$date_jour_precedent->modify('-1 day');
$date_jour_suivant->modify('+1 day');
?>

<script type='text/javascript'>
$(document).ready(function() {

	$(".tablesorter").tablesorter({
		theme : "bootstrap",
		widthFixed: true,
		widgets : [ "uitheme", "zebra" ],
		widgetOptions : {
		}
	});

	$("#previous").click(function() {

		$("#ajax").load("index_ajax.php?date=<?php echo $date_jour_precedent->format('Y-m-d') ?>");
	
	});

	$("#next").click(function() {

		$("#ajax").load("index_ajax.php?date=<?php echo $date_jour_suivant->format('Y-m-d') ?>");
	});
});

</script>

<div style="position:relative;top:0px;left:20px">

	<!-- PREVIOUS -->
	<i style="position:absolute;top:0px; left:70px; width:20px; font-weight:bold; text-align:left; color:#6C7D96; cursor:pointer" id='previous' class="bi bi-chevron-left fa-2x"></i>

	<!-- DATE EN COURS -->
	<div style="position:absolute;top:3px; left:90px; width:380px; font-weight:bold; text-align:center"><?php echo date_iso_fr_complete($date->format("Y-m-d")) ?></div>

	<!-- NEXT -->
	<i style="position:absolute;top:0px; left:470px; width:20px; font-weight:bold; text-align:right;  color:#6C7D96; cursor:pointer" id='next' class="bi bi-chevron-right fa-2x"></i>

	<table class="tablesorter" style="position:absolute;top:50px;">
	<thead>
	<tr>
		<th width="40" style='text-align:center'>Heure</th>
		<th style='text-align:center'>Erreur</th>
	</tr>
	</thead>
	<tbody>
	
	<?php
	$i = 0;
	foreach($tab as $value)
	{
		if (substr($value,0,1) == "[")
		{
			$date = new DateTime(substr($value,1,19)." ".substr($value,28,4));
			
			if ($date->format('Y-m-d') == $_GET['date'])
			{
				// Limite l'afficage a : Derniere heure / 4 dernieres heures / Toute la journée
				if ($timestamp - $timestamp_from < 0)	continue;
				
				$heure	= $date->format("H:i:s");			
				$erreur	= substr($value,33);
			
				
				// N'affiche pas certaines errreurs
				$continue = false;
				foreach ($key_not_dont_take_care  as $key => $value)
				{
					if (stristr ($erreur, $value))	$continue = true;
				}
				if ($continue == true)	continue;

				
				preg_match("(\[[a-z]*\])", $erreur, $type_erreur);

				if ($_GET['notice'] <> 1 && $type_erreur[0] == "[notice]" )	continue;
				if ($_GET['warn'] <> 1   && $type_erreur[0] == "[warn]" )	continue;
				if ($_GET['error'] <> 1  && $type_erreur[0] == "[error]" )	continue;
				
				if ($i++%2 == 0)	$class = "odd";
				else $class = "even";

				// Met de la couleur pour error, warn et notice
				$from 		= array("[:error]", "[:warn]", "[:notice]");
				$to   		= array("<span style='color:red;font-weight:bold'>[:error]</span>", "<span style='color:orange'>[:warn]</span>", "<span style='color:green'>[:notice]</span>");
				
				$erreur = str_replace($from, $to, $erreur);

				echo "<tr><td>".$heure."</td><td>".$erreur."</td></tr>";
			}
		}
	}
	?>
	</tbody>
	</table>

</div>