<?php
// =============
// BIBLIOTHEQUES
// --> pdf
// =============

session_start();


require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/config.global.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/dbconfig.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/lib/lib.main.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/lib/lib.db.inc.php");

libraries(array('tcpdf'));

// A4 portrait
// (0,0)               (210,0)
//   +-------------------+
//   |         |         |
//   +---------+---------+
//   |         |         |
//   +---------+---------+
//   |         |         |
//   +---------+---------+
//   |         |         |
//   +---------+---------+
//   |         |         |
//   +-------------------+
// (0,297)             (210,297)


// Extend the TCPDF class to create custom Header and Footer
class MYPDF extends TCPDF {


	public function rubrique($x,$y,$text)
	{
		$this -> SetFontSize(10);
		$this->SetFillColor(0, 100, 80, 20);
		$this->SetTextColor(0, 0, 0, 0);
		$this->Rect($x, $y, 185, 6, 'DF');
		$this->Text($x, $y+1, $text);
		$this -> SetTextColor(0,0,0);
	}
	
	// Cadre Rouge
	public function cadre_rouge($message,$x_start,$y_start,$width,$height)
	{
		$bordure_rouge_cnam	= array(193, 0, 42);

		$this -> SetLineStyle(array('width' => 0.2, 'cap' => 'round', 'join' => 'round', 'dash' => 0, 'color' => $bordure_rouge_cnam));
		
		$this->setXY($x_start,$y_start);
		$this->SetFillColor(255, 255, 255);
		$this->SetFont('helvetica', 'B', 10);
		$this->SetTextColor(193, 0, 42);
		$this->Cell($width, $height, $message, 1, 0, 'C', $align = '', $fill = false, $link = '', $stretch = 0, $ignore_min_height = false,
$calign = 'T', $valign = 'C' );
		$this->SetFont('helvetica', '', 10);
		$this->SetTextColor(0,0,0);
	}

	
	// Table
	public function Table($header,$data,$x,$height_line,$nb_lines_max,$is_html=false,$display_header=true)
	{
		
		// Nb lignes max = nb lignes de $data
		// --> Si non precisé
		if ($nb_lines_max == "")
			$nb_lines_max = count($data);

		// Colors, line width and bold font
		$this->SetFillColor(255, 255, 255);
		$this->SetTextColor(0,0,0);
		$this->SetDrawColor(0, 100, 80, 20);
		$this->SetLineWidth(0.3);
		$this->SetFont('', 'B');
		

		/*
		Exemple avec 
		  -> nb_lines_max = 5
		  -> count(data)  = 17

[0] =>	+-----+--------------------+------------------+---------+-----------------------------------+------+------+
		| Nom | Proto.             | Domaine          | Version | Nom fichier                       | Type | Hash |
		+-----+--------------------+------------------+---------+-----------------------------------+------+------+
		| 1   | jquery             | http www.cnam.re | 2.2.4   | jquery.min.js                     | js   |  x   |
		| 2   | jqueryui           | http www.cnam.re | 1.12.1  | jquery-ui.min.js                  | js   |      |
		| 2   | jqueryui           | http www.cnam.re |         | jquery.ui.datepicker-fr.js        | js   |      |
		| 2   | jqueryui           | http www.cnam.re | 1.12.1  | jquery-ui.min.css                 | css  |      |
		| 3   | twitter-bootstrap  | http www.cnam.re | 4.1.3   | bootstrap.min.js                  | js   |  x   |
		+-----+--------------------+------------------+---------+-----------------------------------+------+------+

		(addPage)
[1] =>	+-----+--------------------+------------------+---------+-----------------------------------+------+------+
		| Nom | Proto.             | Domaine          | Version | Nom fichier                       | Type | Hash |
		+-----+--------------------+------------------+---------+-----------------------------------+------+------+
		| 3   | twitter-bootstrap  | http www.cnam.re | 4.1.3   | bootstrap.min.css                 | css  |  x   |
		| 4   | jquery-validate    | http www.cnam.re | 1.19.1  | jquery.validate.js                | js   |  x   | 
		| 5   | font-awesome       | http www.cnam.re | 4.7.0   | font-awesome.min.css              | css  |  x   | 
		| 6   | fancybox           | http www.cnam.re | 3.0.47  | jquery.fancybox.min.js            | js   |  x   | 
		| 6   | fancybox           | http www.cnam.re | 3.0.47  | jquery.fancybox.min.css           | css  |  x   |
		+-----+--------------------+------------------+---------+-----------------------------------+------+------+

		(addPage)
[2] =>	+-----+--------------------+------------------+---------+-----------------------------------+------+------+
		| Nom | Proto.             | Domaine          | Version | Nom fichier                       | Type | Hash |
		+-----+--------------------+------------------+---------+-----------------------------------+------+------+
		| 7   | jquery.tablesorter | http www.cnam.re 2.32.1    | jquery.tablesorter.min.js         | js   |      |
		| 7   | jquery.tablesorter | http www.cnam.re 2.32.1    | jquery.tablesorter.widgets.min.js | js   |      |
		| 7   | jquery.tablesorter | http www.cnam.re 2.32.1    | theme.bootstrap.min.css           | css  |      |
		| 8   | jeditable.js       | http www.cnam.re 1.7.3     | jquery.jeditable.js               | js   |  x   |
		| 9   | tinymce            | http www.cnam.re 5.0.3     | tinymce.min.js                    | js   |  x   |
		+-----+--------------------+------------------+---------+-----------------------------------+------+------+

		(addPage)
[3] =>	+-----+--------------------+------------------+---------+-----------------------------------+------+------+
		| Nom | Proto.             | Domaine          | Version | Nom fichier                       | Type | Hash |
		+-----+--------------------+------------------+---------+-----------------------------------+------+------+
		| 10  | moment.js          | http www.cnam.re | 2.24.0  | fr.js                             | js   |  x   |
		| 10  | moment.js          | http www.cnam.re | 2.24.0  | moment.min.js                     | js   |  x   |
		| 11  | jwplayer           | http www.cnam.re | 7.1.4   | jwplayer.js                       | js   |      |
		+-----+--------------------+------------------+---------+-----------------------------------+------+------+
		*/


		/*
		[0] => [0  | 1  | 2  | 3  | 4  ] 
		[1] => [5  | 6  | 7  | 8  | 9  ]
		[2] => [10 | 11 | 12 | 13 | 14 ]
		[3] => [15 | 16 | 17 ]
		*/

		$i=0;
		$actual_data = array();
		for ($i=0;$i<count($data);$i++)
		{
			$actual_data[floor($i/$nb_lines_max)][$i%$nb_lines_max] = $data[$i];
		}


		foreach($actual_data as $key => $page)
		{
			// Add a page
			if ($key > 0)
				$this->AddPage();

			// Header
			if ($display_header)
			{
				$this -> setX($x);
				for ($i=0; $i < count($header); $i++)
				{
					$this->Cell($header[$i]['width'], 7, $header[$i]['text'], 1, 0, $header[$i]['align'], 1);
				}
				$this->Ln();
			}
			
			// Color and font restoration
			$this->SetFillColor(224, 235, 255);
			$this->SetTextColor(0);
			$this->SetFont('');
			
			// Data
			$fill = 0;
			
			
			foreach ($page as $row)
			{
				$this -> setX($x);

				$global_width = 0;
				for($i=0; $i < count($header); $i++)
				{
					if ($is_html)
						$this->MultiCell($header[$i]['width'], $height_line, $row[$i], $border=1, $header[$i]['align'], $fill=false,$ln=0,'','',$reseth=true,$stretch=1,$ishtml=true,$autopadding=true,$maxh='',$valign='M',$fitcell=false);
					else
						$this->Cell($header[$i]['width'], $height_line, $row[$i], $border=1, $ln=0, $header[$i]['align'], $fill=false,$link='',$stretch=1);


					$global_width += $header[$i]['width'];
				}

				$this->Ln();
			}
		}


		$this -> setX($x);
		$this->Cell($global_width, 0, '', 'T');
	}
}

function get_url($src)
{
	// ----------------------------------------------------------------------------------------------
	// 1. Local :  -- > preg_match('/^\//',$src) == true  -- Commence par /
	// --> $_SERVER['HTTP_REFERER'] http://192.168.2.103/base_adm/admin/librairies/index.php?id_menu=1
	// ---------------------------------------------------------------------------------------------- 
	if (preg_match('/^\//',$src))
	{
		$parse_ = parse_url($_SERVER['HTTP_REFERER']);
		$url = $parse_['scheme']."://".$_SERVER['HTTP_HOST'].$src;
	}
	// -----------------------------------------------------------------------------
	//  2. Local : https://cdnjs.cloudflare.com/ajax/libs/jquery/3.4.1/jquery.min.js
	// -----------------------------------------------------------------------------
	else
		$url = $src;
	
	return $url;
}

if ($_GET['format'] == "A4")
	$landscape_portrait = 'Portrait';
else
	$landscape_portrait = 'Landscape';

// Feuille A4 - Portrait
$pdf = new MYPDF($landscape_portrait, 'mm', $_GET['format'], true ,'UTF-8' , false);


// set document information
$pdf->SetCreator(PDF_CREATOR);
$pdf->SetAuthor('Tuteurs');
$pdf->SetTitle('Tuteurs');
$pdf->SetSubject('Tuteurs');
$pdf->SetKeywords('Tuteurs');

// set font
$pdf->SetFont('helvetica', '', 12);

$pdf->SetAutoPageBreak(false);
$pdf->setPrintHeader(false);
$pdf->setPrintFooter(false);


// Add a page
$pdf->AddPage();

// ------
// Entete
// ------


$pdf->cadre_rouge("Bibliothèques (JS + CSS + PHP)",15,20,$getPageWidth-20,5);



if ($_SERVER['HTTP_REFERER'] == "")
{
	echo "ATTENTION : REFERER vide !";
	exit;
}

$header = array();

$header['JS+CSS'][0] = array( 'text' => '',				'align' => 'C', 'width' => 6);
$header['JS+CSS'][1] = array( 'text' => 'Nom',			'align' => 'L', 'width' => 32);
$header['JS+CSS'][2] = array( 'text' => 'Proto.',		'align' => 'C', 'width' => 14);
$header['JS+CSS'][3] = array( 'text' => 'Domaine',		'align' => 'L', 'width' => 40);
$header['JS+CSS'][4] = array( 'text' => 'Version',		'align' => 'C', 'width' => 16);
$header['JS+CSS'][5] = array( 'text' => 'Nom fichier',	'align' => 'L', 'width' => 54);
$header['JS+CSS'][6] = array( 'text' => 'Type',			'align' => 'C', 'width' => 12);
$header['JS+CSS'][7] = array( 'text' => 'Hash',			'align' => 'C', 'width' => 11);


$header['PHP'][0]    = array( 'text' => '',				'align' => 'C', 'width' => 6);
$header['PHP'][1]    = array( 'text' => 'Nom',			'align' => 'L', 'width' => 32);
$header['PHP'][2]    = array( 'text' => 'Proto.',		'align' => 'C', 'width' => 14);
$header['PHP'][3]    = array( 'text' => 'Domaine',		'align' => 'L', 'width' => 40);
$header['PHP'][4]    = array( 'text' => 'Version',		'align' => 'C', 'width' => 16);
$header['PHP'][5]    = array( 'text' => 'Nom fichier',	'align' => 'L', 'width' => 77);


$tab = array('JS+CSS','PHP');

foreach($tab as $type)
{
	$data_formation = array();
	
	$sql_libraries_js_css = dbquery("SELECT *
		FROM libraries,libraries_files,libraries_version
		WHERE libraries.id_library = libraries_files.id_library
			AND libraries_files.id_library_file = libraries_version.id_library_file
			AND libraries_version.active='1'
			AND libraries.type = '".$type."'
		ORDER BY libraries_files.id_library ASC, libraries_files.`type` ASC, libraries_files.id_library ASC");

	for ($i=0;$i<dbnumrows($sql_libraries_js_css);$i++)
	{
		$id_library			= dbresult($sql_libraries_js_css,$i,"libraries.id_library");
		$name				= dbresult($sql_libraries_js_css,$i,"libraries.name");
		$description		= dbresult($sql_libraries_js_css,$i,"libraries_files.description");
		$type_				= dbresult($sql_libraries_js_css,$i,"libraries_files.type");
		$src				= dbresult($sql_libraries_js_css,$i,"libraries_version.src");
		$version			= dbresult($sql_libraries_js_css,$i,"libraries_version.version");
		$integrity			= dbresult($sql_libraries_js_css,$i,"libraries_version.integrity");
		$id_library_version	= dbresult($sql_libraries_js_css,$i,"libraries_version.id_library_version");

	
		
		/*
		function parse_url()
		Array
		(
			[scheme] => https
			[host] => cdnjs.cloudflare.com
			[path] => /ajax/libs/jqueryui/1.12.1/jquery-ui.min.js
		)
		*/
		$parse = parse_url(get_url($src));


		// Nom et prenom
		$data_formation[$i][0]	= $id_library-dbresult($sql_libraries_js_css,0,"libraries.id_library")+1;
		$data_formation[$i][1]	= "<b>".$name."</b>";
		$data_formation[$i][2]	= $parse['scheme'];
		$data_formation[$i][3]	= $parse['host'];
		$data_formation[$i][4]	= $version;
		$data_formation[$i][5]	= basename($src);
		if ($description <> "")
			$data_formation[$i][5]	.= " (".$description.")";
		$data_formation[$i][6]	= $type_;
		$data_formation[$i][7]	= "";
		if ($integrity <> "")
			$data_formation[$i][7]	= "x";
	}


	$x = 15;
	
	// A5 => 12 lignes
	// A4 => 24 lignes
	($_GET['format'] == "A4")? $nb_lines_max = 24: $nb_lines_max = 11;
	
	$pdf -> rubrique(15,$pdf->getY()+10,$type);

	$pdf -> setXY($x,$pdf->getY()+5);
	$pdf -> Table($header[$type], $data_formation,$x,$height=9,$nb_lines_max, $is_html=true,$display_header=true);
}

ob_end_clean();
$pdf->Output('Bibliotheques_JS_CSS_PHP.pdf', 'I');