<?php
session_start();

require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/config.global.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/config/dbconfig.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/lib/lib.main.inc.php");
require($_SERVER['DOCUMENT_ROOT']."/cabinet/lib/lib.db.inc.php");
libraries(array('PHPExcel'));


$objWriter = new PHPExcel();

$sheet = $objWriter->getActiveSheet();


// ======
// STYLES
// ======
$styleEntete = array(
	'font'=>array(
		'bold'=>true,
		'size'=>12,
		'name'=>Arial,
		'color'=>array(
			'rgb'=>'6666CC')),

		'alignment' => array(
			'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
			'vertical'   => PHPExcel_Style_Alignment::VERTICAL_CENTER),

		'fill' => array(
			'type'       => PHPExcel_Style_Fill::FILL_GRADIENT_LINEAR,
			'rotation'   => 90,
			'startcolor' => array(
				'argb' => 'FFFFCC00'),
			'endcolor'   => array(
				'argb' => 'FFFFFFFF')));


$styleDoubleBorderOutline = array(
	'borders' => array(
		'outline' => array(
			'style' => PHPExcel_Style_Border::BORDER_DOUBLE,
			'color' => array('argb' => 'FF993300'),
		),
	),
);

// Entete
$sql_describe = dbquery("DESCRIBE ".$_GET['table']);
$last_column = PHPExcel_Cell::stringFromColumnIndex(dbnumrows($sql_describe)-1);


// Style
$sheet->getStyle('A1:'.$last_column.'1')->applyFromArray($styleEntete);



// Cellule A1
$sheet->setCellValue('A1','Table '.$_GET['table']);

// Fusionnne des cellules
$sheet->mergeCells('A1:'.$last_column.'1');



// Hauteur de la ligne 1
$sheet->getRowDimension('1')->setRowHeight(30);



for ($i=0;$i<dbnumrows($sql_describe);$i++)
{
	$field	= dbresult($sql_describe,$i,"Field");

	$sheet->setCellValueByColumnAndRow($i, 3, $field);
}


// Style
$sheet->getStyle('A3:E3')->applyFromArray($styleDoubleBorderOutline);

// Filtre
$sheet->setAutoFilter('A3:'.$last_column.'3');

$ligne = 4;


$sql_select = dbquery("SELECT * FROM ".$_GET['table']);

for ($i=0;$i<dbnumrows($sql_select);$i++)
{
	$sql_describe = dbquery("DESCRIBE ".$_GET['table']);

	for ($j=0;$j<dbnumrows($sql_describe);$j++)
	{
		$field	= dbresult($sql_describe,$j,"Field");
		$key	= dbresult($sql_describe,$j,"Key");

		$sheet->setCellValueByColumnAndRow($j,$i+$ligne,dbresult($sql_select,$i,$field));
	}
}


header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment;filename="base_cabinet_'.$_GET['table']." ".date('d_m/Y').'.xlsx"');
header('Cache-Control: max-age=0');

$objWriter = PHPExcel_IOFactory::createWriter($objWriter, 'Excel2007');
$objWriter->save('php://output');

?>