<?php
session_start();

header("Content-Type: text/html; charset=UTF-8"); 
?>
<!doctype html>
<html>
<head>
<title>Site boutique</title>
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
	<meta name="robots"		content="noindex, nofollow">
	<meta name="viewport"	content="width=device-width, initial-scale=1, shrink-to-fit=no">
	<!-- favicon.ico -->
	<link href="data:image/x-icon;base64,AAABAAEAEBAAAAEAIABoBAAAFgAAACgAAAAQAAAAIAAAAAEAIAAAAAAAAAQAABMLAAATCwAAAAAAAAAAAAAAAAAAAAAAAAAAAAByxfUAcsX1AXLF9RpyxfVIcsX1Z3LF9WlyxfVMcsX1HnLF9QJyxfUAAAAAAAAAAAAAAAAAAAAAAHHE9QByxfUAcsX1GXLF9XtyxfXRcsX183LF9fxyxfX8csX19HLF9dZyxfWFcsX1H3LF9QByxfUAAAAAAHLF9QByxfUAcsX1L3LF9cByxfX+cMT1/3DE9f9wxPX/cMT1/3DE9f9xxfX/csX1/3LF9ctyxfU6csX1AHLF9QByxfUAcsX1IXLF9cdyxfX/dsf1/5HS9/+W1Pj/l9T4/5fU+P+U0/f/gsv2/3LF9f9yxfX/csX103LF9SxyxfUAcsX1BHLF9ZRyxfX/ccX1/4PM9v/r9/7/1O38/6vd+f+w3/n/yen7/+P0/f+q3Pn/c8X1/3LF9f9yxfWlcsX1CXLF9TVyxfXmcsX1/3HF9f+DzPb/8Pn+/7fh+v9uw/X/cMT1/3XG9f/E5/v/8vr+/4nP9/9xxPX/csX17nLF9UdyxfV5csX1/nLF9f9xxfX/g8z2//D5/v+44vr/b8T1/3HF9f9uw/X/st/6//n9//+S0vf/cMT1/3LF9f9yxfWQcsX1pXLF9f9yxfX/ccX1/4PM9v/w+f7/vuT6/3zJ9v+Ay/b/ltT4/9/y/f/O6/z/esj2/3HF9f9yxfX/csX1vHLF9bByxfX/csX1/3HF9f+DzPb/7/j+/9nv/P+w3/n/uOL6/+Lz/f/Y7/z/gsz2/3HE9f9yxfX/csX1/3LF9cZyxfWZcsX1/3LF9f9xxfX/g8z2//D5/v+54vr/csX1/3TG9f+N0Pf/6fb9/7ji+v9yxfX/csX1/3LF9f9yxfWwcsX1YXLF9flyxfX/ccX1/4PM9v/w+f7/t+L6/2/E9f9wxPX/dcb1/97y/f/W7vz/dMb1/3LF9f9yxfX9csX1d3LF9R5yxfXQcsX1/3HF9f+DzPb/8Pn+/8Dl+/+Ay/b/hs32/6/e+f/v+f7/q935/3HF9f9yxfX/csX13HLF9StyxfUAcsX1Z3LF9flxxfX/fcn2/8Hl+//B5fv/teH6/7rj+v+84/r/mtX4/3XG9f9yxfX/csX1/HLF9XhyxPkAcsX1AHLF9QpyxfWRcsX1+3LF9f9yxfX/c8X1/3TG9f9zxfX/ccX1/3DE9f9yxfX/csX1/XLF9aFyxfUPcsX1AAAAAAByxfUAcsX1DXLF9XxyxfXncsX1/3LF9f9yxfX/csX1/3LF9f9yxfX/csX17HLF9YlyxfUTcsX1AHLE9QAAAAAAAAAAAHLF9QByxfUDcsX1PHLF9Z5yxfXfcsX1+XLF9fpyxfXjcsX1pnLF9UVyxfUFcsX1AAAAAAAAAAAA8A8AAOAHAADAAwAAgAEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAgAAAAIABAADAAwAA4AcAAA==" rel="icon" type="image/x-icon" />	
	<link rel="stylesheet"	type="text/css"		href="/base_adm/config/css/style.css">

	<!-- jquery  (JS) -->
	<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js" integrity='sha512-894YE6QWD5I59HgZOGReFYm4dnWc1Qt5NtvYSaNcOP+u1T9qYdvdihz0PPSiiqn/+/3e7Jo4EaG7TubfWGUrMQ==' crossorigin="anonymous"></script>

	<!-- twitter-bootstrap  (JS + CSS) -->
	<script src="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/5.1.3/js/bootstrap.min.js"  crossorigin="anonymous"></script>
	<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/5.1.3/css/bootstrap.min.css"  crossorigin="anonymous">
	
	<!-- bootstrap-icons  (CSS) -->
	<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-icons/1.8.3/font/bootstrap-icons.css"  crossorigin="anonymous">
	
	<!-- fancybox  (JS + CSS) -->
	<script src="https://cdn.jsdelivr.net/npm/@fancyapps/ui@4.0.27/dist/fancybox.umd.js"  crossorigin="anonymous"></script>
	<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@fancyapps/ui@4.0.27/dist/fancybox.css"  crossorigin="anonymous">
	?>

	<style type="text/css">
	.categorie {
		display: table-cell;
		width: 180px;
		height: 120px;
		padding: 10px;
		border: 1px solid #fff;
		vertical-align: middle;
		text-align: center;
		background-color: #C1002a;
		font-size: 14px;
		color: #fff;
		font-weight: bold;
		border-radius: 10px;
		cursor:pointer;
	}

	.main {
		padding-top:60px;
		padding-left:20px;

		height: 100%;
		width:100%;
		overflow-y: scroll;
		scrollbar-color: rebeccapurple green;
		scrollbar-width: thin;
	}
	</style>

	<script>
	function cart_nb()
	{
		$.ajax({
			async: true,
			type:		"GET",
			url:		"cart/cart_nb.php",
			data:		'',
			success:	function(nb_ue){
					
				$('#badge').html(nb_ue);
				if (nb_ue != 0)
					$('#badge').show();	
				else
					$('#badge').hide();	
			}
		});
	}

	function add_cart(id_produit)
	{
		$.ajax({
			async: true,
			type:		"GET",
			url:		"cart/add.php",
			data:		'id_produit='+id_produit,
			success:	function(response){
					
				if (response == "ok")
					cart_nb();
			}
		});
	}


	function delete_cart(id_produit)
	{
		$.ajax({
			async: true,
			type:		"GET",
			url:		"cart/delete.php",
			data:		'id_produit='+id_produit,
			success:	function(response){
					
				if (response == "ok")
				{
					cart_nb();
					init_cart();	
				}
			}
		});
	}


	function empty_cart()
	{
		$.ajax({
			async: true,
			type:		"GET",
			url:		"cart/empty.php",
			data:		'',
			success:	function(response){
					
				if (response == "ok")
				{
					cart_nb();
					init_cart();	
				}
			}
		});

	}


	// ---------------
	// PANIER EN POPUP
	// ---------------
	function init_cart()
	{
		// Chargement initial
		$.getJSON('cart/index_json.php', function(data){
			
			$('#tbody_cart').html("");

			// Catégories
			$(data).each(function(i, data_from_json){
				
				$('#tbody_cart').append($("<tr>")
										
					.append($("<td>").append(""))
					.append($("<td style='font-weight:bold'>").append(data_from_json.intitule))
					.append($("<td style='text-align:center'>").append(""))
				);

				// Produits
				$(data_from_json.produits).each(function(j, data_from_json2){
				
					$('#tbody_cart').append($("<tr>")
											
						.append($("<td>").append(data_from_json2.id_produit))
						.append($("<td>").append(data_from_json2.intitule))
						.append($("<td style='text-align:center'>").append("<i value='"+data_from_json2.id_produit+"' style='color:red;cursor:pointer' class='delete_cart bi bi-trash fa-lg'></i>"))

					);
				
				});
				
			});



			// Active ou desactive le bouton vider la selection
			if (data.length == 0)
			{
				$("#empty_cart").prop("disabled",true);
			}
			else
			{
				$("#empty_cart").prop("disabled",false);
			}

		})
		.done(function(){

			$(".delete_cart").click(function(){
						
				delete_cart($(this).attr('value'));
			});

		})
		.fail(function(e){
		})
		.always(function(){
		});
	}



	function init_categorie()
	{
		var colmax = 5;
		var data_produit = new Array();
		
		// Chargement initial CATEGORIES
		$.getJSON('categories_produits_json.php', function(data){
			
			var html = "";
			
			$(data).each(function(i, data_from_json){
				if (i%colmax == 0)
					html += "<tr>";

				html += "<td><div class='categorie' id='"+data_from_json.id_categorie+"'>"+data_from_json.intitule+"</div></td>";

				if (i%colmax == colmax-1)
					html += "</tr>";

				data_produit[data_from_json.id_categorie] = data_from_json.produits;
			});


			$(tbody_categories).html(html);

		})
		.done(function(){

			// CATEGORIE
			$( ".categorie").click(function(){
			
				$( ".categorie").each(function( index ) {
					$(this).css('background-color','#C1002a');
				});

				
				$(this).css('background-color','grey');
			
				$('#produits_table').show();


				// Chargement initial DIPLOMES
					
				$('#tbody_produits').html("");

				data2 = data_produit[$(this).attr('id')];

				for (var i=0; i < data2.length; i++)
				{
					$('#tbody_produits').append($("<tr>")
											
						.append($("<td style='text-align:right'>").append(data2[i].id_produit))
						.append($("<td>").append(data2[i].nom_produit))
						.append($("<td style='text-align:right'>").append("<button class='btn btn-danger select_produit' style='width:105px;display:inline' class='btn btn-danger' value='"+data2[i].id_produit+"'>Choisir <i class='bi bi-chevron-right fa-lg'></i></button>"))
					);

				}
				
		
				$(".select_produit").click(function(){
					
					add_cart($(this).attr('value'));
				});

			});
		
		})
		.fail(function(e){
		})
		.always(function(){
		});
	}


	Fancybox.bind('[data-type="ajax"]', {
		closeButton: true,
		dragToClose: false,
		closeButton : "inside",
		click: false,
		on: {
			closing: function (fancybox, event) {
			},
		},
	});

	$(document).ready(function() {

		// --------------
		// INITIALISATION
		// --------------
		init_categorie();
		cart_nb();


		// Verifie si les cookies sont acceptés
		$.ajax({
			async: true,
			type:		"GET",
			url:		"cookie/accept_cookie_state.php",
			data:		'',
			success:	function(response){
					
				if (response == "ok")
				{
					$('#00_clauses_RGPD').hide();
					$('#01_choix_categorie').show();
				}
			}
		});

		$("#accepter_cookies").click(function() {

			$.ajax({
				type:		"GET",
				url:		"cookie/accept_cookie.php",
				data:		"",
				beforeSend:	function() {
					},
				complete:	function() {	
					},
				success:	function(response) {
					if (response == "ok")
					{
						$('#00_clauses_RGPD').hide();
						$('#01_choix_categorie').show();
					}
				}
			});


		});

	});

	</script>

</head>

<body style='margin:0px'>

<!-- Navbar -->
<div style='position: fixed;top:0px;background-color: #C1002a;width:100vw;z-index:2;height:88px'>
	
	<div style='max-width:740px;text-align:right;width:100%'>

		<!-- CART -->
		<a id='cart_link' data-fancybox data-type='ajax' href='cart/index.php' class='btn btn-light' style='position:relative;top:18px;width:90px;right:40px;text-align:center;z-index:2' type='button'><i style='color:red' class="bi bi-cart fa-2x"></i><span id='badge' style='color:white;position:relative;top:-12px;left:-10px' class="badge bg-danger"></span></a>

		<!-- Logo -->
		<img style='position:absolute;top:8px;left:38px;width:220px' src="logo/logo.png">

		<!-- Label -->
		<div style='position:absolute;top:60px;left:40px;color:white'>Boutique</div>
	
	</div>

</div>


<div id='main' class='main'>

	<!--
	====================
	PAGE 00 Clauses RGPD
	====================
	-->
	<div id='00_clauses_RGPD' style='margin-top:40px'>
	
		<p style='font-weight:bold;color:red'>Utilisation des Cookies<p>

		<p>Notre site utilise des cookies. Un cookie est un fichier contenant un identifiant (une chaîne de caractères des lettres et des chiffres) envoyé par un serveur Web à un navigateur Web et stocké par le navigateur.
		
		<p><b>Cookies permanents</b><br>
		Nous ne stockons pas de cookie permanent sur votre ordinateur

		<p><b>Cookies de session</b><br>
		Un cookie de session expirera à la fin de la session utilisateur lorsque le navigateur Web est fermé.<br>
		Données stockées dans votre cookie :
		<ul>
			<li>Choix des produits dans le panier</li>
		</ul>
		</p>
		
		<button class='btn btn-danger' id='accepter_cookies'>Accepter les cookies</button>
	</div>

	
	<!--
	========================
	PAGE 01 CHOIX CATEGORIES
	========================
	-->
	<div id='01_choix_categorie' style='display:none;margin-top:30px'>
		Choisissez une catégorie

		<div style="overflow: auto">
			<!-- TABLE CATEGORIES -->
			<table style='margin-top:20px'>
			<thead>
			</thead>
			<tbody id='tbody_categories'>
			</tbody>
			</table>
		</div>

		<!-- TABLE PRODUITS -->
		<table id='produits_table' style='margin-top:20px;display:none;max-width:740px' class='table table-striped'>
		<thead>
		<tr>
			<th style='text-align:right;width:15px'>N°</th>
			<th>Produits</th>
			<th></th>
		</tr>
		</thead>
		<tbody id='tbody_produits'>
		</tbody>
		</table>
	</div>

</div>

</body>
</html>