<?php

// Librairies php
require($_SERVER['DOCUMENT_ROOT'].'/site/config/php/lib.inc.php');
require($_SERVER['DOCUMENT_ROOT'].'/site/config/php/var.inc.php');
require($_SERVER['DOCUMENT_ROOT'].'/espace/php/var.php');

// session
require($_SERVER['DOCUMENT_ROOT'].'/espace/inc/session-p.php');

// head
require($_SERVER['DOCUMENT_ROOT'].'/espace/inc/head-p.php');

// menu
require($_SERVER['DOCUMENT_ROOT'].'/espace/inc/menu-p.php');
?>


<!-- Font-Awesome CSS -->
<link rel="stylesheet" href="/lib/font-awesome/4.7.0/css/font-awesome.min.css">


<?php
function display_col($id_ue,$annee_universitaire,$ecrit_oral)
{
	$sql_ue = dbquery("SELECT ue.intitule,ue_annee_universitaire.coefficient_note_ecrit,ue_annee_universitaire.coefficient_note_ecrit,ue_annee_universitaire.coefficient_note_oral
	FROM ue,ue_annee_universitaire
	WHERE ue.id_ue = ue_annee_universitaire.id_ue
		AND ue_annee_universitaire.annee_universitaire = '".$annee_universitaire."'
		AND ue.id_ue='".$id_ue."'");

	// Cette UE existe mais n'est pas deployé sur l'année universitaire	
	if (dbnumrows($sql_ue) == 0 )
	{
		if ($ecrit_oral == 'ecrit')
			return true;
		elseif ($ecrit_oral == 'oral')
			return false;
	}
	else
	{		
		$coefficient_note_ecrit	= dbresult($sql_ue,0,"ue_annee_universitaire.coefficient_note_ecrit");
		$coefficient_note_oral	= dbresult($sql_ue,0,"ue_annee_universitaire.coefficient_note_oral");


		if ($ecrit_oral == 'ecrit')
		{
			if ($coefficient_note_ecrit == "")
				return false;
			else
				return true;
		}
		elseif ($ecrit_oral == 'oral')
		{
			if ($coefficient_note_oral == "")
				return false;
			else
				return true;

		}
	}
}



$annee_universitaire = param('annee_universitaire_examen');

if (isset($_GET['annee_universitaire']))
	$annee_universitaire = $_GET['annee_universitaire'];


function auditeur_inscrit_ICH($id_auditeur)
{
	$sql_auditeurs_diplomes = dbquery("SELECT diplomes_filieres.intitule
	FROM auditeurs_diplomes,diplomes,diplomes_filieres
	WHERE auditeurs_diplomes.id_diplome = diplomes.id_diplome
		AND diplomes.id_filiere = diplomes_filieres.id_filiere
		AND auditeurs_diplomes.id_auditeur = '".$id_auditeur."'
		AND diplomes_filieres.intitule = 'Immobilier, construction, habitat (ICH)'");


	$sql_auditeur_ue_ICH = dbquery("SELECT *
					FROM auditeurs_ue
					WHERE id_ue LIKE 'DRM%'
						AND validation <> 'R'
						AND validation <> 'V'
						AND id_auditeur = '".$id_auditeur."'");


	// Inscrit dans la filiere ICH
	if (dbnumrows($sql_auditeurs_diplomes) > 0 || dbnumrows($sql_auditeur_ue_ICH) > 0)
		return true;
	else
		return false;
}




// ------------------------------------------
// SESSION D'EXAMEN en fonction de la filiere
// --> Filiere RUTL
// --> Filiere autre que RUTL
// ------------------------------------------



$sql_auditeur_filiere = dbquery("SELECT id_filiere
	FROM auditeurs_diplomes,diplomes
	WHERE auditeurs_diplomes.id_diplome = diplomes.id_diplome
		AND auditeurs_diplomes.id='".$_SESSION["user"]["id"]."'
		AND auditeurs_diplomes.annee_universitaire='".$annee_universitaire."'"); // provisoire

if (dbnumrows($sql_auditeur_filiere) > 0)
{
	$id_filiere	= dbresult($sql_auditeur_filiere,0,"id_filiere");
}

// RUTL (id_filiere = 9) / autre RUTL (id_filiere <> 9)
if ($id_filiere == 9)
	$sql_session_filiere	= dbquery("SELECT * FROM diplomes_filieres WHERE id_filiere = '9'");
else
	$sql_session_filiere	= dbquery("SELECT * FROM diplomes_filieres WHERE id_filiere <> '9'");


if (dbnumrows($sql_session_filiere) > 0)
{
	$session_examen		= dbresult($sql_session_filiere,0,"session");
	$date_from_examen	= dbresult($sql_session_filiere,0,"date_from");
	$date_to_examen		= dbresult($sql_session_filiere,0,"date_to");
}


// Contenu

// =====================
// EXAMENS
// --> uniquement actifs
// =====================


// ----------
// Classiques
// ----------
$sql_planning_exam_session_1				= dbquery("SELECT * FROM planning_date_maj,file
														WHERE planning_date_maj.file_extension = file.file_extension
															AND planning = 'general_session_1'
															AND categorie = 'examen'
															AND actif='1'");

$sql_planning_exam_session_2				= dbquery("SELECT * FROM planning_date_maj,file
														WHERE planning_date_maj.file_extension = file.file_extension
															AND planning = 'general_session_2'
															AND categorie = 'examen'
															AND actif='1'");

// -----------------
// Cnam Entrepreneur
// -----------------
$sql_planning_exam_CNE_TEPE	= dbquery("SELECT * FROM planning_date_maj,file
														WHERE planning_date_maj.file_extension = file.file_extension
															AND planning = 'Cne_TEPE'
															AND categorie = 'examen'
															AND actif = '1'");

$sql_planning_exam_CNE_LP			= dbquery("SELECT * FROM planning_date_maj,file
														WHERE planning_date_maj.file_extension = file.file_extension
															AND planning = 'cne_LP'
															AND categorie = 'examen'
															AND actif='1'");
// ---
// ICH
// ---
$sql_planning_exam_ICH_cycle_preparatoire	= dbquery("SELECT * FROM planning_date_maj,file
														WHERE planning_date_maj.file_extension = file.file_extension
															AND planning = 'ICH_cycle_preparatoire'
															AND categorie = 'examen'
															AND actif = '1'");

$sql_planning_exam_ICH_cycle_normal			= dbquery("SELECT * FROM planning_date_maj,file
														WHERE planning_date_maj.file_extension = file.file_extension
															AND planning = 'ICH_cycle_normal'
															AND categorie = 'examen'
															AND actif='1'");

// ----
// RUTL
// ----

$sql_planning_exam_RUTL_1er_groupe			= dbquery("SELECT * FROM planning_date_maj,file
														WHERE planning_date_maj.file_extension = file.file_extension
															AND planning = 'RUTL_1er_groupe'
															AND categorie = 'examen'
															AND actif='1'");

$sql_planning_exam_RUTL_2e_groupe			= dbquery("SELECT * FROM planning_date_maj,file
														WHERE planning_date_maj.file_extension = file.file_extension
															AND planning = 'RUTL_2e_groupe'
															AND categorie = 'examen'
															AND actif='1'");



// -----
// DATES
// -----
$date_maj		= array();
$file			= array();
$font_awesome	= array();

if (dbnumrows($sql_planning_exam_session_1) > 0)
{
	$file['examen_session_1']		= dbresult($sql_planning_exam_session_1,0,"repertoire").dbresult($sql_planning_exam_session_1,0,"file");
	
	$date_maj['examen_session_1']		= new DateTime(dbresult($sql_planning_exam_session_1,0,"date_maj"));
	$font_awesome['examen_session_1']	= dbresult($sql_planning_exam_session_1,0,"font_awesome");
	$color_font_awesome['examen_session_1']	= dbresult($sql_planning_exam_session_1,0,"color");
}

if (dbnumrows($sql_planning_exam_session_2) > 0)
{
	$file['examen_session_2']		= dbresult($sql_planning_exam_session_2,0,"repertoire").dbresult($sql_planning_exam_session_2,0,"file");

	$date_maj['examen_session_2']			= new DateTime(dbresult($sql_planning_exam_session_2,0,"date_maj"));
	$font_awesome['examen_session_2']		= dbresult($sql_planning_exam_session_2,0,"font_awesome");
	$color_font_awesome['examen_session_2']	= dbresult($sql_planning_exam_session_2,0,"color");
}

	

if (dbnumrows($sql_planning_exam_CNE_TEPE) > 0)
{
	$file['cne_TEPE']		= dbresult($sql_planning_exam_CNE_TEPE,0,"repertoire").dbresult($sql_planning_exam_CNE_TEPE,0,"file");

	$date_maj['cne_TEPE']			= new DateTime(dbresult($sql_planning_exam_CNE_TEPE,0,"date_maj"));
	$font_awesome['cne_TEPE']		= dbresult($sql_planning_exam_CNE_TEPE,0,"font_awesome");
	$color_font_awesome['cne_TEPE']	= dbresult($sql_planning_exam_CNE_TEPE,0,"color");
}

if (dbnumrows($sql_planning_exam_CNE_LP) > 0)
{
	$file['cne_LP']		= dbresult($sql_planning_exam_CNE_LP,0,"repertoire").dbresult($sql_planning_exam_CNE_LP,0,"file");

	$date_maj['cne_LP']			= new DateTime(dbresult($sql_planning_exam_CNE_LP,0,"date_maj"));
	$font_awesome['cne_LP']		= dbresult($sql_planning_exam_CNE_LP,0,"font_awesome");
	$color_font_awesome['cne_LP']	= dbresult($sql_planning_exam_CNE_LP,0,"color");
}



if (dbnumrows($sql_planning_exam_ICH_cycle_preparatoire) > 0)
{
	$file['ich_preparatoire']		= dbresult($sql_planning_exam_ICH_cycle_preparatoire,0,"repertoire").dbresult($sql_planning_exam_ICH_cycle_preparatoire,0,"file");

	$date_maj['ich_preparatoire']			= new DateTime(dbresult($sql_planning_exam_ICH_cycle_preparatoire,0,"date_maj"));
	$font_awesome['ich_preparatoire']		= dbresult($sql_planning_exam_ICH_cycle_preparatoire,0,"font_awesome");
	$color_font_awesome['ich_preparatoire']	= dbresult($sql_planning_exam_ICH_cycle_preparatoire,0,"color");
}

if (dbnumrows($sql_planning_exam_ICH_cycle_normal) > 0)
{
	$file['ich']		= dbresult($sql_planning_exam_ICH_cycle_normal,0,"repertoire").dbresult($sql_planning_exam_ICH_cycle_normal,0,"file");


	$date_maj['ich']					= new DateTime(dbresult($sql_planning_exam_ICH_cycle_normal,0,"date_maj"));
	$font_awesome['ich']				= dbresult($sql_planning_exam_ICH_cycle_normal,0,"font_awesome");
	$color_font_awesome['ich']			= dbresult($sql_planning_exam_ICH_cycle_normal,0,"color");
}


if (dbnumrows($sql_planning_exam_RUTL_1er_groupe) > 0)
{
	$file['RUTL_1er_groupe']		= dbresult($sql_planning_exam_RUTL_1er_groupe,0,"repertoire").dbresult($sql_planning_exam_RUTL_1er_groupe,0,"file");

	$date_maj['RUTL_1er_groupe']					= new DateTime(dbresult($sql_planning_exam_RUTL_1er_groupe,0,"date_maj"));
	$font_awesome['RUTL_1er_groupe']				= dbresult($sql_planning_exam_RUTL_1er_groupe,0,"font_awesome");
	$color_font_awesome['RUTL_1er_groupe']			= dbresult($sql_planning_exam_RUTL_1er_groupe,0,"color");
}


if (dbnumrows($sql_planning_exam_RUTL_2e_groupe) > 0)
{
	$file['RUTL_2e_groupe']		= dbresult($sql_planning_exam_RUTL_2e_groupe,0,"repertoire").dbresult($sql_planning_exam_RUTL_2e_groupe,0,"file");

	$date_maj['RUTL_2e_groupe']					= new DateTime(dbresult($sql_planning_exam_RUTL_2e_groupe,0,"date_maj"));
	$font_awesome['RUTL_2e_groupe']				= dbresult($sql_planning_exam_RUTL_2e_groupe,0,"font_awesome");
	$color_font_awesome['RUTL_2e_groupe']		= dbresult($sql_planning_exam_RUTL_2e_groupe,0,"color");
}

// ========
// AUDITEUR
// ========
$sql_auditeur = dbquery("SELECT * FROM auditeurs_diplomes
	WHERE id='".$_SESSION["user"]["id"]."'
		AND annee_universitaire='".$annee_universitaire."'"); // provisoire

$sql_auditeur = dbquery("SELECT * FROM auditeurs_diplomes
	WHERE id='".$_SESSION["user"]["id"]."'
		AND annee_universitaire='".$annee_universitaire."'"); // provisoire
?>

<div id="wrapper">

	<div id="header">
		<div class="grid-container">
			<h1>Examens</h1>
			<h6>Le planning des examens est connu avec exactitude environ 2 mois avant le démarrage des épreuves.</h6>
		</div>
	</div>

	<div id="horizontalTab">
		<ul class="grid-container tab-titles">
			<li class="grid-25 infos"><a href="#tab-1"><span class="picto examens-planning"></span><h5 class="examens-planning">Planning des examens</h5></a></li>
			<li class="grid-25 diplomes"><a href="#tab-2"><span class="picto examens-download"></span><h5 class="examens-download">Téléchargements</h5></a></li>
			<li class="grid-25 competences"><a href="#tab-3"><span class="picto examens-historique"></span><h5 class="examens-historique">Historique des résultats</h5></a></li>
			<li class="grid-25 experiences"><a href="#tab-4"><span class="picto examens-reglement"></span><h5 class="examens-reglement">Règlement des examens</h5></a></li>
		</ul>

		<!--
		-------------------------
		01 - PLANNING DES EXAMENS
		-------------------------
		-->

		<div id="tab-1" class="tab">
			<!-- <section class="bg-light">
				<div class="grid-container">
					<header>
						<h2>Convocation d'examen</h2>
					</header>

					<p>
					Pensez à vérifier vos coordonnées personnelles et à les mettre à jour si nécessaire pour recevoir votre convocation par courrier.
					</p>
					<br><br><br>
					<div class="grid-50">
						<a class="btn-empty">Imprimer la convocation</a>
					</div>
					<div class="grid-50">
						<a class="btn-empty">Recevoir par courrier</a>
					</div>
				</div>
			</section> -->
			<section class="bg-light">
				<!-- <div class="arrow-light"></div> -->
				<div class="grid-container">
					<?php
					$_id_auditeur = array();

					if (dbnumrows($sql_auditeur)==0)
					{
						echo "Aucune inscription n'a eu lieu sur ".$annee_universitaire;
							
						// ---------------
						// Année univ prec
						// ----------------
						$sql_annee_univ_prev = dbquery("SELECT annee_universitaire
							FROM annee_universitaire
							WHERE annee_universitaire < '".$annee_universitaire."'
							ORDER BY annee_universitaire DESC");
						if (dbnumrows($sql_annee_univ_prev) > 0)
						{
							$annee_universitaire_prev = dbresult($sql_annee_univ_prev,0,"annee_universitaire");
							
							echo "<p><a style='color:red;font-size:14pt' href='index.php?annee_universitaire=2018-2019'>Essayer sur l'année dernière ".$annee_universitaire_prev."</a></p>";
						}
					}
					else
					{
						$convocation_online = array();
							
						for ($i=0;$i<dbnumrows($sql_auditeur);$i++)
						{
							$id								= dbresult($sql_auditeur,$i,"id_auditeur");
							$id_diplome						= dbresult($sql_auditeur,$i,"id_diplome");
							$date_inscription[$id]			= dbresult($sql_auditeur,$i,"date_inscription");

							if ($session_examen == 1)
							{
								$convocation_online[$id] = dbresult($sql_auditeur,$i,"convocation_semestre_1_online");
							}
							else
							{
								$convocation_online[$id] = dbresult($sql_auditeur,$i,"convocation_semestre_2_online");
							}

							$_id_auditeur[$id]=$id_diplome;
						}


						foreach($_id_auditeur as $id_auditeur => $id_diplome)
						{
							// diplomes
							$sql_diplome = dbquery("SELECT * FROM diplomes WHERE id_diplome = '".$id_diplome."' ");
								
							$titre		= dbresult($sql_diplome,0,"titre");
							$specialite	= dbresult($sql_diplome,0,"specialite");
								
							if($id_diplome == 2001 )
								$titre = "Unités d'enseignement hors diplômes";
							?>
								
							<header>
								<h2><?php echo $annee_universitaire ?></h2>
								<h5 class="red"><?php echo $titre ?><br><span><?php echo $specialite ?></span></h5>
								<span class="small">
									Numéro d'auditeur : <?php echo $id_auditeur ?><br class="hide-on-desktop"><span class="hide-on-mobile"> &nbsp-&nbsp </span>
									Date d'inscription : <?php echo date_iso_fr($date_inscription[$id_auditeur]) ?>
								</span>
							</header>
								

							<p style='margin-bottom:10px'>Pour votre planning excel d'examen, veuillez consulter l'onglet Téléchargement</p>

							<?php
							if ($convocation_online[$id_auditeur] == 1)
							{
								?>

								<form id='form1' method='post' action='/base_adm/pdf/tcpdf/convocation_examens.php'>

									<input type="hidden" name="session"		value="<?php echo $session_examen ?>">
									<input type="hidden" name="date_from"	value="<?php echo $date_from_examen ?>">
									<input type="hidden" name="date_to"		value="<?php echo $date_to_examen ?>">
									<input type="hidden" name="heure_from"	value="">
									<input type="hidden" name="heure_to"	value="">
									<input type="hidden" name="convocation_nord_force" value="">
									<input type="hidden" name="annule_et_remplace"	value="">
									<input type="hidden" name="id_centre_enseignement_connecte" value="1">
									<input type="hidden" name="id_auditeur[0]" value="<?php echo $id_auditeur ?>">

									<?php
									$suffixe  = "session ".$session_examen;
										
									if (param('semestre_convocation_examen') == 1)
										$suffixe .= " semestre ".param('semestre_convocation_examen');
									?>	
									<button style='padding:10px' type='submit'><i style='color:red' class="fa-lg fa fa-file-pdf-o"></i> Convocation examen <?php echo $suffixe; ?></button>
								</form>
									
								<?php
									
							}
							// ====================
							// EXAMEN session 1 & 2
							// ====================
							else
							{
								echo '								
									<table>
										<tr>
											<th class="align-left">Unités d\'enseignement</th>
											<th>
												<span class="hide-on-mobile">
													Session 1
												</span>
													
												<span class="hide-on-desktop align-left">
													<select class="select-column" id="select-column-calendar">
														<option value="col-1-calendar">Session 1</option>
														<option value="col-2-calendar">Session 2</option>
														<option value="col-3-calendar">Type d\'examens</option>
													</select>
												</span>

											</th>
											<th class="hide-on-mobile">Session 2</th>
											<th class="hide-on-mobile">Type d\'examens</th>
										</tr>
								';
									
								// ue
								$sql_ue = dbquery("SELECT * FROM auditeurs_ue,ue 
													WHERE	auditeurs_ue.id_auditeur = '".$id_auditeur."'
													AND		auditeurs_ue.id_ue = ue.id_ue
													AND 	(auditeurs_ue.validation=''
														OR auditeurs_ue.validation='J')
													GROUP BY ue.id_ue
										");

									
								for($i=0;$i<dbnumrows($sql_ue);$i++)
								{
									$id_ue			= dbresult($sql_ue,$i,"id_ue");
									$intitule		= dbresult($sql_ue,$i,"intitule");
										
									$sql_ue_infos = dbquery("SELECT *
										FROM ue_annee_universitaire
										WHERE id_ue = '".$id_ue."'
											AND annee_universitaire = '".$annee_universitaire."' ");
													
									if (dbnumrows($sql_ue_infos) > 0)
									{
										$examen_session[1]	= dbresult($sql_ue_infos,0,"calendrier_examen_session_1");
										$examen_session[2]	= dbresult($sql_ue_infos,0,"calendrier_examen_session_2");
										$examen_table		= dbresult($sql_ue_infos,0,"examen_epreuve_sur_table");
										$examen_oral		= dbresult($sql_ue_infos,0,"examen_epreuve_orale");
										$examen_dossier		= dbresult($sql_ue_infos,0,"examen_dossier_a_rendre");
									}

									// DETECTION SI DATE PRECISE DE L'EXAMEN ARRETEE

									// session 1

									$sql_ue_examens_s1	= dbquery("SELECT *
										FROM examens_auditeur
										WHERE id_ue = '".$id_ue."'
											AND id_auditeur ='".$id_auditeur."'
											AND session='1'");
												
									if (dbnumrows($sql_ue_examens_s1)>0)
									{
										$date			= dbresult($sql_ue_examens_s1,0,"date");
										$heure_debut	= dbresult($sql_ue_examens_s1,0,"heure_debut");
										$heure_fin		= dbresult($sql_ue_examens_s1,0,"heure_fin");		
										$examen_session[1] = "Le ".date_iso_fr($date)." de ".$heure_debut." au ".$heure_fin;
									}
										
									// session 2

									$sql_ue_examens_s2	= dbquery("SELECT *
										FROM examens_auditeur
										WHERE id_ue = '".$id_ue."'
											AND id_auditeur ='".$id_auditeur."'
											AND session='2'");
												
									if (dbnumrows($sql_ue_examens_s2)>0)
									{
										$date			= dbresult($sql_ue_examens_s2,0,"date");
										$heure_debut	= dbresult($sql_ue_examens_s2,0,"heure_debut");
										$heure_fin		= dbresult($sql_ue_examens_s2,0,"heure_fin");		
										$examen_session[2] = "Le ".date_iso_fr($date)." de ".$heure_debut." au ".$heure_fin;
									}

									// --------------------------
									// Session 1 ou 2 du planning
									// --------------------------
									for ($session = 1; $session<=2 ; $session++)
									{
										$sql_ue_examens_planning_salle	= dbquery("SELECT *
											FROM planning_salles
											WHERE id_ue = '".$id_ue."'
												AND annee_universitaire = '".$annee_universitaire."'
												AND session='".$session."'");

										if (dbnumrows($sql_ue_examens_planning_salle) > 0)
										{
											$datetime_debut	= new DateTime(dbresult($sql_ue_examens_planning_salle,0,"datetime_debut"));
											$datetime_fin	= new DateTime(dbresult($sql_ue_examens_planning_salle,0,"datetime_fin"));
												
											$examen_session[$session] = "Le ".$datetime_debut->format('d/m/Y')." de ".$datetime_debut->format('H:i')." au ".$datetime_fin->format('H:i');
										}
									}


									// MISE EN FORME

										// DATE EXAMENS //////////////////////////////////////////////////////////////////////////////////////////
									
											// Session 1

											if($examen_session[1]<>"")
											{
												$_dates_examens_session1		= explode(" ",$examen_session[1]);

												if(count($_dates_examens_session1) == 4 )
													$examen_session[1] = $_dates_examens_session1[0].' '.$_dates_examens_session1[1].'<br>'.$_dates_examens_session1[2].' '.$_dates_examens_session1[3];
											}
											else $examen_session[1] = " - ";

											// Session 2

											if($examen_session[2]<>"")
											{
												$_dates_examens_session2		= explode(" ",$examen_session[2]);

												if(count($_dates_examens_session2) == 4 )
													$examen_session[2] = $_dates_examens_session2[0].' '.$_dates_examens_session2[1].'<br>'.$_dates_examens_session2[2].' '.$_dates_examens_session2[3];
											}
											else $examen_session[2] = " - ";

										// TYPE EXAMENS //////////////////////////////////////////////////////////////////////////////////////////

											if($examen_table <> 0)
											{
												//$examen_table		= '<img style="vertical-align:middle;" src="/site/img/css/icones/legendUe/doc.png" title="Examen (épreuve sur table)" alt="Examen (épreuve sur table)"/> Épreuve sur table';
												$examen_table	= 'Épreuve sur table';
												$examen_dossier	= '';
												$plus			= '<br>+ ';
											}
											elseif ($examen_dossier <> 0)
											{
												//$examen_dossier	= '<img style="float:left" src="/site/img/css/icones/legendUe/dir.png" title="Examen (dossier à rendre)" alt="Examen (dossier à rendre)"/> Dossier<br>';
												$examen_table	= '';
												$examen_dossier = 'Dossier à rendre';
												$plus			= '<br>+ ';
											}
											else
											{
												$examen_dossier		= '';
												$examen_table		= '';
												$plus			= '';
											}
											if ($examen_oral==1)		$examen_oral = '<!-- <img style="vertical-align:middle;" src="/site/css/img/legende/epreuve-orale.png" title="Examen (présentation orale)" alt="Examen (présentation orale)" /> -->'.$plus.'Épreuve orale';
											else						$examen_oral = '';
										
									// ECRITURE LIGNE

									echo '
										<tr>
											<td style="width:50%"class="align-left"><span class="red bold">'.$id_ue.'</span><br>'.$intitule.'</td>
											<td style="width:15%" class="border-radius-rgt col-1-calendar select-column-calendar">'.$examen_session[1].'</td>
											<td style="width:15%" class="border-radius-rgt col-2-calendar select-column-calendar hide-on-mobile">'.$examen_session[2].'</td>
											<td style="width:20%" class="border-radius-rgt col-3-calendar select-column-calendar hide-on-mobile">'.$examen_table.$examen_dossier.$examen_oral.'</td>
										</tr>		
									';
								}
								echo "</table>";
							}
						}
					}
					?>
				</div>
			</section>
		</div>

		<!--
		-------------------
		02 - TELECHARGEMENT
		-------------------
		-->

		<div id="tab-2" class="tab">
			<section class="bg-light">
				<div class="grid-container">			

					<?php
					//=================================================
						
					$annee_universitaire_2 = param('annee_universitaire');
					$sql_auditeurs_diplomes = dbquery("SELECT auditeurs_diplomes.*,diplomes_filieres.intitule,diplomes.titre
						FROM auditeurs_diplomes,diplomes,diplomes_filieres
						WHERE auditeurs_diplomes.id_diplome = diplomes.id_diplome
							AND diplomes.id_filiere = diplomes_filieres.id_filiere
							AND auditeurs_diplomes.id = '".$_SESSION['user']['id']."'
							AND auditeurs_diplomes.annee_universitaire = '".$annee_universitaire_2."'");

	
					if (dbnumrows($sql_auditeurs_diplomes) == 0)
					{
						// Pas d'entrée :
						// --> Année univ suivante (exemple 2016-2017 --> RUTL sur 2017-2018)
						$sql_auditeurs_diplomes = dbquery("SELECT auditeurs_diplomes.*,diplomes_filieres.intitule,diplomes.titre
							FROM auditeurs_diplomes,diplomes,diplomes_filieres
							WHERE auditeurs_diplomes.id_diplome = diplomes.id_diplome
								AND diplomes.id_filiere = diplomes_filieres.id_filiere
								AND auditeurs_diplomes.id = '".$_SESSION['user']['id']."'
								AND auditeurs_diplomes.annee_universitaire > '".$annee_universitaire_2."'");
					}
						
					if (dbnumrows($sql_auditeurs_diplomes) > 0)
					{
						?>

						<form id='form2_a' method='post' action='/base_adm/pdf/tcpdf/carte_eleve_etiquette.php'>
							<input type="hidden" name="etiquettes_cartes"	value="cartes">
							<input type="hidden" name="id_personnel"		value="30">
							<input type="hidden" name="id_auditeur[0]"		value="<?php echo dbresult($sql_auditeurs_diplomes,0,"auditeurs_diplomes.id_auditeur") ?>">

							<button style='width:220px;height:60px;padding:10px;cursor:pointer' type='submit'>
								<i style='position:relative;top:0px;left:-6px;color:red' class="fa-2x fa fa-file-pdf-o"></i>
								<span style='position:relative;top:-5px;left:10px'>Carte d'auditeur <?php echo dbresult($sql_auditeurs_diplomes,0,"auditeurs_diplomes.annee_universitaire") ?></span>
							</button>
						</form>


						<?php
						if (auditeur_inscrit_ICH($id_auditeur))
						{

							// ============
							// CYCLE NORMAL
							// ============
							if (dbnumrows($sql_planning_exam_ICH_cycle_normal) == 0)
								echo "<p>Aucun planning d'examen ICH cycle normal en ligne</p>";
							else
							{
								?>

								<!-- Planning ICH -->
								<form id='form2_b' method='post' action='<?php echo $file['ich'] ?>'>

									<button style='width:220px;height:60px;padding:10px;margin-top:10px' type='submit'>
										<i style='position:relative;top:0px;left:-6px;color:<?php echo $color_font_awesome['ich'] ?>' class="fa-2x fa <?php echo $font_awesome['ich'] ?>"></i>
										<span style='position:relative;top:-10px;left:10px'>Planning ICH Cycle normal</span><br>
										<span style='position:relative;left:17px'>MAJ le <b><?php echo $date_maj['ich']->format('d/m/Y') ?></b></span></button>
								</form>
								<?php
							}
						}
						// ===============
						// PLANNING CNE LP
						// ===============
						else if (dbresult($sql_auditeurs_diplomes,0,"diplomes.titre") == "LICENCE PROFESSIONNELLE DEG mention Métiers de l'entrepreneuriat")
						{
							if (dbnumrows($sql_planning_exam_CNE_LP) == 0)
								echo "<p>Aucun planning d'examen CNE Licence Pro en ligne</p>";
							else
							{
								?>

								<form id='form2_b' method='post' action='<?php echo $file['cne_LP'] ?>'>

									<button style='width:220px;height:60px;padding:10px;margin-top:10px' type='submit'>
										<i style='position:relative;top:0px;left:0px;position:relative;top:5px;color:<?php echo $color_font_awesome['cne_LP'] ?>' class="fa-2x fa <?php echo $font_awesome['cne_LP'] ?>"></i>
										<span style='position:relative;top:-10px;left:10px'>CNE Licence Pro<span><br>
										<span style='position:relative;left:17px'>MAJ le <b><?php echo $date_maj['cne_LP']->format('d/m/Y') ?></span></button>
								</form>

								<?php
							}
						}
						// =================
						// PLANNING CNE TEPE
						// =================
						else if (dbnumrows($sql_auditeurs_diplomes) > 0 && dbresult($sql_auditeurs_diplomes,0,"diplomes.titre") == "TITRE PROFESSIONNEL RNCP NIV. 3 Entrepreneur de petites entreprises")
						{
							if (dbnumrows($sql_planning_exam_CNE_TEPE) == 0)
								echo "<p>Aucun planning d'examen CNE Titre Entrepreneur de petites entreprises en ligne</p>";
							else
							{
								?>

								<form id='form2_b' method='post' action='<?php echo $file['cne_TEPE'] ?>'>

									<button style='width:220px;height:60px;padding:10px;margin-top:10px' type='submit'>
										<i style='position:relative;top:0px;left:0px;position:relative;top:5px;color:<?php echo $color_font_awesome['cne_TEPE'] ?>' class="fa-2x fa <?php echo $font_awesome['cne_TEPE'] ?>"></i>
										<span style='position:relative;top:-10px;left:10px'>CNE TEPE<span><br>
										<span style='position:relative;left:17px'>MAJ le <b><?php echo $date_maj['cne_TEPE']->format('d/m/Y') ?></span></button>
								</form>
								<?php
							}
						}
						// =============
						// PLANNING RUTL
						// =============
						else if (dbnumrows($sql_auditeurs_diplomes) > 0 && dbresult($sql_auditeurs_diplomes,0,"diplomes_filieres.intitule") == "Transport/Logistique")
						{
							// Planning RUTL Groupe 1
							if (dbnumrows($sql_planning_exam_RUTL_1er_groupe) == 0)
								echo "<p>xAucun planning d'examen CNE RUTL 1er groupe en ligne</p>";
							else
							{
								?>
									
								<form id='form2_b' method='post' action='<?php echo $file['RUTL_1er_groupe'] ?>'>

									<button style='width:220px;height:60px;padding:10px;margin-top:10px' type='submit'>
										<i style='position:relative;top:0px;left:0px;position:relative;top:5px;color:<?php echo $color_font_awesome['RUTL_1er_groupe'] ?>' class="fa-2x fa <?php echo $font_awesome['RUTL_1er_groupe'] ?>"></i>
										<span style='position:relative;top:-10px;left:10px'>RUTL groupe 1<span><br>
										<span style='position:relative;left:17px'>MAJ le <b><?php echo $date_maj['RUTL_1er_groupe']->format('d/m/Y') ?></span></button>
								</form>

								<?php
							}


							// Planning RUTL Groupe 2
							if (dbnumrows($sql_planning_exam_RUTL_2e_groupe) == 0)
								echo "<p>Aucun planning d'examen CNE RUTL 2e groupe en ligne</p>";
							else
							{
								?>
									
								<form id='form2_b' method='post' action='<?php echo $file['RUTL_2e_groupe'] ?>'>

									<button style='width:220px;height:60px;padding:10px;margin-top:10px' type='submit'>
										<i style='position:relative;top:0px;left:0px;position:relative;top:5px;color:<?php echo $color_font_awesome['RUTL_2e_groupe'] ?>' class="fa-2x fa <?php echo $font_awesome['RUTL_2e_groupe'] ?>"></i>
										<span style='position:relative;top:-10px;left:10px'>RUTL groupe 2<span><br>
										<span style='position:relative;left:17px'>MAJ le <b><?php echo $date_maj['RUTL_2e_groupe']->format('d/m/Y') ?></span></button>
								</form>

								<?php
							}

						}
						else
						{
							//-- Planning Formations générales session 1 -->
		
							// Planning Session 1
							if (dbnumrows($sql_planning_exam_session_1) > 0)
							{
								?>
									
								<form id='form2_b' method='post' action='<?php echo $file['examen_session_1'] ?>'>

									<button style='width:220px;height:60px;padding:10px;margin-top:10px;cursor:pointer' type='submit'>
										<i style='position:relative;top:0px;left:0px;position:relative;top:5px;color:<?php echo $color_font_awesome['examen_session_1'] ?>' class="fa-2x fa <?php echo $font_awesome['examen_session_1'] ?>"></i>
										<span style='position:relative;top:-10px;left:10px'>Planning session 1<span><br>
										<span style='position:relative;left:17px'>MAJ le <b><?php echo $date_maj['examen_session_1']->format('d/m/Y') ?></span></button>
								</form>

								<?php
							}

							// Planning Formations générales session 2
							if (dbnumrows($sql_planning_exam_session_2) > 0)
							{
								?>

								<form id='form2_b' method='post' action='<?php echo $file['examen_session_2'] ?>'>

									<button style='width:220px;height:60px;padding:10px;margin-top:10px;cursor:pointer' type='submit'>
										<i style='position:relative;top:0px;left:0px;position:relative;top:5px;color:<?php echo $color_font_awesome['examen_session_2'] ?>' class="fa-2x fa <?php echo $font_awesome['examen_session_2'] ?>"></i>
										<span style='position:relative;top:-10px;left:10px'>Planning session 2</span><br>
										<span style='position:relative;left:17px'>MAJ le <b><?php echo $date_maj['examen_session_2']->format('d/m/Y') ?></b></span></button>
								</form>
								<?php
							}
						}
					}
					?>
				</div>
			</section>
		</div>


		<!--
		-----------------------------
		03 - HISTORIQUE DES RESULTATS
		-----------------------------
		-->

		<div id="tab-3" class="tab">
			<section class="bg-light" style="padding:0">
				<div class="grid-container">
					<?php
					require($_SERVER['DOCUMENT_ROOT']."/base_adm/lib/lib.notes.inc.php");

					$sql_auditeur = dbquery("SELECT *
						FROM auditeurs_diplomes
						WHERE id='".$_SESSION["user"]["id"]."'
						ORDER BY annee_universitaire DESC");

					$_id_auditeur = Array();

					for($i=0;$i<dbnumrows($sql_auditeur);$i++)
					{
						$id			 = dbresult($sql_auditeur,$i,"id_auditeur");
						$id_diplome	 = dbresult($sql_auditeur,$i,"id_diplome");
						$date_inscription[$id]	= dbresult($sql_auditeur,$i,"date_inscription");

						$_id_auditeur[$id]=$id_diplome;
					}


					$count = 0;

					if (dbnumrows($sql_auditeur)==0)
						echo "Aucun résultat";
					else
					{
						foreach($_id_auditeur as $key => $value)
						{
							$sql_resultats_s1 = dbquery("SELECT *
								FROM resultats_examen,auditeurs_ue
								WHERE resultats_examen.id_auditeur = auditeurs_ue.id_auditeur
									AND auditeurs_ue.validation<>'V'
									AND resultats_examen.id_ue = auditeurs_ue.id_ue
									AND resultats_examen.id_auditeur = '".$key."'
									AND resultats_examen.etat = 'P'
									AND resultats_examen.session = '1'");
							
							$annee="";


							for ($i=0;$i<dbnumrows($sql_resultats_s1);$i++)
							{
								// ---------
								// Session 1
								// ---------

								$id_ue					= dbresult($sql_resultats_s1,$i,"id_ue");
								$note_s1				= dbresult($sql_resultats_s1,$i,"note_ecrit");
								$note_oral_s1			= dbresult($sql_resultats_s1,$i,"note_oral");
								$annee_universitaire_t	= dbresult($sql_resultats_s1,$i,"annee_universitaire");
									
								if($note_s1 == '')			$note_s1 = '-';
								if($note_oral_s1 == '')		$note_oral_s1 = '-';
								//if($note_c2i<>"")	$note = $note_c2i;


								// ---------
								// Session 2
								// ---------
								$sql_resultats_s1_s2 = dbquery("SELECT *
									FROM resultats_examen,auditeurs_ue
									WHERE resultats_examen.id_auditeur = auditeurs_ue.id_auditeur
										AND resultats_examen.id_ue = auditeurs_ue.id_ue
										AND resultats_examen.id_auditeur = '".$key."'
										AND resultats_examen.etat = 'P'
										AND resultats_examen.session = '2'
										AND auditeurs_ue.validation<>'V'
										AND resultats_examen.id_ue = '".$id_ue."'
										AND resultats_examen.annee_universitaire = '".$annee_universitaire_t."' ");

								if (dbnumrows($sql_resultats_s1_s2)>0){
									$note_s2			= dbresult($sql_resultats_s1_s2,0,"note_ecrit");
									$note_oral_s2		= dbresult($sql_resultats_s1_s2,0,"note_oral");
									$note_c2i_s2		= dbresult($sql_resultats_s1_s2,0,"note_c2i");

									if($note_s2 == '')			$note_s2 = '-';
									if($note_oral_s2 == '')		$note_oral_s2 = '-';
								}
								else{
									$note_s2			= "-";
									$note_oral_s2		= "-";
									$note_c2i_s2		= "-";
								}

								// Test bulat
								if ($id_ue == 'TBU001' || $id_ue == 'UA2B10' || $id_ue == 'UA2B12' || $id_ue == 'UA2B14' || $id_ue == 'UA2B36' || $id_ue == 'UA3B24')
								{
									if ($note_s1 <> '') $note_s1 = "Niveau : ".$note_s1;
									if ($note_s2 <> '') $note_s2 = "Niveau : ".$note_s2;
								}

									
								//annee
								if ($annee_universitaire_t<>$annee)
								{
									$annee = $annee_universitaire_t;

									// diplomes
									$sql_diplome = dbquery("SELECT * FROM diplomes WHERE id_diplome = '".$value."' ");
										
									$titre		= dbresult($sql_diplome,0,"titre");
									$specialite	= dbresult($sql_diplome,0,"specialite");
										
									if($value == 2001 )		$titre = "Unités d'enseignement hors diplômes";
										
									if($count%2 == 0)	{$bg = 'bg-light'; $arrow = '<div class="arrow-medium"></div>';}
									else				{$bg = 'bg-medium'; $arrow = '<div class="arrow-light"></div>';}

									if($count == 0)		{$arrow = '';$arrow_class='';}
									else				$arrow_class='arrow';

									$section = '<section class="'.$bg.' '.$arrow_class.'">'.$arrow.'<div class="grid-container">';
				
									$count ++;
										
									echo '
									</div></section>
										
									'.$section;
									?>

									<header>
										<h2><?php echo $annee_universitaire_t ?></h2>
										<h5 class="red"><?php echo $titre ?>&nbsp&nbsp<?php echo $specialite ?></h5>
										<span class="small">
											Numéro d'auditeur : <?php echo $key ?><br class="hide-on-desktop"><span class="hide-on-mobile"> &nbsp-&nbsp </span>
											Date d'inscription : <?php echo date_iso_fr($date_inscription[$key]) ?></span>
										</span>
									</header>
										
									<table>
									<tr class="align-center">
										<th class="align-left">Intitulé UE</th>
										<th>
											
											<?php
											if (display_col($id_ue,$annee_universitaire_t,'ecrit'))
											{
												?>	
												<span class="hide-on-mobile">Note<br>session 1</span>
												<?php
											}
											?>
													
											<span class="hide-on-desktop align-left">
												<select class="select-column" id="select-column-<?php echo $annee_universitaire_t ?>">
													<option value="col-1-<?php echo $annee_universitaire_t ?>">Note session 1</option>
													<option value="col-2-<?php echo $annee_universitaire_t ?>">Note orale session 1</option>
													<option value="col-3-<?php echo $annee_universitaire_t ?>">Note session 2</option>
													<option value="col-4-<?php echo $annee_universitaire_t ?>">Note orale session 2</option>
												</select>
											</span>
										</th>
										<th class="hide-on-mobile">
											<?php
											if (display_col($id_ue,$annee_universitaire_t,'oral'))
											{
												?>	
												Note orale<br>session 1
												<?php
											}
											?>
										</th>
										<th class="hide-on-mobile">
											<?php
											if (display_col($id_ue,$annee_universitaire_t,'ecrit'))
											{
												?>	
												Note<br>session 2
												<?php
											}
											?>
										</th>
										<th class="hide-on-mobile">
											<?php
											if (display_col($id_ue,$annee_universitaire_t,'oral'))
											{
												?>	
												Note orale<br>session 2
												<?php
											}
											?>
										</th>
									</tr>
									<?php
								}

								$sql_ue		= dbquery("SELECT intitule FROM ue WHERE id_ue = '".$id_ue."'");
								$intitule	= dbresult($sql_ue,0,"intitule");
								?>
								<tr class="align-center">
									<td style="width:50%" class="align-left"><span class="red bold"><?php echo $id_ue ?></span><br><?php echo $intitule ?></td>
									<td style="width:12%" class="border-radius-rgt col-1-<?php echo $annee_universitaire_t ?> select-column-<?php echo $annee_universitaire_t ?>">
										<?php
										if (display_col($id_ue,$annee_universitaire_t,'ecrit'))
											echo $note_s1;
										?>
									</td>
									<td style="width:12%" class="border-radius-rgt hide-on-mobile col-2-<?php echo $annee_universitaire_t ?> select-column-<?php echo $annee_universitaire_t ?>">
										<?php
										if (display_col($id_ue,$annee_universitaire_t,'oral'))
											echo $note_oral_s1;
										?>
									</td>
									<td style="width:12%" class="border-radius-rgt hide-on-mobile col-3-<?php echo $annee_universitaire_t ?> select-column-<?php echo $annee_universitaire_t ?>">
										<?php
										if (display_col($id_ue,$annee_universitaire_t,'ecrit'))
											echo $note_s2;
										?>
									</td>
									<td style="width:12%" class="border-radius-rgt hide-on-mobile col-4-<?php echo $annee_universitaire_t ?> select-column-'.$annee_universitaire_t.'">
										<?php
										if (display_col($id_ue,$annee_universitaire_t,'oral'))
											echo $note_oral_s2;
										?>
									</td>
								</tr>
								<?php
							}

							// -----------------------------------------
							// C2i : Certificat informatique et internet
							// -----------------------------------------
							$sql_is_inscrit_C2i = dbquery("SELECT *
								FROM resultats_examen_c2i 
								WHERE id_auditeur = '".$key."'
									AND annee_universitaire = '".$annee_universitaire_t."' ");

							if (dbnumrows($sql_is_inscrit_C2i) > 0)
							{
								?>
								<tr class="align-center">
									<td class="align-left">C2i / Certificat informatique et internet</td>
									<td><?php echo note_ecrit($key,'C2i',1) ?></td>
									<td></td>
									<td><?php echo note_ecrit($key,'C2i',2) ?></td>
									<td></td>
								</tr>
								<?php
							}
							?>
						</table>
						<?php
						}
					}
					?>
				</div>
			</section>
		</div>


		<!--
		--------------------------
		04 - REGLEMENT DES EXAMENS
		--------------------------
		-->

		<div id="tab-4" class="tab">
			<section class="bg-light">
				<div class="grid-container">
					<iframe style="width:100%;height:800px" src="/site/docs/pdf/reglement_examen_auditeurs.pdf"></iframe>
				<!-- 
					<header>
						<h2>REGLEMENT GÉNÉRAL DES EPREUVES<br>
						ECRITES D’EXAMEN ET DE CONTROLE CONTINU
						</h2>
					</header>
					<p>
					<b>Art. 1</b>
					- Les candidats doivent être présents à l’entrée de la salle d’examen une demie-heure au moins avant l’heure prévue pour le début de l’épreuve, afin de permettre le contrôle des pièces obligatoires mentionnées dans l’art. 3, de prendre connaissance de la place qui leur est attribuée dans la salle et de s’y installer.
					<br>
					Les candidats doivent déposer dans le fond de la salle d’examen, avant l’ouverture du sujet, tous dossiers, classeurs, ouvrages, documents manuscrits ou imprimés, sacs, serviettes ... qu’ils auraient apportés avec eux ; ils ne peuvent les récupérer qu’en fin d’épreuve. Les outils et documents autorisés seront mentionnés par l’enseignant responsable de la matière.
					<br>
					Tout auditeur qui se présente à une épreuve après la distribution des sujets n’est pas admis à composer, sauf si son retard est dû à une raison de force majeure dûment justifiée et acceptée par les surveillants et à condition que son retard n’excède pas dix minutes.
					</p>
					<p>
					<b>Art. 2</b>
					- Les auditeurs ne doivent composer que sur des feuilles d’examen (double, intercalaire, brouillon) choisies et distribuées par l’administration du Centre Régional du Cnam. Toute copie rédigée sur une autre feuille est nulle.
					</p>
					<p>
					<b>Art. 3</b>
					- Les auditeurs doivent se munir de leur carte d’auditeur, d’une pièce d’identité portant une photographie et de l’attestation d’inscription aux Unités d’enseignement. A défaut de ces pièces, il n’est pas autorisé à composer.
					</p>
					<p>
					<b>Art. 4</b>
					- Si l’auditeur est muni de toutes les pièces mentionnées à l’art. 3 mais que son nom ne figure pas sur la feuille de présence, les surveillants l’autoriseront à composer et rajouteront son nom sur la feuille.
					</p>
					<p>
					<b>Art. 5</b>
					- Seuls les surveillants sont habilités à distribuer, en début et en cours d'épreuve, les feuilles d’examen et de brouillon utilisées par les auditeurs. Les candidats, lorsqu’ils quittent la salle d’examen, doivent remettre à l’un des surveillants toutes les feuilles distribuées pendant l’épreuve qu’ils n’ont pas utilisées ou qu’ils ont eux-mêmes annulées.
					</p>
					<p>
					<b>Art. 6</b>
					- La durée de chaque épreuve est de trois heures maximum. Les candidats sont tenus de se conformer aux règles d’utilisation collective des salles dans lesquelles ils composent.
					</p>
					<p>
					<b>Art. 7</b>
					- Les candidats ne sont autorisés à quitter la salle d’examen qu’après une heure d’épreuve. Passé ce délai, s’ils quittent la salle, ce ne peut être que définitivement, sauf s’ils ont fourni un motif impérieux, le cas échéant attesté par un certificat médical ; en ce cas, ils ne peuvent être autorisés à s’absenter, après une heure d’épreuve, que l’un après l’autre, sans aucun document, pour une durée qui ne peut excéder cinq minutes, et ils sont obligatoirement accompagnés par un surveillant.
					</p>
					<p>
					<b>Art. 8</b>
					- Tout auditeur présent à une épreuve doit, lorsqu’il quitte la salle d’examen,	remettre à un surveillant sa copie d’examen, même blanche, après avoir rempli et cacheté le volet d’identification, puis signé la feuille de présence.
					</p>
					<p>
					<b>Art. 9</b>
					- En cas de flagrant délit de fraude ou tentative de fraude (utilisation de documents ou matériels non autorisés, communication avec un voisin ou avec toute personne hors de la salle pendant l’épreuve ...), le surveillant responsable de la salle prend toutes les mesures pour faire cesser la fraude ou la tentative de fraude sans interrompre la participation à l’épreuve du ou des candidats. Il saisit les pièces ou matériels permettant d’établir ultérieurement la réalité des faits. Il dresse un procès-verbal contresigné par les autres surveillants et par le ou les auteurs de la fraude ou de la tentative de fraude. En cas de refus de contresigner, mention est portée au procès-verbal. Toutefois, en cas de substitution de personne (usurpation d’identité constatée au moment du contrôle des présences ou en cours d’épreuve), ou de troubles affectant le déroulement des épreuves, l’expulsion de la salle des examens peut être prononcée par les autorités compétentes. Les poursuites sont engagées devant la section disciplinaire compétente par le Directeur du Centre Régional Associé du Cnam de La Réunion.
					</p>
					<p>
					<b>Art. 10</b>
					- Un candidat ne peut avoir communication de sa copie qu’après délibération du jury et affichage des notes, et seulement en présence d’une personne désignée par le Directeur du Centre Régional du Cnam de La Réunion.
					</p>
					-->
				</div>
			</section>
		</div>
	</div>
</div>
<?php

// Footer
require($_SERVER['DOCUMENT_ROOT'].'/espace/inc/footer-p.php');

// Scripts js
require($_SERVER['DOCUMENT_ROOT'].'/espace/inc/script-p.php');

// Scripts JS specifiques
?>
	<script src="/espace/js/fancySelect.js" type="text/javascript"></script>

	<script>
	
	$('select').fancySelect();

	$(function(){
			$('.options li').click(function(){
				var val			= $(this).attr('data-raw-value');
				var td_class	= $(this).parents('div').attr('id');
				
				//alert(td_class+' / '+val);

				$('.'+td_class).addClass('hide-on-mobile');
				$('.'+val).removeClass('hide-on-mobile');
			});
	});

	</script>

</body>
</html>