<?php

// Librairies php
require($_SERVER['DOCUMENT_ROOT'].'/site/config/php/lib.inc.php');
require($_SERVER['DOCUMENT_ROOT'].'/site/config/php/var.inc.php');
require($_SERVER['DOCUMENT_ROOT'].'/espace/php/var.php');

// session
require($_SERVER['DOCUMENT_ROOT'].'/espace/inc/session-e.php');

// head
require($_SERVER['DOCUMENT_ROOT'].'/espace/inc/head-e.php');

// menu
require($_SERVER['DOCUMENT_ROOT'].'/espace/inc/menu-e.php');


// FILTRES 
/*
$_SELECT['search']['niveau_diplome']		= str_replace('value="'.$_GET['niveau_diplome'].'"', 'value="'.$_GET['niveau_diplome'].'" selected ', $_SELECT['search']['niveau_diplome']);
$_SELECT['search']['specialite_diplome']	= str_replace('value="'.$_GET['specialite_diplome'].'"', 'value="'.$_GET['specialite_diplome'].'" selected ', $_SELECT['search']['specialite_diplome']);
$_SELECT['search']['langue']				= str_replace('value="'.$_GET['langue'].'"', 'value="'.$_GET['langue'].'" selected ', $_SELECT['search']['langue']);
$_SELECT['search']['pratique']				= str_replace('value="'.$_GET['pratique'].'"', 'value="'.$_GET['pratique'].'" selected ', $_SELECT['search']['pratique']);
$_SELECT['search']['secteur_activite']		= str_replace('value="'.$_GET['secteur_activite'].'"', 'value="'.$_GET['secteur_activite'].'" selected ', $_SELECT['search']['secteur_activite']);
$_SELECT['search']['csp']					= str_replace('value="'.$_GET['csp'].'"', 'value="'.$_GET['csp'].'" selected ', $_SELECT['search']['csp']);
$_SELECT['search']['duree_experience']		= str_replace('value="'.$_GET['duree_experience'].'"', 'value="'.$_GET['duree_experience'].'" selected ', $_SELECT['search']['duree_experience']);
*/

// Contenu
?>

	<div id="wrapper">

		<section class="page-title">
			<div class="grid-container">
				<h1>CV</h1>
				<h6>Accédez aux CV en ligne de nos élèves</h6>
			</div>
		</section>

		<div id="horizontalTab">
			<ul class="grid-container tab-titles">
				<li class="grid-50"><a href="#tab-1"><span class="picto search"></span><h5>Recherche</h5></a></li>
				<li class="grid-50"><a href="#tab-2"><span class="picto bookmark"></span><h5>Favoris</h5></a></li>
			</ul>
			
			<div id="tab-1" class="tab">
				<section class="bg-light">
					<div class="grid-container">
						<form id="search-form">
							<div class="grid-50">
								<label>Niveau de diplôme</label>
								<?php echo $_SELECT['search']['niveau_diplome'];?>
							</div>
							<div class="grid-50">
								<label>Validation</label>
								<select name="validation_diplome">
									<option value="default">Indifférent</option>
									<option value="1" <?php if($_GET['validation'] == '1') echo 'selected';?>>Obtenu</option>
									<option value="0" <?php if($_GET['validation'] == '0') echo 'selected';?>>En cours</option>
								</select>
							</div>
							<div class="grid-100">
								<label>Spécialité du diplôme</label>
								<?php echo $_SELECT['search']['specialite_diplome'];?>
							</div>
							<div class="grid-100">
								<hr/>
							</div>
							<div class="grid-50">
								<label>Langue étrangère pratiquée</label>
								<?php echo $_SELECT['search']['langue'];?>
							</div>
							<div class="grid-50">
								<label>Niveau de pratique</label>
								<?php echo $_SELECT['search']['pratique'];?>
							</div>
							<div class="grid-100">
								<hr/>
							</div>
							<div class="grid-50">
								<label>Durée d'expérience</label>
								<select name="duree_experience">
									<option value="default">Indifférent</option>
									<option value="-24">Moins de 2 ans</option>
									<option value="24">2 ans minimum</option>
									<option value="60">5 ans minimum</option>
									<option value="120">10 ans minimum</option>
								</select>
							</div>
							<div class="grid-50">
								<label>CSP</label>
								<?php echo $_SELECT['search']['csp'];?>
							</div>
							<div class="grid-100">
								<label>Secteur d'activité</label>
								<?php echo $_SELECT['search']['secteur_activite'];?>
							</div>
							<div class="grid-100">
								<hr/>
							</div>
							<div class="grid-50">
								<label>Permis B</label>
								<select name="permis_b">
									<option value="default">Indifférent</option>
									<option value="1" <?php if($_GET['permis_b'] == '1') echo 'selected';?>>Oui</option>
									<option value="0" <?php if($_GET['permis_b'] == '0') echo 'selected';?>>Non</option>
									<option value="autre_permis" <?php if($_GET['permis_b'] == 'autre_permis') echo 'selected';?>>Autre permis</option>
								</select>
							</div>
							<div class="grid-50">
								<label>Véhicule</label>
								<select name="vehicule">
									<option value="default">Indifférent</option>
									<option value="1" <?php if($_GET['vehicule'] == '1') echo 'selected';?>>Oui</option>
									<option value="0" <?php if($_GET['vehicule'] == '0') echo 'selected';?>>Non</option>
								</select>
							</div>
							<div class="grid-100 clearboth">
								<label></label>
								<input type="submit" class="bg-red picto-search" value="Rechercher"/>
							</div>
						</form>
					</div>
				</section>

				<section class="bg-medium arrow" id="results-section">	
				
					<div class="arrow-light"></div>

					<div class="grid-container" >	
						<div id="results"></div>
					</div>

				</section>

			</div>

			<div id="tab-2" class="tab">
				<section class="bg-light">
					<div class="grid-container" id="bookmark-list">
						<?php require 'bookmark-list.php';?>
					</div>
				</section>
			</div>
		</div>
<?php

// Footer
require($_SERVER['DOCUMENT_ROOT'].'/espace/inc/footer-e.php');

// Scripts js
require($_SERVER['DOCUMENT_ROOT'].'/espace/inc/script-p.php');
require($_SERVER['DOCUMENT_ROOT'].'/espace/inc/script-form.php');
// Scripts JS specifiques
?>
	
	<script>
	
	function contact(){
		$('#contact-btn').click(function(){
			var id = $(this).attr('data-id');
			$.ajax({
				cache:		false,
				type:		"GET",
				url:		"contact.php?id_cv="+id,
				success:	function(response){
								$('#message').html(response);
							}
			});
		});	
	}
	
	function bookmark_list(){
		$.ajax({
			cache:		false,
			type:		"GET",
			url:		"bookmark-list.php",
			success:	function(response){
							$('#bookmark-list').html(response);
						}
		});
	}

	function bookmark(){
		$('#bookmark-btn').click(function(){
			var id = $(this).attr('data-id');
			$.ajax({
				cache:		false,
				type:		"GET",
				url:		"bookmark.php?id_cv="+id,
				success:	function(response){
								$('#message').html(response);
								$('#bookmark-btn').toggleClass('picto-bookmark-del');
								bookmark_list();
							}
			});
		});	
	}

	function ajax_popup(){
		$('.ajax-popup-link').magnificPopup({
			type: 'ajax',
			cursor: 'mfp-ajax-cur',
			closeBtnInside: true,
			callbacks: {
				 ajaxContentAdded: function(){
					bookmark();
					contact();
				}
			}
		});
	}

	function search(){
			$.ajax({
				cache:		false,
				type:		"GET",
				url:		"search.php",
				data:		$('#search-form').serialize(),
				success:	function(response){
								$("#results").html(response);	
								ajax_popup();
							}
			});
	}

	$('#search-form').submit(function(e){
		e.preventDefault();
		search();
		auto_scroll('#results-section');
	});
	
	$(window).load(search(),ajax_popup());

	</script>

</body>
</html>